/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.av.codec.video;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.monte.media.av.codec.video.AbstractVideoCodecCore;
import org.monte.media.io.ByteArrayImageInputStream;
import org.monte.media.io.UncachedImageInputStream;

public class TechSmithCodecCore
extends AbstractVideoCodecCore {
    private byte[] temp2;
    private int[] palette;
    private ByteBuffer bbuf;

    public TechSmithCodecCore() {
        this.reset();
    }

    private void deflateBBuf(OutputStream out) throws IOException {
        if (this.bbuf.position() == 2) {
            out.write(this.bbuf.array(), 0, 2);
        } else {
            DeflaterOutputStream defl = new DeflaterOutputStream(out);
            defl.write(this.bbuf.array(), 0, this.bbuf.position());
            defl.finish();
        }
    }

    private void ensureBBufCapacity(int width, int height, int depth) {
        int needed = depth == 1 ? 2 * depth * width * height + 2 * height + 2 : depth * width * height + 3 * (width / 255 + 1) + 2 * height + 2;
        if (this.bbuf == null || this.bbuf.capacity() < needed) {
            this.bbuf = ByteBuffer.allocate(needed);
            this.bbuf.order(ByteOrder.LITTLE_ENDIAN);
        }
        this.bbuf.clear();
    }

    public void reset() {
        this.palette = null;
    }

    public int[] getPalette() {
        if (this.palette == null) {
            this.palette = new int[256];
            for (int i = 0; i < this.palette.length; ++i) {
                this.palette[i] = i | i << 8 | i << 16;
            }
        }
        return this.palette;
    }

    public void decodePalette(byte[] inDat, int off, int len) throws IOException {
        this.getPalette();
        ByteArrayImageInputStream in = new ByteArrayImageInputStream(inDat, off, len, ByteOrder.LITTLE_ENDIAN);
        int firstEntry = in.readUnsignedByte();
        int numEntries = in.readUnsignedByte();
        if (numEntries == 0) {
            numEntries = 256;
        }
        int flags = in.readUnsignedShort();
        if (firstEntry + numEntries > 256) {
            throw new IOException("Illegal headers in pc chunk. firstEntry=" + firstEntry + ", numEntries=" + numEntries);
        }
        in.setByteOrder(ByteOrder.BIG_ENDIAN);
        for (int i = 0; i < numEntries; ++i) {
            int rgbf = in.readInt();
            this.palette[i + firstEntry] = rgbf >> 8;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean decode8(byte[] inDat, int off, int length, byte[] outDat, byte[] prevDat, int width, int height, boolean onlyDecodeIfKeyframe) throws IOException {
        block12: {
            if (length <= 2) {
                return false;
            }
            in = new UncachedImageInputStream(new InflaterInputStream(new ByteArrayInputStream(inDat, off, length)));
            offset = 0;
            scanlineStride = width;
            upsideDown = (height - 1) * scanlineStride + offset;
            verticalOffset = false;
            isKeyFrame = true;
            try {
                y = 0;
                xy = upsideDown;
                block7: while (true) {
                    if ((opcode = in.readUnsignedByte()) == 0) {
                        opcode = in.readUnsignedByte();
                        switch (opcode) {
                            case 0: {
                                xy = (height - 1 - ++y) * scanlineStride + offset;
                                break;
                            }
                            case 1: {
                                break block12;
                            }
                            case 2: {
                                isKeyFrame = false;
                                dx = in.readUnsignedByte();
                                dy = in.readUnsignedByte();
                                y += dy;
                                end = xy + dx - dy * scanlineStride;
                                if (prevDat != outDat) {
                                    System.arraycopy(prevDat, xy, outDat, xy, end - xy);
                                }
                                xy = end;
                                break;
                            }
                            default: {
                                in.readFully(outDat, xy, opcode);
                                xy += opcode;
                                if ((opcode & 1) != 1 || (pad = in.readByte() & 255) == 0) continue block7;
                                throw new IOException("Illegal pad byte, pad=0x" + Integer.toHexString(pad));
                            }
                        }
                        continue;
                    }
                    v = in.readByte();
                    end = xy + opcode;
                    while (true) {
                        if (xy < end) ** break;
                        continue block7;
                        outDat[xy] = v;
                        ++xy;
                    }
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException t) {
                t.printStackTrace();
            }
        }
        in.close();
        return isKeyFrame;
    }

    /*
     * Unable to fully structure code
     */
    public boolean decode8(byte[] inDat, int off, int length, int[] outDat, int[] prevDat, int width, int height, boolean onlyDecodeIfKeyframe) throws IOException {
        block14: {
            if (length <= 2) {
                return false;
            }
            if (this.temp2 == null || this.temp2.length < 255) {
                this.temp2 = new byte[255];
            }
            this.getPalette();
            in = new UncachedImageInputStream(new InflaterInputStream(new ByteArrayInputStream(inDat, off, length)));
            offset = 0;
            scanlineStride = width;
            upsideDown = (height - 1) * scanlineStride + offset;
            verticalOffset = false;
            isKeyFrame = true;
            try {
                y = 0;
                xy = upsideDown;
                block7: while (true) {
                    if ((opcode = in.readUnsignedByte()) == 0) {
                        opcode = in.readUnsignedByte();
                        switch (opcode) {
                            case 0: {
                                xy = (height - 1 - ++y) * scanlineStride + offset;
                                break;
                            }
                            case 1: {
                                break block14;
                            }
                            case 2: {
                                isKeyFrame = false;
                                dx = in.readUnsignedByte();
                                dy = in.readUnsignedByte();
                                y += dy;
                                end = xy + dx - dy * scanlineStride;
                                if (prevDat != outDat) {
                                    System.arraycopy(prevDat, xy, outDat, xy, end - xy);
                                }
                                xy = end;
                                break;
                            }
                            default: {
                                in.readFully(this.temp2, 0, opcode);
                                for (i = 0; i < opcode; ++i) {
                                    outDat[xy + i] = this.palette[this.temp2[i] & 255];
                                }
                                xy += opcode;
                                if ((opcode & 1) != 1 || (pad = in.readByte() & 255) == 0) continue block7;
                                throw new IOException("Illegal pad byte, pad=0x" + Integer.toHexString(pad));
                            }
                        }
                        continue;
                    }
                    v = this.palette[in.readUnsignedByte()];
                    end = xy + opcode;
                    while (true) {
                        if (xy < end) ** break;
                        continue block7;
                        outDat[xy] = v;
                        ++xy;
                    }
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException t) {
                t.printStackTrace();
            }
        }
        in.close();
        return isKeyFrame;
    }

    /*
     * Unable to fully structure code
     */
    public boolean decode24(byte[] inDat, int off, int length, int[] outDat, int[] prevDat, int width, int height, boolean onlyDecodeIfKeyframe) throws IOException {
        block12: {
            if (length <= 2) {
                return false;
            }
            in = new UncachedImageInputStream(new InflaterInputStream(new ByteArrayInputStream(inDat, off, length)));
            offset = 0;
            scanlineStride = width;
            upsideDown = (height - 1) * scanlineStride + offset;
            verticalOffset = false;
            isKeyFrame = true;
            try {
                y = 0;
                xy = upsideDown;
                block7: while (true) {
                    if ((opcode = in.readUnsignedByte()) == 0) {
                        opcode = in.readUnsignedByte();
                        switch (opcode) {
                            case 0: {
                                xy = (height - 1 - ++y) * scanlineStride + offset;
                                break;
                            }
                            case 1: {
                                break block12;
                            }
                            case 2: {
                                isKeyFrame = false;
                                dx = in.readUnsignedByte();
                                dy = in.readUnsignedByte();
                                y += dy;
                                end = xy + dx - dy * scanlineStride;
                                if (prevDat != outDat) {
                                    System.arraycopy(prevDat, xy, outDat, xy, end - xy);
                                }
                                xy = end;
                                break;
                            }
                            default: {
                                this.readInts24LE(in, outDat, xy, opcode);
                                xy += opcode;
                                break;
                            }
                        }
                        continue;
                    }
                    v = this.readInt24LE(in);
                    end = xy + opcode;
                    while (true) {
                        if (xy < end) ** break;
                        continue block7;
                        outDat[xy] = v;
                        ++xy;
                    }
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException t) {
                t.printStackTrace();
            }
        }
        in.close();
        return isKeyFrame;
    }

    /*
     * Unable to fully structure code
     */
    public boolean decode16(byte[] inDat, int off, int length, int[] outDat, int[] prevDat, int width, int height, boolean onlyDecodeIfKeyframe) throws IOException {
        block13: {
            if (length <= 2) {
                if (outDat != prevDat) {
                    System.arraycopy(prevDat, 0, outDat, 0, width * height);
                }
                return false;
            }
            in = new UncachedImageInputStream(new InflaterInputStream(new ByteArrayInputStream(inDat, off, length)), ByteOrder.LITTLE_ENDIAN);
            offset = 0;
            scanlineStride = width;
            upsideDown = (height - 1) * scanlineStride + offset;
            verticalOffset = false;
            isKeyFrame = true;
            try {
                y = 0;
                xy = upsideDown;
                block7: while (true) {
                    if ((opcode = in.readUnsignedByte()) == 0) {
                        opcode = in.readUnsignedByte();
                        switch (opcode) {
                            case 0: {
                                xy = (height - 1 - ++y) * scanlineStride + offset;
                                break;
                            }
                            case 1: {
                                break block13;
                            }
                            case 2: {
                                isKeyFrame = false;
                                dx = in.readUnsignedByte();
                                dy = in.readUnsignedByte();
                                y += dy;
                                end = xy + dx - dy * scanlineStride;
                                if (prevDat != outDat) {
                                    System.arraycopy(prevDat, xy, outDat, xy, end - xy);
                                }
                                xy = end;
                                break;
                            }
                            default: {
                                TechSmithCodecCore.readRGBs555to24(in, outDat, xy, opcode);
                                xy += opcode;
                                break;
                            }
                        }
                        continue;
                    }
                    v = this.readRGB555to24(in);
                    end = xy + opcode;
                    while (true) {
                        if (xy < end) ** break;
                        continue block7;
                        outDat[xy] = v;
                        ++xy;
                    }
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException t) {
                t.printStackTrace();
            }
        }
        this.bbuf = null;
        return isKeyFrame;
    }

    public void encodeDelta8(OutputStream out, byte[] data, byte[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        this.ensureBBufCapacity(width, height, 1);
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        int verticalOffset = 0;
        for (int y = offset; y < ymax; y += scanlineStride) {
            int xy = upsideDown - y;
            int xymax = xy + width;
            int skipCount = 0;
            while (xy < xymax && data[xy] == prev[xy]) {
                ++xy;
                ++skipCount;
            }
            if (skipCount == width) {
                ++verticalOffset;
                continue;
            }
            while (verticalOffset > 0 || skipCount > 0) {
                this.bbuf.put((byte)0);
                this.bbuf.put((byte)2);
                this.bbuf.put((byte)Math.min(255, skipCount));
                this.bbuf.put((byte)Math.min(255, verticalOffset));
                skipCount -= Math.min(255, skipCount);
                verticalOffset -= Math.min(255, verticalOffset);
            }
            int literalCount = 0;
            int repeatCount = 0;
            while (xy < xymax) {
                skipCount = 0;
                while (xy < xymax && data[xy] == prev[xy]) {
                    ++xy;
                    ++skipCount;
                }
                byte v = data[xy -= skipCount];
                for (repeatCount = 0; xy < xymax && repeatCount < 255 && data[xy] == v; ++xy, ++repeatCount) {
                }
                if (skipCount < 4 && (xy -= repeatCount) + skipCount < xymax && repeatCount < 3) {
                    ++literalCount;
                } else {
                    while (literalCount > 0) {
                        if (literalCount < 3) {
                            this.bbuf.put((byte)1);
                            this.bbuf.put(data[xy - literalCount]);
                            --literalCount;
                            continue;
                        }
                        int literalRun = Math.min(254, literalCount);
                        this.bbuf.put((byte)0);
                        this.bbuf.put((byte)literalRun);
                        this.bbuf.put(data, xy - literalCount, literalRun);
                        if ((literalRun & 1) == 1) {
                            this.bbuf.put((byte)0);
                        }
                        literalCount -= literalRun;
                    }
                    if (xy + skipCount == xymax) {
                        xy += skipCount - 1;
                    } else if (skipCount >= repeatCount) {
                        while (skipCount > 0) {
                            this.bbuf.put((byte)0);
                            this.bbuf.put((byte)2);
                            this.bbuf.put((byte)Math.min(255, skipCount));
                            this.bbuf.put((byte)0);
                            xy += Math.min(255, skipCount);
                            skipCount -= Math.min(255, skipCount);
                        }
                        --xy;
                    } else {
                        this.bbuf.put((byte)repeatCount);
                        this.bbuf.put(v);
                        xy += repeatCount - 1;
                    }
                }
                ++xy;
            }
            while (literalCount > 0) {
                if (literalCount < 3) {
                    this.bbuf.put((byte)1);
                    this.bbuf.put(data[xy - literalCount]);
                    --literalCount;
                    continue;
                }
                int literalRun = Math.min(254, literalCount);
                this.bbuf.put((byte)0);
                this.bbuf.put((byte)literalRun);
                this.bbuf.put(data, xy - literalCount, literalRun);
                if ((literalRun & 1) == 1) {
                    this.bbuf.put((byte)0);
                }
                literalCount -= literalRun;
            }
            this.bbuf.put((byte)0);
            this.bbuf.put((byte)0);
        }
        this.bbuf.put((byte)0);
        this.bbuf.put((byte)1);
        this.deflateBBuf(out);
    }

    public void encodeDelta8to24(OutputStream out, byte[] data, byte[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        this.ensureBBufCapacity(width, height, 3);
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        int verticalOffset = 0;
        for (int y = offset; y < ymax; y += scanlineStride) {
            int xy = upsideDown - y;
            int xymax = xy + width;
            int skipCount = 0;
            while (xy < xymax && data[xy] == prev[xy]) {
                ++xy;
                ++skipCount;
            }
            if (skipCount == width) {
                ++verticalOffset;
                continue;
            }
            while (verticalOffset > 0 || skipCount > 0) {
                this.bbuf.put((byte)0);
                this.bbuf.put((byte)2);
                this.bbuf.put((byte)Math.min(255, skipCount));
                this.bbuf.put((byte)Math.min(255, verticalOffset));
                skipCount -= Math.min(255, skipCount);
                verticalOffset -= Math.min(255, verticalOffset);
            }
            int literalCount = 0;
            int repeatCount = 0;
            while (xy < xymax) {
                skipCount = 0;
                while (xy < xymax && data[xy] == prev[xy]) {
                    ++xy;
                    ++skipCount;
                }
                byte v = data[xy -= skipCount];
                for (repeatCount = 0; xy < xymax && repeatCount < 255 && data[xy] == v; ++xy, ++repeatCount) {
                }
                if (skipCount < 4 && (xy -= repeatCount) + skipCount < xymax && repeatCount < 3) {
                    ++literalCount;
                } else {
                    while (literalCount > 0) {
                        if (literalCount < 3) {
                            this.bbuf.put((byte)1);
                            TechSmithCodecCore.writeInt24LE(this.bbuf, this.palette[data[xy - literalCount] & 0xFF]);
                            --literalCount;
                            continue;
                        }
                        int literalRun = Math.min(254, literalCount);
                        this.bbuf.put((byte)0);
                        this.bbuf.put((byte)literalRun);
                        int end = xy - literalCount + literalRun;
                        for (int i = xy - literalCount; i < end; ++i) {
                            TechSmithCodecCore.writeInt24LE(this.bbuf, this.palette[data[i] & 0xFF]);
                        }
                        literalCount -= literalRun;
                    }
                    if (xy + skipCount == xymax) {
                        xy += skipCount - 1;
                    } else if (skipCount >= repeatCount) {
                        while (skipCount > 0) {
                            this.bbuf.put((byte)0);
                            this.bbuf.put((byte)2);
                            this.bbuf.put((byte)Math.min(255, skipCount));
                            this.bbuf.put((byte)0);
                            xy += Math.min(255, skipCount);
                            skipCount -= Math.min(255, skipCount);
                        }
                        --xy;
                    } else {
                        this.bbuf.put((byte)repeatCount);
                        TechSmithCodecCore.writeInt24LE(this.bbuf, this.palette[v & 0xFF]);
                        xy += repeatCount - 1;
                    }
                }
                ++xy;
            }
            while (literalCount > 0) {
                if (literalCount < 3) {
                    this.bbuf.put((byte)1);
                    TechSmithCodecCore.writeInt24LE(this.bbuf, this.palette[data[xy - literalCount]]);
                    --literalCount;
                    continue;
                }
                int literalRun = Math.min(254, literalCount);
                this.bbuf.put((byte)0);
                this.bbuf.put((byte)literalRun);
                int end = xy - literalCount + literalRun;
                for (int i = xy - literalCount; i < end; ++i) {
                    TechSmithCodecCore.writeInt24LE(this.bbuf, this.palette[data[i] & 0xFF]);
                }
                literalCount -= literalRun;
            }
            this.bbuf.put((byte)0);
            this.bbuf.put((byte)0);
        }
        this.bbuf.put((byte)0);
        this.bbuf.put((byte)1);
        this.deflateBBuf(out);
    }

    public void encodeSameDelta8(OutputStream out, byte[] data, byte[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        out.write(0);
        out.write(1);
    }

    public void encodeSameDelta24(OutputStream out, int[] data, int[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        out.write(0);
        out.write(1);
    }

    public void encodeSameDelta16(OutputStream out, short[] data, short[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        out.write(0);
        out.write(1);
    }

    public void encodeKey8(OutputStream out, byte[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        this.ensureBBufCapacity(width, height, 1);
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        for (int y = offset; y < ymax; y += scanlineStride) {
            int xy;
            int xymax = xy + width;
            int literalCount = 0;
            int repeatCount = 0;
            for (xy = upsideDown - y; xy < xymax; ++xy) {
                byte v = data[xy];
                for (repeatCount = 0; xy < xymax && repeatCount < 255 && data[xy] == v; ++xy, ++repeatCount) {
                }
                xy -= repeatCount;
                if (repeatCount < 3) {
                    if (++literalCount != 254) continue;
                    this.bbuf.put((byte)0);
                    this.bbuf.put((byte)literalCount);
                    this.bbuf.put(data, xy - literalCount + 1, literalCount);
                    literalCount = 0;
                    continue;
                }
                if (literalCount > 0) {
                    if (literalCount < 3) {
                        while (literalCount > 0) {
                            this.bbuf.put((byte)1);
                            this.bbuf.put(data[xy - literalCount]);
                            --literalCount;
                        }
                    } else {
                        this.bbuf.put((byte)0);
                        this.bbuf.put((byte)literalCount);
                        this.bbuf.put(data, xy - literalCount, literalCount);
                        if ((literalCount & 1) == 1) {
                            this.bbuf.put((byte)0);
                        }
                        literalCount = 0;
                    }
                }
                this.bbuf.put((byte)repeatCount);
                this.bbuf.put(v);
                xy += repeatCount - 1;
            }
            if (literalCount > 0) {
                if (literalCount < 3) {
                    while (literalCount > 0) {
                        this.bbuf.put((byte)1);
                        this.bbuf.put(data[xy - literalCount]);
                        --literalCount;
                    }
                } else {
                    this.bbuf.put((byte)0);
                    this.bbuf.put((byte)literalCount);
                    this.bbuf.put(data, xy - literalCount, literalCount);
                    if ((literalCount & 1) == 1) {
                        this.bbuf.put((byte)0);
                    }
                }
                literalCount = 0;
            }
            this.bbuf.put((byte)0);
            this.bbuf.put((byte)0);
        }
        this.bbuf.put((byte)0);
        this.bbuf.put((byte)1);
        this.deflateBBuf(out);
    }

    public void encodeKey8to24(OutputStream out, byte[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        this.ensureBBufCapacity(width, height, 3);
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        for (int y = offset; y < ymax; y += scanlineStride) {
            int xy;
            int xymax = xy + width;
            int literalCount = 0;
            int repeatCount = 0;
            for (xy = upsideDown - y; xy < xymax; ++xy) {
                int i;
                int end;
                byte v = data[xy];
                for (repeatCount = 0; xy < xymax && repeatCount < 255 && data[xy] == v; ++xy, ++repeatCount) {
                }
                xy -= repeatCount;
                if (repeatCount < 3) {
                    if (++literalCount != 254) continue;
                    this.bbuf.put((byte)0);
                    this.bbuf.put((byte)literalCount);
                    end = xy + 1;
                    for (i = xy - literalCount + 1; i < end; ++i) {
                        TechSmithCodecCore.writeInt24LE(this.bbuf, this.palette[data[i] & 0xFF]);
                    }
                    literalCount = 0;
                    continue;
                }
                if (literalCount > 0) {
                    if (literalCount < 3) {
                        while (literalCount > 0) {
                            this.bbuf.put((byte)1);
                            TechSmithCodecCore.writeInt24LE(this.bbuf, this.palette[data[xy - literalCount] & 0xFF]);
                            --literalCount;
                        }
                    } else {
                        this.bbuf.put((byte)0);
                        this.bbuf.put((byte)literalCount);
                        end = xy;
                        for (i = xy - literalCount; i < end; ++i) {
                            TechSmithCodecCore.writeInt24LE(this.bbuf, this.palette[data[i] & 0xFF]);
                        }
                        literalCount = 0;
                    }
                }
                this.bbuf.put((byte)repeatCount);
                TechSmithCodecCore.writeInt24LE(this.bbuf, this.palette[v & 0xFF]);
                xy += repeatCount - 1;
            }
            if (literalCount > 0) {
                if (literalCount < 3) {
                    while (literalCount > 0) {
                        this.bbuf.put((byte)1);
                        TechSmithCodecCore.writeInt24LE(this.bbuf, this.palette[data[xy - literalCount] & 0xFF]);
                        --literalCount;
                    }
                } else {
                    this.bbuf.put((byte)0);
                    this.bbuf.put((byte)literalCount);
                    int end = xy;
                    for (int i = xy - literalCount; i < end; ++i) {
                        TechSmithCodecCore.writeInt24LE(this.bbuf, this.palette[data[i] & 0xFF]);
                    }
                }
                literalCount = 0;
            }
            this.bbuf.put((byte)0);
            this.bbuf.put((byte)0);
        }
        this.bbuf.put((byte)0);
        this.bbuf.put((byte)1);
        this.deflateBBuf(out);
    }

    public void encodeDelta16(OutputStream out, short[] data, short[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        this.ensureBBufCapacity(width, height, 2);
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        int verticalOffset = 0;
        for (int y = offset; y < ymax; y += scanlineStride) {
            int xy = upsideDown - y;
            int xymax = xy + width;
            int skipCount = 0;
            while (xy < xymax && data[xy] == prev[xy]) {
                ++xy;
                ++skipCount;
            }
            if (skipCount == width) {
                ++verticalOffset;
                continue;
            }
            while (verticalOffset > 0 || skipCount > 0) {
                this.bbuf.put((byte)0);
                this.bbuf.put((byte)2);
                this.bbuf.put((byte)Math.min(255, skipCount));
                this.bbuf.put((byte)Math.min(255, verticalOffset));
                skipCount -= Math.min(255, skipCount);
                verticalOffset -= Math.min(255, verticalOffset);
            }
            int literalCount = 0;
            int repeatCount = 0;
            while (xy < xymax) {
                skipCount = 0;
                while (xy < xymax && data[xy] == prev[xy]) {
                    ++xy;
                    ++skipCount;
                }
                short v = data[xy -= skipCount];
                for (repeatCount = 0; xy < xymax && repeatCount < 255 && data[xy] == v; ++xy, ++repeatCount) {
                }
                if (skipCount < 4 && (xy -= repeatCount) + skipCount < xymax && repeatCount < 3) {
                    ++literalCount;
                } else {
                    while (literalCount > 0) {
                        if (literalCount < 3) {
                            this.bbuf.put((byte)1);
                            this.bbuf.putShort(data[xy - literalCount]);
                            --literalCount;
                            continue;
                        }
                        int literalRun = Math.min(254, literalCount);
                        this.bbuf.put((byte)0);
                        this.bbuf.put((byte)literalRun);
                        TechSmithCodecCore.writeInts16LE(this.bbuf, data, xy - literalCount, literalRun);
                        literalCount -= literalRun;
                    }
                    if (xy + skipCount == xymax) {
                        xy += skipCount - 1;
                    } else if (skipCount >= repeatCount) {
                        while (skipCount > 0) {
                            this.bbuf.put((byte)0);
                            this.bbuf.put((byte)2);
                            this.bbuf.put((byte)Math.min(255, skipCount));
                            this.bbuf.put((byte)0);
                            xy += Math.min(255, skipCount);
                            skipCount -= Math.min(255, skipCount);
                        }
                        --xy;
                    } else {
                        this.bbuf.put((byte)repeatCount);
                        this.bbuf.putShort(v);
                        xy += repeatCount - 1;
                    }
                }
                ++xy;
            }
            while (literalCount > 0) {
                if (literalCount < 3) {
                    this.bbuf.put((byte)1);
                    this.bbuf.putShort(data[xy - literalCount]);
                    --literalCount;
                    continue;
                }
                int literalRun = Math.min(254, literalCount);
                this.bbuf.put((byte)0);
                this.bbuf.put((byte)literalRun);
                TechSmithCodecCore.writeInts16LE(this.bbuf, data, xy - literalCount, literalRun);
                literalCount -= literalRun;
            }
            this.bbuf.put((byte)0);
            this.bbuf.put((byte)0);
        }
        this.bbuf.put((byte)0);
        this.bbuf.put((byte)1);
        this.deflateBBuf(out);
    }

    public void encodeKey24(OutputStream out, int[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        this.ensureBBufCapacity(width, height, 3);
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        for (int y = offset; y < ymax; y += scanlineStride) {
            int xy;
            int xymax = xy + width;
            int literalCount = 0;
            int repeatCount = 0;
            for (xy = upsideDown - y; xy < xymax; ++xy) {
                int v = data[xy];
                for (repeatCount = 0; xy < xymax && repeatCount < 255 && data[xy] == v; ++xy, ++repeatCount) {
                }
                xy -= repeatCount;
                if (repeatCount < 3) {
                    if (++literalCount != 254) continue;
                    this.bbuf.put((byte)0);
                    this.bbuf.put((byte)literalCount);
                    TechSmithCodecCore.writeInts24LE(this.bbuf, data, xy - literalCount + 1, literalCount);
                    literalCount = 0;
                    continue;
                }
                if (literalCount > 0) {
                    if (literalCount < 3) {
                        while (literalCount > 0) {
                            this.bbuf.put((byte)1);
                            TechSmithCodecCore.writeInt24LE(this.bbuf, data[xy - literalCount]);
                            --literalCount;
                        }
                    } else {
                        this.bbuf.put((byte)0);
                        this.bbuf.put((byte)literalCount);
                        TechSmithCodecCore.writeInts24LE(this.bbuf, data, xy - literalCount, literalCount);
                        literalCount = 0;
                    }
                }
                this.bbuf.put((byte)repeatCount);
                TechSmithCodecCore.writeInt24LE(this.bbuf, v);
                xy += repeatCount - 1;
            }
            if (literalCount > 0) {
                if (literalCount < 3) {
                    while (literalCount > 0) {
                        this.bbuf.put((byte)1);
                        TechSmithCodecCore.writeInt24LE(this.bbuf, data[xy - literalCount]);
                        --literalCount;
                    }
                } else {
                    this.bbuf.put((byte)0);
                    this.bbuf.put((byte)literalCount);
                    TechSmithCodecCore.writeInts24LE(this.bbuf, data, xy - literalCount, literalCount);
                }
                literalCount = 0;
            }
            this.bbuf.put((byte)0);
            this.bbuf.put((byte)0);
        }
        this.bbuf.put((byte)0);
        this.bbuf.put((byte)1);
        this.deflateBBuf(out);
    }

    public void encodeDelta24(OutputStream out, int[] data, int[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        this.ensureBBufCapacity(width, height, 3);
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        int verticalOffset = 0;
        for (int y = offset; y < ymax; y += scanlineStride) {
            int xy = upsideDown - y;
            int xymax = xy + width;
            int skipCount = 0;
            while (xy < xymax && data[xy] == prev[xy]) {
                ++xy;
                ++skipCount;
            }
            if (skipCount == width) {
                ++verticalOffset;
                continue;
            }
            while (verticalOffset > 0 || skipCount > 0) {
                this.bbuf.put((byte)0);
                this.bbuf.put((byte)2);
                this.bbuf.put((byte)Math.min(255, skipCount));
                this.bbuf.put((byte)Math.min(255, verticalOffset));
                skipCount -= Math.min(255, skipCount);
                verticalOffset -= Math.min(255, verticalOffset);
            }
            int literalCount = 0;
            int repeatCount = 0;
            while (xy < xymax) {
                skipCount = 0;
                while (xy < xymax && data[xy] == prev[xy]) {
                    ++xy;
                    ++skipCount;
                }
                int v = data[xy -= skipCount];
                for (repeatCount = 0; xy < xymax && repeatCount < 255 && data[xy] == v; ++xy, ++repeatCount) {
                }
                if (skipCount < 4 && (xy -= repeatCount) + skipCount < xymax && repeatCount < 3) {
                    ++literalCount;
                } else {
                    while (literalCount > 0) {
                        if (literalCount < 3) {
                            this.bbuf.put((byte)1);
                            TechSmithCodecCore.writeInt24LE(this.bbuf, data[xy - literalCount]);
                            --literalCount;
                            continue;
                        }
                        int literalRun = Math.min(254, literalCount);
                        this.bbuf.put((byte)0);
                        this.bbuf.put((byte)literalRun);
                        TechSmithCodecCore.writeInts24LE(this.bbuf, data, xy - literalCount, literalRun);
                        literalCount -= literalRun;
                    }
                    if (xy + skipCount == xymax) {
                        xy += skipCount - 1;
                    } else if (skipCount >= repeatCount) {
                        while (skipCount > 0) {
                            this.bbuf.put((byte)0);
                            this.bbuf.put((byte)2);
                            this.bbuf.put((byte)Math.min(255, skipCount));
                            this.bbuf.put((byte)0);
                            xy += Math.min(255, skipCount);
                            skipCount -= Math.min(255, skipCount);
                        }
                        --xy;
                    } else {
                        this.bbuf.put((byte)repeatCount);
                        TechSmithCodecCore.writeInt24LE(this.bbuf, v);
                        xy += repeatCount - 1;
                    }
                }
                ++xy;
            }
            while (literalCount > 0) {
                if (literalCount < 3) {
                    this.bbuf.put((byte)1);
                    TechSmithCodecCore.writeInt24LE(this.bbuf, data[xy - literalCount]);
                    --literalCount;
                    continue;
                }
                int literalRun = Math.min(254, literalCount);
                this.bbuf.put((byte)0);
                this.bbuf.put((byte)literalRun);
                TechSmithCodecCore.writeInts24LE(this.bbuf, data, xy - literalCount, literalRun);
                literalCount -= literalRun;
            }
            this.bbuf.put((byte)0);
            this.bbuf.put((byte)0);
        }
        this.bbuf.put((byte)0);
        this.bbuf.put((byte)1);
        this.deflateBBuf(out);
    }

    public void encodeKey16(OutputStream out, short[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        this.ensureBBufCapacity(width, height, 2);
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        for (int y = offset; y < ymax; y += scanlineStride) {
            int xy;
            int xymax = xy + width;
            int literalCount = 0;
            int repeatCount = 0;
            for (xy = upsideDown - y; xy < xymax; ++xy) {
                short v = data[xy];
                for (repeatCount = 0; xy < xymax && repeatCount < 255 && data[xy] == v; ++xy, ++repeatCount) {
                }
                xy -= repeatCount;
                if (repeatCount < 3) {
                    if (++literalCount != 254) continue;
                    this.bbuf.put((byte)0);
                    this.bbuf.put((byte)literalCount);
                    TechSmithCodecCore.writeInts16LE(this.bbuf, data, xy - literalCount + 1, literalCount);
                    literalCount = 0;
                    continue;
                }
                if (literalCount > 0) {
                    if (literalCount < 3) {
                        while (literalCount > 0) {
                            this.bbuf.put((byte)1);
                            this.bbuf.putShort(data[xy - literalCount]);
                            --literalCount;
                        }
                    } else {
                        this.bbuf.put((byte)0);
                        this.bbuf.put((byte)literalCount);
                        TechSmithCodecCore.writeInts16LE(this.bbuf, data, xy - literalCount, literalCount);
                        literalCount = 0;
                    }
                }
                this.bbuf.put((byte)repeatCount);
                this.bbuf.putShort(v);
                xy += repeatCount - 1;
            }
            if (literalCount > 0) {
                if (literalCount < 3) {
                    while (literalCount > 0) {
                        this.bbuf.put((byte)1);
                        this.bbuf.putShort(data[xy - literalCount]);
                        --literalCount;
                    }
                } else {
                    this.bbuf.put((byte)0);
                    this.bbuf.put((byte)literalCount);
                    TechSmithCodecCore.writeInts16LE(this.bbuf, data, xy - literalCount, literalCount);
                }
                literalCount = 0;
            }
            this.bbuf.put((byte)0);
            this.bbuf.put((byte)0);
        }
        this.bbuf.put((byte)0);
        this.bbuf.put((byte)1);
        this.deflateBBuf(out);
    }

    public void setPalette(byte[] redValues, byte[] greenValues, byte[] blueValues) {
        if (this.palette == null) {
            this.palette = new int[256];
        }
        for (int i = 0; i < 256; ++i) {
            this.palette[i] = (redValues[i] & 0xFF) << 16 | (greenValues[i] & 0xFF) << 8 | (blueValues[i] & 0xFF) << 0;
        }
    }

    public void setPalette(int[] rgbValues) {
        if (this.palette == null) {
            this.palette = new int[256];
        }
        System.arraycopy(rgbValues, 0, this.palette, 0, Math.min(this.palette.length, rgbValues.length));
    }
}

