/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.avi;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import javax.imageio.stream.ImageInputStream;
import org.monte.media.av.Buffer;
import org.monte.media.av.BufferFlag;
import org.monte.media.av.Codec;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.MovieReader;
import org.monte.media.av.Registry;
import org.monte.media.av.codec.audio.AudioFormatKeys;
import org.monte.media.av.codec.video.VideoFormatKeys;
import org.monte.media.avi.AVIInputStream;
import org.monte.media.avi.AbstractAVIStream;
import org.monte.media.math.Rational;

public class AVIReader
extends AVIInputStream
implements MovieReader {
    public static final Format AVI = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "video/avi"});
    private Rational movieDuration = null;

    public AVIReader(ImageInputStream in) throws IOException {
        super(in);
    }

    public AVIReader(File file) throws IOException {
        super(file);
    }

    @Override
    public Format getFileFormat() throws IOException {
        return AVI;
    }

    @Override
    public Format getFormat(int track) throws IOException {
        this.ensureRealized();
        return ((AbstractAVIStream.Track)this.tracks.get((int)track)).format;
    }

    @Override
    public void read(int track, Buffer buffer) throws IOException {
        byte[] b;
        this.ensureRealized();
        AbstractAVIStream.Track tr = (AbstractAVIStream.Track)this.tracks.get(track);
        if (tr.readIndex >= (long)tr.samples.size()) {
            buffer.setFlagsTo(BufferFlag.END_OF_MEDIA, BufferFlag.DISCARD);
            buffer.length = 0;
            return;
        }
        buffer.sequenceNumber = tr.readIndex;
        AbstractAVIStream.Sample s = tr.samples.get((int)tr.readIndex);
        if (s.header != null) {
            if (buffer.data instanceof byte[]) {
                b = (byte[])buffer.data;
                if ((long)b.length < s.header.length) {
                    b = new byte[((int)s.header.length + 1023) / 1024 * 1024];
                    buffer.data = b;
                }
            } else {
                b = new byte[((int)s.header.length + 1023) / 1024 * 1024];
                buffer.data = b;
            }
            this.in.seek(s.header.offset);
            this.in.readFully(b, 0, (int)s.header.length);
        } else {
            buffer.header = null;
        }
        this.in.seek(s.offset);
        if (buffer.data instanceof byte[]) {
            b = (byte[])buffer.data;
            if ((long)b.length < s.length) {
                b = new byte[((int)s.length + 1023) / 1024 * 1024];
                buffer.data = b;
            }
        } else {
            b = new byte[((int)s.length + 1023) / 1024 * 1024];
            buffer.data = b;
        }
        this.in.readFully(b, 0, (int)s.length);
        buffer.offset = 0;
        buffer.length = (int)s.length;
        switch (tr.mediaType) {
            case AUDIO: {
                Format af = tr.format;
                buffer.sampleCount = buffer.length / af.get(AudioFormatKeys.FrameSizeKey);
                break;
            }
            case VIDEO: {
                buffer.sampleCount = 1;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported media type " + String.valueOf((Object)tr.mediaType));
            }
        }
        buffer.format = tr.format;
        buffer.track = track;
        buffer.sampleDuration = new Rational(tr.scale, tr.rate);
        buffer.timeStamp = new Rational((s.timeStamp + tr.startTime) * tr.scale, tr.rate);
        buffer.flags = s.isKeyframe ? EnumSet.of(BufferFlag.KEYFRAME) : EnumSet.noneOf(BufferFlag.class);
        ++tr.readIndex;
    }

    private void readPalette(byte[] pc, int offset, int length, byte[] r, byte[] g, byte[] b) throws IOException {
        int read = offset;
        byte firstEntry = pc[read++];
        int numEntries = pc[read++];
        int flags = pc[read++] & 0xFF | (pc[read++] & 0xFF) << 8;
        for (int i = 0; i < numEntries; ++i) {
            r[firstEntry + 1] = pc[read++];
            g[firstEntry + 1] = pc[read++];
            b[firstEntry + 1] = pc[read++];
            ++read;
        }
    }

    public BufferedImage read(int track, BufferedImage img) throws IOException {
        AbstractAVIStream.Track tr = (AbstractAVIStream.Track)this.tracks.get(track);
        if (tr.inputBuffer == null) {
            tr.inputBuffer = new Buffer();
        }
        if (tr.codec == null) {
            this.createCodec(tr);
        }
        Buffer buf = new Buffer();
        buf.data = img;
        do {
            this.read(track, tr.inputBuffer);
            tr.codec.process(tr.inputBuffer, buf);
        } while (buf.isFlag(BufferFlag.DISCARD) && !buf.isFlag(BufferFlag.END_OF_MEDIA));
        if (tr.inputBuffer.isFlag(BufferFlag.END_OF_MEDIA)) {
            return null;
        }
        return (BufferedImage)buf.data;
    }

    private void createCodec(AbstractAVIStream.Track tr) throws IOException {
        Format fmt = tr.format;
        Codec codec = this.createCodec(fmt);
        String enc = fmt.get(FormatKeys.EncodingKey);
        if (codec == null) {
            throw new IOException("Track " + String.valueOf(tr) + " no codec found for format " + String.valueOf(fmt));
        }
        if (fmt.get(FormatKeys.MediaTypeKey) == FormatKeys.MediaType.VIDEO) {
            if (null == codec.setInputFormat(fmt)) {
                throw new IOException("Track " + String.valueOf(tr) + " codec " + String.valueOf(codec) + " does not support input format " + String.valueOf(fmt) + ". codec=" + String.valueOf(codec));
            }
            Format outFormat = fmt.prepend(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image", VideoFormatKeys.DataClassKey, BufferedImage.class});
            if (null == codec.setOutputFormat(outFormat)) {
                throw new IOException("Track " + String.valueOf(tr) + " codec " + String.valueOf(codec) + " does not support output format " + String.valueOf(outFormat) + ". codec=" + String.valueOf(codec));
            }
        }
        tr.codec = codec;
    }

    private Codec createCodec(Format fmt) {
        return Registry.getInstance().getDecoder(fmt.prepend(FormatKeys.MimeTypeKey, "video/avi"));
    }

    @Override
    public Rational getReadTime(int track) throws IOException {
        AbstractAVIStream.Track tr = (AbstractAVIStream.Track)this.tracks.get(track);
        if ((long)tr.samples.size() > tr.readIndex) {
            AbstractAVIStream.Sample s = tr.samples.get((int)tr.readIndex);
            return new Rational((s.timeStamp + tr.startTime) * tr.scale, tr.rate);
        }
        return new Rational(0L, 1L);
    }

    @Override
    public int nextTrack() throws IOException {
        this.ensureRealized();
        Rational ts = new Rational(Integer.MAX_VALUE, 1L);
        int nextTrack = -1;
        int n = this.tracks.size();
        for (int i = 0; i < n; ++i) {
            Rational trts;
            AbstractAVIStream.Track tr = (AbstractAVIStream.Track)this.tracks.get(i);
            if (tr.samples.isEmpty()) continue;
            AbstractAVIStream.Sample currentSample = tr.readIndex < (long)tr.samples.size() ? tr.samples.get((int)tr.readIndex) : tr.samples.get(tr.samples.size() - 1);
            long readTimeStamp = currentSample.timeStamp;
            if (tr.readIndex >= (long)tr.samples.size()) {
                readTimeStamp += (long)currentSample.duration;
            }
            if ((trts = new Rational((readTimeStamp + tr.startTime) * tr.scale, tr.rate)).compareTo(ts) >= 0 || tr.readIndex >= (long)tr.samples.size()) continue;
            ts = trts;
            nextTrack = i;
        }
        return nextTrack;
    }

    @Override
    public Rational getDuration() {
        try {
            this.ensureRealized();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return new Rational(0L, 1L);
        }
        if (this.movieDuration == null) {
            Rational maxDuration = new Rational(0L, 1L);
            for (AbstractAVIStream.Track tr : this.tracks) {
                Rational trackDuration = new Rational(tr.length * tr.scale + tr.startTime, tr.rate);
                if (maxDuration.compareTo(trackDuration) >= 0) continue;
                maxDuration = trackDuration;
            }
            this.movieDuration = maxDuration;
        }
        return this.movieDuration;
    }

    @Override
    public Rational getDuration(int track) {
        AbstractAVIStream.Track tr = (AbstractAVIStream.Track)this.tracks.get(track);
        Rational trackDuration = new Rational(tr.length * tr.scale + tr.startTime, tr.rate);
        return trackDuration;
    }

    @Override
    public long getTimeScale(int track) {
        return ((AbstractAVIStream.Track)this.tracks.get((int)track)).rate;
    }

    @Override
    public long timeToSample(int track, Rational time) {
        AbstractAVIStream.Track tr = (AbstractAVIStream.Track)this.tracks.get(track);
        long index = time.getNumerator() * tr.rate / time.getDenominator() / tr.scale - tr.startTime;
        if (tr.mediaType == AbstractAVIStream.AVIMediaType.AUDIO) {
            int count = 0;
            int n = tr.samples.size();
            for (int i = 0; i < n; ++i) {
                long d = (long)tr.samples.get((int)i).duration * tr.scale;
                if ((long)count + d > index) {
                    index = i;
                    break;
                }
                count = (int)((long)count + d);
            }
        }
        return Math.max(0L, Math.min(index, (long)tr.samples.size()));
    }

    @Override
    public Rational sampleToTime(int track, long sampleIndex) throws IOException {
        this.ensureRealized();
        AbstractAVIStream.Track tr = (AbstractAVIStream.Track)this.tracks.get(track);
        AbstractAVIStream.Sample sample = tr.samples.get((int)Math.max(0L, Math.min((long)(tr.samples.size() - 1), sampleIndex)));
        long time = (tr.startTime + sample.timeStamp) * tr.scale;
        if (sampleIndex >= (long)tr.samples.size()) {
            time += (long)sample.duration * tr.scale;
        }
        return new Rational(time, tr.rate);
    }

    @Override
    public void setMovieReadTime(Rational newValue) throws IOException {
        this.ensureRealized();
        int n = this.tracks.size();
        for (int t = 0; t < n; ++t) {
            AbstractAVIStream.Track tr = (AbstractAVIStream.Track)this.tracks.get(t);
            int sample = (int)Math.min(this.timeToSample(t, newValue), (long)(tr.samples.size() - 1));
            if (tr.readIndex > (long)sample) {
                tr.readIndex = 0L;
            }
            while (sample >= 0 && (long)sample > tr.readIndex && !tr.samples.get((int)sample).isKeyframe) {
                --sample;
            }
            tr.readIndex = sample;
        }
    }

    @Override
    public int findTrack(int fromTrack, Format format) throws IOException {
        int n = this.getTrackCount();
        for (int i = fromTrack; i < n; ++i) {
            if (!this.getFormat(i).matches(format)) continue;
            return i;
        }
        return -1;
    }
}

