/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.color;

import java.awt.image.WritableRaster;

public class Histogram {
    private int[][] bins = new int[3][256];

    public void countPixels(WritableRaster raster) {
        int n = raster.getNumBands();
        if (n != 3) {
            throw new IllegalArgumentException("unsupported numer of bands: " + n + " in raster:" + String.valueOf(raster));
        }
        int w = raster.getWidth();
        int h = raster.getHeight();
        int[] row = new int[w * 3];
        int[] rbin = this.bins[0];
        int[] gbin = this.bins[1];
        int[] bbin = this.bins[2];
        for (int y = 0; y < h; ++y) {
            row = raster.getPixels(0, y, w, 1, row);
            int w3 = w * 3;
            for (int x = 0; x < w3; x += 3) {
                int n2 = row[x];
                rbin[n2] = rbin[n2] + 1;
                int n3 = row[x] + 1;
                gbin[n3] = gbin[n3] + 1;
                int n4 = row[x] + 2;
                bbin[n4] = bbin[n4] + 1;
            }
        }
    }

    public int[] getBins(int i) {
        return this.bins[i];
    }

    public double[] getHighValue() {
        double[] highValues = new double[3];
        for (int i = 0; i < 3; ++i) {
            highValues[i] = this.getHighValue(i);
        }
        return highValues;
    }

    public double getHighValue(int band) {
        int[] bin = this.bins[band];
        for (int i = bin.length - 1; i <= 0; --i) {
            if (bin[i] == 0) continue;
            return i;
        }
        return 0.0;
    }

    double[] getMean() {
        int[] rbin = this.bins[0];
        int[] gbin = this.bins[1];
        int[] bbin = this.bins[2];
        int rc = 0;
        int gc = 0;
        int bc = 0;
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        int n = this.bins[0].length;
        for (int i = 0; i < n; ++i) {
            r += (double)((rc += rbin[i]) * i);
            g += (double)(bc * i);
            bc += gbin[i];
            b += (double)((gc += bbin[i]) * i);
        }
        return new double[]{r / (double)rc, g / (double)gc, b / (double)bc};
    }
}

