/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.pgm;

import java.awt.Point;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.monte.media.pgm.PGMImageReaderSpi;

public class PGMImageReader
extends ImageReader {
    private int width = -1;
    private int height = -1;
    private int maxGray = -1;
    private int numImages = -1;
    private long dataOffset = -1L;

    public PGMImageReader(PGMImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        if (allowSearch && this.numImages == -1) {
            this.readHeader();
            ImageInputStream in = (ImageInputStream)this.getInput();
            in.seek(this.dataOffset);
            int dataSize = this.width * this.height * (this.maxGray > 255 ? 2 : 1);
            this.numImages = 0;
            while (in.skipBytes(dataSize) == dataSize) {
                ++this.numImages;
            }
        }
        return this.numImages;
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.readHeader();
        return this.width;
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.readHeader();
        return this.height;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.readHeader();
        LinkedList<ImageTypeSpecifier> l = new LinkedList<ImageTypeSpecifier>();
        ComponentColorModel ccm = new ComponentColorModel(new ICC_ColorSpace(ICC_Profile.getInstance(1003)), new int[]{this.maxGray > 255 ? 16 : 8}, false, false, 1, this.maxGray > 255 ? 2 : 0);
        l.add(new ImageTypeSpecifier(ccm, ccm.createCompatibleSampleModel(this.width, this.height)));
        return l.iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        BufferedImage img;
        this.readHeader();
        if (imageIndex > 0) {
            throw new ArrayIndexOutOfBoundsException("imageIndex is " + imageIndex + " must be 0.");
        }
        ImageInputStream in = (ImageInputStream)this.getInput();
        in.seek(this.dataOffset + (long)(imageIndex * this.width * this.height * (this.maxGray > 255 ? 2 : 1)));
        ComponentColorModel ccm = new ComponentColorModel(new ICC_ColorSpace(ICC_Profile.getInstance(1003)), new int[]{this.maxGray > 255 ? 16 : 8}, false, false, 1, this.maxGray > 255 ? 2 : 0);
        SampleModel sm = ccm.createCompatibleSampleModel(this.width, this.height);
        if (this.maxGray > 255) {
            DataBufferShort db = new DataBufferShort(this.width * this.height);
            in.readFully(db.getData(), 0, this.width * this.height);
            img = new BufferedImage(ccm, Raster.createWritableRaster(sm, db, new Point(0, 0)), false, new Hashtable());
        } else {
            DataBufferByte db = new DataBufferByte(this.width * this.height);
            in.readFully(db.getData(), 0, this.width * this.height);
            img = new BufferedImage(ccm, Raster.createWritableRaster(sm, db, new Point(0, 0)), false, new Hashtable());
        }
        return img;
    }

    private void readHeader() throws IOException {
        if (this.dataOffset == -1L) {
            ImageInputStream in = (ImageInputStream)this.getInput();
            in.seek(0L);
            if (in.readShort() != 20533) {
                in.reset();
                throw new IOException("Illegal magic number");
            }
            int b = in.readUnsignedByte();
            if (b != 32 && b != 9 && b != 13 && b != 10) {
                throw new IOException("Whitespace missing after magic number");
            }
            this.width = this.readHeaderValue(in, "image width");
            if (this.width < 1) {
                throw new IOException("Illegal image width " + this.width);
            }
            this.height = this.readHeaderValue(in, "image height");
            if (this.height < 1) {
                throw new IOException("Illegal image width " + this.height);
            }
            this.maxGray = this.readHeaderValue(in, "maximum gray value");
            if (this.maxGray < 2 || this.maxGray > 65536) {
                throw new IOException("Illegal maximum gray value " + this.maxGray);
            }
            this.dataOffset = in.getStreamPosition();
        }
    }

    private int readHeaderValue(ImageInputStream in, String name) throws IOException {
        int b;
        do {
            if ((b = in.readUnsignedByte()) != 35) continue;
            while ((b = in.readUnsignedByte()) != 13 && b != 10) {
            }
        } while (b == 32 || b == 9 || b == 13 || b == 10);
        if (b < 48 || b > 57) {
            throw new IOException(name + " missing");
        }
        int value = 0;
        do {
            if (value >= 100000) {
                throw new IOException(name + " is too large");
            }
            value = value * 10 + b - 48;
        } while ((b = in.readUnsignedByte()) >= 48 && b <= 57);
        if (b != 32 && b != 9 && b != 13 && b != 10) {
            throw new IOException("Whitespace after " + name + " missing");
        }
        return value;
    }
}

