/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.riff;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RIFFPrimitivesInputStream
extends FilterInputStream {
    private long scan;
    private long mark;

    public RIFFPrimitivesInputStream(InputStream in) {
        super(in);
    }

    public int readUBYTE() throws IOException {
        int b0 = this.in.read();
        if (b0 == -1) {
            throw new EOFException();
        }
        ++this.scan;
        return b0 & 0xFF;
    }

    public short readWORD() throws IOException {
        int b0 = this.in.read();
        int b1 = this.in.read();
        if (b1 == -1) {
            throw new EOFException();
        }
        this.scan += 2L;
        return (short)((b0 & 0xFF) << 0 | (b1 & 0xFF) << 8);
    }

    public int readUWORD() throws IOException {
        return this.readWORD() & 0xFFFF;
    }

    public int readLONG() throws IOException {
        int b0 = this.in.read();
        int b1 = this.in.read();
        int b2 = this.in.read();
        int b3 = this.in.read();
        if (b3 == -1) {
            throw new EOFException();
        }
        this.scan += 4L;
        return ((b0 & 0xFF) << 0) + ((b1 & 0xFF) << 8) + ((b2 & 0xFF) << 16) + ((b3 & 0xFF) << 24);
    }

    public int readFourCC() throws IOException {
        int b3 = this.in.read();
        int b2 = this.in.read();
        int b1 = this.in.read();
        int b0 = this.in.read();
        if (b0 == -1) {
            throw new EOFException();
        }
        this.scan += 4L;
        return ((b0 & 0xFF) << 0) + ((b1 & 0xFF) << 8) + ((b2 & 0xFF) << 16) + ((b3 & 0xFF) << 24);
    }

    public String readFourCCString() throws IOException {
        byte[] buf = new byte[4];
        this.readFully(buf, 0, 4);
        return new String(buf, "ASCII");
    }

    public long readULONG() throws IOException {
        return (long)this.readLONG() & 0xFFFFFFFFL;
    }

    public void align() throws IOException {
        if (this.scan % 2L == 1L) {
            this.in.skip(1L);
            ++this.scan;
        }
    }

    public long getScan() {
        return this.scan;
    }

    @Override
    public int read() throws IOException {
        int data = this.in.read();
        if (data != -1) {
            ++this.scan;
        }
        return data;
    }

    public int readFully(byte[] b, int offset, int length) throws IOException {
        int count = this.read(b, offset, length);
        if (count != length) {
            throw new EOFException("readFully for " + length + " bytes, unexpected EOF after " + count + " bytes.");
        }
        return count;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        int count;
        int result;
        for (count = 0; count < length && (result = this.in.read(b, offset + count, length - count)) != -1; count += result) {
        }
        this.scan += (long)count;
        return count;
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.mark = this.scan;
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.scan = this.mark;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = this.in.skip(n);
        this.scan += skipped;
        return skipped;
    }

    public void skipFully(long n) throws IOException {
        if (n == 0L) {
            return;
        }
        int total = 0;
        int cur = 0;
        while ((long)total < n && (cur = (int)this.in.skip(n - (long)total)) > 0) {
            total += cur;
        }
        if (cur == 0) {
            throw new EOFException();
        }
        this.scan += (long)total;
    }
}

