/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TreeNode<T extends TreeNode<T>> {
    private T parent;
    private final List<T> children = new ArrayList<T>();

    public T getChildAt(int index) {
        return (T)((TreeNode)this.children.get(index));
    }

    public int getChildCount() {
        return this.children.size();
    }

    protected void setParent(T newParent) {
        this.parent = newParent;
    }

    public T getParent() {
        return this.parent;
    }

    public void remove(T child) {
        if (((TreeNode)child).getParent() == this) {
            this.children.remove(child);
            ((TreeNode)child).setParent(null);
        }
    }

    public void add(T child) {
        T oldParent = child.getParent();
        if (oldParent != null) {
            ((TreeNode)oldParent).remove(child);
        }
        child.setParent((TreeNode)this);
        this.children.add(child);
    }

    public Iterable<T> children() {
        return this.children;
    }

    public void sortChildren(Comparator<T> comparator) {
        Collections.sort(this.children, comparator);
    }

    public void removeAllChildren() {
        for (TreeNode child : this.children) {
            child.setParent(null);
        }
        this.children.clear();
    }
}

