/* ____  ______________  ________________________  __________
 * \   \/   /      \   \/   /   __/   /      \   \/   /      \
 *  \______/___/\___\______/___/_____/___/\___\______/___/\___\
 *
 * The MIT License (MIT)
 *
 * Copyright 2024 Vavr, https://vavr.io
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package io.vavr.collection;

import org.junit.jupiter.api.Test;

import static org.assertj.core.api.Assertions.assertThat;

public class IntMod2Test {

    private static final IntMod2 _1 = new IntMod2(1);
    private static final IntMod2 _2 = new IntMod2(2);
    private static final IntMod2 _3 = new IntMod2(3);
    private static final IntMod2 _4 = new IntMod2(4);

    @Test
    public void shouldBeEqualIfEven() {
        assertThat(_2.equals(_4)).isTrue();
        assertThat(_2.compareTo(_4)).isEqualTo(0);
    }

    @Test
    public void shouldBeEqualIfOdd() {
        assertThat(_1.equals(_3)).isTrue();
        assertThat(_1.compareTo(_3)).isEqualTo(0);
    }

    @Test
    public void shouldNotBeEqualIfEvenAndOdd() {
        assertThat(_1.equals(_2)).isFalse();
        assertThat(_1.compareTo(_2)).isEqualTo(1);
        assertThat(_2.compareTo(_3)).isEqualTo(-1);
    }

}
