/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.collection.ChampTrie;
import io.vavr.collection.Iterator;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;

class ChampIteration {
    ChampIteration() {
    }

    static class ChampSpliterator<K, E>
    extends Spliterators.AbstractSpliterator<E> {
        private final Function<K, E> mappingFunction;
        private final Deque<StackElement<K>> stack = new ArrayDeque<StackElement<K>>(8);
        private K current;

        public ChampSpliterator(ChampTrie.Node<K> root, Function<K, E> mappingFunction, int characteristics, long size) {
            super(size, characteristics);
            if (root.nodeArity() + root.dataArity() > 0) {
                this.stack.push(new StackElement<K>(root));
            }
            this.mappingFunction = mappingFunction == null ? i -> i : mappingFunction;
        }

        public E current() {
            return this.mappingFunction.apply(this.current);
        }

        int getNextBitpos(StackElement<K> elem) {
            return 1 << Integer.numberOfTrailingZeros(elem.map);
        }

        boolean isDone(StackElement<K> elem) {
            return elem.index >= elem.size;
        }

        int moveIndex(StackElement<K> elem) {
            return elem.index++;
        }

        boolean moveNext() {
            while (!this.stack.isEmpty()) {
                StackElement<K> elem = this.stack.peek();
                ChampTrie.Node node = elem.node;
                if (node instanceof ChampTrie.HashCollisionNode) {
                    ChampTrie.HashCollisionNode hcn = (ChampTrie.HashCollisionNode)node;
                    this.current = hcn.getData(this.moveIndex(elem));
                    if (this.isDone(elem)) {
                        this.stack.pop();
                    }
                    return true;
                }
                if (!(node instanceof ChampTrie.BitmapIndexedNode)) continue;
                ChampTrie.BitmapIndexedNode bin = (ChampTrie.BitmapIndexedNode)node;
                int bitpos = this.getNextBitpos(elem);
                elem.map ^= bitpos;
                this.moveIndex(elem);
                if (this.isDone(elem)) {
                    this.stack.pop();
                }
                if ((bin.nodeMap() & bitpos) != 0) {
                    this.stack.push(new StackElement(bin.getNode(bin.nodeIndex(bitpos))));
                    continue;
                }
                this.current = bin.getData(bin.dataIndex(bitpos));
                return true;
            }
            return false;
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            if (this.moveNext()) {
                action.accept(this.current());
                return true;
            }
            return false;
        }

        static class StackElement<K> {
            final ChampTrie.Node<K> node;
            final int size;
            int index;
            int map;

            public StackElement(ChampTrie.Node<K> node) {
                this.node = node;
                this.size = node.nodeArity() + node.dataArity();
                this.index = 0;
                this.map = node instanceof ChampTrie.BitmapIndexedNode ? ((ChampTrie.BitmapIndexedNode)node).dataMap() | ((ChampTrie.BitmapIndexedNode)node).nodeMap() : 0;
            }
        }
    }

    static class IteratorFacade<E>
    implements Iterator<E>,
    Consumer<E> {
        private final Spliterator<E> spliterator;
        boolean hasCurrent = false;
        E current;

        IteratorFacade(Spliterator<E> spliterator) {
            this.spliterator = spliterator;
        }

        @Override
        public void accept(E t) {
            this.hasCurrent = true;
            this.current = t;
        }

        @Override
        public boolean hasNext() {
            if (!this.hasCurrent) {
                this.spliterator.tryAdvance(this);
            }
            return this.hasCurrent;
        }

        @Override
        public E next() {
            if (!this.hasCurrent && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hasCurrent = false;
            E t = this.current;
            this.current = null;
            return t;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            if (this.hasCurrent) {
                this.hasCurrent = false;
                E t = this.current;
                this.current = null;
                action.accept(t);
            }
            this.spliterator.forEachRemaining(action);
        }
    }
}

