/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.Tuple2;
import io.vavr.collection.BitMappedTrie;
import io.vavr.collection.ChampIteration;
import io.vavr.collection.ChampTrie;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.Vector;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;

class ChampSequenced {
    ChampSequenced() {
    }

    static final class ChampTombstone {
        private final int before;
        private final int after;

        ChampTombstone(int before, int after) {
            this.before = before;
            this.after = after;
        }

        public int before() {
            return this.before;
        }

        public int after() {
            return this.after;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ChampTombstone that = (ChampTombstone)obj;
            return this.before == that.before && this.after == that.after;
        }

        public int hashCode() {
            return Objects.hash(this.before, this.after);
        }

        public String toString() {
            return "ChampTombstone[before=" + this.before + ", after=" + this.after + ']';
        }
    }

    static class ChampSequencedEntry<K, V>
    extends AbstractMap.SimpleImmutableEntry<K, V>
    implements ChampSequencedData {
        private static final long serialVersionUID = 0L;
        private final int sequenceNumber;

        ChampSequencedEntry(K key) {
            super(key, null);
            this.sequenceNumber = Integer.MIN_VALUE;
        }

        ChampSequencedEntry(K key, V value) {
            super(key, value);
            this.sequenceNumber = Integer.MIN_VALUE;
        }

        ChampSequencedEntry(K key, V value, int sequenceNumber) {
            super(key, value);
            this.sequenceNumber = sequenceNumber;
        }

        static <K, V> ChampSequencedEntry<K, V> forceUpdate(ChampSequencedEntry<K, V> oldK, ChampSequencedEntry<K, V> newK) {
            return newK;
        }

        static <K, V> boolean keyEquals(ChampSequencedEntry<K, V> a, ChampSequencedEntry<K, V> b) {
            return Objects.equals(a.getKey(), b.getKey());
        }

        static <K, V> boolean keyAndValueEquals(ChampSequencedEntry<K, V> a, ChampSequencedEntry<K, V> b) {
            return Objects.equals(a.getKey(), b.getKey()) && Objects.equals(a.getValue(), b.getValue());
        }

        static <V, K> int entryKeyHash(ChampSequencedEntry<K, V> a) {
            return Objects.hashCode(a.getKey());
        }

        static <V, K> int keyHash(Object key) {
            return Objects.hashCode(key);
        }

        static <K, V> ChampSequencedEntry<K, V> update(ChampSequencedEntry<K, V> oldK, ChampSequencedEntry<K, V> newK) {
            return Objects.equals(oldK.getValue(), newK.getValue()) ? oldK : new ChampSequencedEntry(oldK.getKey(), newK.getValue(), oldK.getSequenceNumber());
        }

        static <K, V> ChampSequencedEntry<K, V> updateAndMoveToFirst(ChampSequencedEntry<K, V> oldK, ChampSequencedEntry<K, V> newK) {
            return Objects.equals(oldK.getValue(), newK.getValue()) && oldK.getSequenceNumber() == newK.getSequenceNumber() + 1 ? oldK : newK;
        }

        static <K, V> ChampSequencedEntry<K, V> updateAndMoveToLast(ChampSequencedEntry<K, V> oldK, ChampSequencedEntry<K, V> newK) {
            return Objects.equals(oldK.getValue(), newK.getValue()) && oldK.getSequenceNumber() == newK.getSequenceNumber() - 1 ? oldK : newK;
        }

        static <K, V> ChampSequencedEntry<K, V> updateWithNewKey(ChampSequencedEntry<K, V> oldK, ChampSequencedEntry<K, V> newK) {
            return Objects.equals(oldK.getValue(), newK.getValue()) && oldK.getKey() == newK.getKey() ? oldK : new ChampSequencedEntry<K, V>(newK.getKey(), newK.getValue(), oldK.getSequenceNumber());
        }

        @Override
        public int getSequenceNumber() {
            return this.sequenceNumber;
        }
    }

    static class ChampSequencedElement<E>
    implements ChampSequencedData {
        private final E element;
        private final int sequenceNumber;

        ChampSequencedElement(E element) {
            this.element = element;
            this.sequenceNumber = Integer.MIN_VALUE;
        }

        ChampSequencedElement(E element, int sequenceNumber) {
            this.element = element;
            this.sequenceNumber = sequenceNumber;
        }

        public static int keyHash(Object a) {
            return Objects.hashCode(a);
        }

        static <E> ChampSequencedElement<E> forceUpdate(ChampSequencedElement<E> oldK, ChampSequencedElement<E> newK) {
            return newK;
        }

        static <E> ChampSequencedElement<E> update(ChampSequencedElement<E> oldK, ChampSequencedElement<E> newK) {
            return oldK;
        }

        static <E> ChampSequencedElement<E> updateAndMoveToFirst(ChampSequencedElement<E> oldK, ChampSequencedElement<E> newK) {
            return oldK.getSequenceNumber() == newK.getSequenceNumber() + 1 ? oldK : newK;
        }

        static <E> ChampSequencedElement<E> updateAndMoveToLast(ChampSequencedElement<E> oldK, ChampSequencedElement<E> newK) {
            return oldK.getSequenceNumber() == newK.getSequenceNumber() - 1 ? oldK : newK;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChampSequencedElement that = (ChampSequencedElement)o;
            return Objects.equals(this.element, that.element);
        }

        public int hashCode() {
            return Objects.hashCode(this.element);
        }

        E getElement() {
            return this.element;
        }

        @Override
        public int getSequenceNumber() {
            return this.sequenceNumber;
        }

        public String toString() {
            return "{" + this.element + ", seq=" + this.sequenceNumber + '}';
        }
    }

    static interface ChampSequencedData {
        public static final int NO_SEQUENCE_NUMBER = Integer.MIN_VALUE;
        public static final ChampTombstone TOMB_ZERO_ZERO;

        public static <K extends ChampSequencedData> ChampTrie.BitmapIndexedNode<K> buildSequencedTrie(ChampTrie.BitmapIndexedNode<K> root, ChampTrie.IdentityObject owner) {
            ChampTrie.Node seqRoot = ChampTrie.BitmapIndexedNode.emptyNode();
            ChampTrie.ChangeEvent details = new ChampTrie.ChangeEvent();
            ChampIteration.ChampSpliterator i = new ChampIteration.ChampSpliterator(root, null, 0, 0L);
            while (i.moveNext()) {
                ChampSequencedData elem = (ChampSequencedData)i.current();
                seqRoot = seqRoot.put(owner, elem, ChampSequencedData.seqHash(elem.getSequenceNumber()), 0, details, (oldK, newK) -> oldK, ChampSequencedData::seqEquals, ChampSequencedData::seqHash);
            }
            return seqRoot;
        }

        public static boolean mustRenumber(int size, int first, int last) {
            return size == 0 && (first != -1 || last != 0) || last > 0x7FFFFFFD || first < -2147483646;
        }

        public static <K extends ChampSequencedData> Vector<Object> vecBuildSequencedTrie(ChampTrie.BitmapIndexedNode<K> root, ChampTrie.IdentityObject owner, int size) {
            ArrayList<Object> list = new ArrayList<Object>(size);
            ChampIteration.ChampSpliterator i = new ChampIteration.ChampSpliterator(root, Function.identity(), 0, Long.MAX_VALUE);
            while (i.moveNext()) {
                list.add(i.current());
            }
            list.sort(Comparator.comparing(ChampSequencedData::getSequenceNumber));
            return Vector.ofAll(list);
        }

        public static boolean vecMustRenumber(int size, int offset, int vectorSize) {
            return size == 0 || vectorSize >>> 1 > size || (long)vectorSize - (long)offset > 0x7FFFFFFDL || offset < -2147483646;
        }

        public static <K extends ChampSequencedData> ChampTrie.BitmapIndexedNode<K> renumber(int size, ChampTrie.BitmapIndexedNode<K> root, ChampTrie.BitmapIndexedNode<K> sequenceRoot, ChampTrie.IdentityObject owner, ToIntFunction<K> hashFunction, BiPredicate<K, K> equalsFunction, BiFunction<K, Integer, K> factoryFunction) {
            if (size == 0) {
                return root;
            }
            ChampTrie.Node newRoot = root;
            ChampTrie.ChangeEvent details = new ChampTrie.ChangeEvent();
            int seq = 0;
            ChampIteration.ChampSpliterator i = new ChampIteration.ChampSpliterator(sequenceRoot, Function.identity(), 0, 0L);
            while (i.moveNext()) {
                ChampSequencedData e = (ChampSequencedData)i.current();
                ChampSequencedData newElement = (ChampSequencedData)factoryFunction.apply(e, seq);
                newRoot = newRoot.put(owner, newElement, Objects.hashCode(e), 0, details, (oldk, newk) -> oldk.getSequenceNumber() == newk.getSequenceNumber() ? oldk : newk, equalsFunction, hashFunction);
                ++seq;
            }
            return newRoot;
        }

        public static <K extends ChampSequencedData> Tuple2<ChampTrie.BitmapIndexedNode<K>, Vector<Object>> vecRenumber(int size, ChampTrie.BitmapIndexedNode<K> root, Vector<Object> vector, ChampTrie.IdentityObject owner, ToIntFunction<K> hashFunction, BiPredicate<K, K> equalsFunction, BiFunction<K, Integer, K> factoryFunction) {
            if (size == 0) {
                new Tuple2<ChampTrie.BitmapIndexedNode<K>, Vector<Object>>(root, vector);
            }
            ChampTrie.Node renumberedRoot = root;
            IndexedSeq<Object> renumberedVector = Vector.of(new Object[0]);
            ChampTrie.ChangeEvent details = new ChampTrie.ChangeEvent();
            BiFunction<ChampSequencedData, ChampSequencedData, ChampSequencedData> forceUpdate = (oldk, newk) -> newk;
            int seq = 0;
            ChampVectorSpliterator<ChampSequencedData> i = new ChampVectorSpliterator<ChampSequencedData>(vector, o -> (ChampSequencedData)o, 0, Long.MAX_VALUE, 0);
            while (i.moveNext()) {
                ChampSequencedData current = i.current();
                ChampSequencedData data = (ChampSequencedData)factoryFunction.apply(current, seq++);
                renumberedVector = renumberedVector.append((Object)data);
                renumberedRoot = renumberedRoot.put(owner, data, hashFunction.applyAsInt(current), 0, details, forceUpdate, equalsFunction, hashFunction);
            }
            return new Tuple2<ChampTrie.BitmapIndexedNode<K>, Vector<Object>>(renumberedRoot, (Vector<Object>)renumberedVector);
        }

        public static <K extends ChampSequencedData> boolean seqEquals(K a, K b) {
            return a.getSequenceNumber() == b.getSequenceNumber();
        }

        public static <K extends ChampSequencedData> int seqHash(K e) {
            return ChampSequencedData.seqHash(e.getSequenceNumber());
        }

        public static int seqHash(int sequenceNumber) {
            int u = sequenceNumber + Integer.MIN_VALUE;
            return u >>> 27 | (u & 0x7C00000) >>> 17 | (u & 0x3E0000) >>> 7 | (u & 0x1F000) << 3 | (u & 0xF80) << 13 | (u & 0x7C) << 23 | (u & 3) << 30;
        }

        public static <K extends ChampSequencedData> ChampTrie.BitmapIndexedNode<K> seqRemove(ChampTrie.BitmapIndexedNode<K> seqRoot, ChampTrie.IdentityObject owner, K key, ChampTrie.ChangeEvent<K> details) {
            return seqRoot.remove(owner, (Object)key, ChampSequencedData.seqHash(key.getSequenceNumber()), 0, (ChampTrie.ChangeEvent)details, ChampSequencedData::seqEquals);
        }

        public static <K extends ChampSequencedData> ChampTrie.BitmapIndexedNode<K> seqUpdate(ChampTrie.BitmapIndexedNode<K> seqRoot, ChampTrie.IdentityObject owner, K key, ChampTrie.ChangeEvent<K> details, BiFunction<K, K, K> replaceFunction) {
            return seqRoot.put(owner, (Object)key, ChampSequencedData.seqHash(key.getSequenceNumber()), 0, (ChampTrie.ChangeEvent)details, (BiFunction)replaceFunction, ChampSequencedData::seqEquals, ChampSequencedData::seqHash);
        }

        public static <K extends ChampSequencedData> Tuple2<Vector<Object>, Integer> vecRemove(Vector<Object> vector, K oldElem, int offset) {
            int size = vector.size();
            int index = oldElem.getSequenceNumber() + offset;
            if (index == 0) {
                Object o;
                if (size > 1 && (o = vector.get(1)) instanceof ChampTombstone) {
                    ChampTombstone t = (ChampTombstone)o;
                    return new Tuple2<Vector<Object>, Integer>(((Vector)vector).removeRange(0, 2 + t.after()), offset - 2 - t.after());
                }
                return new Tuple2<IndexedSeq, Integer>(((Vector)vector).tail(), offset - 1);
            }
            if (index == size - 1) {
                Object o = vector.get(size - 2);
                if (o instanceof ChampTombstone) {
                    ChampTombstone t = (ChampTombstone)o;
                    return new Tuple2<Vector<Object>, Integer>(((Vector)vector).removeRange(size - 2 - t.before(), size), offset);
                }
                return new Tuple2<IndexedSeq, Integer>(((Vector)vector).init(), offset);
            }
            if (!(1.$assertionsDisabled || index > 0 && index < size - 1)) {
                throw new AssertionError();
            }
            Object before = vector.get(index - 1);
            Object after = vector.get(index + 1);
            if (before instanceof ChampTombstone && after instanceof ChampTombstone) {
                ChampTombstone tb = (ChampTombstone)before;
                ChampTombstone ta = (ChampTombstone)after;
                vector = ((Vector)vector).update(index - 1 - tb.before(), new ChampTombstone(0, 2 + tb.before() + ta.after()));
                vector = ((Vector)vector).update(index, TOMB_ZERO_ZERO);
                vector = ((Vector)vector).update(index + 1 + ta.after(), new ChampTombstone(2 + tb.before() + ta.after(), 0));
            } else if (before instanceof ChampTombstone) {
                ChampTombstone tb = (ChampTombstone)before;
                vector = ((Vector)vector).update(index - 1 - tb.before(), new ChampTombstone(0, 1 + tb.before()));
                vector = ((Vector)vector).update(index, new ChampTombstone(1 + tb.before(), 0));
            } else if (after instanceof ChampTombstone) {
                ChampTombstone ta = (ChampTombstone)after;
                vector = ((Vector)vector).update(index, new ChampTombstone(0, 1 + ta.after()));
                vector = ((Vector)vector).update(index + 1 + ta.after(), new ChampTombstone(1 + ta.after(), 0));
            } else {
                vector = ((Vector)vector).update(index, TOMB_ZERO_ZERO);
            }
            return new Tuple2<Vector<Object>, Integer>((Vector<Object>)vector, offset);
        }

        public static <T> Vector<T> removeRange(Vector<T> v, int fromIndex, int toIndex) {
            ChampTrie.ChampListHelper.checkIndex(fromIndex, toIndex + 1);
            ChampTrie.ChampListHelper.checkIndex(toIndex, v.size() + 1);
            if (fromIndex == 0) {
                return v.slice(toIndex, v.size());
            }
            if (toIndex == v.size()) {
                return v.slice(0, fromIndex);
            }
            IndexedSeq begin = v.slice(0, fromIndex);
            return ((Vector)begin).appendAll(() -> v.iterator(toIndex));
        }

        public static <K extends ChampSequencedData> Vector<Object> vecUpdate(Vector<Object> newSeqRoot, ChampTrie.IdentityObject owner, K newElem, ChampTrie.ChangeEvent<K> details, BiFunction<K, K, K> replaceFunction) {
            return newSeqRoot;
        }

        public int getSequenceNumber();

        static {
            if (1.$assertionsDisabled) {
                // empty if block
            }
            TOMB_ZERO_ZERO = new ChampTombstone(0, 0);
        }
    }

    static class ChampReverseVectorSpliterator<K>
    extends Spliterators.AbstractSpliterator<K> {
        private final Vector<Object> vector;
        private final Function<Object, K> mapper;
        private int index;
        private K current;

        ChampReverseVectorSpliterator(Vector<Object> vector, Function<Object, K> mapper, int fromIndex, int additionalCharacteristics, long est) {
            super(est, additionalCharacteristics);
            this.vector = vector;
            this.mapper = mapper;
            this.index = vector.size() - 1 - fromIndex;
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> action) {
            if (this.moveNext()) {
                action.accept(this.current);
                return true;
            }
            return false;
        }

        boolean moveNext() {
            Object o;
            if (this.index < 0) {
                return false;
            }
            if ((o = this.vector.get(this.index--)) instanceof ChampTombstone) {
                ChampTombstone t = (ChampTombstone)o;
                this.index -= t.before();
                o = this.vector.get(this.index--);
            }
            this.current = this.mapper.apply(o);
            return true;
        }

        K current() {
            return this.current;
        }
    }

    static class ChampVectorSpliterator<K>
    extends Spliterators.AbstractSpliterator<K> {
        private final BitMappedTrie.BitMappedTrieSpliterator<Object> vector;
        private final Function<Object, K> mapper;
        private K current;

        ChampVectorSpliterator(Vector<Object> vector, Function<Object, K> mapper, int fromIndex, long est, int additionalCharacteristics) {
            super(est, additionalCharacteristics);
            this.vector = new BitMappedTrie.BitMappedTrieSpliterator(vector.trie, fromIndex, 0);
            this.mapper = mapper;
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> action) {
            if (this.moveNext()) {
                action.accept(this.current);
                return true;
            }
            return false;
        }

        K current() {
            return this.current;
        }

        boolean moveNext() {
            boolean success = this.vector.moveNext();
            if (!success) {
                return false;
            }
            if (this.vector.current() instanceof ChampTombstone) {
                ChampTombstone t = (ChampTombstone)this.vector.current();
                this.vector.skip(t.after());
                this.vector.moveNext();
            }
            this.current = this.mapper.apply(this.vector.current());
            return true;
        }
    }
}

