/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.Tuple2;
import io.vavr.collection.ChampTrie;
import io.vavr.collection.Traversable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

class ChampTransience {
    ChampTransience() {
    }

    static abstract class ChampAbstractTransientSet<E, D>
    extends ChampAbstractTransientCollection<D> {
        ChampAbstractTransientSet() {
        }

        abstract void clear();

        abstract boolean remove(Object var1);

        boolean removeAll(Iterable<?> c) {
            if (this.isEmpty()) {
                return false;
            }
            if (c == this) {
                this.clear();
                return true;
            }
            boolean modified = false;
            for (Object o : c) {
                modified |= this.remove(o);
            }
            return modified;
        }

        abstract Iterator<E> iterator();

        boolean retainAll(Iterable<?> c) {
            Predicate<Object> predicate;
            HashSet that;
            if (this.isEmpty()) {
                return false;
            }
            if (c instanceof Collection && ((Collection)c).isEmpty()) {
                Collection cc = (Collection)c;
                this.clear();
                return true;
            }
            if (c instanceof Collection) {
                that = (HashSet)c;
                predicate = that::contains;
            } else {
                that = new HashSet();
                c.forEach(that::add);
                predicate = that::contains;
            }
            boolean removed = false;
            Iterator<E> i = this.iterator();
            while (i.hasNext()) {
                E e = i.next();
                if (predicate.test(e)) continue;
                this.remove(e);
                removed = true;
            }
            return removed;
        }
    }

    static abstract class ChampAbstractTransientMap<K, V, E>
    extends ChampAbstractTransientCollection<E> {
        ChampAbstractTransientMap() {
        }

        boolean removeAll(Iterable<?> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean modified = false;
            for (Object key : c) {
                ChampTrie.ChangeEvent<E> details = this.removeKey(key);
                modified |= details.isModified();
            }
            return modified;
        }

        abstract ChampTrie.ChangeEvent<E> removeKey(K var1);

        abstract void clear();

        abstract V put(K var1, V var2);

        boolean putAllTuples(Iterable<? extends Tuple2<? extends K, ? extends V>> c) {
            boolean modified = false;
            for (Tuple2<K, V> tuple2 : c) {
                Object oldValue = this.put(tuple2._1, tuple2._2);
                modified = modified || !Objects.equals(oldValue, tuple2);
            }
            return modified;
        }

        boolean retainAllTuples(Iterable<? extends Tuple2<K, V>> c) {
            if (this.isEmpty()) {
                return false;
            }
            if (c instanceof Collection && ((Collection)c).isEmpty() || c instanceof Traversable && ((Traversable)c).isEmpty()) {
                this.clear();
                return true;
            }
            if (c instanceof Collection) {
                Collection that = (Collection)c;
                return this.filterAll(e -> that.contains(e.getKey()));
            }
            if (c instanceof Map) {
                Map that = (Map)((Object)c);
                return this.filterAll(e -> that.containsKey(e.getKey()) && Objects.equals(e.getValue(), that.get(e.getKey())));
            }
            HashSet that = new HashSet();
            c.forEach(t -> that.add(new AbstractMap.SimpleImmutableEntry(t._1, t._2)));
            return this.filterAll(that::contains);
        }

        abstract boolean filterAll(Predicate<Map.Entry<K, V>> var1);
    }

    static abstract class ChampAbstractTransientCollection<D> {
        ChampTrie.IdentityObject owner;
        ChampTrie.BitmapIndexedNode<D> root;
        int size;
        int modCount;

        ChampAbstractTransientCollection() {
        }

        int size() {
            return this.size;
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        ChampTrie.IdentityObject makeOwner() {
            if (this.owner == null) {
                this.owner = new ChampTrie.IdentityObject();
            }
            return this.owner;
        }
    }
}

