/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;

public class ChampTrie {

    static class ChampListHelper {
        private ChampListHelper() {
        }

        static <T> T[] copyComponentAdd(T[] src, int index, int numComponents) {
            if (index == src.length) {
                return Arrays.copyOf(src, src.length + numComponents);
            }
            Object[] dst = (Object[])Array.newInstance(src.getClass().getComponentType(), src.length + numComponents);
            System.arraycopy(src, 0, dst, 0, index);
            System.arraycopy(src, index, dst, index + numComponents, src.length - index);
            return dst;
        }

        static <T> T[] copyComponentRemove(T[] src, int index, int numComponents) {
            if (index == src.length - numComponents) {
                return Arrays.copyOf(src, src.length - numComponents);
            }
            Object[] dst = (Object[])Array.newInstance(src.getClass().getComponentType(), src.length - numComponents);
            System.arraycopy(src, 0, dst, 0, index);
            System.arraycopy(src, index + numComponents, dst, index, src.length - index - numComponents);
            return dst;
        }

        static <T> T[] copySet(T[] src, int index, T value) {
            T[] dst = Arrays.copyOf(src, src.length);
            dst[index] = value;
            return dst;
        }

        static boolean arrayEquals(Object[] a, int aFrom, int aTo, Object[] b, int bFrom, int bTo) {
            if (aTo - aFrom != bTo - bFrom) {
                return false;
            }
            int bOffset = bFrom - aFrom;
            for (int i = aFrom; i < aTo; ++i) {
                if (Objects.equals(a[i], b[i + bOffset])) continue;
                return false;
            }
            return true;
        }

        static boolean arrayEquals(Object[] a, int aFrom, int aTo, Object[] b, int bFrom, int bTo, BiPredicate<Object, Object> c) {
            if (aTo - aFrom != bTo - bFrom) {
                return false;
            }
            int bOffset = bFrom - aFrom;
            for (int i = aFrom; i < aTo; ++i) {
                if (c.test(a[i], b[i + bOffset])) continue;
                return false;
            }
            return true;
        }

        static void checkIndex(int index, int size) {
            if (index < 0 || index >= size) {
                throw new IndexOutOfBoundsException("index=" + index + " size=" + size);
            }
        }
    }

    static class IdentityObject
    implements Serializable {
        private static final long serialVersionUID = 0L;

        IdentityObject() {
        }
    }

    static class BulkChangeEvent {
        int inBoth;
        boolean replaced;
        int removed;

        BulkChangeEvent() {
        }
    }

    static class ChangeEvent<D> {
        private Type type = Type.UNCHANGED;
        private D oldData;
        private D newData;

        ChangeEvent() {
        }

        boolean isUnchanged() {
            return this.type == Type.UNCHANGED;
        }

        boolean isAdded() {
            return this.type == Type.ADDED;
        }

        void setAdded(D newData) {
            this.newData = newData;
            this.type = Type.ADDED;
        }

        void found(D data) {
            this.oldData = data;
        }

        D getOldData() {
            return this.oldData;
        }

        D getNewData() {
            return this.newData;
        }

        D getOldDataNonNull() {
            return Objects.requireNonNull(this.oldData);
        }

        D getNewDataNonNull() {
            return Objects.requireNonNull(this.newData);
        }

        void setReplaced(D oldData, D newData) {
            this.oldData = oldData;
            this.newData = newData;
            this.type = Type.REPLACED;
        }

        void setRemoved(D oldData) {
            this.oldData = oldData;
            this.type = Type.REMOVED;
        }

        boolean isModified() {
            return this.type != Type.UNCHANGED;
        }

        boolean isReplaced() {
            return this.type == Type.REPLACED;
        }

        void reset() {
            this.type = Type.UNCHANGED;
            this.oldData = null;
            this.newData = null;
        }

        static enum Type {
            UNCHANGED,
            ADDED,
            REMOVED,
            REPLACED;

        }
    }

    static class NodeFactory {
        private NodeFactory() {
        }

        static <K> BitmapIndexedNode<K> newBitmapIndexedNode(IdentityObject owner, int nodeMap, int dataMap, Object[] nodes) {
            return owner == null ? new BitmapIndexedNode(nodeMap, dataMap, nodes) : new MutableBitmapIndexedNode(owner, nodeMap, dataMap, nodes);
        }

        static <K> HashCollisionNode<K> newHashCollisionNode(IdentityObject owner, int hash, Object[] entries) {
            return owner == null ? new HashCollisionNode(hash, entries) : new MutableHashCollisionNode(owner, hash, entries);
        }
    }

    static class MutableHashCollisionNode<K>
    extends HashCollisionNode<K> {
        private static final long serialVersionUID = 0L;
        private final IdentityObject owner;

        MutableHashCollisionNode(IdentityObject owner, int hash, Object[] entries) {
            super(hash, entries);
            this.owner = owner;
        }

        @Override
        IdentityObject getOwner() {
            return this.owner;
        }
    }

    static class MutableBitmapIndexedNode<K>
    extends BitmapIndexedNode<K> {
        private static final long serialVersionUID = 0L;
        private final IdentityObject owner;

        MutableBitmapIndexedNode(IdentityObject owner, int nodeMap, int dataMap, Object[] nodes) {
            super(nodeMap, dataMap, nodes);
            this.owner = owner;
        }

        @Override
        IdentityObject getOwner() {
            return this.owner;
        }
    }

    static class HashCollisionNode<D>
    extends Node<D> {
        private static final HashCollisionNode<?> EMPTY = new HashCollisionNode(0, new Object[0]);
        private final int hash;
        Object[] data;

        HashCollisionNode(int hash, Object[] data) {
            this.data = data;
            this.hash = hash;
        }

        @Override
        int dataArity() {
            return this.data.length;
        }

        @Override
        boolean hasDataArityOne() {
            return false;
        }

        @Override
        boolean equivalent(Object other) {
            if (this == other) {
                return true;
            }
            HashCollisionNode that = (HashCollisionNode)other;
            Object[] thatEntries = that.data;
            if (this.hash != that.hash || thatEntries.length != this.data.length) {
                return false;
            }
            Object[] thatEntriesCloned = (Object[])thatEntries.clone();
            int remainingLength = thatEntriesCloned.length;
            block0: for (Object key : this.data) {
                for (int j = 0; j < remainingLength; ++j) {
                    Object todoKey = thatEntriesCloned[j];
                    if (!Objects.equals(todoKey, key)) continue;
                    System.arraycopy(thatEntriesCloned, remainingLength - 1, thatEntriesCloned, j, 1);
                    --remainingLength;
                    continue block0;
                }
                return false;
            }
            return true;
        }

        @Override
        Object find(D key, int dataHash, int shift, BiPredicate<D, D> equalsFunction) {
            for (Object entry : this.data) {
                if (!equalsFunction.test(key, entry)) continue;
                return entry;
            }
            return NO_DATA;
        }

        @Override
        D getData(int index) {
            return (D)this.data[index];
        }

        @Override
        Node<D> getNode(int index) {
            throw new IllegalStateException("Is leaf node.");
        }

        @Override
        boolean hasData() {
            return this.data.length > 0;
        }

        @Override
        boolean hasNodes() {
            return false;
        }

        @Override
        int nodeArity() {
            return 0;
        }

        @Override
        Node<D> remove(IdentityObject owner, D data, int dataHash, int shift, ChangeEvent<D> details, BiPredicate<D, D> equalsFunction) {
            int idx = 0;
            int i = 0;
            while (i < this.data.length) {
                if (equalsFunction.test(this.data[i], data)) {
                    Object currentVal = this.data[i];
                    details.setRemoved(currentVal);
                    if (this.data.length == 1) {
                        return BitmapIndexedNode.emptyNode();
                    }
                    if (this.data.length == 2) {
                        return NodeFactory.newBitmapIndexedNode(owner, 0, HashCollisionNode.bitpos(HashCollisionNode.mask(dataHash, 0)), new Object[]{this.getData(idx ^ 1)});
                    }
                    Object[] entriesNew = ChampListHelper.copyComponentRemove(this.data, idx, 1);
                    if (this.isAllowedToUpdate(owner)) {
                        this.data = entriesNew;
                        return this;
                    }
                    return NodeFactory.newHashCollisionNode(owner, dataHash, entriesNew);
                }
                ++i;
                ++idx;
            }
            return this;
        }

        @Override
        Node<D> put(IdentityObject owner, D newData, int dataHash, int shift, ChangeEvent<D> details, BiFunction<D, D, D> updateFunction, BiPredicate<D, D> equalsFunction, ToIntFunction<D> hashFunction) {
            assert (this.hash == dataHash);
            for (int i = 0; i < this.data.length; ++i) {
                Object oldData = this.data[i];
                if (!equalsFunction.test(oldData, newData)) continue;
                D updatedData = updateFunction.apply(oldData, newData);
                if (updatedData == oldData) {
                    details.found(oldData);
                    return this;
                }
                details.setReplaced(oldData, updatedData);
                if (this.isAllowedToUpdate(owner)) {
                    this.data[i] = updatedData;
                    return this;
                }
                Object[] newKeys = ChampListHelper.copySet(this.data, i, updatedData);
                return NodeFactory.newHashCollisionNode(owner, dataHash, newKeys);
            }
            Object[] entriesNew = ChampListHelper.copyComponentAdd(this.data, this.data.length, 1);
            entriesNew[this.data.length] = newData;
            details.setAdded(newData);
            if (this.isAllowedToUpdate(owner)) {
                this.data = entriesNew;
                return this;
            }
            return NodeFactory.newHashCollisionNode(owner, dataHash, entriesNew);
        }

        @Override
        int calculateSize() {
            return this.dataArity();
        }

        @Override
        Node<D> putAll(IdentityObject owner, Node<D> otherNode, int shift, BulkChangeEvent bulkChange, BiFunction<D, D, D> updateFunction, BiPredicate<D, D> equalsFunction, ToIntFunction<D> hashFunction, ChangeEvent<D> details) {
            if (otherNode == this) {
                bulkChange.inBoth += this.dataArity();
                return this;
            }
            HashCollisionNode that = (HashCollisionNode)otherNode;
            int thisSize = this.dataArity();
            int thatSize = that.dataArity();
            Object[] buffer = Arrays.copyOf(this.data, thisSize + thatSize);
            System.arraycopy(this.data, 0, buffer, 0, this.data.length);
            Object[] thatArray = that.data;
            int resultSize = thisSize;
            boolean updated = false;
            block0: for (int i = 0; i < thatSize; ++i) {
                Object thatData = thatArray[i];
                for (int j = 0; j < thisSize; ++j) {
                    Object thisData = buffer[j];
                    if (!equalsFunction.test(thatData, thisData)) continue;
                    D updatedData = updateFunction.apply(thisData, thatData);
                    buffer[j] = updatedData;
                    updated |= updatedData != thisData;
                    ++bulkChange.inBoth;
                    continue block0;
                }
                buffer[resultSize++] = thatData;
            }
            return this.newCroppedHashCollisionNode(updated | resultSize != thisSize, buffer, resultSize);
        }

        @Override
        Node<D> removeAll(IdentityObject owner, Node<D> otherNode, int shift, BulkChangeEvent bulkChange, BiFunction<D, D, D> updateFunction, BiPredicate<D, D> equalsFunction, ToIntFunction<D> hashFunction, ChangeEvent<D> details) {
            if (otherNode == this) {
                bulkChange.removed += this.dataArity();
                return EMPTY;
            }
            HashCollisionNode that = (HashCollisionNode)otherNode;
            int thisSize = this.dataArity();
            int thatSize = that.dataArity();
            int resultSize = thisSize;
            Object[] buffer = (Object[])this.data.clone();
            Object[] thatArray = that.data;
            block0: for (int i = 0; i < thatSize && resultSize > 0; ++i) {
                Object thatData = thatArray[i];
                for (int j = 0; j < resultSize; ++j) {
                    Object thisData = buffer[j];
                    if (!equalsFunction.test(thatData, thisData)) continue;
                    System.arraycopy(buffer, j + 1, buffer, j, resultSize - j - 1);
                    --resultSize;
                    ++bulkChange.removed;
                    continue block0;
                }
            }
            return this.newCroppedHashCollisionNode(thisSize != resultSize, buffer, resultSize);
        }

        private HashCollisionNode<D> newCroppedHashCollisionNode(boolean changed, Object[] buffer, int size) {
            if (changed) {
                if (buffer.length != size) {
                    buffer = Arrays.copyOf(buffer, size);
                }
                return new HashCollisionNode<D>(this.hash, buffer);
            }
            return this;
        }

        @Override
        Node<D> retainAll(IdentityObject owner, Node<D> otherNode, int shift, BulkChangeEvent bulkChange, BiFunction<D, D, D> updateFunction, BiPredicate<D, D> equalsFunction, ToIntFunction<D> hashFunction, ChangeEvent<D> details) {
            if (otherNode == this) {
                bulkChange.removed += this.dataArity();
                return EMPTY;
            }
            HashCollisionNode that = (HashCollisionNode)otherNode;
            int thisSize = this.dataArity();
            int thatSize = that.dataArity();
            int resultSize = 0;
            Object[] buffer = (Object[])this.data.clone();
            Object[] thatArray = that.data;
            Object[] thisArray = this.data;
            block0: for (int i = 0; i < thatSize; ++i) {
                Object thatData = thatArray[i];
                for (int j = resultSize; j < thisSize; ++j) {
                    Object thisData = thisArray[j];
                    if (!equalsFunction.test(thatData, thisData)) continue;
                    buffer[resultSize++] = thisData;
                    continue block0;
                }
                ++bulkChange.removed;
            }
            return this.newCroppedHashCollisionNode(thisSize != resultSize, buffer, resultSize);
        }

        @Override
        Node<D> filterAll(IdentityObject owner, Predicate<? super D> predicate, int shift, BulkChangeEvent bulkChange) {
            int thisSize = this.dataArity();
            int resultSize = 0;
            Object[] buffer = new Object[thisSize];
            Object[] thisArray = this.data;
            for (int i = 0; i < thisSize; ++i) {
                Object thisData = thisArray[i];
                if (predicate.test(thisData)) {
                    buffer[resultSize++] = thisData;
                    continue;
                }
                ++bulkChange.removed;
            }
            return this.newCroppedHashCollisionNode(thisSize != resultSize, buffer, resultSize);
        }
    }

    static class BitmapIndexedNode<D>
    extends Node<D> {
        static final BitmapIndexedNode<?> EMPTY_NODE = NodeFactory.newBitmapIndexedNode(null, 0, 0, new Object[0]);
        final Object[] mixed;
        private final int nodeMap;
        private final int dataMap;

        BitmapIndexedNode(int nodeMap, int dataMap, Object[] mixed) {
            this.nodeMap = nodeMap;
            this.dataMap = dataMap;
            this.mixed = mixed;
            assert (mixed.length == this.nodeArity() + this.dataArity());
        }

        static <K> BitmapIndexedNode<K> emptyNode() {
            return EMPTY_NODE;
        }

        BitmapIndexedNode<D> copyAndInsertData(IdentityObject owner, int bitpos, D data) {
            int idx = this.dataIndex(bitpos);
            Object[] dst = ChampListHelper.copyComponentAdd(this.mixed, idx, 1);
            dst[idx] = data;
            return NodeFactory.newBitmapIndexedNode(owner, this.nodeMap, this.dataMap | bitpos, dst);
        }

        BitmapIndexedNode<D> copyAndMigrateFromDataToNode(IdentityObject owner, int bitpos, Node<D> node) {
            int idxOld = this.dataIndex(bitpos);
            int idxNew = this.mixed.length - 1 - this.nodeIndex(bitpos);
            assert (idxOld <= idxNew);
            Object[] src = this.mixed;
            Object[] dst = new Object[src.length];
            System.arraycopy(src, 0, dst, 0, idxOld);
            System.arraycopy(src, idxOld + 1, dst, idxOld, idxNew - idxOld);
            System.arraycopy(src, idxNew + 1, dst, idxNew + 1, src.length - idxNew - 1);
            dst[idxNew] = node;
            return NodeFactory.newBitmapIndexedNode(owner, this.nodeMap | bitpos, this.dataMap ^ bitpos, dst);
        }

        BitmapIndexedNode<D> copyAndMigrateFromNodeToData(IdentityObject owner, int bitpos, Node<D> node) {
            int idxOld = this.mixed.length - 1 - this.nodeIndex(bitpos);
            int idxNew = this.dataIndex(bitpos);
            Object[] src = this.mixed;
            Object[] dst = new Object[src.length];
            assert (idxOld >= idxNew);
            System.arraycopy(src, 0, dst, 0, idxNew);
            System.arraycopy(src, idxNew, dst, idxNew + 1, idxOld - idxNew);
            System.arraycopy(src, idxOld + 1, dst, idxOld + 1, src.length - idxOld - 1);
            dst[idxNew] = node.getData(0);
            return NodeFactory.newBitmapIndexedNode(owner, this.nodeMap ^ bitpos, this.dataMap | bitpos, dst);
        }

        BitmapIndexedNode<D> copyAndSetNode(IdentityObject owner, int bitpos, Node<D> node) {
            int idx = this.mixed.length - 1 - this.nodeIndex(bitpos);
            if (this.isAllowedToUpdate(owner)) {
                this.mixed[idx] = node;
                return this;
            }
            Object[] dst = ChampListHelper.copySet(this.mixed, idx, node);
            return NodeFactory.newBitmapIndexedNode(owner, this.nodeMap, this.dataMap, dst);
        }

        @Override
        int dataArity() {
            return Integer.bitCount(this.dataMap);
        }

        int dataIndex(int bitpos) {
            return Integer.bitCount(this.dataMap & bitpos - 1);
        }

        int index(int map, int bitpos) {
            return Integer.bitCount(map & bitpos - 1);
        }

        int dataMap() {
            return this.dataMap;
        }

        @Override
        boolean equivalent(Object other) {
            if (this == other) {
                return true;
            }
            BitmapIndexedNode that = (BitmapIndexedNode)other;
            Object[] thatNodes = that.mixed;
            int splitAt = this.dataArity();
            return this.nodeMap() == that.nodeMap() && this.dataMap() == that.dataMap() && ChampListHelper.arrayEquals(this.mixed, 0, splitAt, thatNodes, 0, splitAt) && ChampListHelper.arrayEquals(this.mixed, splitAt, this.mixed.length, thatNodes, splitAt, thatNodes.length, (a, b) -> ((Node)a).equivalent(b));
        }

        @Override
        Object find(D key, int dataHash, int shift, BiPredicate<D, D> equalsFunction) {
            D k;
            int bitpos = BitmapIndexedNode.bitpos(BitmapIndexedNode.mask(dataHash, shift));
            if ((this.nodeMap & bitpos) != 0) {
                return this.getNode(this.nodeIndex(bitpos)).find(key, dataHash, shift + 5, equalsFunction);
            }
            if ((this.dataMap & bitpos) != 0 && equalsFunction.test(k = this.getData(this.dataIndex(bitpos)), key)) {
                return k;
            }
            return NO_DATA;
        }

        @Override
        D getData(int index) {
            return (D)this.mixed[index];
        }

        @Override
        Node<D> getNode(int index) {
            return (Node)this.mixed[this.mixed.length - 1 - index];
        }

        @Override
        boolean hasData() {
            return this.dataMap != 0;
        }

        @Override
        boolean hasDataArityOne() {
            return Integer.bitCount(this.dataMap) == 1;
        }

        @Override
        boolean hasNodes() {
            return this.nodeMap != 0;
        }

        @Override
        int nodeArity() {
            return Integer.bitCount(this.nodeMap);
        }

        int nodeIndex(int bitpos) {
            return Integer.bitCount(this.nodeMap & bitpos - 1);
        }

        int nodeMap() {
            return this.nodeMap;
        }

        @Override
        BitmapIndexedNode<D> remove(IdentityObject owner, D data, int dataHash, int shift, ChangeEvent<D> details, BiPredicate<D, D> equalsFunction) {
            int mask = BitmapIndexedNode.mask(dataHash, shift);
            int bitpos = BitmapIndexedNode.bitpos(mask);
            if ((this.dataMap & bitpos) != 0) {
                return this.removeData(owner, data, dataHash, shift, details, bitpos, equalsFunction);
            }
            if ((this.nodeMap & bitpos) != 0) {
                return this.removeSubNode(owner, data, dataHash, shift, details, bitpos, equalsFunction);
            }
            return this;
        }

        private BitmapIndexedNode<D> removeData(IdentityObject owner, D data, int dataHash, int shift, ChangeEvent<D> details, int bitpos, BiPredicate<D, D> equalsFunction) {
            int dataIndex = this.dataIndex(bitpos);
            int entryLength = 1;
            if (!equalsFunction.test(this.getData(dataIndex), data)) {
                return this;
            }
            D currentVal = this.getData(dataIndex);
            details.setRemoved(currentVal);
            if (this.dataArity() == 2 && !this.hasNodes()) {
                int newDataMap = shift == 0 ? this.dataMap ^ bitpos : BitmapIndexedNode.bitpos(BitmapIndexedNode.mask(dataHash, 0));
                Object[] nodes = new Object[]{this.getData(dataIndex ^ 1)};
                return NodeFactory.newBitmapIndexedNode(owner, 0, newDataMap, nodes);
            }
            int idx = dataIndex * entryLength;
            Object[] dst = ChampListHelper.copyComponentRemove(this.mixed, idx, entryLength);
            return NodeFactory.newBitmapIndexedNode(owner, this.nodeMap, this.dataMap ^ bitpos, dst);
        }

        private BitmapIndexedNode<D> removeSubNode(IdentityObject owner, D data, int dataHash, int shift, ChangeEvent<D> details, int bitpos, BiPredicate<D, D> equalsFunction) {
            Node<D> updatedSubNode;
            Node<D> subNode = this.getNode(this.nodeIndex(bitpos));
            if (subNode == (updatedSubNode = subNode.remove(owner, data, dataHash, shift + 5, details, equalsFunction))) {
                return this;
            }
            if (!updatedSubNode.hasNodes() && updatedSubNode.hasDataArityOne()) {
                if (!this.hasData() && this.nodeArity() == 1) {
                    return (BitmapIndexedNode)updatedSubNode;
                }
                return this.copyAndMigrateFromNodeToData(owner, bitpos, updatedSubNode);
            }
            return this.copyAndSetNode(owner, bitpos, updatedSubNode);
        }

        @Override
        BitmapIndexedNode<D> put(IdentityObject owner, D newData, int dataHash, int shift, ChangeEvent<D> details, BiFunction<D, D, D> updateFunction, BiPredicate<D, D> equalsFunction, ToIntFunction<D> hashFunction) {
            int mask = BitmapIndexedNode.mask(dataHash, shift);
            int bitpos = BitmapIndexedNode.bitpos(mask);
            if ((this.dataMap & bitpos) != 0) {
                int dataIndex = this.dataIndex(bitpos);
                D oldData = this.getData(dataIndex);
                if (equalsFunction.test(oldData, newData)) {
                    D updatedData = updateFunction.apply(oldData, newData);
                    if (updatedData == oldData) {
                        details.found(oldData);
                        return this;
                    }
                    details.setReplaced(oldData, updatedData);
                    return this.copyAndSetData(owner, dataIndex, updatedData);
                }
                Node<D> updatedSubNode = BitmapIndexedNode.mergeTwoDataEntriesIntoNode(owner, oldData, hashFunction.applyAsInt(oldData), newData, dataHash, shift + 5);
                details.setAdded(newData);
                return this.copyAndMigrateFromDataToNode(owner, bitpos, updatedSubNode);
            }
            if ((this.nodeMap & bitpos) != 0) {
                Node<D> updatedSubNode;
                Node<D> subNode = this.getNode(this.nodeIndex(bitpos));
                return subNode == (updatedSubNode = subNode.put(owner, newData, dataHash, shift + 5, details, updateFunction, equalsFunction, hashFunction)) ? this : this.copyAndSetNode(owner, bitpos, updatedSubNode);
            }
            details.setAdded(newData);
            return this.copyAndInsertData(owner, bitpos, newData);
        }

        private BitmapIndexedNode<D> copyAndSetData(IdentityObject owner, int dataIndex, D updatedData) {
            if (this.isAllowedToUpdate(owner)) {
                this.mixed[dataIndex] = updatedData;
                return this;
            }
            Object[] newMixed = ChampListHelper.copySet(this.mixed, dataIndex, updatedData);
            return NodeFactory.newBitmapIndexedNode(owner, this.nodeMap, this.dataMap, newMixed);
        }

        @Override
        BitmapIndexedNode<D> putAll(IdentityObject owner, Node<D> other, int shift, BulkChangeEvent bulkChange, BiFunction<D, D, D> updateFunction, BiPredicate<D, D> equalsFunction, ToIntFunction<D> hashFunction, ChangeEvent<D> details) {
            BitmapIndexedNode that = (BitmapIndexedNode)other;
            if (this == that) {
                bulkChange.inBoth += this.calculateSize();
                return this;
            }
            int newBitMap = this.nodeMap | this.dataMap | that.nodeMap | that.dataMap;
            Object[] buffer = new Object[Integer.bitCount(newBitMap)];
            int newDataMap = this.dataMap | that.dataMap;
            int newNodeMap = this.nodeMap | that.nodeMap;
            for (int mapToDo = newBitMap; mapToDo != 0; mapToDo ^= Integer.lowestOneBit(mapToDo)) {
                D thatData;
                D thisData;
                Node<Object> thatNode;
                boolean thatIsNode;
                int mask = Integer.numberOfTrailingZeros(mapToDo);
                int bitpos = BitmapIndexedNode.bitpos(mask);
                boolean thisIsData = (this.dataMap & bitpos) != 0;
                boolean thatIsData = (that.dataMap & bitpos) != 0;
                boolean thisIsNode = (this.nodeMap & bitpos) != 0;
                boolean bl = thatIsNode = (that.nodeMap & bitpos) != 0;
                if (!thisIsNode && !thisIsData) {
                    if (thatIsData) {
                        buffer[this.index((int)newDataMap, (int)bitpos)] = that.getData(that.dataIndex(bitpos));
                        continue;
                    }
                    buffer[buffer.length - 1 - this.index((int)newNodeMap, (int)bitpos)] = that.getNode(that.nodeIndex(bitpos));
                    continue;
                }
                if (!thatIsNode && !thatIsData) {
                    if (thisIsData) {
                        buffer[this.index((int)newDataMap, (int)bitpos)] = this.getData(this.dataIndex(bitpos));
                        continue;
                    }
                    buffer[buffer.length - 1 - this.index((int)newNodeMap, (int)bitpos)] = this.getNode(this.nodeIndex(bitpos));
                    continue;
                }
                if (thisIsNode && thatIsNode) {
                    Node<D> thisNode = this.getNode(this.nodeIndex(bitpos));
                    thatNode = that.getNode(that.nodeIndex(bitpos));
                    buffer[buffer.length - 1 - this.index((int)newNodeMap, (int)bitpos)] = thisNode.putAll(owner, thatNode, shift + 5, bulkChange, updateFunction, equalsFunction, hashFunction, details);
                    continue;
                }
                if (thisIsData && thatIsNode) {
                    thisData = this.getData(this.dataIndex(bitpos));
                    thatNode = that.getNode(that.nodeIndex(bitpos));
                    details.reset();
                    buffer[buffer.length - 1 - this.index((int)newNodeMap, (int)bitpos)] = thatNode.put(null, thisData, hashFunction.applyAsInt(thisData), shift + 5, details, (D a, D b) -> updateFunction.apply(b, a), equalsFunction, hashFunction);
                    if (details.isUnchanged()) {
                        ++bulkChange.inBoth;
                    } else if (details.isReplaced()) {
                        bulkChange.replaced = true;
                        ++bulkChange.inBoth;
                    }
                    newDataMap ^= bitpos;
                    continue;
                }
                if (thisIsNode) {
                    D thatData2 = that.getData(that.dataIndex(bitpos));
                    Node<D> thisNode = this.getNode(this.nodeIndex(bitpos));
                    details.reset();
                    buffer[buffer.length - 1 - this.index((int)newNodeMap, (int)bitpos)] = thisNode.put(owner, thatData2, hashFunction.applyAsInt(thatData2), shift + 5, details, updateFunction, equalsFunction, hashFunction);
                    if (!details.isModified()) {
                        ++bulkChange.inBoth;
                    }
                    newDataMap ^= bitpos;
                    continue;
                }
                thisData = this.getData(this.dataIndex(bitpos));
                if (equalsFunction.test(thisData, thatData = that.getData(that.dataIndex(bitpos)))) {
                    ++bulkChange.inBoth;
                    D updated = updateFunction.apply(thisData, thatData);
                    buffer[this.index((int)newDataMap, (int)bitpos)] = updated;
                    bulkChange.replaced = bulkChange.replaced | updated != thisData;
                    continue;
                }
                newDataMap ^= bitpos;
                buffer[buffer.length - 1 - this.index((int)(newNodeMap ^= bitpos), (int)bitpos)] = BitmapIndexedNode.mergeTwoDataEntriesIntoNode(owner, thisData, hashFunction.applyAsInt(thisData), thatData, hashFunction.applyAsInt(thatData), shift + 5);
            }
            return new BitmapIndexedNode<D>(newNodeMap, newDataMap, buffer);
        }

        @Override
        BitmapIndexedNode<D> removeAll(IdentityObject owner, Node<D> other, int shift, BulkChangeEvent bulkChange, BiFunction<D, D, D> updateFunction, BiPredicate<D, D> equalsFunction, ToIntFunction<D> hashFunction, ChangeEvent<D> details) {
            BitmapIndexedNode that = (BitmapIndexedNode)other;
            if (this == that) {
                bulkChange.inBoth += this.calculateSize();
                return this;
            }
            int newBitMap = this.nodeMap | this.dataMap;
            Object[] buffer = new Object[Integer.bitCount(newBitMap)];
            int newDataMap = this.dataMap;
            int newNodeMap = this.nodeMap;
            for (int mapToDo = newBitMap; mapToDo != 0; mapToDo ^= Integer.lowestOneBit(mapToDo)) {
                D thatData;
                D thisData;
                Object result;
                Node<D> thatNode;
                boolean thatIsNode;
                int mask = Integer.numberOfTrailingZeros(mapToDo);
                int bitpos = BitmapIndexedNode.bitpos(mask);
                boolean thisIsData = (this.dataMap & bitpos) != 0;
                boolean thatIsData = (that.dataMap & bitpos) != 0;
                boolean thisIsNode = (this.nodeMap & bitpos) != 0;
                boolean bl = thatIsNode = (that.nodeMap & bitpos) != 0;
                if (!thisIsNode && !thisIsData) {
                    assert (false);
                    continue;
                }
                if (!thatIsNode && !thatIsData) {
                    if (thisIsData) {
                        buffer[this.index((int)newDataMap, (int)bitpos)] = this.getData(this.dataIndex(bitpos));
                        continue;
                    }
                    buffer[buffer.length - 1 - this.index((int)newNodeMap, (int)bitpos)] = this.getNode(this.nodeIndex(bitpos));
                    continue;
                }
                if (thisIsNode && thatIsNode) {
                    Node<D> thisNode = this.getNode(this.nodeIndex(bitpos));
                    result = thisNode.removeAll(owner, thatNode = that.getNode(that.nodeIndex(bitpos)), shift + 5, bulkChange, updateFunction, equalsFunction, hashFunction, details);
                    if (((Node)result).isNodeEmpty()) {
                        newNodeMap ^= bitpos;
                        continue;
                    }
                    if (((Node)result).hasMany()) {
                        buffer[buffer.length - 1 - this.index((int)newNodeMap, (int)bitpos)] = result;
                        continue;
                    }
                    newNodeMap ^= bitpos;
                    buffer[this.index((int)(newDataMap ^= bitpos), (int)bitpos)] = ((Node)result).getData(0);
                    continue;
                }
                if (thisIsData && thatIsNode) {
                    thisData = this.getData(this.dataIndex(bitpos));
                    thatNode = that.getNode(that.nodeIndex(bitpos));
                    result = thatNode.find(thisData, hashFunction.applyAsInt(thisData), shift + 5, equalsFunction);
                    if (result == NO_DATA) {
                        buffer[this.index((int)newDataMap, (int)bitpos)] = thisData;
                        continue;
                    }
                    newDataMap ^= bitpos;
                    ++bulkChange.removed;
                    continue;
                }
                if (thisIsNode) {
                    D thatData2 = that.getData(that.dataIndex(bitpos));
                    Node<D> thisNode = this.getNode(this.nodeIndex(bitpos));
                    details.reset();
                    result = thisNode.remove(owner, thatData2, hashFunction.applyAsInt(thatData2), shift + 5, details, equalsFunction);
                    if (details.isModified()) {
                        ++bulkChange.removed;
                    }
                    if (((Node)result).isNodeEmpty()) {
                        newNodeMap ^= bitpos;
                        continue;
                    }
                    if (((Node)result).hasMany()) {
                        buffer[buffer.length - 1 - this.index((int)newNodeMap, (int)bitpos)] = result;
                        continue;
                    }
                    newNodeMap ^= bitpos;
                    buffer[this.index((int)(newDataMap ^= bitpos), (int)bitpos)] = ((Node)result).getData(0);
                    continue;
                }
                thisData = this.getData(this.dataIndex(bitpos));
                if (equalsFunction.test(thisData, thatData = that.getData(that.dataIndex(bitpos)))) {
                    ++bulkChange.removed;
                    newDataMap ^= bitpos;
                    continue;
                }
                buffer[this.index((int)newDataMap, (int)bitpos)] = thisData;
            }
            return this.newCroppedBitmapIndexedNode(buffer, newDataMap, newNodeMap);
        }

        private BitmapIndexedNode<D> newCroppedBitmapIndexedNode(Object[] buffer, int newDataMap, int newNodeMap) {
            int newLength = Integer.bitCount(newNodeMap | newDataMap);
            if (newLength != buffer.length) {
                Object[] temp = buffer;
                buffer = new Object[newLength];
                int dataCount = Integer.bitCount(newDataMap);
                int nodeCount = Integer.bitCount(newNodeMap);
                System.arraycopy(temp, 0, buffer, 0, dataCount);
                System.arraycopy(temp, temp.length - nodeCount, buffer, dataCount, nodeCount);
            }
            return new BitmapIndexedNode<D>(newNodeMap, newDataMap, buffer);
        }

        @Override
        BitmapIndexedNode<D> retainAll(IdentityObject owner, Node<D> other, int shift, BulkChangeEvent bulkChange, BiFunction<D, D, D> updateFunction, BiPredicate<D, D> equalsFunction, ToIntFunction<D> hashFunction, ChangeEvent<D> details) {
            BitmapIndexedNode that = (BitmapIndexedNode)other;
            if (this == that) {
                bulkChange.inBoth += this.calculateSize();
                return this;
            }
            int newBitMap = this.nodeMap | this.dataMap;
            Object[] buffer = new Object[Integer.bitCount(newBitMap)];
            int newDataMap = this.dataMap;
            int newNodeMap = this.nodeMap;
            for (int mapToDo = newBitMap; mapToDo != 0; mapToDo ^= Integer.lowestOneBit(mapToDo)) {
                D thatData;
                D thisData;
                Object result;
                Node<D> thatNode;
                boolean thatIsNode;
                int mask = Integer.numberOfTrailingZeros(mapToDo);
                int bitpos = BitmapIndexedNode.bitpos(mask);
                boolean thisIsData = (this.dataMap & bitpos) != 0;
                boolean thatIsData = (that.dataMap & bitpos) != 0;
                boolean thisIsNode = (this.nodeMap & bitpos) != 0;
                boolean bl = thatIsNode = (that.nodeMap & bitpos) != 0;
                if (!thisIsNode && !thisIsData) {
                    assert (false);
                    continue;
                }
                if (!thatIsNode && !thatIsData) {
                    if (thisIsData) {
                        newDataMap ^= bitpos;
                        ++bulkChange.removed;
                        continue;
                    }
                    newNodeMap ^= bitpos;
                    bulkChange.removed += this.getNode(this.nodeIndex(bitpos)).calculateSize();
                    continue;
                }
                if (thisIsNode && thatIsNode) {
                    Node<D> thisNode = this.getNode(this.nodeIndex(bitpos));
                    result = thisNode.retainAll(owner, thatNode = that.getNode(that.nodeIndex(bitpos)), shift + 5, bulkChange, updateFunction, equalsFunction, hashFunction, details);
                    if (((Node)result).isNodeEmpty()) {
                        newNodeMap ^= bitpos;
                        continue;
                    }
                    if (((Node)result).hasMany()) {
                        buffer[buffer.length - 1 - this.index((int)newNodeMap, (int)bitpos)] = result;
                        continue;
                    }
                    newNodeMap ^= bitpos;
                    buffer[this.index((int)(newDataMap ^= bitpos), (int)bitpos)] = ((Node)result).getData(0);
                    continue;
                }
                if (thisIsData && thatIsNode) {
                    thisData = this.getData(this.dataIndex(bitpos));
                    thatNode = that.getNode(that.nodeIndex(bitpos));
                    result = thatNode.find(thisData, hashFunction.applyAsInt(thisData), shift + 5, equalsFunction);
                    if (result == NO_DATA) {
                        newDataMap ^= bitpos;
                        ++bulkChange.removed;
                        continue;
                    }
                    buffer[this.index((int)newDataMap, (int)bitpos)] = thisData;
                    continue;
                }
                if (thisIsNode) {
                    D thatData2 = that.getData(that.dataIndex(bitpos));
                    Node<D> thisNode = this.getNode(this.nodeIndex(bitpos));
                    result = thisNode.find(thatData2, hashFunction.applyAsInt(thatData2), shift + 5, equalsFunction);
                    if (result == NO_DATA) {
                        bulkChange.removed += this.getNode(this.nodeIndex(bitpos)).calculateSize();
                        newNodeMap ^= bitpos;
                        continue;
                    }
                    newNodeMap ^= bitpos;
                    buffer[this.index((int)(newDataMap ^= bitpos), (int)bitpos)] = result;
                    bulkChange.removed += this.getNode(this.nodeIndex(bitpos)).calculateSize() - 1;
                    continue;
                }
                thisData = this.getData(this.dataIndex(bitpos));
                if (equalsFunction.test(thisData, thatData = that.getData(that.dataIndex(bitpos)))) {
                    buffer[this.index((int)newDataMap, (int)bitpos)] = thisData;
                    continue;
                }
                ++bulkChange.removed;
                newDataMap ^= bitpos;
            }
            return this.newCroppedBitmapIndexedNode(buffer, newDataMap, newNodeMap);
        }

        @Override
        BitmapIndexedNode<D> filterAll(IdentityObject owner, Predicate<? super D> predicate, int shift, BulkChangeEvent bulkChange) {
            int newBitMap = this.nodeMap | this.dataMap;
            Object[] buffer = new Object[Integer.bitCount(newBitMap)];
            int newDataMap = this.dataMap;
            int newNodeMap = this.nodeMap;
            for (int mapToDo = newBitMap; mapToDo != 0; mapToDo ^= Integer.lowestOneBit(mapToDo)) {
                boolean thisIsNode;
                int mask = Integer.numberOfTrailingZeros(mapToDo);
                int bitpos = BitmapIndexedNode.bitpos(mask);
                boolean bl = thisIsNode = (this.nodeMap & bitpos) != 0;
                if (thisIsNode) {
                    Node<? super D> thisNode = this.getNode(this.nodeIndex(bitpos));
                    Node<D> result = thisNode.filterAll(owner, predicate, shift + 5, bulkChange);
                    if (result.isNodeEmpty()) {
                        newNodeMap ^= bitpos;
                        continue;
                    }
                    if (result.hasMany()) {
                        buffer[buffer.length - 1 - this.index((int)newNodeMap, (int)bitpos)] = result;
                        continue;
                    }
                    newNodeMap ^= bitpos;
                    buffer[this.index((int)(newDataMap ^= bitpos), (int)bitpos)] = result.getData(0);
                    continue;
                }
                D thisData = this.getData(this.dataIndex(bitpos));
                if (predicate.test(thisData)) {
                    buffer[this.index((int)newDataMap, (int)bitpos)] = thisData;
                    continue;
                }
                newDataMap ^= bitpos;
                ++bulkChange.removed;
            }
            return this.newCroppedBitmapIndexedNode(buffer, newDataMap, newNodeMap);
        }

        @Override
        int calculateSize() {
            int size = this.dataArity();
            int n = this.nodeArity();
            for (int i = 0; i < n; ++i) {
                Node<D> node = this.getNode(i);
                size += node.calculateSize();
            }
            return size;
        }
    }

    static abstract class Node<D> {
        static final Object NO_DATA = new Object();
        static final int HASH_CODE_LENGTH = 32;
        static final int BIT_PARTITION_SIZE = 5;
        static final int BIT_PARTITION_MASK = 31;
        static final int MAX_DEPTH = 8;

        Node() {
        }

        static int bitpos(int mask) {
            return 1 << mask;
        }

        static <E> E getFirst(Node<E> node) {
            int dataMap;
            BitmapIndexedNode bxn;
            int nodeMap;
            while (node instanceof BitmapIndexedNode && ((nodeMap = (bxn = (BitmapIndexedNode)node).nodeMap()) | (dataMap = bxn.dataMap())) != 0) {
                int firstNodeBit = Integer.numberOfTrailingZeros(nodeMap);
                int firstDataBit = Integer.numberOfTrailingZeros(dataMap);
                if (nodeMap != 0 && firstNodeBit < firstDataBit) {
                    node = node.getNode(0);
                    continue;
                }
                return node.getData(0);
            }
            if (node instanceof HashCollisionNode) {
                HashCollisionNode hcn = (HashCollisionNode)node;
                return (E)hcn.getData(0);
            }
            throw new NoSuchElementException();
        }

        static <E> E getLast(Node<E> node) {
            int dataMap;
            BitmapIndexedNode bxn;
            int nodeMap;
            while (node instanceof BitmapIndexedNode && ((nodeMap = (bxn = (BitmapIndexedNode)node).nodeMap()) | (dataMap = bxn.dataMap())) != 0) {
                if (Integer.compareUnsigned(nodeMap, dataMap) > 0) {
                    node = node.getNode(node.nodeArity() - 1);
                    continue;
                }
                return node.getData(node.dataArity() - 1);
            }
            if (node instanceof HashCollisionNode) {
                HashCollisionNode hcn = (HashCollisionNode)node;
                return (E)hcn.getData(hcn.dataArity() - 1);
            }
            throw new NoSuchElementException();
        }

        static int mask(int dataHash, int shift) {
            return dataHash >>> shift & 0x1F;
        }

        static <K> Node<K> mergeTwoDataEntriesIntoNode(IdentityObject owner, K k0, int keyHash0, K k1, int keyHash1, int shift) {
            int mask1;
            if (shift >= 32) {
                Object[] entries = new Object[]{k0, k1};
                return NodeFactory.newHashCollisionNode(owner, keyHash0, entries);
            }
            int mask0 = Node.mask(keyHash0, shift);
            if (mask0 != (mask1 = Node.mask(keyHash1, shift))) {
                int dataMap = Node.bitpos(mask0) | Node.bitpos(mask1);
                Object[] entries = new Object[2];
                if (mask0 < mask1) {
                    entries[0] = k0;
                    entries[1] = k1;
                } else {
                    entries[0] = k1;
                    entries[1] = k0;
                }
                return NodeFactory.newBitmapIndexedNode(owner, 0, dataMap, entries);
            }
            Node<K> node = Node.mergeTwoDataEntriesIntoNode(owner, k0, keyHash0, k1, keyHash1, shift + 5);
            int nodeMap = Node.bitpos(mask0);
            return NodeFactory.newBitmapIndexedNode(owner, nodeMap, 0, new Object[]{node});
        }

        abstract int dataArity();

        abstract boolean equivalent(Object var1);

        abstract Object find(D var1, int var2, int var3, BiPredicate<D, D> var4);

        abstract D getData(int var1);

        IdentityObject getOwner() {
            return null;
        }

        abstract Node<D> getNode(int var1);

        abstract boolean hasData();

        boolean isNodeEmpty() {
            return !this.hasData() && !this.hasNodes();
        }

        boolean hasMany() {
            return this.hasNodes() || this.dataArity() > 1;
        }

        abstract boolean hasDataArityOne();

        abstract boolean hasNodes();

        boolean isAllowedToUpdate(IdentityObject y) {
            IdentityObject x = this.getOwner();
            return x != null && x == y;
        }

        abstract int nodeArity();

        abstract Node<D> remove(IdentityObject var1, D var2, int var3, int var4, ChangeEvent<D> var5, BiPredicate<D, D> var6);

        abstract Node<D> put(IdentityObject var1, D var2, int var3, int var4, ChangeEvent<D> var5, BiFunction<D, D, D> var6, BiPredicate<D, D> var7, ToIntFunction<D> var8);

        abstract Node<D> putAll(IdentityObject var1, Node<D> var2, int var3, BulkChangeEvent var4, BiFunction<D, D, D> var5, BiPredicate<D, D> var6, ToIntFunction<D> var7, ChangeEvent<D> var8);

        abstract Node<D> removeAll(IdentityObject var1, Node<D> var2, int var3, BulkChangeEvent var4, BiFunction<D, D, D> var5, BiPredicate<D, D> var6, ToIntFunction<D> var7, ChangeEvent<D> var8);

        abstract Node<D> retainAll(IdentityObject var1, Node<D> var2, int var3, BulkChangeEvent var4, BiFunction<D, D, D> var5, BiPredicate<D, D> var6, ToIntFunction<D> var7, ChangeEvent<D> var8);

        abstract Node<D> filterAll(IdentityObject var1, Predicate<? super D> var2, int var3, BulkChangeEvent var4);

        abstract int calculateSize();
    }
}

