/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.ChampIteration;
import io.vavr.collection.ChampTransience;
import io.vavr.collection.ChampTrie;
import io.vavr.collection.Collections;
import io.vavr.collection.HashSet;
import io.vavr.collection.Iterator;
import io.vavr.collection.Map;
import io.vavr.collection.Maps;
import io.vavr.collection.Set;
import io.vavr.collection.Stream;
import io.vavr.collection.Traversable;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;

public final class HashMap<K, V>
implements Map<K, V>,
Serializable {
    private final ChampTrie.BitmapIndexedNode<AbstractMap.SimpleImmutableEntry<K, V>> root;
    private static final long serialVersionUID = 1L;
    private static final HashMap<?, ?> EMPTY = new HashMap(ChampTrie.BitmapIndexedNode.emptyNode(), 0);
    static final int SALT = 0;
    final int size;

    HashMap(ChampTrie.BitmapIndexedNode<AbstractMap.SimpleImmutableEntry<K, V>> root, int size) {
        this.root = root;
        this.size = size;
    }

    public static <K, V> Collector<Tuple2<K, V>, ArrayList<Tuple2<K, V>>, HashMap<K, V>> collector() {
        return Collections.toListAndThen(HashMap::ofEntries);
    }

    public static <K, V, T extends V> Collector<T, ArrayList<T>, HashMap<K, V>> collector(Function<? super T, ? extends K> keyMapper) {
        Objects.requireNonNull(keyMapper, "keyMapper is null");
        return HashMap.collector(keyMapper, v -> v);
    }

    public static <K, V, T> Collector<T, ArrayList<T>, HashMap<K, V>> collector(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        Objects.requireNonNull(keyMapper, "keyMapper is null");
        Objects.requireNonNull(valueMapper, "valueMapper is null");
        return Collections.toListAndThen(arr -> HashMap.ofEntries(Iterator.ofAll(arr).map((T t) -> Tuple.of(keyMapper.apply(t), valueMapper.apply(t)))));
    }

    public static <K, V> HashMap<K, V> empty() {
        return EMPTY;
    }

    public static <K, V> HashMap<K, V> narrow(HashMap<? extends K, ? extends V> hashMap) {
        return hashMap;
    }

    public static <K, V> HashMap<K, V> of(Tuple2<? extends K, ? extends V> entry) {
        return HashMap.empty().put(entry._1, entry._2);
    }

    public static <K, V> HashMap<K, V> ofAll(java.util.Map<? extends K, ? extends V> map) {
        return super.putAllEntries(map.entrySet());
    }

    public static <T, K, V> HashMap<K, V> ofAll(java.util.stream.Stream<? extends T> stream, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return Maps.ofStream(HashMap.empty(), stream, keyMapper, valueMapper);
    }

    public static <T, K, V> HashMap<K, V> ofAll(java.util.stream.Stream<? extends T> stream, Function<? super T, Tuple2<? extends K, ? extends V>> entryMapper) {
        return Maps.ofStream(HashMap.empty(), stream, entryMapper);
    }

    public static <K, V> HashMap<K, V> of(K key, V value) {
        return HashMap.empty().put((Object)key, (Object)value);
    }

    public static <K, V> HashMap<K, V> of(K k1, V v1, K k2, V v2) {
        return HashMap.of(k1, v1).put((Object)k2, (Object)v2);
    }

    public static <K, V> HashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return HashMap.of(k1, v1, k2, v2).put((Object)k3, (Object)v3);
    }

    public static <K, V> HashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return HashMap.of(k1, v1, k2, v2, k3, v3).put((Object)k4, (Object)v4);
    }

    public static <K, V> HashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return HashMap.of(k1, v1, k2, v2, k3, v3, k4, v4).put((Object)k5, (Object)v5);
    }

    public static <K, V> HashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        return HashMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5).put((Object)k6, (Object)v6);
    }

    public static <K, V> HashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        return HashMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6).put((Object)k7, (Object)v7);
    }

    public static <K, V> HashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        return HashMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7).put((Object)k8, (Object)v8);
    }

    public static <K, V> HashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        return HashMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8).put((Object)k9, (Object)v9);
    }

    public static <K, V> HashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10) {
        return HashMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8, k9, v9).put((Object)k10, (Object)v10);
    }

    public static <K, V> HashMap<K, V> tabulate(int n, Function<? super Integer, ? extends Tuple2<? extends K, ? extends V>> f) {
        Objects.requireNonNull(f, "f is null");
        return HashMap.ofEntries(Collections.tabulate(n, f));
    }

    public static <K, V> HashMap<K, V> fill(int n, Supplier<? extends Tuple2<? extends K, ? extends V>> s) {
        Objects.requireNonNull(s, "s is null");
        return HashMap.ofEntries(Collections.fill(n, s));
    }

    @SafeVarargs
    public static <K, V> HashMap<K, V> ofEntries(Map.Entry<? extends K, ? extends V> ... entries) {
        Objects.requireNonNull(entries, "entries is null");
        return super.putAllEntries(Arrays.asList(entries));
    }

    @SafeVarargs
    public static <K, V> HashMap<K, V> ofEntries(Tuple2<? extends K, ? extends V> ... entries) {
        Objects.requireNonNull(entries, "entries is null");
        return super.putAllTuples(Arrays.asList(entries));
    }

    public static <K, V> HashMap<K, V> ofEntries(Iterable<? extends Tuple2<? extends K, ? extends V>> entries) {
        Objects.requireNonNull(entries, "entries is null");
        return super.putAllTuples(entries);
    }

    @Override
    public <K2, V2> HashMap<K2, V2> bimap(Function<? super K, ? extends K2> keyMapper, Function<? super V, ? extends V2> valueMapper) {
        Objects.requireNonNull(keyMapper, "keyMapper is null");
        Objects.requireNonNull(valueMapper, "valueMapper is null");
        Traversable entries = this.iterator().map((T entry) -> Tuple.of(keyMapper.apply((Object)entry._1), valueMapper.apply((Object)entry._2)));
        return HashMap.ofEntries(entries);
    }

    @Override
    public Tuple2<V, HashMap<K, V>> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return Maps.computeIfAbsent(this, key, mappingFunction);
    }

    @Override
    public Tuple2<Option<V>, HashMap<K, V>> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return Maps.computeIfPresent(this, key, remappingFunction);
    }

    @Override
    public boolean containsKey(K key) {
        return this.root.find(new AbstractMap.SimpleImmutableEntry<K, Object>(key, null), Objects.hashCode(key), 0, HashMap::keyEquals) != ChampTrie.Node.NO_DATA;
    }

    @Override
    public HashMap<K, V> distinct() {
        return Maps.distinct(this);
    }

    @Override
    public HashMap<K, V> distinctBy(Comparator<? super Tuple2<K, V>> comparator) {
        return Maps.distinctBy(this, this::createFromEntries, comparator);
    }

    @Override
    public <U> HashMap<K, V> distinctBy(Function<? super Tuple2<K, V>, ? extends U> keyExtractor) {
        return Maps.distinctBy(this, this::createFromEntries, keyExtractor);
    }

    @Override
    public HashMap<K, V> drop(int n) {
        return Maps.drop(this, this::createFromEntries, HashMap::empty, n);
    }

    @Override
    public HashMap<K, V> dropRight(int n) {
        return Maps.dropRight(this, this::createFromEntries, HashMap::empty, n);
    }

    @Override
    public HashMap<K, V> dropUntil(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.dropUntil(this, this::createFromEntries, predicate);
    }

    @Override
    public HashMap<K, V> dropWhile(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.dropWhile(this, this::createFromEntries, predicate);
    }

    @Override
    public HashMap<K, V> filter(BiPredicate<? super K, ? super V> predicate) {
        TransientHashMap t = this.toTransient();
        t.filterAll(e -> predicate.test((Object)e.getKey(), (Object)e.getValue()));
        return t.root == this.root ? this : t.toImmutable();
    }

    @Override
    public HashMap<K, V> filterNot(BiPredicate<? super K, ? super V> predicate) {
        return this.filter((BiPredicate)predicate.negate());
    }

    @Override
    public HashMap<K, V> filter(Predicate<? super Tuple2<K, V>> predicate) {
        TransientHashMap t = this.toTransient();
        t.filterAll(e -> predicate.test(new Tuple2(e.getKey(), e.getValue())));
        return t.root == this.root ? this : t.toImmutable();
    }

    @Override
    public HashMap<K, V> filterNot(Predicate<? super Tuple2<K, V>> predicate) {
        return this.filter((Predicate)predicate.negate());
    }

    @Override
    public HashMap<K, V> filterKeys(Predicate<? super K> predicate) {
        TransientHashMap t = this.toTransient();
        t.filterAll(e -> predicate.test((Object)e.getKey()));
        return t.root == this.root ? this : t.toImmutable();
    }

    @Override
    public HashMap<K, V> filterNotKeys(Predicate<? super K> predicate) {
        return this.filterKeys((Predicate)predicate.negate());
    }

    @Override
    public HashMap<K, V> filterValues(Predicate<? super V> predicate) {
        TransientHashMap t = this.toTransient();
        t.filterAll(e -> predicate.test((Object)e.getValue()));
        return t.root == this.root ? this : t.toImmutable();
    }

    @Override
    public HashMap<K, V> filterNotValues(Predicate<? super V> predicate) {
        return this.filterValues((Predicate)predicate.negate());
    }

    @Override
    public <K2, V2> HashMap<K2, V2> flatMap(BiFunction<? super K, ? super V, ? extends Iterable<Tuple2<K2, V2>>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.foldLeft(HashMap.empty(), (acc, entry) -> {
            for (Tuple2 mappedEntry : (Iterable)mapper.apply((Object)entry._1, (Object)entry._2)) {
                acc = acc.put(mappedEntry);
            }
            return acc;
        });
    }

    @Override
    public Option<V> get(K key) {
        Object result = this.root.find(new AbstractMap.SimpleImmutableEntry<K, Object>(key, null), Objects.hashCode(key), 0, HashMap::keyEquals);
        return result == ChampTrie.Node.NO_DATA || result == null ? Option.none() : Option.some(((AbstractMap.SimpleImmutableEntry)result).getValue());
    }

    @Override
    public V getOrElse(K key, V defaultValue) {
        return this.get(key).getOrElse(defaultValue);
    }

    @Override
    public <C> Map<C, HashMap<K, V>> groupBy(Function<? super Tuple2<K, V>, ? extends C> classifier) {
        return Maps.groupBy(this, this::createFromEntries, classifier);
    }

    @Override
    public Iterator<HashMap<K, V>> grouped(int size) {
        return Maps.grouped(this, this::createFromEntries, size);
    }

    @Override
    public Tuple2<K, V> head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head of empty HashMap");
        }
        AbstractMap.SimpleImmutableEntry<K, V> entry = ChampTrie.Node.getFirst(this.root);
        return new Tuple2<K, V>(entry.getKey(), entry.getValue());
    }

    @Override
    public HashMap<K, V> init() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty HashMap");
        }
        return this.remove(((Tuple2)this.last())._1);
    }

    @Override
    public Option<HashMap<K, V>> initOption() {
        return Maps.initOption(this);
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public Iterator<Tuple2<K, V>> iterator() {
        return new ChampIteration.IteratorFacade<Tuple2<K, V>>(this.spliterator());
    }

    @Override
    public Set<K> keySet() {
        return HashSet.ofAll(this.iterator().map(Tuple2::_1));
    }

    @Override
    public Iterator<K> keysIterator() {
        return new ChampIteration.IteratorFacade<K>(this.keysSpliterator());
    }

    private Spliterator<K> keysSpliterator() {
        return new ChampIteration.ChampSpliterator<AbstractMap.SimpleImmutableEntry, Object>(this.root, AbstractMap.SimpleImmutableEntry::getKey, 17473, this.size);
    }

    @Override
    public Tuple2<K, V> last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("last of empty HashMap");
        }
        AbstractMap.SimpleImmutableEntry<K, V> entry = ChampTrie.Node.getLast(this.root);
        return new Tuple2<K, V>(entry.getKey(), entry.getValue());
    }

    @Override
    public <K2, V2> HashMap<K2, V2> map(BiFunction<? super K, ? super V, Tuple2<K2, V2>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.foldLeft(HashMap.empty(), (acc, entry) -> acc.put(entry.map(mapper)));
    }

    @Override
    public <K2> HashMap<K2, V> mapKeys(Function<? super K, ? extends K2> keyMapper) {
        Objects.requireNonNull(keyMapper, "keyMapper is null");
        return this.map((T k, U v) -> Tuple.of(keyMapper.apply((Object)k), v));
    }

    @Override
    public <K2> HashMap<K2, V> mapKeys(Function<? super K, ? extends K2> keyMapper, BiFunction<? super V, ? super V, ? extends V> valueMerge) {
        return Collections.mapKeys(this, HashMap.empty(), keyMapper, valueMerge);
    }

    @Override
    public <V2> HashMap<K, V2> mapValues(Function<? super V, ? extends V2> valueMapper) {
        Objects.requireNonNull(valueMapper, "valueMapper is null");
        return this.map((T k, U v) -> Tuple.of(k, valueMapper.apply((Object)v)));
    }

    @Override
    public HashMap<K, V> merge(Map<? extends K, ? extends V> that) {
        return this.putAllTuples(that);
    }

    @Override
    public <U extends V> HashMap<K, V> merge(Map<? extends K, U> that, BiFunction<? super V, ? super U, ? extends V> collisionResolution) {
        return Maps.merge(this, this::createFromEntries, that, collisionResolution);
    }

    @Override
    public HashMap<K, V> orElse(Iterable<? extends Tuple2<K, V>> other) {
        return this.isEmpty() ? HashMap.ofEntries(other) : this;
    }

    @Override
    public HashMap<K, V> orElse(Supplier<? extends Iterable<? extends Tuple2<K, V>>> supplier) {
        return this.isEmpty() ? HashMap.ofEntries(supplier.get()) : this;
    }

    @Override
    public Tuple2<HashMap<K, V>, HashMap<K, V>> partition(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.partition(this, this::createFromEntries, predicate);
    }

    @Override
    public HashMap<K, V> peek(Consumer<? super Tuple2<K, V>> action) {
        return Maps.peek(this, action);
    }

    @Override
    public <U extends V> HashMap<K, V> put(K key, U value, BiFunction<? super V, ? super U, ? extends V> merge) {
        return Maps.put(this, key, value, merge);
    }

    @Override
    public HashMap<K, V> put(K key, V value) {
        ChampTrie.ChangeEvent details = new ChampTrie.ChangeEvent();
        ChampTrie.Node newRootNode = this.root.put(null, (Object)new AbstractMap.SimpleImmutableEntry<K, V>(key, value), Objects.hashCode(key), 0, details, HashMap::updateWithNewKey, HashMap::keyEquals, HashMap::entryKeyHash);
        if (details.isModified()) {
            if (details.isReplaced()) {
                return new HashMap<K, V>(newRootNode, this.size);
            }
            return new HashMap<K, V>(newRootNode, this.size + 1);
        }
        return this;
    }

    @Override
    public HashMap<K, V> put(Tuple2<? extends K, ? extends V> entry) {
        return Maps.put(this, entry);
    }

    @Override
    public <U extends V> HashMap<K, V> put(Tuple2<? extends K, U> entry, BiFunction<? super V, ? super U, ? extends V> merge) {
        return Maps.put(this, entry, merge);
    }

    private HashMap<K, V> putAllEntries(Iterable<? extends Map.Entry<? extends K, ? extends V>> c) {
        TransientHashMap<K, V> t = this.toTransient();
        t.putAllEntries(c);
        return t.root == this.root ? this : t.toImmutable();
    }

    private HashMap<K, V> putAllTuples(Iterable<? extends Tuple2<? extends K, ? extends V>> c) {
        if (this.isEmpty() && c instanceof HashMap) {
            HashMap that = (HashMap)c;
            return that;
        }
        TransientHashMap<K, V> t = this.toTransient();
        t.putAllTuples(c);
        return t.root == this.root ? this : t.toImmutable();
    }

    @Override
    public HashMap<K, V> remove(K key) {
        int keyHash = Objects.hashCode(key);
        ChampTrie.ChangeEvent details = new ChampTrie.ChangeEvent();
        ChampTrie.Node newRootNode = this.root.remove(null, (Object)new AbstractMap.SimpleImmutableEntry<K, Object>(key, null), keyHash, 0, details, HashMap::keyEquals);
        if (details.isModified()) {
            return new HashMap<K, V>(newRootNode, this.size - 1);
        }
        return this;
    }

    @Override
    public HashMap<K, V> removeAll(Iterable<? extends K> c) {
        TransientHashMap<K, V> t = this.toTransient();
        t.removeAll(c);
        return t.root == this.root ? this : t.toImmutable();
    }

    @Override
    public HashMap<K, V> replace(Tuple2<K, V> currentElement, Tuple2<K, V> newElement) {
        return Maps.replace(this, currentElement, newElement);
    }

    @Override
    public HashMap<K, V> replaceAll(Tuple2<K, V> currentElement, Tuple2<K, V> newElement) {
        return Maps.replaceAll(this, currentElement, newElement);
    }

    @Override
    public HashMap<K, V> replaceValue(K key, V value) {
        return Maps.replaceValue(this, key, value);
    }

    @Override
    public HashMap<K, V> replace(K key, V oldValue, V newValue) {
        return Maps.replace(this, key, oldValue, newValue);
    }

    @Override
    public HashMap<K, V> replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        return Maps.replaceAll(this, function);
    }

    @Override
    public HashMap<K, V> retainAll(Iterable<? extends Tuple2<K, V>> elements) {
        TransientHashMap<K, V> t = this.toTransient();
        t.retainAllTuples(elements);
        return t.root == this.root ? this : t.toImmutable();
    }

    @Override
    public HashMap<K, V> scan(Tuple2<K, V> zero, BiFunction<? super Tuple2<K, V>, ? super Tuple2<K, V>, ? extends Tuple2<K, V>> operation) {
        return Maps.scan(this, zero, operation, this::createFromEntries);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<HashMap<K, V>> slideBy(Function<? super Tuple2<K, V>, ?> classifier) {
        return Maps.slideBy(this, this::createFromEntries, classifier);
    }

    @Override
    public Iterator<HashMap<K, V>> sliding(int size) {
        return Maps.sliding(this, this::createFromEntries, size);
    }

    @Override
    public Iterator<HashMap<K, V>> sliding(int size, int step) {
        return Maps.sliding(this, this::createFromEntries, size, step);
    }

    @Override
    public Tuple2<HashMap<K, V>, HashMap<K, V>> span(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.span(this, this::createFromEntries, predicate);
    }

    @Override
    public Spliterator<Tuple2<K, V>> spliterator() {
        return new ChampIteration.ChampSpliterator<AbstractMap.SimpleImmutableEntry, Tuple2>(this.root, entry -> new Tuple2(entry.getKey(), entry.getValue()), 17473, this.size);
    }

    @Override
    public HashMap<K, V> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty HashMap");
        }
        return this.remove(((Tuple2)this.head())._1);
    }

    @Override
    public Option<HashMap<K, V>> tailOption() {
        return Maps.tailOption(this);
    }

    @Override
    public HashMap<K, V> take(int n) {
        return Maps.take(this, this::createFromEntries, n);
    }

    @Override
    public HashMap<K, V> takeRight(int n) {
        return Maps.takeRight(this, this::createFromEntries, n);
    }

    @Override
    public HashMap<K, V> takeUntil(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.takeUntil(this, this::createFromEntries, predicate);
    }

    @Override
    public HashMap<K, V> takeWhile(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.takeWhile(this, this::createFromEntries, predicate);
    }

    @Override
    public java.util.HashMap<K, V> toJavaMap() {
        return this.toJavaMap(java.util.HashMap::new, t -> t);
    }

    TransientHashMap<K, V> toTransient() {
        return new TransientHashMap(this);
    }

    @Override
    public Stream<V> values() {
        return this.valuesIterator().toStream();
    }

    @Override
    public Iterator<V> valuesIterator() {
        return new ChampIteration.IteratorFacade<V>(this.valuesSpliterator());
    }

    private Spliterator<V> valuesSpliterator() {
        return new ChampIteration.ChampSpliterator<AbstractMap.SimpleImmutableEntry, Object>(this.root, AbstractMap.SimpleImmutableEntry::getValue, 17472, this.size);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof HashMap) {
            HashMap that = (HashMap)other;
            return this.size == that.size && this.root.equivalent(that.root);
        }
        return Collections.equals(this, other);
    }

    @Override
    public int hashCode() {
        return Collections.hashUnordered(this);
    }

    private Object readResolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    @Override
    public String stringPrefix() {
        return "HashMap";
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }

    private HashMap<K, V> createFromEntries(Iterable<Tuple2<K, V>> tuples) {
        return HashMap.ofEntries(tuples);
    }

    static <V, K> boolean keyEquals(AbstractMap.SimpleImmutableEntry<K, V> a, AbstractMap.SimpleImmutableEntry<K, V> b) {
        return Objects.equals(a.getKey(), b.getKey());
    }

    static <V, K> int keyHash(Object e) {
        return 0 ^ Objects.hashCode(e);
    }

    static <V, K> int entryKeyHash(AbstractMap.SimpleImmutableEntry<K, V> e) {
        return 0 ^ Objects.hashCode(e.getKey());
    }

    static <V, K> boolean entryKeyEquals(AbstractMap.SimpleImmutableEntry<K, V> a, AbstractMap.SimpleImmutableEntry<K, V> b) {
        return Objects.equals(a.getKey(), b.getKey());
    }

    static <K, V> AbstractMap.SimpleImmutableEntry<K, V> updateWithNewKey(AbstractMap.SimpleImmutableEntry<K, V> oldv, AbstractMap.SimpleImmutableEntry<K, V> newv) {
        return Objects.equals(oldv.getValue(), newv.getValue()) && oldv.getKey() == newv.getKey() ? oldv : newv;
    }

    static <K, V> AbstractMap.SimpleImmutableEntry<K, V> updateEntry(AbstractMap.SimpleImmutableEntry<K, V> oldv, AbstractMap.SimpleImmutableEntry<K, V> newv) {
        return Objects.equals(oldv.getValue(), newv.getValue()) ? oldv : newv;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    static class TransientHashMap<K, V>
    extends ChampTransience.ChampAbstractTransientMap<K, V, AbstractMap.SimpleImmutableEntry<K, V>> {
        TransientHashMap(HashMap<K, V> m) {
            this.root = ((HashMap)m).root;
            this.size = m.size;
        }

        TransientHashMap() {
            this(HashMap.empty());
        }

        @Override
        public V put(K key, V value) {
            AbstractMap.SimpleImmutableEntry<K, V> oldData = this.putEntry(key, value, false).getOldData();
            return oldData == null ? null : (V)oldData.getValue();
        }

        boolean putAllEntries(Iterable<? extends Map.Entry<? extends K, ? extends V>> c) {
            if (c == this) {
                return false;
            }
            boolean modified = false;
            for (Map.Entry<K, V> e : c) {
                V oldValue = this.put(e.getKey(), e.getValue());
                modified = modified || !Objects.equals(oldValue, e.getValue());
            }
            return modified;
        }

        @Override
        boolean putAllTuples(Iterable<? extends Tuple2<? extends K, ? extends V>> c) {
            if (c instanceof HashMap) {
                HashMap that = (HashMap)c;
                ChampTrie.BulkChangeEvent bulkChange = new ChampTrie.BulkChangeEvent();
                ChampTrie.Node newRootNode = this.root.putAll(this.makeOwner(), (ChampTrie.Node)that.root, 0, bulkChange, HashMap::updateEntry, HashMap::entryKeyEquals, HashMap::entryKeyHash, new ChampTrie.ChangeEvent());
                if (bulkChange.inBoth == that.size() && !bulkChange.replaced) {
                    return false;
                }
                this.root = newRootNode;
                this.size += that.size - bulkChange.inBoth;
                ++this.modCount;
                return true;
            }
            return super.putAllTuples(c);
        }

        ChampTrie.ChangeEvent<AbstractMap.SimpleImmutableEntry<K, V>> putEntry(K key, V value, boolean moveToLast) {
            int keyHash = HashMap.keyHash(key);
            ChampTrie.ChangeEvent<AbstractMap.SimpleImmutableEntry<K, V>> details = new ChampTrie.ChangeEvent<AbstractMap.SimpleImmutableEntry<K, V>>();
            this.root = this.root.put(this.makeOwner(), new AbstractMap.SimpleImmutableEntry<K, V>(key, value), keyHash, 0, (ChampTrie.ChangeEvent)details, HashMap::updateEntry, HashMap::entryKeyEquals, HashMap::entryKeyHash);
            if (details.isModified() && !details.isReplaced()) {
                ++this.size;
                ++this.modCount;
            }
            return details;
        }

        @Override
        ChampTrie.ChangeEvent<AbstractMap.SimpleImmutableEntry<K, V>> removeKey(K key) {
            int keyHash = HashMap.keyHash(key);
            ChampTrie.ChangeEvent<AbstractMap.SimpleImmutableEntry<K, V>> details = new ChampTrie.ChangeEvent<AbstractMap.SimpleImmutableEntry<K, V>>();
            this.root = this.root.remove(this.makeOwner(), new AbstractMap.SimpleImmutableEntry<K, Object>(key, null), keyHash, 0, (ChampTrie.ChangeEvent)details, HashMap::entryKeyEquals);
            if (details.isModified()) {
                --this.size;
                ++this.modCount;
            }
            return details;
        }

        @Override
        void clear() {
            this.root = ChampTrie.BitmapIndexedNode.emptyNode();
            this.size = 0;
            ++this.modCount;
        }

        public HashMap<K, V> toImmutable() {
            this.owner = null;
            return this.isEmpty() ? HashMap.empty() : new HashMap(this.root, this.size);
        }

        @Override
        boolean retainAllTuples(Iterable<? extends Tuple2<K, V>> c) {
            if (this.isEmpty()) {
                return false;
            }
            if (c instanceof Collection && ((Collection)c).isEmpty() || c instanceof Traversable && ((Traversable)c).isEmpty()) {
                this.clear();
                return true;
            }
            if (c instanceof HashMap) {
                HashMap that = (HashMap)c;
                ChampTrie.BulkChangeEvent bulkChange = new ChampTrie.BulkChangeEvent();
                ChampTrie.Node newRootNode = this.root.retainAll(this.makeOwner(), (ChampTrie.Node)that.root, 0, bulkChange, HashMap::updateEntry, HashMap::entryKeyEquals, HashMap::entryKeyHash, new ChampTrie.ChangeEvent());
                if (bulkChange.removed == 0) {
                    return false;
                }
                this.root = newRootNode;
                this.size -= bulkChange.removed;
                ++this.modCount;
                return true;
            }
            return super.retainAllTuples(c);
        }

        @Override
        boolean filterAll(Predicate<Map.Entry<K, V>> predicate) {
            ChampTrie.BulkChangeEvent bulkChange = new ChampTrie.BulkChangeEvent();
            ChampTrie.Node newRootNode = this.root.filterAll(this.makeOwner(), predicate, 0, bulkChange);
            if (bulkChange.removed == 0) {
                return false;
            }
            this.root = newRootNode;
            this.size -= bulkChange.removed;
            ++this.modCount;
            return true;
        }
    }

    private static final class SerializationProxy<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient HashMap<K, V> map;

        SerializationProxy(HashMap<K, V> map) {
            this.map = map;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeInt(this.map.size());
            for (Tuple2 tuple2 : this.map) {
                s.writeObject(tuple2._1);
                s.writeObject(tuple2._2);
            }
        }

        private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
            s.defaultReadObject();
            int size = s.readInt();
            if (size < 0) {
                throw new InvalidObjectException("No elements");
            }
            ChampTrie.IdentityObject owner = new ChampTrie.IdentityObject();
            ChampTrie.Node newRoot = ChampTrie.BitmapIndexedNode.emptyNode();
            ChampTrie.ChangeEvent details = new ChampTrie.ChangeEvent();
            int newSize = 0;
            for (int i = 0; i < size; ++i) {
                Object key = s.readObject();
                Object value = s.readObject();
                int keyHash = Objects.hashCode(key);
                newRoot = newRoot.put(owner, new AbstractMap.SimpleImmutableEntry<Object, Object>(key, value), keyHash, 0, details, HashMap::updateEntry, Objects::equals, Objects::hashCode);
                if (!details.isModified()) continue;
                ++newSize;
            }
            this.map = newSize == 0 ? HashMap.empty() : new HashMap(newRoot, newSize);
        }

        private Object readResolve() {
            return this.map;
        }
    }
}

