/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.PartialFunction;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.ChampIteration;
import io.vavr.collection.ChampTransience;
import io.vavr.collection.ChampTrie;
import io.vavr.collection.Collections;
import io.vavr.collection.Iterator;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;

public final class HashSet<T>
implements Set<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final HashSet<?> EMPTY = new HashSet(ChampTrie.BitmapIndexedNode.emptyNode(), 0);
    private final ChampTrie.BitmapIndexedNode<T> root;
    final int size;
    static final int SALT = 0;

    HashSet(ChampTrie.BitmapIndexedNode<T> root, int size) {
        this.root = root;
        this.size = size;
    }

    public static <T> HashSet<T> empty() {
        return EMPTY;
    }

    public static <T> Collector<T, ArrayList<T>, HashSet<T>> collector() {
        return Collections.toListAndThen(HashSet::ofAll);
    }

    public static <T> HashSet<T> narrow(HashSet<? extends T> hashSet) {
        return hashSet;
    }

    public static <T> HashSet<T> of(T element) {
        return HashSet.empty().add((Object)element);
    }

    @SafeVarargs
    public static <T> HashSet<T> of(T ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return HashSet.empty().addAll(Arrays.asList(elements));
    }

    public static <T> HashSet<T> tabulate(int n, Function<? super Integer, ? extends T> f) {
        Objects.requireNonNull(f, "f is null");
        return Collections.tabulate(n, f, HashSet.empty(), HashSet::of);
    }

    public static <T> HashSet<T> fill(int n, Supplier<? extends T> s) {
        Objects.requireNonNull(s, "s is null");
        return Collections.fill(n, s, HashSet.empty(), HashSet::of);
    }

    public static <T> HashSet<T> ofAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        return elements instanceof HashSet ? (HashSet)elements : HashSet.of(new Object[0]).addAll(elements);
    }

    public static <T> HashSet<T> ofAll(Stream<? extends T> javaStream) {
        Objects.requireNonNull(javaStream, "javaStream is null");
        return HashSet.ofAll(Iterator.ofAll(javaStream.iterator()));
    }

    public static HashSet<Boolean> ofAll(boolean ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return HashSet.ofAll(Iterator.ofAll(elements));
    }

    public static HashSet<Byte> ofAll(byte ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return HashSet.ofAll(Iterator.ofAll(elements));
    }

    public static HashSet<Character> ofAll(char ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return HashSet.ofAll(Iterator.ofAll(elements));
    }

    public static HashSet<Double> ofAll(double ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return HashSet.ofAll(Iterator.ofAll(elements));
    }

    public static HashSet<Float> ofAll(float ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return HashSet.ofAll(Iterator.ofAll(elements));
    }

    public static HashSet<Integer> ofAll(int ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return HashSet.ofAll(Iterator.ofAll(elements));
    }

    public static HashSet<Long> ofAll(long ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return HashSet.ofAll(Iterator.ofAll(elements));
    }

    public static HashSet<Short> ofAll(short ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return HashSet.ofAll(Iterator.ofAll(elements));
    }

    public static HashSet<Integer> range(int from, int toExclusive) {
        return HashSet.ofAll(Iterator.range(from, toExclusive));
    }

    public static HashSet<Character> range(char from, char toExclusive) {
        return HashSet.ofAll(Iterator.range(from, toExclusive));
    }

    public static HashSet<Integer> rangeBy(int from, int toExclusive, int step) {
        return HashSet.ofAll(Iterator.rangeBy(from, toExclusive, step));
    }

    public static HashSet<Character> rangeBy(char from, char toExclusive, int step) {
        return HashSet.ofAll(Iterator.rangeBy(from, toExclusive, step));
    }

    public static HashSet<Double> rangeBy(double from, double toExclusive, double step) {
        return HashSet.ofAll(Iterator.rangeBy(from, toExclusive, step));
    }

    public static HashSet<Long> range(long from, long toExclusive) {
        return HashSet.ofAll(Iterator.range(from, toExclusive));
    }

    public static HashSet<Long> rangeBy(long from, long toExclusive, long step) {
        return HashSet.ofAll(Iterator.rangeBy(from, toExclusive, step));
    }

    public static HashSet<Integer> rangeClosed(int from, int toInclusive) {
        return HashSet.ofAll(Iterator.rangeClosed(from, toInclusive));
    }

    public static HashSet<Character> rangeClosed(char from, char toInclusive) {
        return HashSet.ofAll(Iterator.rangeClosed(from, toInclusive));
    }

    public static HashSet<Integer> rangeClosedBy(int from, int toInclusive, int step) {
        return HashSet.ofAll(Iterator.rangeClosedBy(from, toInclusive, step));
    }

    public static HashSet<Character> rangeClosedBy(char from, char toInclusive, int step) {
        return HashSet.ofAll(Iterator.rangeClosedBy(from, toInclusive, step));
    }

    public static HashSet<Double> rangeClosedBy(double from, double toInclusive, double step) {
        return HashSet.ofAll(Iterator.rangeClosedBy(from, toInclusive, step));
    }

    public static HashSet<Long> rangeClosed(long from, long toInclusive) {
        return HashSet.ofAll(Iterator.rangeClosed(from, toInclusive));
    }

    public static HashSet<Long> rangeClosedBy(long from, long toInclusive, long step) {
        return HashSet.ofAll(Iterator.rangeClosedBy(from, toInclusive, step));
    }

    @Override
    public HashSet<T> add(T element) {
        int keyHash = HashSet.keyHash(element);
        ChampTrie.ChangeEvent details = new ChampTrie.ChangeEvent();
        ChampTrie.Node newRootNode = this.root.put((ChampTrie.IdentityObject)null, (Object)element, keyHash, 0, details, HashSet::updateElement, Objects::equals, HashSet::keyHash);
        if (details.isModified()) {
            return new HashSet<T>(newRootNode, this.size + 1);
        }
        return this;
    }

    static <E> E updateElement(E oldElement, E newElement) {
        return oldElement;
    }

    @Override
    public HashSet<T> addAll(Iterable<? extends T> elements) {
        if (this.isEmpty() && elements instanceof HashSet) {
            return (HashSet)elements;
        }
        TransientHashSet<T> t = this.toTransient();
        t.addAll(elements);
        return t.root == this.root ? this : t.toImmutable();
    }

    @Override
    public <R> HashSet<R> collect(PartialFunction<? super T, ? extends R> partialFunction) {
        return HashSet.ofAll(this.iterator().collect(partialFunction));
    }

    @Override
    public boolean contains(T element) {
        return this.root.find(element, HashSet.keyHash(element), 0, Objects::equals) != ChampTrie.Node.NO_DATA;
    }

    @Override
    public HashSet<T> diff(Set<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (this.isEmpty() || elements.isEmpty()) {
            return this;
        }
        return this.removeAll(elements);
    }

    @Override
    public HashSet<T> distinct() {
        return this;
    }

    @Override
    public HashSet<T> distinctBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return HashSet.ofAll(this.iterator().distinctBy(comparator));
    }

    @Override
    public <U> HashSet<T> distinctBy(Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor, "keyExtractor is null");
        return HashSet.ofAll(this.iterator().distinctBy(keyExtractor));
    }

    @Override
    public HashSet<T> drop(int n) {
        if (n <= 0) {
            return this;
        }
        return HashSet.ofAll(this.iterator().drop(n));
    }

    @Override
    public HashSet<T> dropRight(int n) {
        return this.drop(n);
    }

    @Override
    public HashSet<T> dropUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.dropWhile((Predicate)predicate.negate());
    }

    @Override
    public HashSet<T> dropWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        HashSet<T> dropped = HashSet.ofAll(this.iterator().dropWhile(predicate));
        return dropped.length() == this.length() ? this : dropped;
    }

    @Override
    public HashSet<T> filter(Predicate<? super T> predicate) {
        TransientHashSet<T> t = this.toTransient();
        t.filterAll(predicate);
        return t.root == this.root ? this : t.toImmutable();
    }

    @Override
    public HashSet<T> filterNot(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.filter((Predicate)predicate.negate());
    }

    @Override
    public <U> HashSet<U> flatMap(Function<? super T, ? extends Iterable<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        if (this.isEmpty()) {
            return HashSet.empty();
        }
        return this.foldLeft(HashSet.empty(), (tree, t) -> tree.addAll((Iterable)mapper.apply(t)));
    }

    @Override
    public <U> U foldRight(U zero, BiFunction<? super T, ? super U, ? extends U> f) {
        return (U)this.foldLeft(zero, (u, t) -> f.apply(t, u));
    }

    @Override
    public <C> Map<C, HashSet<T>> groupBy(Function<? super T, ? extends C> classifier) {
        return Collections.groupBy(this, classifier, HashSet::ofAll);
    }

    @Override
    public Iterator<HashSet<T>> grouped(int size) {
        return this.sliding(size, size);
    }

    @Override
    public boolean hasDefiniteSize() {
        return true;
    }

    @Override
    public T head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head of empty set");
        }
        return ChampTrie.Node.getFirst(this.root);
    }

    @Override
    public Option<T> headOption() {
        return this.iterator().headOption();
    }

    @Override
    public HashSet<T> init() {
        return this.tail();
    }

    @Override
    public Option<HashSet<T>> initOption() {
        return this.tailOption();
    }

    @Override
    public HashSet<T> intersect(Set<? extends T> elements) {
        return this.retainAll(elements);
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public boolean isTraversableAgain() {
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new ChampIteration.IteratorFacade<T>(this.spliterator());
    }

    static int keyHash(Object e) {
        return 0 ^ Objects.hashCode(e);
    }

    @Override
    public T last() {
        return ChampTrie.Node.getLast(this.root);
    }

    @Override
    public int length() {
        return this.size;
    }

    @Override
    public <U> HashSet<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        if (this.isEmpty()) {
            return HashSet.empty();
        }
        return this.foldLeft(HashSet.empty(), (tree, t) -> {
            Object u = mapper.apply(t);
            return tree.add(u);
        });
    }

    @Override
    public String mkString(CharSequence prefix, CharSequence delimiter, CharSequence suffix) {
        return this.iterator().mkString(prefix, delimiter, suffix);
    }

    @Override
    public HashSet<T> orElse(Iterable<? extends T> other) {
        return this.isEmpty() ? HashSet.ofAll(other) : this;
    }

    @Override
    public HashSet<T> orElse(Supplier<? extends Iterable<? extends T>> supplier) {
        return this.isEmpty() ? HashSet.ofAll(supplier.get()) : this;
    }

    @Override
    public Tuple2<HashSet<T>, HashSet<T>> partition(Predicate<? super T> predicate) {
        return Collections.partition(this, HashSet::ofAll, predicate);
    }

    @Override
    public HashSet<T> peek(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        if (!this.isEmpty()) {
            action.accept(this.iterator().head());
        }
        return this;
    }

    @Override
    public HashSet<T> remove(T key) {
        int keyHash = HashSet.keyHash(key);
        ChampTrie.ChangeEvent details = new ChampTrie.ChangeEvent();
        ChampTrie.Node newRootNode = this.root.remove((ChampTrie.IdentityObject)null, (Object)key, keyHash, 0, details, Objects::equals);
        if (details.isModified()) {
            return this.size == 1 ? HashSet.empty() : new HashSet<T>(newRootNode, this.size - 1);
        }
        return this;
    }

    @Override
    public HashSet<T> removeAll(Iterable<? extends T> elements) {
        TransientHashSet<T> t = this.toTransient();
        t.removeAll(elements);
        return t.root == this.root ? this : t.toImmutable();
    }

    @Override
    public HashSet<T> replace(T currentElement, T newElement) {
        Set removed = this.remove((Object)currentElement);
        return removed != this ? ((HashSet)removed).add((Object)newElement) : this;
    }

    @Override
    public HashSet<T> replaceAll(T currentElement, T newElement) {
        return this.replace((Object)currentElement, (Object)newElement);
    }

    @Override
    public HashSet<T> retainAll(Iterable<? extends T> elements) {
        TransientHashSet<T> t = this.toTransient();
        t.retainAll(elements);
        return t.root == this.root ? this : t.toImmutable();
    }

    @Override
    public HashSet<T> scan(T zero, BiFunction<? super T, ? super T, ? extends T> operation) {
        return this.scanLeft(zero, operation);
    }

    @Override
    public <U> HashSet<U> scanLeft(U zero, BiFunction<? super U, ? super T, ? extends U> operation) {
        return Collections.scanLeft(this, zero, operation, HashSet::ofAll);
    }

    @Override
    public <U> HashSet<U> scanRight(U zero, BiFunction<? super T, ? super U, ? extends U> operation) {
        return Collections.scanRight(this, zero, operation, HashSet::ofAll);
    }

    @Override
    public Iterator<HashSet<T>> slideBy(Function<? super T, ?> classifier) {
        return this.iterator().slideBy(classifier).map(HashSet::ofAll);
    }

    @Override
    public Iterator<HashSet<T>> sliding(int size) {
        return this.sliding(size, 1);
    }

    @Override
    public Iterator<HashSet<T>> sliding(int size, int step) {
        return this.iterator().sliding(size, step).map(HashSet::ofAll);
    }

    @Override
    public Tuple2<HashSet<T>, HashSet<T>> span(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        Tuple2<Iterator<? super T>, Iterator<? super T>> t = this.iterator().span(predicate);
        return Tuple.of(HashSet.ofAll((Iterable)t._1), HashSet.ofAll((Iterable)t._2));
    }

    @Override
    public Spliterator<T> spliterator() {
        return new ChampIteration.ChampSpliterator(this.root, Function.identity(), 17473, this.size);
    }

    @Override
    public HashSet<T> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty set");
        }
        return this.remove((Object)this.head());
    }

    @Override
    public Option<HashSet<T>> tailOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.tail());
    }

    @Override
    public HashSet<T> take(int n) {
        if (n >= this.size() || this.isEmpty()) {
            return this;
        }
        if (n <= 0) {
            return HashSet.empty();
        }
        return HashSet.ofAll(() -> this.iterator().take(n));
    }

    @Override
    public HashSet<T> takeRight(int n) {
        return this.take(n);
    }

    @Override
    public HashSet<T> takeUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.takeWhile((Predicate)predicate.negate());
    }

    @Override
    public HashSet<T> takeWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        HashSet<T> taken = HashSet.ofAll(this.iterator().takeWhile(predicate));
        return taken.length() == this.length() ? this : taken;
    }

    public <U> U transform(Function<? super HashSet<T>, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return f.apply(this);
    }

    @Override
    public java.util.HashSet<T> toJavaSet() {
        return this.toJavaSet(java.util.HashSet::new);
    }

    TransientHashSet<T> toTransient() {
        return new TransientHashSet(this);
    }

    @Override
    public HashSet<T> union(Set<? extends T> elements) {
        return this.addAll(elements);
    }

    @Override
    public <U> HashSet<Tuple2<T, U>> zip(Iterable<? extends U> that) {
        return this.zipWith((Iterable)that, Tuple::of);
    }

    @Override
    public <U, R> HashSet<R> zipWith(Iterable<? extends U> that, BiFunction<? super T, ? super U, ? extends R> mapper) {
        Objects.requireNonNull(that, "that is null");
        Objects.requireNonNull(mapper, "mapper is null");
        return HashSet.ofAll(this.iterator().zipWith(that, mapper));
    }

    @Override
    public <U> HashSet<Tuple2<T, U>> zipAll(Iterable<? extends U> that, T thisElem, U thatElem) {
        Objects.requireNonNull(that, "that is null");
        return HashSet.ofAll(this.iterator().zipAll(that, thisElem, thatElem));
    }

    @Override
    public HashSet<Tuple2<T, Integer>> zipWithIndex() {
        return this.zipWithIndex(Tuple::of);
    }

    @Override
    public <U> HashSet<U> zipWithIndex(BiFunction<? super T, ? super Integer, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return HashSet.ofAll(this.iterator().zipWithIndex(mapper));
    }

    @Override
    public boolean equals(Object o) {
        return Collections.equals(this, o);
    }

    @Override
    public int hashCode() {
        return Collections.hashUnordered(this);
    }

    @Override
    public String stringPrefix() {
        return "HashSet";
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    static class TransientHashSet<E>
    extends ChampTransience.ChampAbstractTransientSet<E, E> {
        TransientHashSet(HashSet<E> s) {
            this.root = ((HashSet)s).root;
            this.size = s.size;
        }

        TransientHashSet() {
            this(HashSet.empty());
        }

        public HashSet<E> toImmutable() {
            this.owner = null;
            return this.isEmpty() ? HashSet.empty() : new HashSet(this.root, this.size);
        }

        boolean add(E e) {
            ChampTrie.ChangeEvent details = new ChampTrie.ChangeEvent();
            this.root = this.root.put(this.makeOwner(), e, HashSet.keyHash(e), 0, details, (oldKey, newKey) -> oldKey, Objects::equals, HashSet::keyHash);
            if (details.isModified()) {
                ++this.size;
                ++this.modCount;
            }
            return details.isModified();
        }

        boolean addAll(Iterable<? extends E> c) {
            if (c == this.root) {
                return false;
            }
            if (this.isEmpty() && c instanceof HashSet) {
                HashSet cc = (HashSet)c;
                this.root = cc.root;
                this.size = cc.size;
                return true;
            }
            if (c instanceof HashSet) {
                HashSet that = (HashSet)c;
                ChampTrie.BulkChangeEvent bulkChange = new ChampTrie.BulkChangeEvent();
                ChampTrie.Node newRootNode = this.root.putAll(this.makeOwner(), (ChampTrie.Node)that.root, 0, bulkChange, HashSet::updateElement, Objects::equals, HashSet::keyHash, new ChampTrie.ChangeEvent());
                if (bulkChange.inBoth == that.size()) {
                    return false;
                }
                this.root = newRootNode;
                this.size += that.size - bulkChange.inBoth;
                ++this.modCount;
                return true;
            }
            boolean added = false;
            for (E e : c) {
                added |= this.add(e);
            }
            return added;
        }

        @Override
        public java.util.Iterator<E> iterator() {
            return new ChampIteration.IteratorFacade<E>(this.spliterator());
        }

        public Spliterator<E> spliterator() {
            return new ChampIteration.ChampSpliterator(this.root, Function.identity(), 65, this.size);
        }

        @Override
        boolean remove(Object key) {
            int keyHash = HashSet.keyHash(key);
            ChampTrie.ChangeEvent details = new ChampTrie.ChangeEvent();
            this.root = this.root.remove(this.owner, key, keyHash, 0, details, Objects::equals);
            if (details.isModified()) {
                --this.size;
                return true;
            }
            return false;
        }

        @Override
        boolean removeAll(Iterable<?> c) {
            if (this.isEmpty() || c instanceof Collection && ((Collection)c).isEmpty()) {
                return false;
            }
            if (c instanceof HashSet) {
                HashSet that = (HashSet)c;
                ChampTrie.BulkChangeEvent bulkChange = new ChampTrie.BulkChangeEvent();
                ChampTrie.Node newRootNode = this.root.removeAll(this.makeOwner(), (ChampTrie.Node)that.root, 0, bulkChange, HashSet::updateElement, Objects::equals, HashSet::keyHash, new ChampTrie.ChangeEvent());
                if (bulkChange.removed == 0) {
                    return false;
                }
                this.root = newRootNode;
                this.size -= bulkChange.removed;
                ++this.modCount;
                return true;
            }
            return super.removeAll(c);
        }

        @Override
        void clear() {
            this.root = ChampTrie.BitmapIndexedNode.emptyNode();
            this.size = 0;
            ++this.modCount;
        }

        @Override
        boolean retainAll(Iterable<?> c) {
            ChampTrie.Node newRootNode;
            if (this.isEmpty()) {
                return false;
            }
            if (c instanceof Collection && ((Collection)c).isEmpty()) {
                Collection cc = (Collection)c;
                this.clear();
                return true;
            }
            ChampTrie.BulkChangeEvent bulkChange = new ChampTrie.BulkChangeEvent();
            if (c instanceof HashSet) {
                HashSet that = (HashSet)c;
                newRootNode = this.root.retainAll(this.makeOwner(), (ChampTrie.Node)that.root, 0, bulkChange, HashSet::updateElement, Objects::equals, HashSet::keyHash, new ChampTrie.ChangeEvent());
            } else if (c instanceof Collection) {
                Collection that = (Collection)c;
                newRootNode = this.root.filterAll(this.makeOwner(), that::contains, 0, bulkChange);
            } else {
                java.util.HashSet that = new java.util.HashSet();
                c.forEach(that::add);
                newRootNode = this.root.filterAll(this.makeOwner(), that::contains, 0, bulkChange);
            }
            if (bulkChange.removed == 0) {
                return false;
            }
            this.root = newRootNode;
            this.size -= bulkChange.removed;
            ++this.modCount;
            return true;
        }

        public boolean filterAll(Predicate<? super E> predicate) {
            ChampTrie.BulkChangeEvent bulkChange = new ChampTrie.BulkChangeEvent();
            ChampTrie.Node newRootNode = this.root.filterAll(this.makeOwner(), predicate, 0, bulkChange);
            if (bulkChange.removed == 0) {
                return false;
            }
            this.root = newRootNode;
            this.size -= bulkChange.removed;
            ++this.modCount;
            return true;
        }
    }

    private static final class SerializationProxy<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient HashSet<T> tree;

        SerializationProxy(HashSet<T> tree) {
            this.tree = tree;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeInt(this.tree.size());
            for (Object e : this.tree) {
                s.writeObject(e);
            }
        }

        private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
            s.defaultReadObject();
            int size = s.readInt();
            if (size < 0) {
                throw new InvalidObjectException("No elements");
            }
            ChampTrie.IdentityObject owner = new ChampTrie.IdentityObject();
            ChampTrie.Node newRoot = ChampTrie.BitmapIndexedNode.emptyNode();
            ChampTrie.ChangeEvent details = new ChampTrie.ChangeEvent();
            int newSize = 0;
            for (int i = 0; i < size; ++i) {
                Object element = s.readObject();
                int keyHash = HashSet.keyHash(element);
                newRoot = newRoot.put(owner, element, keyHash, 0, details, HashSet::updateElement, Objects::equals, HashSet::keyHash);
                if (!details.isModified()) continue;
                ++newSize;
            }
            this.tree = newSize == 0 ? HashSet.empty() : new HashSet(newRoot, newSize);
        }

        private Object readResolve() {
            return this.tree;
        }
    }
}

