/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.ChampIteration;
import io.vavr.collection.ChampSequenced;
import io.vavr.collection.ChampTransience;
import io.vavr.collection.ChampTrie;
import io.vavr.collection.Collections;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.Iterator;
import io.vavr.collection.LinkedHashSet;
import io.vavr.collection.Map;
import io.vavr.collection.Maps;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.collection.Traversable;
import io.vavr.collection.Vector;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;

public class LinkedHashMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final LinkedHashMap<?, ?> EMPTY = new LinkedHashMap(ChampTrie.BitmapIndexedNode.emptyNode(), Vector.empty(), 0, 0);
    private final ChampTrie.BitmapIndexedNode<ChampSequenced.ChampSequencedEntry<K, V>> root;
    final int offset;
    final int size;
    final Vector<Object> vector;

    LinkedHashMap(ChampTrie.BitmapIndexedNode<ChampSequenced.ChampSequencedEntry<K, V>> root, Vector<Object> vector, int size, int offset) {
        this.root = root;
        this.size = size;
        this.offset = offset;
        this.vector = Objects.requireNonNull(vector);
    }

    public static <K, V> Collector<Tuple2<K, V>, ArrayList<Tuple2<K, V>>, LinkedHashMap<K, V>> collector() {
        return Collections.toListAndThen(LinkedHashMap::ofEntries);
    }

    public static <K, V, T extends V> Collector<T, ArrayList<T>, LinkedHashMap<K, V>> collector(Function<? super T, ? extends K> keyMapper) {
        Objects.requireNonNull(keyMapper, "keyMapper is null");
        return LinkedHashMap.collector(keyMapper, v -> v);
    }

    public static <K, V, T> Collector<T, ArrayList<T>, LinkedHashMap<K, V>> collector(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        Objects.requireNonNull(keyMapper, "keyMapper is null");
        Objects.requireNonNull(valueMapper, "valueMapper is null");
        return Collections.toListAndThen(arr -> LinkedHashMap.ofEntries(Iterator.ofAll(arr).map((T t) -> Tuple.of(keyMapper.apply(t), valueMapper.apply(t)))));
    }

    public static <K, V> LinkedHashMap<K, V> empty() {
        return EMPTY;
    }

    public static <K, V> LinkedHashMap<K, V> narrow(LinkedHashMap<? extends K, ? extends V> linkedHashMap) {
        return linkedHashMap;
    }

    public static <K, V> LinkedHashMap<K, V> of(Tuple2<? extends K, ? extends V> entry) {
        Objects.requireNonNull(entry, "entry is null");
        return LinkedHashMap.empty().put(entry._1, entry._2);
    }

    public static <K, V> LinkedHashMap<K, V> ofAll(java.util.Map<? extends K, ? extends V> map) {
        Objects.requireNonNull(map, "map is null");
        TransientLinkedHashMap<? extends K, ? extends V> m = new TransientLinkedHashMap<K, V>();
        m.putAllEntries(map.entrySet());
        return m.toImmutable();
    }

    public static <T, K, V> LinkedHashMap<K, V> ofAll(Stream<? extends T> stream, Function<? super T, Tuple2<? extends K, ? extends V>> entryMapper) {
        return Maps.ofStream(LinkedHashMap.empty(), stream, entryMapper);
    }

    public static <T, K, V> LinkedHashMap<K, V> ofAll(Stream<? extends T> stream, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return Maps.ofStream(LinkedHashMap.empty(), stream, keyMapper, valueMapper);
    }

    public static <K, V> LinkedHashMap<K, V> of(K key, V value) {
        return LinkedHashMap.empty().put((Object)key, (Object)value);
    }

    public static <K, V> LinkedHashMap<K, V> of(K k1, V v1, K k2, V v2) {
        TransientLinkedHashMap<K, V> t = new TransientLinkedHashMap<K, V>();
        t.put(k1, v1);
        t.put(k2, v2);
        return t.toImmutable();
    }

    public static <K, V> LinkedHashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        TransientLinkedHashMap<K, V> t = new TransientLinkedHashMap<K, V>();
        t.put(k1, v1);
        t.put(k2, v2);
        t.put(k3, v3);
        return t.toImmutable();
    }

    public static <K, V> LinkedHashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        TransientLinkedHashMap<K, V> t = new TransientLinkedHashMap<K, V>();
        t.put(k1, v1);
        t.put(k2, v2);
        t.put(k3, v3);
        t.put(k4, v4);
        return t.toImmutable();
    }

    public static <K, V> LinkedHashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        TransientLinkedHashMap<K, V> t = new TransientLinkedHashMap<K, V>();
        t.put(k1, v1);
        t.put(k2, v2);
        t.put(k3, v3);
        t.put(k4, v4);
        t.put(k5, v5);
        return t.toImmutable();
    }

    public static <K, V> LinkedHashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        TransientLinkedHashMap<K, V> t = new TransientLinkedHashMap<K, V>();
        t.put(k1, v1);
        t.put(k2, v2);
        t.put(k3, v3);
        t.put(k4, v4);
        t.put(k5, v5);
        t.put(k6, v6);
        return t.toImmutable();
    }

    public static <K, V> LinkedHashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        TransientLinkedHashMap<K, V> t = new TransientLinkedHashMap<K, V>();
        t.put(k1, v1);
        t.put(k2, v2);
        t.put(k3, v3);
        t.put(k4, v4);
        t.put(k5, v5);
        t.put(k6, v6);
        t.put(k7, v7);
        return t.toImmutable();
    }

    public static <K, V> LinkedHashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        TransientLinkedHashMap<K, V> t = new TransientLinkedHashMap<K, V>();
        t.put(k1, v1);
        t.put(k2, v2);
        t.put(k3, v3);
        t.put(k4, v4);
        t.put(k5, v5);
        t.put(k6, v6);
        t.put(k7, v7);
        t.put(k8, v8);
        return t.toImmutable();
    }

    public static <K, V> LinkedHashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        TransientLinkedHashMap<K, V> t = new TransientLinkedHashMap<K, V>();
        t.put(k1, v1);
        t.put(k2, v2);
        t.put(k3, v3);
        t.put(k4, v4);
        t.put(k5, v5);
        t.put(k6, v6);
        t.put(k7, v7);
        t.put(k8, v8);
        t.put(k9, v9);
        return t.toImmutable();
    }

    public static <K, V> LinkedHashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10) {
        TransientLinkedHashMap<K, V> t = new TransientLinkedHashMap<K, V>();
        t.put(k1, v1);
        t.put(k2, v2);
        t.put(k3, v3);
        t.put(k4, v4);
        t.put(k5, v5);
        t.put(k6, v6);
        t.put(k7, v7);
        t.put(k8, v8);
        t.put(k9, v9);
        t.put(k10, v10);
        return t.toImmutable();
    }

    public static <K, V> LinkedHashMap<K, V> tabulate(int n, Function<? super Integer, ? extends Tuple2<? extends K, ? extends V>> f) {
        Objects.requireNonNull(f, "f is null");
        return LinkedHashMap.ofEntries(Collections.tabulate(n, f));
    }

    public static <K, V> LinkedHashMap<K, V> fill(int n, Supplier<? extends Tuple2<? extends K, ? extends V>> s) {
        Objects.requireNonNull(s, "s is null");
        return LinkedHashMap.ofEntries(Collections.fill(n, s));
    }

    public static <K, V> LinkedHashMap<K, V> ofEntries(Map.Entry<? extends K, ? extends V> ... entries) {
        return super.putAllEntries(Arrays.asList(entries));
    }

    public static <K, V> LinkedHashMap<K, V> ofEntries(Tuple2<? extends K, ? extends V> ... entries) {
        return super.putAllTuples(Arrays.asList(entries));
    }

    public static <K, V> LinkedHashMap<K, V> ofEntries(Iterable<? extends Tuple2<? extends K, ? extends V>> entries) {
        Objects.requireNonNull(entries, "entries is null");
        return super.putAllTuples(entries);
    }

    @Override
    public <K2, V2> LinkedHashMap<K2, V2> bimap(Function<? super K, ? extends K2> keyMapper, Function<? super V, ? extends V2> valueMapper) {
        Objects.requireNonNull(keyMapper, "keyMapper is null");
        Objects.requireNonNull(valueMapper, "valueMapper is null");
        Traversable entries = this.iterator().map((T entry) -> Tuple.of(keyMapper.apply((Object)entry._1), valueMapper.apply((Object)entry._2)));
        return LinkedHashMap.ofEntries(entries);
    }

    @Override
    public Tuple2<V, LinkedHashMap<K, V>> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return Maps.computeIfAbsent(this, key, mappingFunction);
    }

    @Override
    public Tuple2<Option<V>, LinkedHashMap<K, V>> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return Maps.computeIfPresent(this, key, remappingFunction);
    }

    @Override
    public boolean containsKey(K key) {
        return this.root.find(new ChampSequenced.ChampSequencedEntry(key), ChampSequenced.ChampSequencedEntry.keyHash(key), 0, ChampSequenced.ChampSequencedEntry::keyEquals) != ChampTrie.Node.NO_DATA;
    }

    @Override
    public LinkedHashMap<K, V> distinct() {
        return Maps.distinct(this);
    }

    @Override
    public LinkedHashMap<K, V> distinctBy(Comparator<? super Tuple2<K, V>> comparator) {
        return Maps.distinctBy(this, this::createFromEntries, comparator);
    }

    @Override
    public <U> LinkedHashMap<K, V> distinctBy(Function<? super Tuple2<K, V>, ? extends U> keyExtractor) {
        return Maps.distinctBy(this, this::createFromEntries, keyExtractor);
    }

    @Override
    public LinkedHashMap<K, V> drop(int n) {
        return n <= 0 ? this : LinkedHashMap.ofEntries(this.iterator(n));
    }

    @Override
    public LinkedHashMap<K, V> dropRight(int n) {
        return Maps.dropRight(this, this::createFromEntries, LinkedHashMap::empty, n);
    }

    @Override
    public LinkedHashMap<K, V> dropUntil(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.dropUntil(this, this::createFromEntries, predicate);
    }

    @Override
    public LinkedHashMap<K, V> dropWhile(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.dropWhile(this, this::createFromEntries, predicate);
    }

    @Override
    public LinkedHashMap<K, V> filter(BiPredicate<? super K, ? super V> predicate) {
        TransientLinkedHashMap t = this.toTransient();
        t.filterAll(e -> predicate.test((Object)e.getKey(), (Object)e.getValue()));
        return t.root == this.root ? this : t.toImmutable();
    }

    @Override
    public LinkedHashMap<K, V> filterNot(BiPredicate<? super K, ? super V> predicate) {
        return this.filter((BiPredicate)predicate.negate());
    }

    @Override
    public LinkedHashMap<K, V> filter(Predicate<? super Tuple2<K, V>> predicate) {
        TransientLinkedHashMap t = this.toTransient();
        t.filterAll(e -> predicate.test(new Tuple2(e.getKey(), e.getValue())));
        return t.root == this.root ? this : t.toImmutable();
    }

    @Override
    public LinkedHashMap<K, V> filterNot(Predicate<? super Tuple2<K, V>> predicate) {
        return this.filter((Predicate)predicate.negate());
    }

    @Override
    public LinkedHashMap<K, V> filterKeys(Predicate<? super K> predicate) {
        TransientLinkedHashMap t = this.toTransient();
        t.filterAll(e -> predicate.test((Object)e.getKey()));
        return t.root == this.root ? this : t.toImmutable();
    }

    @Override
    public LinkedHashMap<K, V> filterNotKeys(Predicate<? super K> predicate) {
        return this.filterKeys((Predicate)predicate.negate());
    }

    @Override
    public LinkedHashMap<K, V> filterValues(Predicate<? super V> predicate) {
        TransientLinkedHashMap t = this.toTransient();
        t.filterAll(e -> predicate.test((Object)e.getValue()));
        return t.root == this.root ? this : t.toImmutable();
    }

    @Override
    public LinkedHashMap<K, V> filterNotValues(Predicate<? super V> predicate) {
        return this.filterValues((Predicate)predicate.negate());
    }

    @Override
    public <K2, V2> LinkedHashMap<K2, V2> flatMap(BiFunction<? super K, ? super V, ? extends Iterable<Tuple2<K2, V2>>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.foldLeft(LinkedHashMap.empty(), (acc, entry) -> {
            for (Tuple2 mappedEntry : (Iterable)mapper.apply((Object)entry._1, (Object)entry._2)) {
                acc = acc.put(mappedEntry);
            }
            return acc;
        });
    }

    @Override
    public Option<V> get(K key) {
        Object result = this.root.find(new ChampSequenced.ChampSequencedEntry(key), ChampSequenced.ChampSequencedEntry.keyHash(key), 0, ChampSequenced.ChampSequencedEntry::keyEquals);
        return result instanceof ChampSequenced.ChampSequencedEntry ? Option.some(((ChampSequenced.ChampSequencedEntry)result).getValue()) : Option.none();
    }

    @Override
    public V getOrElse(K key, V defaultValue) {
        return this.get(key).getOrElse(defaultValue);
    }

    @Override
    public <C> Map<C, LinkedHashMap<K, V>> groupBy(Function<? super Tuple2<K, V>, ? extends C> classifier) {
        return Maps.groupBy(this, this::createFromEntries, classifier);
    }

    @Override
    public Iterator<LinkedHashMap<K, V>> grouped(int size) {
        return Maps.grouped(this, this::createFromEntries, size);
    }

    @Override
    public Tuple2<K, V> head() {
        Map.Entry entry = (Map.Entry)this.vector.head();
        return new Tuple2(entry.getKey(), entry.getValue());
    }

    @Override
    public LinkedHashMap<K, V> init() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("init of empty LinkedHashMap");
        }
        return this.remove(((Tuple2)this.last())._1);
    }

    @Override
    public Option<LinkedHashMap<K, V>> initOption() {
        return Maps.initOption(this);
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public boolean isSequential() {
        return true;
    }

    @Override
    public Iterator<Tuple2<K, V>> iterator() {
        return new ChampIteration.IteratorFacade<Tuple2<K, V>>(this.spliterator());
    }

    Iterator<Tuple2<K, V>> iterator(int startIndex) {
        return new ChampIteration.IteratorFacade<Tuple2<K, V>>(this.spliterator(startIndex));
    }

    @Override
    public Set<K> keySet() {
        return LinkedHashSet.ofAll(this.iterator().map(Tuple2::_1));
    }

    @Override
    public Tuple2<K, V> last() {
        Map.Entry entry = (Map.Entry)this.vector.last();
        return new Tuple2(entry.getKey(), entry.getValue());
    }

    @Override
    public <K2, V2> LinkedHashMap<K2, V2> map(BiFunction<? super K, ? super V, Tuple2<K2, V2>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.foldLeft(LinkedHashMap.empty(), (acc, entry) -> acc.put(entry.map(mapper)));
    }

    @Override
    public <K2> LinkedHashMap<K2, V> mapKeys(Function<? super K, ? extends K2> keyMapper) {
        Objects.requireNonNull(keyMapper, "keyMapper is null");
        return this.map((T k, U v) -> Tuple.of(keyMapper.apply((Object)k), v));
    }

    @Override
    public <K2> LinkedHashMap<K2, V> mapKeys(Function<? super K, ? extends K2> keyMapper, BiFunction<? super V, ? super V, ? extends V> valueMerge) {
        return Collections.mapKeys(this, LinkedHashMap.empty(), keyMapper, valueMerge);
    }

    @Override
    public <W> LinkedHashMap<K, W> mapValues(Function<? super V, ? extends W> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.map((T k, U v) -> Tuple.of(k, mapper.apply((Object)v)));
    }

    @Override
    public LinkedHashMap<K, V> merge(Map<? extends K, ? extends V> that) {
        return this.putAllTuples(that);
    }

    @Override
    public <U extends V> LinkedHashMap<K, V> merge(Map<? extends K, U> that, BiFunction<? super V, ? super U, ? extends V> collisionResolution) {
        return Maps.merge(this, this::createFromEntries, that, collisionResolution);
    }

    @Override
    public LinkedHashMap<K, V> orElse(Iterable<? extends Tuple2<K, V>> other) {
        return this.isEmpty() ? LinkedHashMap.ofEntries(other) : this;
    }

    @Override
    public LinkedHashMap<K, V> orElse(Supplier<? extends Iterable<? extends Tuple2<K, V>>> supplier) {
        return this.isEmpty() ? LinkedHashMap.ofEntries(supplier.get()) : this;
    }

    @Override
    public Tuple2<LinkedHashMap<K, V>, LinkedHashMap<K, V>> partition(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.partition(this, this::createFromEntries, predicate);
    }

    @Override
    public LinkedHashMap<K, V> peek(Consumer<? super Tuple2<K, V>> action) {
        return Maps.peek(this, action);
    }

    @Override
    public <U extends V> LinkedHashMap<K, V> put(K key, U value, BiFunction<? super V, ? super U, ? extends V> merge) {
        return Maps.put(this, key, value, merge);
    }

    @Override
    public LinkedHashMap<K, V> put(K key, V value) {
        return this.putLast(key, value, false);
    }

    private LinkedHashMap<K, V> putAllEntries(Iterable<? extends Map.Entry<? extends K, ? extends V>> c) {
        TransientLinkedHashMap<K, V> t = this.toTransient();
        t.putAllEntries(c);
        return t.root == this.root ? this : t.toImmutable();
    }

    private LinkedHashMap<K, V> putAllTuples(Iterable<? extends Tuple2<? extends K, ? extends V>> c) {
        if (this.isEmpty() && c instanceof LinkedHashMap) {
            LinkedHashMap that = (LinkedHashMap)c;
            return that;
        }
        TransientLinkedHashMap<K, V> t = this.toTransient();
        t.putAllTuples(c);
        return t.root == this.root ? this : t.toImmutable();
    }

    private LinkedHashMap<K, V> putLast(K key, V value, boolean moveToLast) {
        ChampTrie.ChangeEvent details = new ChampTrie.ChangeEvent();
        ChampSequenced.ChampSequencedEntry<K, V> newEntry = new ChampSequenced.ChampSequencedEntry<K, V>(key, value, this.vector.size() - this.offset);
        ChampTrie.Node newRoot = this.root.put(null, (Object)newEntry, ChampSequenced.ChampSequencedEntry.keyHash(key), 0, details, moveToLast ? ChampSequenced.ChampSequencedEntry::updateAndMoveToLast : ChampSequenced.ChampSequencedEntry::updateWithNewKey, ChampSequenced.ChampSequencedEntry::keyEquals, ChampSequenced.ChampSequencedEntry::entryKeyHash);
        if (details.isReplaced() && ((ChampSequenced.ChampSequencedEntry)details.getOldDataNonNull()).getSequenceNumber() == ((ChampSequenced.ChampSequencedEntry)details.getNewDataNonNull()).getSequenceNumber()) {
            IndexedSeq newVector = this.vector.update(((ChampSequenced.ChampSequencedEntry)details.getNewDataNonNull()).getSequenceNumber() - this.offset, details.getNewDataNonNull());
            return new LinkedHashMap<K, V>(newRoot, (Vector<Object>)newVector, this.size, this.offset);
        }
        if (details.isModified()) {
            Vector newVector = this.vector;
            int newOffset = this.offset;
            int newSize = this.size;
            if (details.isReplaced()) {
                if (moveToLast) {
                    ChampSequenced.ChampSequencedEntry oldElem = (ChampSequenced.ChampSequencedEntry)details.getOldDataNonNull();
                    Tuple2<Vector<Object>, Integer> result = ChampSequenced.ChampSequencedData.vecRemove(newVector, oldElem, newOffset);
                    newVector = (Vector)result._1;
                    newOffset = (Integer)result._2;
                }
            } else {
                ++newSize;
            }
            newVector = newVector.append(newEntry);
            return this.renumber((ChampTrie.BitmapIndexedNode<ChampSequenced.ChampSequencedEntry<K, V>>)newRoot, newVector, newSize, newOffset);
        }
        return this;
    }

    @Override
    public LinkedHashMap<K, V> put(Tuple2<? extends K, ? extends V> entry) {
        return Maps.put(this, entry);
    }

    @Override
    public <U extends V> LinkedHashMap<K, V> put(Tuple2<? extends K, U> entry, BiFunction<? super V, ? super U, ? extends V> merge) {
        return Maps.put(this, entry, merge);
    }

    @Override
    public LinkedHashMap<K, V> remove(K key) {
        int keyHash = ChampSequenced.ChampSequencedEntry.keyHash(key);
        ChampTrie.ChangeEvent details = new ChampTrie.ChangeEvent();
        ChampTrie.Node newRoot = this.root.remove(null, (Object)new ChampSequenced.ChampSequencedEntry(key), keyHash, 0, details, ChampSequenced.ChampSequencedEntry::keyEquals);
        if (details.isModified()) {
            ChampSequenced.ChampSequencedEntry oldElem = (ChampSequenced.ChampSequencedEntry)details.getOldDataNonNull();
            Tuple2<Vector<Object>, Integer> result = ChampSequenced.ChampSequencedData.vecRemove(this.vector, oldElem, this.offset);
            return this.renumber((ChampTrie.BitmapIndexedNode<ChampSequenced.ChampSequencedEntry<K, V>>)newRoot, (Vector)result._1, this.size - 1, (Integer)result._2);
        }
        return this;
    }

    @Override
    public LinkedHashMap<K, V> removeAll(Iterable<? extends K> keys) {
        Objects.requireNonNull(keys, "keys is null");
        TransientLinkedHashMap<K, V> t = this.toTransient();
        return t.removeAll(keys) ? t.toImmutable() : this;
    }

    private LinkedHashMap<K, V> renumber(ChampTrie.BitmapIndexedNode<ChampSequenced.ChampSequencedEntry<K, V>> root, Vector<Object> vector, int size, int offset) {
        if (ChampSequenced.ChampSequencedData.vecMustRenumber(size, offset, this.vector.size())) {
            ChampTrie.IdentityObject owner = new ChampTrie.IdentityObject();
            Tuple2<ChampTrie.BitmapIndexedNode<ChampSequenced.ChampSequencedEntry>, Vector<Object>> result = ChampSequenced.ChampSequencedData.vecRenumber(size, root, vector, owner, ChampSequenced.ChampSequencedEntry::entryKeyHash, ChampSequenced.ChampSequencedEntry::keyEquals, (e, seq) -> new ChampSequenced.ChampSequencedEntry(e.getKey(), e.getValue(), (int)seq));
            return new LinkedHashMap<K, V>((ChampTrie.BitmapIndexedNode)result._1, (Vector)result._2, size, 0);
        }
        return new LinkedHashMap<K, V>(root, vector, size, offset);
    }

    @Override
    public LinkedHashMap<K, V> replace(Tuple2<K, V> currentEntry, Tuple2<K, V> newEntry) {
        if (Objects.equals(currentEntry, newEntry)) {
            return this;
        }
        ChampTrie.ChangeEvent detailsCurrent = new ChampTrie.ChangeEvent();
        ChampTrie.IdentityObject owner = new ChampTrie.IdentityObject();
        ChampTrie.Node newRoot = this.root.remove(owner, (Object)new ChampSequenced.ChampSequencedEntry(currentEntry._1, currentEntry._2), Objects.hashCode(currentEntry._1), 0, detailsCurrent, ChampSequenced.ChampSequencedEntry::keyAndValueEquals);
        if (!detailsCurrent.isModified()) {
            return this;
        }
        IndexedSeq newVector = this.vector;
        int newOffset = this.offset;
        ChampSequenced.ChampSequencedEntry removedData = (ChampSequenced.ChampSequencedEntry)detailsCurrent.getOldData();
        int seq = removedData.getSequenceNumber();
        Tuple2<Vector<Object>, Integer> result = ChampSequenced.ChampSequencedData.vecRemove(newVector, removedData, this.offset);
        newVector = (Vector)result._1;
        newOffset = (Integer)result._2;
        ChampTrie.ChangeEvent detailsNew = new ChampTrie.ChangeEvent();
        ChampSequenced.ChampSequencedEntry newData = new ChampSequenced.ChampSequencedEntry(newEntry._1, newEntry._2, seq);
        newRoot = ((ChampTrie.BitmapIndexedNode)newRoot).put(owner, newData, Objects.hashCode(newEntry._1), 0, detailsNew, ChampSequenced.ChampSequencedEntry::forceUpdate, ChampSequenced.ChampSequencedEntry::keyEquals, ChampSequenced.ChampSequencedEntry::entryKeyHash);
        boolean isReplaced = detailsNew.isReplaced();
        if (isReplaced) {
            ChampSequenced.ChampSequencedEntry replacedData = (ChampSequenced.ChampSequencedEntry)detailsNew.getOldData();
            result = ChampSequenced.ChampSequencedData.vecRemove(newVector, replacedData, newOffset);
            newVector = (Vector)result._1;
            newOffset = (Integer)result._2;
        }
        IndexedSeq indexedSeq = newVector = seq + newOffset < newVector.size() ? newVector.update(seq + newOffset, newData) : newVector.append(newData);
        if (isReplaced) {
            return this.renumber((ChampTrie.BitmapIndexedNode<ChampSequenced.ChampSequencedEntry<K, V>>)newRoot, (Vector<Object>)newVector, this.size - 1, newOffset);
        }
        return new LinkedHashMap<K, V>(newRoot, (Vector<Object>)newVector, this.size, newOffset);
    }

    @Override
    public LinkedHashMap<K, V> replaceAll(Tuple2<K, V> currentElement, Tuple2<K, V> newElement) {
        return Maps.replaceAll(this, currentElement, newElement);
    }

    @Override
    public LinkedHashMap<K, V> replaceValue(K key, V value) {
        return Maps.replaceValue(this, key, value);
    }

    @Override
    public LinkedHashMap<K, V> replace(K key, V oldValue, V newValue) {
        return Maps.replace(this, key, oldValue, newValue);
    }

    @Override
    public LinkedHashMap<K, V> replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        return Maps.replaceAll(this, function);
    }

    @Override
    public LinkedHashMap<K, V> retainAll(Iterable<? extends Tuple2<K, V>> elements) {
        TransientLinkedHashMap<K, V> t = this.toTransient();
        t.retainAllTuples(elements);
        return t.root == this.root ? this : t.toImmutable();
    }

    Iterator<Tuple2<K, V>> reverseIterator() {
        return new ChampIteration.IteratorFacade<Tuple2<K, V>>(this.reverseSpliterator());
    }

    Spliterator<Tuple2<K, V>> reverseSpliterator() {
        return new ChampSequenced.ChampReverseVectorSpliterator<Tuple2<K, V>>(this.vector, e -> new Tuple2(((Map.Entry)e).getKey(), ((Map.Entry)e).getValue()), 0, this.size(), 1105L);
    }

    @Override
    public LinkedHashMap<K, V> scan(Tuple2<K, V> zero, BiFunction<? super Tuple2<K, V>, ? super Tuple2<K, V>, ? extends Tuple2<K, V>> operation) {
        return Maps.scan(this, zero, operation, this::createFromEntries);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<LinkedHashMap<K, V>> slideBy(Function<? super Tuple2<K, V>, ?> classifier) {
        return Maps.slideBy(this, this::createFromEntries, classifier);
    }

    @Override
    public Iterator<LinkedHashMap<K, V>> sliding(int size) {
        return Maps.sliding(this, this::createFromEntries, size);
    }

    @Override
    public Iterator<LinkedHashMap<K, V>> sliding(int size, int step) {
        return Maps.sliding(this, this::createFromEntries, size, step);
    }

    @Override
    public Tuple2<LinkedHashMap<K, V>, LinkedHashMap<K, V>> span(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.span(this, this::createFromEntries, predicate);
    }

    @Override
    public Spliterator<Tuple2<K, V>> spliterator() {
        return this.spliterator(0);
    }

    Spliterator<Tuple2<K, V>> spliterator(int startIndex) {
        return new ChampSequenced.ChampVectorSpliterator<Tuple2<K, V>>(this.vector, e -> new Tuple2(((Map.Entry)e).getKey(), ((Map.Entry)e).getValue()), startIndex, this.size(), 1105);
    }

    @Override
    public LinkedHashMap<K, V> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty LinkedHashMap");
        }
        return this.remove(((Tuple2)this.head())._1);
    }

    @Override
    public Option<LinkedHashMap<K, V>> tailOption() {
        return Maps.tailOption(this);
    }

    @Override
    public LinkedHashMap<K, V> take(int n) {
        return Maps.take(this, this::createFromEntries, n);
    }

    @Override
    public LinkedHashMap<K, V> takeRight(int n) {
        return Maps.takeRight(this, this::createFromEntries, n);
    }

    @Override
    public LinkedHashMap<K, V> takeUntil(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.takeUntil(this, this::createFromEntries, predicate);
    }

    @Override
    public LinkedHashMap<K, V> takeWhile(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.takeWhile(this, this::createFromEntries, predicate);
    }

    @Override
    public java.util.LinkedHashMap<K, V> toJavaMap() {
        return this.toJavaMap(java.util.LinkedHashMap::new, t -> t);
    }

    TransientLinkedHashMap<K, V> toTransient() {
        return new TransientLinkedHashMap(this);
    }

    @Override
    public Seq<V> values() {
        return this.map((T t) -> t._2);
    }

    @Override
    public boolean equals(Object o) {
        return Collections.equals(this, o);
    }

    @Override
    public int hashCode() {
        return Collections.hashUnordered(this);
    }

    private Object readResolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    @Override
    public String stringPrefix() {
        return "LinkedHashMap";
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }

    private LinkedHashMap<K, V> createFromEntries(Iterable<Tuple2<K, V>> tuples) {
        return LinkedHashMap.ofEntries(tuples);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    static class TransientLinkedHashMap<K, V>
    extends ChampTransience.ChampAbstractTransientMap<K, V, ChampSequenced.ChampSequencedEntry<K, V>> {
        private int offset;
        private Vector<Object> vector;

        TransientLinkedHashMap(LinkedHashMap<K, V> m) {
            this.vector = m.vector;
            this.root = ((LinkedHashMap)m).root;
            this.offset = m.offset;
            this.size = m.size;
        }

        TransientLinkedHashMap() {
            this(LinkedHashMap.empty());
        }

        @Override
        public V put(K key, V value) {
            ChampSequenced.ChampSequencedEntry<K, V> oldData = this.putLast(key, value, false).getOldData();
            return oldData == null ? null : (V)oldData.getValue();
        }

        boolean putAllEntries(Iterable<? extends Map.Entry<? extends K, ? extends V>> c) {
            if (c == this) {
                return false;
            }
            boolean modified = false;
            for (Map.Entry<K, V> e : c) {
                modified |= this.putLast(e.getKey(), e.getValue(), false).isModified();
            }
            return modified;
        }

        @Override
        boolean putAllTuples(Iterable<? extends Tuple2<? extends K, ? extends V>> c) {
            if (c == this) {
                return false;
            }
            boolean modified = false;
            for (Tuple2<K, V> tuple2 : c) {
                modified |= this.putLast(tuple2._1, tuple2._2, false).isModified();
            }
            return modified;
        }

        ChampTrie.ChangeEvent<ChampSequenced.ChampSequencedEntry<K, V>> putLast(K key, V value, boolean moveToLast) {
            ChampTrie.ChangeEvent<ChampSequenced.ChampSequencedEntry<K, V>> details = new ChampTrie.ChangeEvent<ChampSequenced.ChampSequencedEntry<K, V>>();
            ChampSequenced.ChampSequencedEntry<K, V> newEntry = new ChampSequenced.ChampSequencedEntry<K, V>(key, value, this.vector.size() - this.offset);
            ChampTrie.IdentityObject owner = this.makeOwner();
            this.root = this.root.put(owner, newEntry, Objects.hashCode(key), 0, (ChampTrie.ChangeEvent)details, moveToLast ? ChampSequenced.ChampSequencedEntry::updateAndMoveToLast : ChampSequenced.ChampSequencedEntry::updateWithNewKey, ChampSequenced.ChampSequencedEntry::keyEquals, ChampSequenced.ChampSequencedEntry::entryKeyHash);
            if (details.isReplaced() && ((ChampSequenced.ChampSequencedEntry)details.getOldDataNonNull()).getSequenceNumber() == details.getNewDataNonNull().getSequenceNumber()) {
                this.vector = this.vector.update(details.getNewDataNonNull().getSequenceNumber() - this.offset, (Object)details.getNewDataNonNull());
                return details;
            }
            if (details.isModified()) {
                if (details.isReplaced()) {
                    Tuple2<Vector<Object>, Integer> result = ChampSequenced.ChampSequencedData.vecRemove(this.vector, (ChampSequenced.ChampSequencedData)details.getOldDataNonNull(), this.offset);
                    this.vector = (Vector)result._1;
                    this.offset = (Integer)result._2;
                } else {
                    ++this.size;
                }
                ++this.modCount;
                this.vector = this.vector.append((Object)newEntry);
                this.renumber();
            }
            return details;
        }

        @Override
        boolean removeAll(Iterable<?> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean modified = false;
            for (Object key : c) {
                ChampTrie.ChangeEvent<ChampSequenced.ChampSequencedEntry<?, V>> details = this.removeKey(key);
                modified |= details.isModified();
            }
            return modified;
        }

        @Override
        ChampTrie.ChangeEvent<ChampSequenced.ChampSequencedEntry<K, V>> removeKey(K key) {
            ChampTrie.ChangeEvent<ChampSequenced.ChampSequencedEntry<K, V>> details = new ChampTrie.ChangeEvent<ChampSequenced.ChampSequencedEntry<K, V>>();
            this.root = this.root.remove((ChampTrie.IdentityObject)null, new ChampSequenced.ChampSequencedEntry(key), Objects.hashCode(key), 0, (ChampTrie.ChangeEvent)details, ChampSequenced.ChampSequencedEntry::keyEquals);
            if (details.isModified()) {
                ChampSequenced.ChampSequencedEntry oldElem = (ChampSequenced.ChampSequencedEntry)details.getOldDataNonNull();
                Tuple2<Vector<Object>, Integer> result = ChampSequenced.ChampSequencedData.vecRemove(this.vector, oldElem, this.offset);
                this.vector = (Vector)result._1;
                this.offset = (Integer)result._2;
                --this.size;
                ++this.modCount;
                this.renumber();
            }
            return details;
        }

        @Override
        void clear() {
            this.root = ChampTrie.BitmapIndexedNode.emptyNode();
            this.vector = Vector.empty();
            this.offset = 0;
            this.size = 0;
        }

        void renumber() {
            if (ChampSequenced.ChampSequencedData.vecMustRenumber(this.size, this.offset, this.vector.size())) {
                ChampTrie.IdentityObject owner = this.makeOwner();
                Tuple2<ChampTrie.BitmapIndexedNode<ChampSequenced.ChampSequencedEntry>, Vector<Object>> result = ChampSequenced.ChampSequencedData.vecRenumber(this.size, this.root, this.vector, owner, ChampSequenced.ChampSequencedEntry::entryKeyHash, ChampSequenced.ChampSequencedEntry::keyEquals, (e, seq) -> new ChampSequenced.ChampSequencedEntry(e.getKey(), e.getValue(), (int)seq));
                this.root = (ChampTrie.BitmapIndexedNode)result._1;
                this.vector = (Vector)result._2;
                this.offset = 0;
            }
        }

        public LinkedHashMap<K, V> toImmutable() {
            this.owner = null;
            return this.isEmpty() ? LinkedHashMap.empty() : new LinkedHashMap(this.root, this.vector, this.size, this.offset);
        }

        @Override
        boolean filterAll(Predicate<Map.Entry<K, V>> predicate) {
            ChampTrie.BulkChangeEvent bulkChange = new ChampTrie.BulkChangeEvent();
            VectorSideEffectPredicate<K, V> vp = new VectorSideEffectPredicate<K, V>(predicate, this.vector, this.offset);
            ChampTrie.Node newRootNode = this.root.filterAll(this.makeOwner(), vp, 0, bulkChange);
            if (bulkChange.removed == 0) {
                return false;
            }
            this.root = newRootNode;
            this.vector = vp.newVector;
            this.offset = this.vector.isEmpty() ? 0 : vp.newOffset;
            this.size -= bulkChange.removed;
            ++this.modCount;
            return true;
        }

        static class VectorSideEffectPredicate<K, V>
        implements Predicate<ChampSequenced.ChampSequencedEntry<K, V>> {
            Vector<Object> newVector;
            int newOffset;
            Predicate<? super Map.Entry<K, V>> predicate;

            public VectorSideEffectPredicate(Predicate<? super Map.Entry<K, V>> predicate, Vector<Object> vector, int offset) {
                this.predicate = predicate;
                this.newVector = vector;
                this.newOffset = offset;
            }

            @Override
            public boolean test(ChampSequenced.ChampSequencedEntry<K, V> e) {
                if (!this.predicate.test(e)) {
                    Tuple2<Vector<Object>, Integer> result = ChampSequenced.ChampSequencedData.vecRemove(this.newVector, e, this.newOffset);
                    this.newVector = (Vector)result._1;
                    this.newOffset = (Integer)result._2;
                    return false;
                }
                return true;
            }
        }
    }

    private static final class SerializationProxy<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient LinkedHashMap<K, V> map;

        SerializationProxy(LinkedHashMap<K, V> map) {
            this.map = map;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeInt(this.map.size());
            for (Tuple2 tuple2 : this.map) {
                s.writeObject(tuple2._1);
                s.writeObject(tuple2._2);
            }
        }

        private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
            s.defaultReadObject();
            int size = s.readInt();
            if (size < 0) {
                throw new InvalidObjectException("No elements");
            }
            TransientLinkedHashMap<Object, Object> t = new TransientLinkedHashMap<Object, Object>();
            for (int i = 0; i < size; ++i) {
                Object key = s.readObject();
                Object value = s.readObject();
                t.put(key, value);
            }
            this.map = t.toImmutable();
        }

        private Object readResolve() {
            return this.map;
        }
    }
}

