/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.PartialFunction;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.ChampIteration;
import io.vavr.collection.ChampSequenced;
import io.vavr.collection.ChampTransience;
import io.vavr.collection.ChampTrie;
import io.vavr.collection.Collections;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.Iterator;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import io.vavr.collection.Vector;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;

public final class LinkedHashSet<T>
implements Set<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final LinkedHashSet<?> EMPTY = new LinkedHashSet(ChampTrie.BitmapIndexedNode.emptyNode(), Vector.of(new Object[0]), 0, 0);
    private final ChampTrie.BitmapIndexedNode<ChampSequenced.ChampSequencedElement<T>> root;
    final int offset;
    final int size;
    final Vector<Object> vector;

    LinkedHashSet(ChampTrie.BitmapIndexedNode<ChampSequenced.ChampSequencedElement<T>> root, Vector<Object> vector, int size, int offset) {
        this.root = root;
        this.size = size;
        this.offset = offset;
        this.vector = Objects.requireNonNull(vector);
    }

    public static <T> LinkedHashSet<T> empty() {
        return EMPTY;
    }

    public static <T> Collector<T, ArrayList<T>, LinkedHashSet<T>> collector() {
        return Collections.toListAndThen(LinkedHashSet::ofAll);
    }

    public static <T> LinkedHashSet<T> narrow(LinkedHashSet<? extends T> linkedHashSet) {
        return linkedHashSet;
    }

    public static <T> LinkedHashSet<T> of(T element) {
        return LinkedHashSet.empty().add((Object)element);
    }

    @SafeVarargs
    public static <T> LinkedHashSet<T> of(T ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return LinkedHashSet.empty().addAll(Arrays.asList(elements));
    }

    public static <T> LinkedHashSet<T> tabulate(int n, Function<? super Integer, ? extends T> f) {
        Objects.requireNonNull(f, "f is null");
        return Collections.tabulate(n, f, LinkedHashSet.empty(), LinkedHashSet::of);
    }

    public static <T> LinkedHashSet<T> fill(int n, Supplier<? extends T> s) {
        Objects.requireNonNull(s, "s is null");
        return Collections.fill(n, s, LinkedHashSet.empty(), LinkedHashSet::of);
    }

    public static <T> LinkedHashSet<T> ofAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        return elements instanceof LinkedHashSet ? (LinkedHashSet)elements : LinkedHashSet.of(new Object[0]).addAll(elements);
    }

    public static <T> LinkedHashSet<T> ofAll(Stream<? extends T> javaStream) {
        Objects.requireNonNull(javaStream, "javaStream is null");
        return LinkedHashSet.ofAll(Iterator.ofAll(javaStream.iterator()));
    }

    public static LinkedHashSet<Boolean> ofAll(boolean ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return LinkedHashSet.ofAll(Iterator.ofAll(elements));
    }

    public static LinkedHashSet<Byte> ofAll(byte ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return LinkedHashSet.ofAll(Iterator.ofAll(elements));
    }

    public static LinkedHashSet<Character> ofAll(char ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return LinkedHashSet.ofAll(Iterator.ofAll(elements));
    }

    public static LinkedHashSet<Double> ofAll(double ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return LinkedHashSet.ofAll(Iterator.ofAll(elements));
    }

    public static LinkedHashSet<Float> ofAll(float ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return LinkedHashSet.ofAll(Iterator.ofAll(elements));
    }

    public static LinkedHashSet<Integer> ofAll(int ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return LinkedHashSet.ofAll(Iterator.ofAll(elements));
    }

    public static LinkedHashSet<Long> ofAll(long ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return LinkedHashSet.ofAll(Iterator.ofAll(elements));
    }

    public static LinkedHashSet<Short> ofAll(short ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return LinkedHashSet.ofAll(Iterator.ofAll(elements));
    }

    public static LinkedHashSet<Integer> range(int from, int toExclusive) {
        return LinkedHashSet.ofAll(Iterator.range(from, toExclusive));
    }

    public static LinkedHashSet<Character> range(char from, char toExclusive) {
        return LinkedHashSet.ofAll(Iterator.range(from, toExclusive));
    }

    public static LinkedHashSet<Integer> rangeBy(int from, int toExclusive, int step) {
        return LinkedHashSet.ofAll(Iterator.rangeBy(from, toExclusive, step));
    }

    public static LinkedHashSet<Character> rangeBy(char from, char toExclusive, int step) {
        return LinkedHashSet.ofAll(Iterator.rangeBy(from, toExclusive, step));
    }

    public static LinkedHashSet<Double> rangeBy(double from, double toExclusive, double step) {
        return LinkedHashSet.ofAll(Iterator.rangeBy(from, toExclusive, step));
    }

    public static LinkedHashSet<Long> range(long from, long toExclusive) {
        return LinkedHashSet.ofAll(Iterator.range(from, toExclusive));
    }

    public static LinkedHashSet<Long> rangeBy(long from, long toExclusive, long step) {
        return LinkedHashSet.ofAll(Iterator.rangeBy(from, toExclusive, step));
    }

    public static LinkedHashSet<Integer> rangeClosed(int from, int toInclusive) {
        return LinkedHashSet.ofAll(Iterator.rangeClosed(from, toInclusive));
    }

    public static LinkedHashSet<Character> rangeClosed(char from, char toInclusive) {
        return LinkedHashSet.ofAll(Iterator.rangeClosed(from, toInclusive));
    }

    public static LinkedHashSet<Integer> rangeClosedBy(int from, int toInclusive, int step) {
        return LinkedHashSet.ofAll(Iterator.rangeClosedBy(from, toInclusive, step));
    }

    public static LinkedHashSet<Character> rangeClosedBy(char from, char toInclusive, int step) {
        return LinkedHashSet.ofAll(Iterator.rangeClosedBy(from, toInclusive, step));
    }

    public static LinkedHashSet<Double> rangeClosedBy(double from, double toInclusive, double step) {
        return LinkedHashSet.ofAll(Iterator.rangeClosedBy(from, toInclusive, step));
    }

    public static LinkedHashSet<Long> rangeClosed(long from, long toInclusive) {
        return LinkedHashSet.ofAll(Iterator.rangeClosed(from, toInclusive));
    }

    public static LinkedHashSet<Long> rangeClosedBy(long from, long toInclusive, long step) {
        return LinkedHashSet.ofAll(Iterator.rangeClosedBy(from, toInclusive, step));
    }

    @Override
    public LinkedHashSet<T> add(T element) {
        return this.addLast(element, false);
    }

    private LinkedHashSet<T> addLast(T e, boolean moveToLast) {
        ChampTrie.ChangeEvent details = new ChampTrie.ChangeEvent();
        ChampSequenced.ChampSequencedElement<T> newElem = new ChampSequenced.ChampSequencedElement<T>(e, this.vector.size() - this.offset);
        ChampTrie.Node newRoot = this.root.put(null, (Object)newElem, Objects.hashCode(e), 0, details, moveToLast ? ChampSequenced.ChampSequencedElement::updateAndMoveToLast : ChampSequenced.ChampSequencedElement::update, Objects::equals, Objects::hashCode);
        if (details.isModified()) {
            Vector newVector = this.vector;
            int newOffset = this.offset;
            int newSize = this.size;
            if (details.isReplaced()) {
                if (moveToLast) {
                    ChampSequenced.ChampSequencedElement oldElem = (ChampSequenced.ChampSequencedElement)details.getOldData();
                    Tuple2<Vector<Object>, Integer> result = ChampSequenced.ChampSequencedData.vecRemove(newVector, oldElem, newOffset);
                    newVector = (Vector)result._1;
                    newOffset = (Integer)result._2;
                }
            } else {
                ++newSize;
            }
            newVector = newVector.append(newElem);
            return this.renumber((ChampTrie.BitmapIndexedNode<ChampSequenced.ChampSequencedElement<T>>)newRoot, newVector, newSize, newOffset);
        }
        return this;
    }

    @Override
    public LinkedHashSet<T> addAll(Iterable<? extends T> elements) {
        if (this.isEmpty() && elements instanceof LinkedHashSet) {
            return (LinkedHashSet)elements;
        }
        TransientLinkedHashSet<T> t = this.toTransient();
        t.addAll(elements);
        return t.root == this.root ? this : t.toImmutable();
    }

    @Override
    public <R> LinkedHashSet<R> collect(PartialFunction<? super T, ? extends R> partialFunction) {
        return LinkedHashSet.ofAll(this.iterator().collect(partialFunction));
    }

    @Override
    public boolean contains(T element) {
        return this.root.find(new ChampSequenced.ChampSequencedElement<T>(element), Objects.hashCode(element), 0, Objects::equals) != ChampTrie.Node.NO_DATA;
    }

    @Override
    public LinkedHashSet<T> diff(Set<? extends T> elements) {
        return this.removeAll(elements);
    }

    @Override
    public LinkedHashSet<T> distinct() {
        return this;
    }

    @Override
    public LinkedHashSet<T> distinctBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return LinkedHashSet.ofAll(this.iterator().distinctBy(comparator));
    }

    @Override
    public <U> LinkedHashSet<T> distinctBy(Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor, "keyExtractor is null");
        return LinkedHashSet.ofAll(this.iterator().distinctBy(keyExtractor));
    }

    @Override
    public LinkedHashSet<T> drop(int n) {
        if (n <= 0) {
            return this;
        }
        return LinkedHashSet.ofAll(this.iterator(n));
    }

    @Override
    public LinkedHashSet<T> dropRight(int n) {
        if (n <= 0) {
            return this;
        }
        return LinkedHashSet.ofAll(this.iterator().dropRight(n));
    }

    @Override
    public LinkedHashSet<T> dropUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.dropWhile((Predicate)predicate.negate());
    }

    @Override
    public LinkedHashSet<T> dropWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        LinkedHashSet<T> dropped = LinkedHashSet.ofAll(this.iterator().dropWhile(predicate));
        return dropped.length() == this.length() ? this : dropped;
    }

    @Override
    public LinkedHashSet<T> filter(Predicate<? super T> predicate) {
        TransientLinkedHashSet<T> t = this.toTransient();
        t.filterAll(predicate);
        return t.root == this.root ? this : t.toImmutable();
    }

    @Override
    public LinkedHashSet<T> filterNot(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.filter((Predicate)predicate.negate());
    }

    @Override
    public <U> LinkedHashSet<U> flatMap(Function<? super T, ? extends Iterable<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        Set<T> flatMapped = LinkedHashSet.empty();
        for (Object t : this) {
            for (U u : mapper.apply(t)) {
                flatMapped = flatMapped.add(u);
            }
        }
        return flatMapped;
    }

    @Override
    public <U> U foldRight(U zero, BiFunction<? super T, ? super U, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return this.iterator().foldRight(zero, f);
    }

    @Override
    public <C> Map<C, LinkedHashSet<T>> groupBy(Function<? super T, ? extends C> classifier) {
        return Collections.groupBy(this, classifier, LinkedHashSet::ofAll);
    }

    @Override
    public Iterator<LinkedHashSet<T>> grouped(int size) {
        return this.sliding(size, size);
    }

    @Override
    public boolean hasDefiniteSize() {
        return true;
    }

    @Override
    public T head() {
        return (T)((ChampSequenced.ChampSequencedElement)this.vector.head()).getElement();
    }

    @Override
    public Option<T> headOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.head());
    }

    @Override
    public LinkedHashSet<T> init() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        return this.remove((Object)this.last());
    }

    @Override
    public Option<LinkedHashSet<T>> initOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.init());
    }

    @Override
    public LinkedHashSet<T> intersect(Set<? extends T> elements) {
        return this.retainAll(elements);
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public boolean isTraversableAgain() {
        return true;
    }

    @Override
    public boolean isSequential() {
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new ChampIteration.IteratorFacade<T>(this.spliterator());
    }

    Iterator<T> iterator(int startIndex) {
        return new ChampIteration.IteratorFacade<T>(this.spliterator(startIndex));
    }

    @Override
    public T last() {
        return (T)((ChampSequenced.ChampSequencedElement)this.vector.last()).getElement();
    }

    @Override
    public int length() {
        return this.size;
    }

    @Override
    public <U> LinkedHashSet<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        Set<T> mapped = LinkedHashSet.empty();
        for (Object t : this) {
            mapped = mapped.add(mapper.apply(t));
        }
        return mapped;
    }

    @Override
    public String mkString(CharSequence prefix, CharSequence delimiter, CharSequence suffix) {
        return this.iterator().mkString(prefix, delimiter, suffix);
    }

    @Override
    public LinkedHashSet<T> orElse(Iterable<? extends T> other) {
        return this.isEmpty() ? LinkedHashSet.ofAll(other) : this;
    }

    @Override
    public LinkedHashSet<T> orElse(Supplier<? extends Iterable<? extends T>> supplier) {
        return this.isEmpty() ? LinkedHashSet.ofAll(supplier.get()) : this;
    }

    @Override
    public Tuple2<LinkedHashSet<T>, LinkedHashSet<T>> partition(Predicate<? super T> predicate) {
        return Collections.partition(this, LinkedHashSet::ofAll, predicate);
    }

    @Override
    public LinkedHashSet<T> peek(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        if (!this.isEmpty()) {
            action.accept(this.iterator().head());
        }
        return this;
    }

    @Override
    public LinkedHashSet<T> remove(T element) {
        int keyHash = Objects.hashCode(element);
        ChampTrie.ChangeEvent details = new ChampTrie.ChangeEvent();
        ChampTrie.Node newRoot = this.root.remove(null, (Object)new ChampSequenced.ChampSequencedElement<T>(element), keyHash, 0, details, Objects::equals);
        if (details.isModified()) {
            ChampSequenced.ChampSequencedElement removedElem = (ChampSequenced.ChampSequencedElement)details.getOldDataNonNull();
            Tuple2<Vector<Object>, Integer> result = ChampSequenced.ChampSequencedData.vecRemove(this.vector, removedElem, this.offset);
            return this.renumber((ChampTrie.BitmapIndexedNode<ChampSequenced.ChampSequencedElement<T>>)newRoot, (Vector)result._1, this.size - 1, (Integer)result._2);
        }
        return this;
    }

    @Override
    public LinkedHashSet<T> removeAll(Iterable<? extends T> elements) {
        TransientLinkedHashSet<T> t = this.toTransient();
        t.removeAll(elements);
        return t.root == this.root ? this : t.toImmutable();
    }

    private LinkedHashSet<T> renumber(ChampTrie.BitmapIndexedNode<ChampSequenced.ChampSequencedElement<T>> root, Vector<Object> vector, int size, int offset) {
        if (ChampSequenced.ChampSequencedData.vecMustRenumber(size, offset, this.vector.size())) {
            ChampTrie.IdentityObject owner = new ChampTrie.IdentityObject();
            Tuple2<ChampTrie.BitmapIndexedNode<ChampSequenced.ChampSequencedElement>, Vector<Object>> result = ChampSequenced.ChampSequencedData.vecRenumber(size, root, vector, owner, Objects::hashCode, Objects::equals, (e, seq) -> new ChampSequenced.ChampSequencedElement(e.getElement(), (int)seq));
            return new LinkedHashSet<T>(result._1(), result._2(), size, 0);
        }
        return new LinkedHashSet<T>(root, vector, size, offset);
    }

    @Override
    public LinkedHashSet<T> replace(T currentElement, T newElement) {
        if (Objects.equals(currentElement, newElement)) {
            return this;
        }
        ChampTrie.ChangeEvent detailsCurrent = new ChampTrie.ChangeEvent();
        ChampTrie.IdentityObject owner = new ChampTrie.IdentityObject();
        ChampTrie.Node newRoot = this.root.remove(owner, (Object)new ChampSequenced.ChampSequencedElement<T>(currentElement), Objects.hashCode(currentElement), 0, detailsCurrent, Objects::equals);
        if (!detailsCurrent.isModified()) {
            return this;
        }
        IndexedSeq newVector = this.vector;
        int newOffset = this.offset;
        ChampSequenced.ChampSequencedElement currentData = (ChampSequenced.ChampSequencedElement)detailsCurrent.getOldData();
        int seq = currentData.getSequenceNumber();
        Tuple2<Vector<Object>, Integer> result = ChampSequenced.ChampSequencedData.vecRemove(newVector, currentData, newOffset);
        newVector = (Vector)result._1;
        newOffset = (Integer)result._2;
        ChampTrie.ChangeEvent detailsNew = new ChampTrie.ChangeEvent();
        ChampSequenced.ChampSequencedElement<T> newData = new ChampSequenced.ChampSequencedElement<T>(newElement, seq);
        newRoot = ((ChampTrie.BitmapIndexedNode)newRoot).put(owner, newData, Objects.hashCode(newElement), 0, detailsNew, ChampSequenced.ChampSequencedElement::forceUpdate, Objects::equals, Objects::hashCode);
        boolean isReplaced = detailsNew.isReplaced();
        if (isReplaced) {
            ChampSequenced.ChampSequencedElement replacedEntry = (ChampSequenced.ChampSequencedElement)detailsNew.getOldData();
            result = ChampSequenced.ChampSequencedData.vecRemove(newVector, replacedEntry, newOffset);
            newVector = (Vector)result._1;
            newOffset = (Integer)result._2;
        }
        IndexedSeq indexedSeq = newVector = seq + newOffset < newVector.size() ? newVector.update(seq + newOffset, newData) : newVector.append(newData);
        if (isReplaced) {
            return this.renumber((ChampTrie.BitmapIndexedNode<ChampSequenced.ChampSequencedElement<T>>)newRoot, (Vector<Object>)newVector, this.size - 1, newOffset);
        }
        return new LinkedHashSet<T>(newRoot, (Vector<Object>)newVector, this.size, newOffset);
    }

    @Override
    public LinkedHashSet<T> replaceAll(T currentElement, T newElement) {
        return this.replace((Object)currentElement, (Object)newElement);
    }

    @Override
    public LinkedHashSet<T> retainAll(Iterable<? extends T> elements) {
        TransientLinkedHashSet<T> t = this.toTransient();
        t.retainAll(elements);
        return t.root == this.root ? this : t.toImmutable();
    }

    private Iterator<T> reverseIterator() {
        return new ChampIteration.IteratorFacade<T>(this.reverseSpliterator());
    }

    private Spliterator<T> reverseSpliterator() {
        return new ChampSequenced.ChampReverseVectorSpliterator<Object>(this.vector, e -> ((ChampSequenced.ChampSequencedElement)e).getElement(), 0, this.size(), 1105L);
    }

    @Override
    public LinkedHashSet<T> scan(T zero, BiFunction<? super T, ? super T, ? extends T> operation) {
        return this.scanLeft(zero, operation);
    }

    @Override
    public <U> LinkedHashSet<U> scanLeft(U zero, BiFunction<? super U, ? super T, ? extends U> operation) {
        return Collections.scanLeft(this, zero, operation, LinkedHashSet::ofAll);
    }

    @Override
    public <U> LinkedHashSet<U> scanRight(U zero, BiFunction<? super T, ? super U, ? extends U> operation) {
        return Collections.scanRight(this, zero, operation, LinkedHashSet::ofAll);
    }

    @Override
    public Iterator<LinkedHashSet<T>> slideBy(Function<? super T, ?> classifier) {
        return this.iterator().slideBy(classifier).map(LinkedHashSet::ofAll);
    }

    @Override
    public Iterator<LinkedHashSet<T>> sliding(int size) {
        return this.sliding(size, 1);
    }

    @Override
    public Iterator<LinkedHashSet<T>> sliding(int size, int step) {
        return this.iterator().sliding(size, step).map(LinkedHashSet::ofAll);
    }

    @Override
    public Tuple2<LinkedHashSet<T>, LinkedHashSet<T>> span(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        Tuple2<Iterator<? super T>, Iterator<? super T>> t = this.iterator().span(predicate);
        return Tuple.of(LinkedHashSet.ofAll((Iterable)t._1), LinkedHashSet.ofAll((Iterable)t._2));
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.spliterator(0);
    }

    Spliterator<T> spliterator(int startIndex) {
        return new ChampSequenced.ChampVectorSpliterator<Object>(this.vector, e -> ((ChampSequenced.ChampSequencedElement)e).getElement(), startIndex, this.size(), 1105);
    }

    @Override
    public LinkedHashSet<T> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        return this.remove((Object)this.head());
    }

    @Override
    public Option<LinkedHashSet<T>> tailOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.tail());
    }

    @Override
    public LinkedHashSet<T> take(int n) {
        if (this.size() <= n) {
            return this;
        }
        return LinkedHashSet.ofAll(() -> this.iterator().take(n));
    }

    @Override
    public LinkedHashSet<T> takeRight(int n) {
        if (this.size() <= n) {
            return this;
        }
        return LinkedHashSet.ofAll(() -> this.iterator().takeRight(n));
    }

    @Override
    public LinkedHashSet<T> takeUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.takeWhile((Predicate)predicate.negate());
    }

    @Override
    public LinkedHashSet<T> takeWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        LinkedHashSet<T> taken = LinkedHashSet.ofAll(this.iterator().takeWhile(predicate));
        return taken.length() == this.length() ? this : taken;
    }

    public <U> U transform(Function<? super LinkedHashSet<T>, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return f.apply(this);
    }

    @Override
    public java.util.LinkedHashSet<T> toJavaSet() {
        return this.toJavaSet(java.util.LinkedHashSet::new);
    }

    TransientLinkedHashSet<T> toTransient() {
        return new TransientLinkedHashSet(this);
    }

    @Override
    public LinkedHashSet<T> union(Set<? extends T> elements) {
        return this.addAll(elements);
    }

    @Override
    public <U> LinkedHashSet<Tuple2<T, U>> zip(Iterable<? extends U> that) {
        return this.zipWith((Iterable)that, Tuple::of);
    }

    @Override
    public <U, R> LinkedHashSet<R> zipWith(Iterable<? extends U> that, BiFunction<? super T, ? super U, ? extends R> mapper) {
        Objects.requireNonNull(that, "that is null");
        Objects.requireNonNull(mapper, "mapper is null");
        return LinkedHashSet.ofAll(this.iterator().zipWith(that, mapper));
    }

    @Override
    public <U> LinkedHashSet<Tuple2<T, U>> zipAll(Iterable<? extends U> that, T thisElem, U thatElem) {
        Objects.requireNonNull(that, "that is null");
        return LinkedHashSet.ofAll(this.iterator().zipAll(that, thisElem, thatElem));
    }

    @Override
    public LinkedHashSet<Tuple2<T, Integer>> zipWithIndex() {
        return this.zipWithIndex(Tuple::of);
    }

    @Override
    public <U> LinkedHashSet<U> zipWithIndex(BiFunction<? super T, ? super Integer, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return LinkedHashSet.ofAll(this.iterator().zipWithIndex(mapper));
    }

    @Override
    public boolean equals(Object o) {
        return Collections.equals(this, o);
    }

    @Override
    public int hashCode() {
        return Collections.hashUnordered(this);
    }

    @Override
    public String stringPrefix() {
        return "LinkedHashSet";
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    static class TransientLinkedHashSet<E>
    extends ChampTransience.ChampAbstractTransientSet<E, ChampSequenced.ChampSequencedElement<E>> {
        int offset;
        Vector<Object> vector;

        TransientLinkedHashSet(LinkedHashSet<E> s) {
            this.root = ((LinkedHashSet)s).root;
            this.size = s.size;
            this.vector = s.vector;
            this.offset = s.offset;
        }

        TransientLinkedHashSet() {
            this(LinkedHashSet.empty());
        }

        @Override
        void clear() {
            this.root = ChampTrie.BitmapIndexedNode.emptyNode();
            this.vector = Vector.empty();
            this.size = 0;
            ++this.modCount;
            this.offset = -1;
        }

        public LinkedHashSet<E> toImmutable() {
            this.owner = null;
            return this.isEmpty() ? LinkedHashSet.empty() : new LinkedHashSet(this.root, this.vector, this.size, this.offset);
        }

        boolean add(E element) {
            return this.addLast(element, false);
        }

        private boolean addLast(E e, boolean moveToLast) {
            ChampTrie.ChangeEvent details = new ChampTrie.ChangeEvent();
            ChampSequenced.ChampSequencedElement<E> newElem = new ChampSequenced.ChampSequencedElement<E>(e, this.vector.size() - this.offset);
            this.root = this.root.put(this.makeOwner(), newElem, Objects.hashCode(e), 0, details, moveToLast ? ChampSequenced.ChampSequencedElement::updateAndMoveToLast : ChampSequenced.ChampSequencedElement::update, Objects::equals, Objects::hashCode);
            if (details.isModified()) {
                if (details.isReplaced()) {
                    if (moveToLast) {
                        ChampSequenced.ChampSequencedElement oldElem = (ChampSequenced.ChampSequencedElement)details.getOldData();
                        Tuple2<Vector<Object>, Integer> result = ChampSequenced.ChampSequencedData.vecRemove(this.vector, oldElem, this.offset);
                        this.vector = (Vector)result._1;
                        this.offset = (Integer)result._2;
                    }
                } else {
                    ++this.size;
                }
                this.vector = this.vector.append((Object)newElem);
                this.renumber();
                return true;
            }
            return false;
        }

        boolean addAll(Iterable<? extends E> c) {
            if (c == this.root) {
                return false;
            }
            if (this.isEmpty() && c instanceof LinkedHashSet) {
                LinkedHashSet cc = (LinkedHashSet)c;
                this.root = cc.root;
                this.size = cc.size;
                return true;
            }
            boolean modified = false;
            for (E e : c) {
                modified |= this.add(e);
            }
            return modified;
        }

        @Override
        java.util.Iterator<E> iterator() {
            return new ChampIteration.IteratorFacade<E>(this.spliterator());
        }

        Spliterator<E> spliterator() {
            return new ChampSequenced.ChampVectorSpliterator<Object>(this.vector, o -> ((ChampSequenced.ChampSequencedElement)o).getElement(), 0, this.size(), 81);
        }

        @Override
        boolean remove(Object element) {
            int keyHash = Objects.hashCode(element);
            ChampTrie.ChangeEvent details = new ChampTrie.ChangeEvent();
            this.root = this.root.remove(this.makeOwner(), new ChampSequenced.ChampSequencedElement<Object>(element), keyHash, 0, details, Objects::equals);
            if (details.isModified()) {
                ChampSequenced.ChampSequencedElement removedElem = (ChampSequenced.ChampSequencedElement)details.getOldDataNonNull();
                Tuple2<Vector<Object>, Integer> result = ChampSequenced.ChampSequencedData.vecRemove(this.vector, removedElem, this.offset);
                this.vector = (Vector)result._1;
                this.offset = (Integer)result._2;
                --this.size;
                this.renumber();
                return true;
            }
            return false;
        }

        private void renumber() {
            if (ChampSequenced.ChampSequencedData.vecMustRenumber(this.size, this.offset, this.vector.size())) {
                ChampTrie.IdentityObject owner = new ChampTrie.IdentityObject();
                Tuple2<ChampTrie.BitmapIndexedNode<ChampSequenced.ChampSequencedElement>, Vector<Object>> result = ChampSequenced.ChampSequencedData.vecRenumber(this.size, this.root, this.vector, owner, Objects::hashCode, Objects::equals, (e, seq) -> new ChampSequenced.ChampSequencedElement(e.getElement(), (int)seq));
                this.root = (ChampTrie.BitmapIndexedNode)result._1;
                this.vector = (Vector)result._2;
                this.offset = 0;
            }
        }

        boolean filterAll(Predicate<? super E> predicate) {
            VectorSideEffectPredicate<? super E> vp = new VectorSideEffectPredicate<E>(predicate, this.vector, this.offset);
            ChampTrie.BulkChangeEvent bulkChange = new ChampTrie.BulkChangeEvent();
            ChampTrie.Node newRootNode = this.root.filterAll(this.makeOwner(), vp, 0, bulkChange);
            if (bulkChange.removed == 0) {
                return false;
            }
            this.root = newRootNode;
            this.vector = vp.newVector;
            this.offset = vp.newOffset;
            this.size -= bulkChange.removed;
            ++this.modCount;
            return true;
        }

        static class VectorSideEffectPredicate<E>
        implements Predicate<ChampSequenced.ChampSequencedElement<E>> {
            Vector<Object> newVector;
            int newOffset;
            Predicate<? super E> predicate;

            public VectorSideEffectPredicate(Predicate<? super E> predicate, Vector<Object> vector, int offset) {
                this.predicate = predicate;
                this.newVector = vector;
                this.newOffset = offset;
            }

            @Override
            public boolean test(ChampSequenced.ChampSequencedElement<E> e) {
                if (!this.predicate.test(e.getElement())) {
                    Tuple2<Vector<Object>, Integer> result = ChampSequenced.ChampSequencedData.vecRemove(this.newVector, e, this.newOffset);
                    this.newVector = (Vector)result._1;
                    this.newOffset = (Integer)result._2;
                    return false;
                }
                return true;
            }
        }
    }

    private static final class SerializationProxy<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient LinkedHashSet<T> set;

        SerializationProxy(LinkedHashSet<T> set) {
            this.set = set;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeInt(this.set.size());
            for (Object e : this.set) {
                s.writeObject(e);
            }
        }

        private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
            s.defaultReadObject();
            int size = s.readInt();
            if (size < 0) {
                throw new InvalidObjectException("No elements");
            }
            Set temp = LinkedHashSet.empty();
            for (int i = 0; i < size; ++i) {
                Object element = s.readObject();
                temp = temp.add(element);
            }
            this.set = temp;
        }

        private Object readResolve() {
            return LinkedHashSet.empty().addAll(this.set);
        }
    }
}

