/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.PartialFunction;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Value;
import io.vavr.collection.Collections;
import io.vavr.collection.Iterator;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.collection.Stream;
import io.vavr.collection.Traversable;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;

public abstract class Tree<T>
implements Traversable<T>,
Serializable {
    private static final long serialVersionUID = 1L;

    private Tree() {
    }

    public static <T> Collector<T, ArrayList<T>, Tree<T>> collector() {
        return Collections.toListAndThen(Tree::ofAll);
    }

    public static <T> Empty<T> empty() {
        return Empty.instance();
    }

    public static <T> Tree<T> narrow(Tree<? extends T> tree) {
        return tree;
    }

    public static <T> Node<T> of(T value) {
        return new Node<T>(value, List.empty());
    }

    @SafeVarargs
    public static <T> Node<T> of(T value, Node<T> ... children) {
        Objects.requireNonNull(children, "children is null");
        return new Node<T>(value, List.of(children));
    }

    public static <T> Node<T> of(T value, Iterable<Node<T>> children) {
        Objects.requireNonNull(children, "children is null");
        return new Node<T>(value, List.ofAll(children));
    }

    @SafeVarargs
    public static <T> Tree<T> of(T ... values) {
        Objects.requireNonNull(values, "values is null");
        List<T> list = List.of(values);
        return list.isEmpty() ? Empty.instance() : new Node(list.head(), ((List)list.tail()).map(Tree::of));
    }

    public static <T> Tree<T> ofAll(Iterable<? extends T> iterable) {
        Objects.requireNonNull(iterable, "iterable is null");
        if (iterable instanceof Tree) {
            return (Tree)iterable;
        }
        List<T> list = List.ofAll(iterable);
        return list.isEmpty() ? Empty.instance() : new Node(list.head(), ((List)list.tail()).map(Tree::of));
    }

    public static <T> Tree<T> ofAll(java.util.stream.Stream<? extends T> javaStream) {
        Objects.requireNonNull(javaStream, "javaStream is null");
        return Tree.ofAll(Iterator.ofAll(javaStream.iterator()));
    }

    public static <T> Tree<T> tabulate(int n, Function<? super Integer, ? extends T> f) {
        Objects.requireNonNull(f, "f is null");
        return Collections.tabulate(n, f, Tree.empty(), Tree::of);
    }

    public static <T> Tree<T> fill(int n, Supplier<? extends T> s) {
        Objects.requireNonNull(s, "s is null");
        return Collections.fill(n, s, Tree.empty(), Tree::of);
    }

    public static <T> Tree<T> fill(int n, T element) {
        return Collections.fillObject(n, element, Tree.empty(), Tree::of);
    }

    public static <T> Node<T> recurse(T seed, Function<? super T, ? extends Iterable<? extends T>> descend) {
        Objects.requireNonNull(descend, "descend is null");
        return Tree.of(seed, ((Stream)Stream.of(seed).flatMap(descend)).map((T children) -> Tree.recurse(children, descend)));
    }

    public static <T, ID> List<Node<T>> build(Iterable<? extends T> source, Function<? super T, ? extends ID> idMapper, Function<? super T, ? extends ID> parentMapper) {
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(source, "idMapper is null");
        Objects.requireNonNull(source, "parentMapper is null");
        List<? super T> list = List.ofAll(source);
        Map<ID, List<T>> byParent = list.groupBy(parentMapper);
        Function descend = idMapper.andThen(byParent::get).andThen(o -> o.getOrElse(List::empty));
        List roots = byParent.get(null).getOrElse(List::empty);
        return roots.map((T v) -> Tree.recurse(v, descend));
    }

    @Override
    public final <R> Tree<R> collect(PartialFunction<? super T, ? extends R> partialFunction) {
        return Tree.ofAll(this.iterator().collect(partialFunction));
    }

    public abstract T getValue();

    public abstract List<Node<T>> getChildren();

    public abstract boolean isLeaf();

    public final boolean isBranch() {
        return !this.isEmpty() && !this.isLeaf();
    }

    @Override
    public final boolean isAsync() {
        return false;
    }

    @Override
    public final boolean isDistinct() {
        return false;
    }

    @Override
    public final boolean isLazy() {
        return false;
    }

    @Override
    public final boolean isSequential() {
        return true;
    }

    public final Iterator<T> iterator(Order order) {
        return this.values(order).iterator();
    }

    public abstract String toLispString();

    public final <U> U transform(Function<? super Tree<T>, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return f.apply(this);
    }

    public final Seq<Node<T>> traverse() {
        return this.traverse(Order.PRE_ORDER);
    }

    public final Seq<Node<T>> traverse(Order order) {
        Objects.requireNonNull(order, "order is null");
        if (this.isEmpty()) {
            return Stream.empty();
        }
        Node node = (Node)this;
        switch (order) {
            case PRE_ORDER: {
                return Tree.traversePreOrder(node);
            }
            case IN_ORDER: {
                return Tree.traverseInOrder(node);
            }
            case POST_ORDER: {
                return Tree.traversePostOrder(node);
            }
            case LEVEL_ORDER: {
                return Tree.traverseLevelOrder(node);
            }
        }
        throw new IllegalStateException("Unknown order: " + order.name());
    }

    public final Seq<T> values() {
        return this.traverse(Order.PRE_ORDER).map(Node::getValue);
    }

    public final Seq<T> values(Order order) {
        return this.traverse(order).map(Node::getValue);
    }

    public final int branchCount() {
        if (this.isEmpty() || this.isLeaf()) {
            return 0;
        }
        return this.getChildren().foldLeft(1, (count, child) -> count + child.branchCount());
    }

    public final int leafCount() {
        if (this.isEmpty()) {
            return 0;
        }
        if (this.isLeaf()) {
            return 1;
        }
        return this.getChildren().foldLeft(0, (count, child) -> count + child.leafCount());
    }

    public final int nodeCount() {
        return this.length();
    }

    @Override
    public final Seq<T> distinct() {
        return this.values().distinct();
    }

    @Override
    public final Seq<T> distinctBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return this.values().distinctBy((Comparator)comparator);
    }

    @Override
    public final <U> Seq<T> distinctBy(Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor, "keyExtractor is null");
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return this.values().distinctBy(keyExtractor);
    }

    @Override
    public final Seq<T> drop(int n) {
        if (n >= this.length()) {
            return Stream.empty();
        }
        return this.values().drop(n);
    }

    @Override
    public final Seq<T> dropRight(int n) {
        if (n >= this.length()) {
            return Stream.empty();
        }
        return this.values().dropRight(n);
    }

    @Override
    public final Seq<T> dropUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.dropWhile((Predicate)predicate.negate());
    }

    @Override
    public final Seq<T> dropWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return this.values().dropWhile((Predicate)predicate);
    }

    @Override
    public final Seq<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return this.values().filter((Predicate)predicate);
    }

    @Override
    public final Seq<T> filterNot(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return this.values().filterNot((Predicate)predicate);
    }

    @Override
    public final <U> Tree<U> flatMap(Function<? super T, ? extends Iterable<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.isEmpty() ? Empty.instance() : Tree.flatMap((Node)this, mapper);
    }

    @Override
    public final <U> U foldRight(U zero, BiFunction<? super T, ? super U, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        if (this.isEmpty()) {
            return zero;
        }
        return this.iterator().foldRight(zero, f);
    }

    @Override
    public final <C> Map<C, Seq<T>> groupBy(Function<? super T, ? extends C> classifier) {
        return Collections.groupBy(this.values(), classifier, Stream::ofAll);
    }

    @Override
    public final Iterator<Seq<T>> grouped(int size) {
        return this.sliding(size, size);
    }

    @Override
    public final boolean hasDefiniteSize() {
        return true;
    }

    @Override
    public final T head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head of empty tree");
        }
        return (T)this.iterator().next();
    }

    @Override
    public final Seq<T> init() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("init of empty tree");
        }
        return this.values().init();
    }

    @Override
    public final Option<Seq<T>> initOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.init());
    }

    @Override
    public final boolean isTraversableAgain() {
        return true;
    }

    @Override
    public final Iterator<T> iterator() {
        return this.values().iterator();
    }

    @Override
    public final <U> Tree<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.isEmpty() ? Empty.instance() : Tree.map((Node)this, mapper);
    }

    @Override
    public final Tree<T> orElse(Iterable<? extends T> other) {
        return this.isEmpty() ? Tree.ofAll(other) : this;
    }

    @Override
    public final Tree<T> orElse(Supplier<? extends Iterable<? extends T>> supplier) {
        return this.isEmpty() ? Tree.ofAll(supplier.get()) : this;
    }

    @Override
    public final Tuple2<Seq<T>, Seq<T>> partition(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (this.isEmpty()) {
            return Tuple.of(Stream.empty(), Stream.empty());
        }
        return this.values().partition(predicate);
    }

    @Override
    public final Tree<T> peek(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        if (!this.isEmpty()) {
            action.accept(this.head());
        }
        return this;
    }

    @Override
    public final Tree<T> replace(T currentElement, T newElement) {
        if (this.isEmpty()) {
            return Empty.instance();
        }
        return Tree.replace((Node)this, currentElement, newElement);
    }

    @Override
    public final Tree<T> replaceAll(T currentElement, T newElement) {
        return this.map((T t) -> Objects.equals(t, currentElement) ? newElement : t);
    }

    @Override
    public final Seq<T> retainAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        return this.values().retainAll((Iterable)elements);
    }

    @Override
    public final Seq<T> scan(T zero, BiFunction<? super T, ? super T, ? extends T> operation) {
        return this.scanLeft(zero, operation);
    }

    @Override
    public final <U> Seq<U> scanLeft(U zero, BiFunction<? super U, ? super T, ? extends U> operation) {
        return Collections.scanLeft(this, zero, operation, Value::toStream);
    }

    @Override
    public final <U> Seq<U> scanRight(U zero, BiFunction<? super T, ? super U, ? extends U> operation) {
        return Collections.scanRight(this, zero, operation, Value::toStream);
    }

    @Override
    public final Iterator<Seq<T>> slideBy(Function<? super T, ?> classifier) {
        return this.iterator().slideBy(classifier);
    }

    @Override
    public final Iterator<Seq<T>> sliding(int size) {
        return this.sliding(size, 1);
    }

    @Override
    public final Iterator<Seq<T>> sliding(int size, int step) {
        return this.iterator().sliding(size, step);
    }

    @Override
    public final Tuple2<Seq<T>, Seq<T>> span(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (this.isEmpty()) {
            return Tuple.of(Stream.empty(), Stream.empty());
        }
        return this.values().span(predicate);
    }

    @Override
    public final String stringPrefix() {
        return "Tree";
    }

    @Override
    public final Seq<T> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty tree");
        }
        return this.values().tail();
    }

    @Override
    public final Option<Seq<T>> tailOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.tail());
    }

    @Override
    public final Seq<T> take(int n) {
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return this.values().take(n);
    }

    @Override
    public final Seq<T> takeRight(int n) {
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return this.values().takeRight(n);
    }

    @Override
    public final Seq<T> takeUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.values().takeUntil((Predicate)predicate);
    }

    @Override
    public final Seq<T> takeWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.values().takeWhile((Predicate)predicate);
    }

    @Override
    public final <U> Tree<Tuple2<T, U>> zip(Iterable<? extends U> that) {
        return this.zipWith((Iterable)that, Tuple::of);
    }

    @Override
    public final <U, R> Tree<R> zipWith(Iterable<? extends U> that, BiFunction<? super T, ? super U, ? extends R> mapper) {
        Objects.requireNonNull(that, "that is null");
        Objects.requireNonNull(mapper, "mapper is null");
        if (this.isEmpty()) {
            return Empty.instance();
        }
        return Tree.zip((Node)this, that.iterator(), mapper);
    }

    @Override
    public final <U> Tree<Tuple2<T, U>> zipAll(Iterable<? extends U> that, T thisElem, U thatElem) {
        Objects.requireNonNull(that, "that is null");
        if (this.isEmpty()) {
            return Iterator.ofAll(that).map((T elem) -> Tuple.of(thisElem, elem)).toTree();
        }
        java.util.Iterator<U> thatIter = that.iterator();
        Tree<Tuple2<T, U>> tree = Tree.zipAll((Node)this, thatIter, thatElem);
        if (thatIter.hasNext()) {
            Traversable remainder = Iterator.ofAll(thatIter).map((T elem) -> Tree.of(Tuple.of(thisElem, elem)));
            return new Node<Tuple2<T, U>>(tree.getValue(), tree.getChildren().appendAll((Iterable)remainder));
        }
        return tree;
    }

    @Override
    public final Tree<Tuple2<T, Integer>> zipWithIndex() {
        return this.zipWithIndex(Tuple::of);
    }

    @Override
    public final <U> Tree<U> zipWithIndex(BiFunction<? super T, ? super Integer, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.zipWith(Iterator.from(0), mapper);
    }

    public abstract String draw();

    private static <T, U> Tree<U> flatMap(Node<T> node, Function<? super T, ? extends Iterable<? extends U>> mapper) {
        Tree<U> mapped = Tree.ofAll(mapper.apply(node.getValue()));
        if (mapped.isEmpty()) {
            return Tree.empty();
        }
        List children = (List)((List)node.getChildren().map((T child) -> Tree.flatMap(child, mapper))).filter(Traversable::nonEmpty);
        return Tree.of(mapped.get(), children.prependAll(mapped.getChildren()));
    }

    private static <T, U> Node<U> map(Node<T> node, Function<? super T, ? extends U> mapper) {
        U value = mapper.apply(node.getValue());
        LinearSeq children = node.getChildren().map((T child) -> Tree.map(child, mapper));
        return new Node<U>(value, children);
    }

    private static <T> Node<T> replace(Node<T> node, T currentElement, T newElement) {
        if (Objects.equals(node.getValue(), currentElement)) {
            return new Node<T>(newElement, node.getChildren());
        }
        for (Node node2 : node.getChildren()) {
            Node<T> newChild = Tree.replace(node2, currentElement, newElement);
            boolean found = newChild != node2;
            if (!found) continue;
            LinearSeq newChildren = node.getChildren().replace((Object)node2, newChild);
            return new Node<T>(node.getValue(), newChildren);
        }
        return node;
    }

    private static <T> Stream<Node<T>> traversePreOrder(Node<T> node) {
        return node.getChildren().foldLeft(Stream.of(node), (acc, child) -> acc.appendAll((Iterable)Tree.traversePreOrder(child)));
    }

    private static <T> Stream<Node<T>> traverseInOrder(Node<T> node) {
        if (node.isLeaf()) {
            return Stream.of(node);
        }
        List<Node<T>> children = node.getChildren();
        return ((Stream)children.tail().foldLeft(Stream.empty(), (acc, child) -> acc.appendAll((Iterable)Tree.traverseInOrder(child))).prepend(node)).prependAll(Tree.traverseInOrder((Node)children.head()));
    }

    private static <T> Stream<Node<T>> traversePostOrder(Node<T> node) {
        return node.getChildren().foldLeft(Stream.empty(), (acc, child) -> acc.appendAll((Iterable)Tree.traversePostOrder(child))).append(node);
    }

    private static <T> Stream<Node<T>> traverseLevelOrder(Node<T> node) {
        LinearSeq result = Stream.empty();
        LinkedList<Node<T>> queue = new LinkedList<Node<T>>();
        queue.add(node);
        while (!queue.isEmpty()) {
            Node next = (Node)queue.remove();
            result = result.prepend(next);
            queue.addAll(next.getChildren().toJavaList());
        }
        return result.reverse();
    }

    private static <T, U, R> Tree<R> zip(Node<T> node, java.util.Iterator<? extends U> that, BiFunction<? super T, ? super U, ? extends R> mapper) {
        if (!that.hasNext()) {
            return Empty.instance();
        }
        R value = mapper.apply(node.getValue(), that.next());
        List children = (List)((List)node.getChildren().map((T child) -> Tree.zip(child, that, mapper))).filter(Traversable::nonEmpty);
        return new Node<R>(value, children);
    }

    private static <T, U> Tree<Tuple2<T, U>> zipAll(Node<T> node, java.util.Iterator<? extends U> that, U thatElem) {
        if (!that.hasNext()) {
            return node.map((T value) -> Tuple.of(value, thatElem));
        }
        Tuple2<T, U> value2 = Tuple.of(node.getValue(), that.next());
        List children = (List)((List)node.getChildren().map((T child) -> Tree.zipAll(child, that, thatElem))).filter(Traversable::nonEmpty);
        return new Node<Tuple2<T, U>>(value2, children);
    }

    public static enum Order {
        PRE_ORDER,
        IN_ORDER,
        POST_ORDER,
        LEVEL_ORDER;

    }

    @Deprecated
    public static final class Empty<T>
    extends Tree<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final Empty<?> INSTANCE = new Empty();

        private Empty() {
        }

        public static <T> Empty<T> instance() {
            return INSTANCE;
        }

        @Override
        public List<Node<T>> getChildren() {
            return List.empty();
        }

        @Override
        public T getValue() {
            throw new UnsupportedOperationException("getValue of empty Tree");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public T last() {
            throw new NoSuchElementException("last of empty tree");
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public String toString() {
            return this.stringPrefix() + "()";
        }

        @Override
        public String toLispString() {
            return "()";
        }

        @Override
        public String draw() {
            return "\u25a3";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    @Deprecated
    public static final class Node<T>
    extends Tree<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final T value;
        private final List<Node<T>> children;
        private final int size;

        public Node(T value, List<Node<T>> children) {
            Objects.requireNonNull(children, "children is null");
            this.value = value;
            this.children = children;
            this.size = children.foldLeft(1, (acc, child) -> acc + child.size);
        }

        @Override
        public List<Node<T>> getChildren() {
            return this.children;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int length() {
            return this.size;
        }

        @Override
        public boolean isLeaf() {
            return this.size == 1;
        }

        @Override
        public T last() {
            return this.children.isEmpty() ? this.value : this.children.last().last();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Node) {
                Node that = (Node)o;
                return Objects.equals(this.getValue(), that.getValue()) && Objects.equals(this.getChildren(), that.getChildren());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Tuple.hash(this.value, this.children);
        }

        @Override
        public String toString() {
            return this.mkString(this.stringPrefix() + "(", ", ", ")");
        }

        @Override
        public String toLispString() {
            return Node.toLispString(this);
        }

        @Override
        public String draw() {
            StringBuilder builder = new StringBuilder();
            this.drawAux("", builder);
            return builder.toString();
        }

        private void drawAux(String indent, StringBuilder builder) {
            builder.append(this.value);
            LinearSeq<Node<T>> it = this.children;
            while (!it.isEmpty()) {
                boolean isLast = ((List)it.tail()).isEmpty();
                builder.append('\n').append(indent).append(isLast ? "\u2514\u2500\u2500" : "\u251c\u2500\u2500");
                ((Node)it.head()).drawAux(indent + (isLast ? "   " : "\u2502  "), builder);
                it = it.tail();
            }
        }

        private static String toLispString(Tree<?> tree) {
            String value = String.valueOf(tree.getValue());
            if (tree.isLeaf()) {
                return value;
            }
            String children = tree.getChildren().map((T child) -> Node.toLispString(child)).mkString(" ");
            return "(" + value + " " + children + ")";
        }

        private Object writeReplace() {
            return new SerializationProxy(this);
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Proxy required");
        }

        private static final class SerializationProxy<T>
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private transient Node<T> node;

            SerializationProxy(Node<T> node) {
                this.node = node;
            }

            private void writeObject(ObjectOutputStream s) throws IOException {
                s.defaultWriteObject();
                s.writeObject(((Node)this.node).value);
                s.writeObject(((Node)this.node).children);
            }

            private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
                s.defaultReadObject();
                Object value = s.readObject();
                List children = (List)s.readObject();
                this.node = new Node<Object>(value, children);
            }

            private Object readResolve() {
                return this.node;
            }
        }
    }
}

