/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.control;

interface TryModule {
    public static boolean isFatal(Throwable throwable) {
        return throwable instanceof InterruptedException || throwable instanceof LinkageError || ThreadDeathChecker.isThreadDeath(throwable) || throwable instanceof VirtualMachineError;
    }

    public static <T extends Throwable, R> R sneakyThrow(Throwable t) throws T {
        throw t;
    }

    public static class ThreadDeathChecker {
        static final Class<?> THREAD_DEATH_CLASS = ThreadDeathChecker.resolve();

        static boolean isThreadDeath(Throwable throwable) {
            return THREAD_DEATH_CLASS != null && THREAD_DEATH_CLASS.isInstance(throwable);
        }

        private static Class<?> resolve() {
            try {
                return Class.forName("java.lang.ThreadDeath");
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    }
}

