package ch.rasc.darksky.model;

import ch.rasc.darksky.converter.DsUnitDeserializer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link DsFlag}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDsFlag.builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "DsFlag"})
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableDsFlag implements DsFlag {
  private final @Nullable Object darkskyUnavailable;
  private final @Nullable String metnoLicense;
  private final List<String> sources;
  private final @Nullable DsUnit units;

  private ImmutableDsFlag(
      @Nullable Object darkskyUnavailable,
      @Nullable String metnoLicense,
      List<String> sources,
      @Nullable DsUnit units) {
    this.darkskyUnavailable = darkskyUnavailable;
    this.metnoLicense = metnoLicense;
    this.sources = sources;
    this.units = units;
  }

  /**
   * The presence of this property indicates that the Dark Sky data source supports the
   * given location, but a temporary error (such as a radar station being down for
   * maintenance) has made the data unavailable.
   */
  @JsonProperty("darksky-unavailable")
  @Override
  public @Nullable Object darkskyUnavailable() {
    return darkskyUnavailable;
  }

  /**
   * The presence of this property indicates that data from
   * <a href="http://api.met.no/">api.met.no</a> was utilized in order to facilitate
   * this request (as per their license agreement).
   */
  @JsonProperty("metno-license")
  @Override
  public @Nullable String metnoLicense() {
    return metnoLicense;
  }

  /**
   * This property contains list of IDs for each
   * <a href="https://darksky.net/dev/docs/sources">data source</a> utilized in
   * servicing this request.
   */
  @JsonProperty("sources")
  @Override
  public List<String> sources() {
    return sources;
  }

  /**
   * Indicates the units which were used for the data in this request.
   */
  @JsonProperty("units")
  @JsonDeserialize(using = DsUnitDeserializer.class)
  @Override
  public @Nullable DsUnit units() {
    return units;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsFlag#darkskyUnavailable() darkskyUnavailable} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for darkskyUnavailable (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsFlag withDarkskyUnavailable(@Nullable Object value) {
    if (this.darkskyUnavailable == value) return this;
    return new ImmutableDsFlag(value, this.metnoLicense, this.sources, this.units);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsFlag#metnoLicense() metnoLicense} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for metnoLicense (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsFlag withMetnoLicense(@Nullable String value) {
    if (Objects.equals(this.metnoLicense, value)) return this;
    return new ImmutableDsFlag(this.darkskyUnavailable, value, this.sources, this.units);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DsFlag#sources() sources}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDsFlag withSources(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableDsFlag(this.darkskyUnavailable, this.metnoLicense, newValue, this.units);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DsFlag#sources() sources}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of sources elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDsFlag withSources(Iterable<String> elements) {
    if (this.sources == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableDsFlag(this.darkskyUnavailable, this.metnoLicense, newValue, this.units);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsFlag#units() units} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for units (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsFlag withUnits(@Nullable DsUnit value) {
    if (this.units == value) return this;
    return new ImmutableDsFlag(this.darkskyUnavailable, this.metnoLicense, this.sources, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDsFlag} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDsFlag
        && equalTo((ImmutableDsFlag) another);
  }

  private boolean equalTo(ImmutableDsFlag another) {
    return Objects.equals(darkskyUnavailable, another.darkskyUnavailable)
        && Objects.equals(metnoLicense, another.metnoLicense)
        && sources.equals(another.sources)
        && Objects.equals(units, another.units);
  }

  /**
   * Computes a hash code from attributes: {@code darkskyUnavailable}, {@code metnoLicense}, {@code sources}, {@code units}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(darkskyUnavailable);
    h = h * 17 + Objects.hashCode(metnoLicense);
    h = h * 17 + sources.hashCode();
    h = h * 17 + Objects.hashCode(units);
    return h;
  }

  /**
   * Prints the immutable value {@code DsFlag} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DsFlag{"
        + "darkskyUnavailable=" + darkskyUnavailable
        + ", metnoLicense=" + metnoLicense
        + ", sources=" + sources
        + ", units=" + units
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DsFlag {
    Object darkskyUnavailable;
    String metnoLicense;
    List<String> sources = Collections.emptyList();
    DsUnit units;
    @JsonProperty("darksky-unavailable")
    public void setDarkskyUnavailable(@Nullable Object darkskyUnavailable) {
      this.darkskyUnavailable = darkskyUnavailable;
    }
    @JsonProperty("metno-license")
    public void setMetnoLicense(@Nullable String metnoLicense) {
      this.metnoLicense = metnoLicense;
    }
    @JsonProperty("sources")
    public void setSources(List<String> sources) {
      this.sources = sources;
    }
    @JsonProperty("units")
    @JsonDeserialize(using = DsUnitDeserializer.class)
    public void setUnits(@Nullable DsUnit units) {
      this.units = units;
    }
    @Override
    public Object darkskyUnavailable() { throw new UnsupportedOperationException(); }
    @Override
    public String metnoLicense() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> sources() { throw new UnsupportedOperationException(); }
    @Override
    public DsUnit units() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDsFlag fromJson(Json json) {
    ImmutableDsFlag.Builder builder = ImmutableDsFlag.builder();
    if (json.darkskyUnavailable != null) {
      builder.darkskyUnavailable(json.darkskyUnavailable);
    }
    if (json.metnoLicense != null) {
      builder.metnoLicense(json.metnoLicense);
    }
    if (json.sources != null) {
      builder.addAllSources(json.sources);
    }
    if (json.units != null) {
      builder.units(json.units);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DsFlag} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DsFlag instance
   */
  public static ImmutableDsFlag copyOf(DsFlag instance) {
    if (instance instanceof ImmutableDsFlag) {
      return (ImmutableDsFlag) instance;
    }
    return ImmutableDsFlag.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDsFlag ImmutableDsFlag}.
   * @return A new ImmutableDsFlag builder
   */
  public static ImmutableDsFlag.Builder builder() {
    return new ImmutableDsFlag.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDsFlag ImmutableDsFlag}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Object darkskyUnavailable;
    private String metnoLicense;
    private List<String> sources = new ArrayList<String>();
    private DsUnit units;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DsFlag} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DsFlag instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Object darkskyUnavailableValue = instance.darkskyUnavailable();
      if (darkskyUnavailableValue != null) {
        darkskyUnavailable(darkskyUnavailableValue);
      }
      @Nullable String metnoLicenseValue = instance.metnoLicense();
      if (metnoLicenseValue != null) {
        metnoLicense(metnoLicenseValue);
      }
      addAllSources(instance.sources());
      @Nullable DsUnit unitsValue = instance.units();
      if (unitsValue != null) {
        units(unitsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DsFlag#darkskyUnavailable() darkskyUnavailable} attribute.
     * @param darkskyUnavailable The value for darkskyUnavailable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("darksky-unavailable")
    public final Builder darkskyUnavailable(@Nullable Object darkskyUnavailable) {
      this.darkskyUnavailable = darkskyUnavailable;
      return this;
    }

    /**
     * Initializes the value for the {@link DsFlag#metnoLicense() metnoLicense} attribute.
     * @param metnoLicense The value for metnoLicense (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metno-license")
    public final Builder metnoLicense(@Nullable String metnoLicense) {
      this.metnoLicense = metnoLicense;
      return this;
    }

    /**
     * Adds one element to {@link DsFlag#sources() sources} list.
     * @param element A sources element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSources(String element) {
      this.sources.add(Objects.requireNonNull(element, "sources element"));
      return this;
    }

    /**
     * Adds elements to {@link DsFlag#sources() sources} list.
     * @param elements An array of sources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSources(String... elements) {
      for (String element : elements) {
        this.sources.add(Objects.requireNonNull(element, "sources element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link DsFlag#sources() sources} list.
     * @param elements An iterable of sources elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("sources")
    public final Builder sources(Iterable<String> elements) {
      this.sources.clear();
      return addAllSources(elements);
    }

    /**
     * Adds elements to {@link DsFlag#sources() sources} list.
     * @param elements An iterable of sources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSources(Iterable<String> elements) {
      for (String element : elements) {
        this.sources.add(Objects.requireNonNull(element, "sources element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DsFlag#units() units} attribute.
     * @param units The value for units (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("units")
    public final Builder units(@Nullable DsUnit units) {
      this.units = units;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDsFlag ImmutableDsFlag}.
     * @return An immutable instance of DsFlag
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDsFlag build() {
      return new ImmutableDsFlag(darkskyUnavailable, metnoLicense, createUnmodifiableList(true, sources), units);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
