/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.darksky.model;

import ch.rasc.darksky.converter.DsIconDeserializer;
import ch.rasc.darksky.model.DsDataBlock;
import ch.rasc.darksky.model.DsDataPoint;
import ch.rasc.darksky.model.DsIcon;
import ch.rasc.darksky.model.Nullable;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableDsDataBlock
implements DsDataBlock {
    @Nullable
    private final String summary;
    @Nullable
    private final DsIcon icon;
    private final List<DsDataPoint> data;

    private ImmutableDsDataBlock(@Nullable String summary, @Nullable DsIcon icon, List<DsDataPoint> data) {
        this.summary = summary;
        this.icon = icon;
        this.data = data;
    }

    @Override
    @JsonProperty(value="summary")
    @Nullable
    public String summary() {
        return this.summary;
    }

    @Override
    @JsonProperty(value="icon")
    @JsonDeserialize(using=DsIconDeserializer.class)
    @Nullable
    public DsIcon icon() {
        return this.icon;
    }

    @Override
    @JsonProperty(value="data")
    public List<DsDataPoint> data() {
        return this.data;
    }

    public final ImmutableDsDataBlock withSummary(@Nullable String value) {
        if (Objects.equals(this.summary, value)) {
            return this;
        }
        return new ImmutableDsDataBlock(value, this.icon, this.data);
    }

    public final ImmutableDsDataBlock withIcon(@Nullable DsIcon value) {
        if (this.icon == value) {
            return this;
        }
        return new ImmutableDsDataBlock(this.summary, value, this.data);
    }

    public final ImmutableDsDataBlock withData(DsDataPoint ... elements) {
        List<DsDataPoint> newValue = ImmutableDsDataBlock.createUnmodifiableList(false, ImmutableDsDataBlock.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDsDataBlock(this.summary, this.icon, newValue);
    }

    public final ImmutableDsDataBlock withData(Iterable<? extends DsDataPoint> elements) {
        if (this.data == elements) {
            return this;
        }
        List<DsDataPoint> newValue = ImmutableDsDataBlock.createUnmodifiableList(false, ImmutableDsDataBlock.createSafeList(elements, true, false));
        return new ImmutableDsDataBlock(this.summary, this.icon, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDsDataBlock && this.equalTo((ImmutableDsDataBlock)another);
    }

    private boolean equalTo(ImmutableDsDataBlock another) {
        return Objects.equals(this.summary, another.summary) && Objects.equals((Object)this.icon, (Object)another.icon) && this.data.equals(another.data);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.summary);
        h = h * 17 + Objects.hashCode((Object)this.icon);
        h = h * 17 + this.data.hashCode();
        return h;
    }

    public String toString() {
        return "DsDataBlock{summary=" + this.summary + ", icon=" + (Object)((Object)this.icon) + ", data=" + this.data + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDsDataBlock fromJson(Json json) {
        Builder builder = ImmutableDsDataBlock.builder();
        if (json.summary != null) {
            builder.summary(json.summary);
        }
        if (json.icon != null) {
            builder.icon(json.icon);
        }
        if (json.data != null) {
            builder.addAllData(json.data);
        }
        return builder.build();
    }

    public static ImmutableDsDataBlock copyOf(DsDataBlock instance) {
        if (instance instanceof ImmutableDsDataBlock) {
            return (ImmutableDsDataBlock)instance;
        }
        return ImmutableDsDataBlock.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private String summary;
        private DsIcon icon;
        private List<DsDataPoint> data = new ArrayList<DsDataPoint>();

        private Builder() {
        }

        public final Builder from(DsDataBlock instance) {
            DsIcon iconValue;
            Objects.requireNonNull(instance, "instance");
            String summaryValue = instance.summary();
            if (summaryValue != null) {
                this.summary(summaryValue);
            }
            if ((iconValue = instance.icon()) != null) {
                this.icon(iconValue);
            }
            this.addAllData(instance.data());
            return this;
        }

        @JsonProperty(value="summary")
        public final Builder summary(@Nullable String summary) {
            this.summary = summary;
            return this;
        }

        @JsonProperty(value="icon")
        public final Builder icon(@Nullable DsIcon icon) {
            this.icon = icon;
            return this;
        }

        public final Builder addData(DsDataPoint element) {
            this.data.add(Objects.requireNonNull(element, "data element"));
            return this;
        }

        public final Builder addData(DsDataPoint ... elements) {
            for (DsDataPoint element : elements) {
                this.data.add(Objects.requireNonNull(element, "data element"));
            }
            return this;
        }

        @JsonProperty(value="data")
        public final Builder data(Iterable<? extends DsDataPoint> elements) {
            this.data.clear();
            return this.addAllData(elements);
        }

        public final Builder addAllData(Iterable<? extends DsDataPoint> elements) {
            for (DsDataPoint dsDataPoint : elements) {
                this.data.add(Objects.requireNonNull(dsDataPoint, "data element"));
            }
            return this;
        }

        public ImmutableDsDataBlock build() {
            return new ImmutableDsDataBlock(this.summary, this.icon, ImmutableDsDataBlock.createUnmodifiableList(true, this.data));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements DsDataBlock {
        String summary;
        DsIcon icon;
        List<DsDataPoint> data = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="summary")
        public void setSummary(@Nullable String summary) {
            this.summary = summary;
        }

        @JsonProperty(value="icon")
        @JsonDeserialize(using=DsIconDeserializer.class)
        public void setIcon(@Nullable DsIcon icon) {
            this.icon = icon;
        }

        @JsonProperty(value="data")
        public void setData(List<DsDataPoint> data) {
            this.data = data;
        }

        @Override
        public String summary() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DsIcon icon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<DsDataPoint> data() {
            throw new UnsupportedOperationException();
        }
    }
}

