/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.darksky.model;

import ch.rasc.darksky.model.DsAlert;
import ch.rasc.darksky.model.DsDataBlock;
import ch.rasc.darksky.model.DsDataPoint;
import ch.rasc.darksky.model.DsFlag;
import ch.rasc.darksky.model.DsResponse;
import ch.rasc.darksky.model.Nullable;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableDsResponse
implements DsResponse {
    private final BigDecimal latitude;
    private final BigDecimal longitude;
    private final String timezone;
    private final int offset;
    @Nullable
    private final DsDataPoint currently;
    @Nullable
    private final DsDataBlock minutely;
    @Nullable
    private final DsDataBlock hourly;
    @Nullable
    private final DsDataBlock daily;
    private final List<DsAlert> alerts;
    @Nullable
    private final DsFlag flags;

    private ImmutableDsResponse(BigDecimal latitude, BigDecimal longitude, String timezone, int offset, @Nullable DsDataPoint currently, @Nullable DsDataBlock minutely, @Nullable DsDataBlock hourly, @Nullable DsDataBlock daily, List<DsAlert> alerts, @Nullable DsFlag flags) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.timezone = timezone;
        this.offset = offset;
        this.currently = currently;
        this.minutely = minutely;
        this.hourly = hourly;
        this.daily = daily;
        this.alerts = alerts;
        this.flags = flags;
    }

    @Override
    @JsonProperty(value="latitude")
    public BigDecimal latitude() {
        return this.latitude;
    }

    @Override
    @JsonProperty(value="longitude")
    public BigDecimal longitude() {
        return this.longitude;
    }

    @Override
    @JsonProperty(value="timezone")
    public String timezone() {
        return this.timezone;
    }

    @Override
    @JsonProperty(value="offset")
    public int offset() {
        return this.offset;
    }

    @Override
    @JsonProperty(value="currently")
    @Nullable
    public DsDataPoint currently() {
        return this.currently;
    }

    @Override
    @JsonProperty(value="minutely")
    @Nullable
    public DsDataBlock minutely() {
        return this.minutely;
    }

    @Override
    @JsonProperty(value="hourly")
    @Nullable
    public DsDataBlock hourly() {
        return this.hourly;
    }

    @Override
    @JsonProperty(value="daily")
    @Nullable
    public DsDataBlock daily() {
        return this.daily;
    }

    @Override
    @JsonProperty(value="alerts")
    public List<DsAlert> alerts() {
        return this.alerts;
    }

    @Override
    @JsonProperty(value="flags")
    @Nullable
    public DsFlag flags() {
        return this.flags;
    }

    public final ImmutableDsResponse withLatitude(BigDecimal value) {
        if (this.latitude == value) {
            return this;
        }
        BigDecimal newValue = Objects.requireNonNull(value, "latitude");
        return new ImmutableDsResponse(newValue, this.longitude, this.timezone, this.offset, this.currently, this.minutely, this.hourly, this.daily, this.alerts, this.flags);
    }

    public final ImmutableDsResponse withLongitude(BigDecimal value) {
        if (this.longitude == value) {
            return this;
        }
        BigDecimal newValue = Objects.requireNonNull(value, "longitude");
        return new ImmutableDsResponse(this.latitude, newValue, this.timezone, this.offset, this.currently, this.minutely, this.hourly, this.daily, this.alerts, this.flags);
    }

    public final ImmutableDsResponse withTimezone(String value) {
        if (this.timezone.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "timezone");
        return new ImmutableDsResponse(this.latitude, this.longitude, newValue, this.offset, this.currently, this.minutely, this.hourly, this.daily, this.alerts, this.flags);
    }

    public final ImmutableDsResponse withOffset(int value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableDsResponse(this.latitude, this.longitude, this.timezone, value, this.currently, this.minutely, this.hourly, this.daily, this.alerts, this.flags);
    }

    public final ImmutableDsResponse withCurrently(@Nullable DsDataPoint value) {
        if (this.currently == value) {
            return this;
        }
        return new ImmutableDsResponse(this.latitude, this.longitude, this.timezone, this.offset, value, this.minutely, this.hourly, this.daily, this.alerts, this.flags);
    }

    public final ImmutableDsResponse withMinutely(@Nullable DsDataBlock value) {
        if (this.minutely == value) {
            return this;
        }
        return new ImmutableDsResponse(this.latitude, this.longitude, this.timezone, this.offset, this.currently, value, this.hourly, this.daily, this.alerts, this.flags);
    }

    public final ImmutableDsResponse withHourly(@Nullable DsDataBlock value) {
        if (this.hourly == value) {
            return this;
        }
        return new ImmutableDsResponse(this.latitude, this.longitude, this.timezone, this.offset, this.currently, this.minutely, value, this.daily, this.alerts, this.flags);
    }

    public final ImmutableDsResponse withDaily(@Nullable DsDataBlock value) {
        if (this.daily == value) {
            return this;
        }
        return new ImmutableDsResponse(this.latitude, this.longitude, this.timezone, this.offset, this.currently, this.minutely, this.hourly, value, this.alerts, this.flags);
    }

    public final ImmutableDsResponse withAlerts(DsAlert ... elements) {
        List<DsAlert> newValue = ImmutableDsResponse.createUnmodifiableList(false, ImmutableDsResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDsResponse(this.latitude, this.longitude, this.timezone, this.offset, this.currently, this.minutely, this.hourly, this.daily, newValue, this.flags);
    }

    public final ImmutableDsResponse withAlerts(Iterable<? extends DsAlert> elements) {
        if (this.alerts == elements) {
            return this;
        }
        List<DsAlert> newValue = ImmutableDsResponse.createUnmodifiableList(false, ImmutableDsResponse.createSafeList(elements, true, false));
        return new ImmutableDsResponse(this.latitude, this.longitude, this.timezone, this.offset, this.currently, this.minutely, this.hourly, this.daily, newValue, this.flags);
    }

    public final ImmutableDsResponse withFlags(@Nullable DsFlag value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableDsResponse(this.latitude, this.longitude, this.timezone, this.offset, this.currently, this.minutely, this.hourly, this.daily, this.alerts, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDsResponse && this.equalTo((ImmutableDsResponse)another);
    }

    private boolean equalTo(ImmutableDsResponse another) {
        return this.latitude.equals(another.latitude) && this.longitude.equals(another.longitude) && this.timezone.equals(another.timezone) && this.offset == another.offset && Objects.equals(this.currently, another.currently) && Objects.equals(this.minutely, another.minutely) && Objects.equals(this.hourly, another.hourly) && Objects.equals(this.daily, another.daily) && this.alerts.equals(another.alerts) && Objects.equals(this.flags, another.flags);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.latitude.hashCode();
        h = h * 17 + this.longitude.hashCode();
        h = h * 17 + this.timezone.hashCode();
        h = h * 17 + this.offset;
        h = h * 17 + Objects.hashCode(this.currently);
        h = h * 17 + Objects.hashCode(this.minutely);
        h = h * 17 + Objects.hashCode(this.hourly);
        h = h * 17 + Objects.hashCode(this.daily);
        h = h * 17 + this.alerts.hashCode();
        h = h * 17 + Objects.hashCode(this.flags);
        return h;
    }

    public String toString() {
        return "DsResponse{latitude=" + this.latitude + ", longitude=" + this.longitude + ", timezone=" + this.timezone + ", offset=" + this.offset + ", currently=" + this.currently + ", minutely=" + this.minutely + ", hourly=" + this.hourly + ", daily=" + this.daily + ", alerts=" + this.alerts + ", flags=" + this.flags + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDsResponse fromJson(Json json) {
        Builder builder = ImmutableDsResponse.builder();
        if (json.latitude != null) {
            builder.latitude(json.latitude);
        }
        if (json.longitude != null) {
            builder.longitude(json.longitude);
        }
        if (json.timezone != null) {
            builder.timezone(json.timezone);
        }
        if (json.offsetIsSet) {
            builder.offset(json.offset);
        }
        if (json.currently != null) {
            builder.currently(json.currently);
        }
        if (json.minutely != null) {
            builder.minutely(json.minutely);
        }
        if (json.hourly != null) {
            builder.hourly(json.hourly);
        }
        if (json.daily != null) {
            builder.daily(json.daily);
        }
        if (json.alerts != null) {
            builder.addAllAlerts(json.alerts);
        }
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        return builder.build();
    }

    public static ImmutableDsResponse copyOf(DsResponse instance) {
        if (instance instanceof ImmutableDsResponse) {
            return (ImmutableDsResponse)instance;
        }
        return ImmutableDsResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_LATITUDE = 1L;
        private static final long INIT_BIT_LONGITUDE = 2L;
        private static final long INIT_BIT_TIMEZONE = 4L;
        private static final long INIT_BIT_OFFSET = 8L;
        private long initBits = 15L;
        private BigDecimal latitude;
        private BigDecimal longitude;
        private String timezone;
        private int offset;
        private DsDataPoint currently;
        private DsDataBlock minutely;
        private DsDataBlock hourly;
        private DsDataBlock daily;
        private List<DsAlert> alerts = new ArrayList<DsAlert>();
        private DsFlag flags;

        private Builder() {
        }

        public final Builder from(DsResponse instance) {
            DsDataBlock dailyValue;
            DsDataBlock hourlyValue;
            DsDataBlock minutelyValue;
            Objects.requireNonNull(instance, "instance");
            this.latitude(instance.latitude());
            this.longitude(instance.longitude());
            this.timezone(instance.timezone());
            this.offset(instance.offset());
            DsDataPoint currentlyValue = instance.currently();
            if (currentlyValue != null) {
                this.currently(currentlyValue);
            }
            if ((minutelyValue = instance.minutely()) != null) {
                this.minutely(minutelyValue);
            }
            if ((hourlyValue = instance.hourly()) != null) {
                this.hourly(hourlyValue);
            }
            if ((dailyValue = instance.daily()) != null) {
                this.daily(dailyValue);
            }
            this.addAllAlerts(instance.alerts());
            DsFlag flagsValue = instance.flags();
            if (flagsValue != null) {
                this.flags(flagsValue);
            }
            return this;
        }

        @JsonProperty(value="latitude")
        public final Builder latitude(BigDecimal latitude) {
            this.latitude = Objects.requireNonNull(latitude, "latitude");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="longitude")
        public final Builder longitude(BigDecimal longitude) {
            this.longitude = Objects.requireNonNull(longitude, "longitude");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="timezone")
        public final Builder timezone(String timezone) {
            this.timezone = Objects.requireNonNull(timezone, "timezone");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="offset")
        public final Builder offset(int offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="currently")
        public final Builder currently(@Nullable DsDataPoint currently) {
            this.currently = currently;
            return this;
        }

        @JsonProperty(value="minutely")
        public final Builder minutely(@Nullable DsDataBlock minutely) {
            this.minutely = minutely;
            return this;
        }

        @JsonProperty(value="hourly")
        public final Builder hourly(@Nullable DsDataBlock hourly) {
            this.hourly = hourly;
            return this;
        }

        @JsonProperty(value="daily")
        public final Builder daily(@Nullable DsDataBlock daily) {
            this.daily = daily;
            return this;
        }

        public final Builder addAlerts(DsAlert element) {
            this.alerts.add(Objects.requireNonNull(element, "alerts element"));
            return this;
        }

        public final Builder addAlerts(DsAlert ... elements) {
            for (DsAlert element : elements) {
                this.alerts.add(Objects.requireNonNull(element, "alerts element"));
            }
            return this;
        }

        @JsonProperty(value="alerts")
        public final Builder alerts(Iterable<? extends DsAlert> elements) {
            this.alerts.clear();
            return this.addAllAlerts(elements);
        }

        public final Builder addAllAlerts(Iterable<? extends DsAlert> elements) {
            for (DsAlert dsAlert : elements) {
                this.alerts.add(Objects.requireNonNull(dsAlert, "alerts element"));
            }
            return this;
        }

        @JsonProperty(value="flags")
        public final Builder flags(@Nullable DsFlag flags) {
            this.flags = flags;
            return this;
        }

        public ImmutableDsResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDsResponse(this.latitude, this.longitude, this.timezone, this.offset, this.currently, this.minutely, this.hourly, this.daily, ImmutableDsResponse.createUnmodifiableList(true, this.alerts), this.flags);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("latitude");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("longitude");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("timezone");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("offset");
            }
            return "Cannot build DsResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements DsResponse {
        BigDecimal latitude;
        BigDecimal longitude;
        String timezone;
        int offset;
        boolean offsetIsSet;
        DsDataPoint currently;
        DsDataBlock minutely;
        DsDataBlock hourly;
        DsDataBlock daily;
        List<DsAlert> alerts = Collections.emptyList();
        DsFlag flags;

        Json() {
        }

        @JsonProperty(value="latitude")
        public void setLatitude(BigDecimal latitude) {
            this.latitude = latitude;
        }

        @JsonProperty(value="longitude")
        public void setLongitude(BigDecimal longitude) {
            this.longitude = longitude;
        }

        @JsonProperty(value="timezone")
        public void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @JsonProperty(value="offset")
        public void setOffset(int offset) {
            this.offset = offset;
            this.offsetIsSet = true;
        }

        @JsonProperty(value="currently")
        public void setCurrently(@Nullable DsDataPoint currently) {
            this.currently = currently;
        }

        @JsonProperty(value="minutely")
        public void setMinutely(@Nullable DsDataBlock minutely) {
            this.minutely = minutely;
        }

        @JsonProperty(value="hourly")
        public void setHourly(@Nullable DsDataBlock hourly) {
            this.hourly = hourly;
        }

        @JsonProperty(value="daily")
        public void setDaily(@Nullable DsDataBlock daily) {
            this.daily = daily;
        }

        @JsonProperty(value="alerts")
        public void setAlerts(List<DsAlert> alerts) {
            this.alerts = alerts;
        }

        @JsonProperty(value="flags")
        public void setFlags(@Nullable DsFlag flags) {
            this.flags = flags;
        }

        @Override
        public BigDecimal latitude() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal longitude() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String timezone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int offset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DsDataPoint currently() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DsDataBlock minutely() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DsDataBlock hourly() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DsDataBlock daily() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<DsAlert> alerts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DsFlag flags() {
            throw new UnsupportedOperationException();
        }
    }
}

