/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.darksky.model;

import ch.rasc.darksky.converter.DsAlertSeverityDeserializer;
import ch.rasc.darksky.model.DsAlert;
import ch.rasc.darksky.model.DsAlertSeverity;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="DsAlert", generator="Immutables")
@Immutable
public final class ImmutableDsAlert
implements DsAlert {
    private final String description;
    private final long expires;
    private final List<String> regions;
    private final DsAlertSeverity severity;
    private final long time;
    private final String title;
    private final String uri;

    private ImmutableDsAlert(String description, long expires, List<String> regions, DsAlertSeverity severity, long time, String title, String uri) {
        this.description = description;
        this.expires = expires;
        this.regions = regions;
        this.severity = severity;
        this.time = time;
        this.title = title;
        this.uri = uri;
    }

    @Override
    @JsonProperty(value="description")
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="expires")
    public long expires() {
        return this.expires;
    }

    @Override
    @JsonProperty(value="regions")
    public List<String> regions() {
        return this.regions;
    }

    @Override
    @JsonProperty(value="severity")
    @JsonDeserialize(using=DsAlertSeverityDeserializer.class)
    public DsAlertSeverity severity() {
        return this.severity;
    }

    @Override
    @JsonProperty(value="time")
    public long time() {
        return this.time;
    }

    @Override
    @JsonProperty(value="title")
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="uri")
    public String uri() {
        return this.uri;
    }

    public final ImmutableDsAlert withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableDsAlert(newValue, this.expires, this.regions, this.severity, this.time, this.title, this.uri);
    }

    public final ImmutableDsAlert withExpires(long value) {
        if (this.expires == value) {
            return this;
        }
        return new ImmutableDsAlert(this.description, value, this.regions, this.severity, this.time, this.title, this.uri);
    }

    public final ImmutableDsAlert withRegions(String ... elements) {
        List<String> newValue = ImmutableDsAlert.createUnmodifiableList(false, ImmutableDsAlert.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDsAlert(this.description, this.expires, newValue, this.severity, this.time, this.title, this.uri);
    }

    public final ImmutableDsAlert withRegions(Iterable<String> elements) {
        if (this.regions == elements) {
            return this;
        }
        List<String> newValue = ImmutableDsAlert.createUnmodifiableList(false, ImmutableDsAlert.createSafeList(elements, true, false));
        return new ImmutableDsAlert(this.description, this.expires, newValue, this.severity, this.time, this.title, this.uri);
    }

    public final ImmutableDsAlert withSeverity(DsAlertSeverity value) {
        if (this.severity == value) {
            return this;
        }
        DsAlertSeverity newValue = Objects.requireNonNull(value, "severity");
        if (this.severity.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableDsAlert(this.description, this.expires, this.regions, newValue, this.time, this.title, this.uri);
    }

    public final ImmutableDsAlert withTime(long value) {
        if (this.time == value) {
            return this;
        }
        return new ImmutableDsAlert(this.description, this.expires, this.regions, this.severity, value, this.title, this.uri);
    }

    public final ImmutableDsAlert withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableDsAlert(this.description, this.expires, this.regions, this.severity, this.time, newValue, this.uri);
    }

    public final ImmutableDsAlert withUri(String value) {
        String newValue = Objects.requireNonNull(value, "uri");
        if (this.uri.equals(newValue)) {
            return this;
        }
        return new ImmutableDsAlert(this.description, this.expires, this.regions, this.severity, this.time, this.title, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDsAlert && this.equalTo((ImmutableDsAlert)another);
    }

    private boolean equalTo(ImmutableDsAlert another) {
        return this.description.equals(another.description) && this.expires == another.expires && this.regions.equals(another.regions) && this.severity.equals((Object)another.severity) && this.time == another.time && this.title.equals(another.title) && this.uri.equals(another.uri);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + Long.hashCode(this.expires);
        h += (h << 5) + this.regions.hashCode();
        h += (h << 5) + this.severity.hashCode();
        h += (h << 5) + Long.hashCode(this.time);
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.uri.hashCode();
        return h;
    }

    public String toString() {
        return "DsAlert{description=" + this.description + ", expires=" + this.expires + ", regions=" + this.regions + ", severity=" + (Object)((Object)this.severity) + ", time=" + this.time + ", title=" + this.title + ", uri=" + this.uri + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDsAlert fromJson(Json json) {
        Builder builder = ImmutableDsAlert.builder();
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.expiresIsSet) {
            builder.expires(json.expires);
        }
        if (json.regions != null) {
            builder.addAllRegions(json.regions);
        }
        if (json.severity != null) {
            builder.severity(json.severity);
        }
        if (json.timeIsSet) {
            builder.time(json.time);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.uri != null) {
            builder.uri(json.uri);
        }
        return builder.build();
    }

    public static ImmutableDsAlert copyOf(DsAlert instance) {
        if (instance instanceof ImmutableDsAlert) {
            return (ImmutableDsAlert)instance;
        }
        return ImmutableDsAlert.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="DsAlert", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DESCRIPTION = 1L;
        private static final long INIT_BIT_EXPIRES = 2L;
        private static final long INIT_BIT_SEVERITY = 4L;
        private static final long INIT_BIT_TIME = 8L;
        private static final long INIT_BIT_TITLE = 16L;
        private static final long INIT_BIT_URI = 32L;
        private long initBits = 63L;
        @Nullable
        private String description;
        private long expires;
        private List<String> regions = new ArrayList<String>();
        @Nullable
        private DsAlertSeverity severity;
        private long time;
        @Nullable
        private String title;
        @Nullable
        private String uri;

        private Builder() {
        }

        public final Builder from(DsAlert instance) {
            Objects.requireNonNull(instance, "instance");
            this.description(instance.description());
            this.expires(instance.expires());
            this.addAllRegions(instance.regions());
            this.severity(instance.severity());
            this.time(instance.time());
            this.title(instance.title());
            this.uri(instance.uri());
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="expires")
        public final Builder expires(long expires) {
            this.expires = expires;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addRegions(String element) {
            this.regions.add(Objects.requireNonNull(element, "regions element"));
            return this;
        }

        public final Builder addRegions(String ... elements) {
            for (String element : elements) {
                this.regions.add(Objects.requireNonNull(element, "regions element"));
            }
            return this;
        }

        @JsonProperty(value="regions")
        public final Builder regions(Iterable<String> elements) {
            this.regions.clear();
            return this.addAllRegions(elements);
        }

        public final Builder addAllRegions(Iterable<String> elements) {
            for (String element : elements) {
                this.regions.add(Objects.requireNonNull(element, "regions element"));
            }
            return this;
        }

        @JsonProperty(value="severity")
        @JsonDeserialize(using=DsAlertSeverityDeserializer.class)
        public final Builder severity(DsAlertSeverity severity) {
            this.severity = Objects.requireNonNull(severity, "severity");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="time")
        public final Builder time(long time) {
            this.time = time;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="title")
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="uri")
        public final Builder uri(String uri) {
            this.uri = Objects.requireNonNull(uri, "uri");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableDsAlert build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDsAlert(this.description, this.expires, ImmutableDsAlert.createUnmodifiableList(true, this.regions), this.severity, this.time, this.title, this.uri);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("expires");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("severity");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("time");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("uri");
            }
            return "Cannot build DsAlert, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DsAlert", generator="Immutables")
    static final class Json
    implements DsAlert {
        @Nullable
        String description;
        long expires;
        boolean expiresIsSet;
        @Nullable
        List<String> regions = Collections.emptyList();
        @Nullable
        DsAlertSeverity severity;
        long time;
        boolean timeIsSet;
        @Nullable
        String title;
        @Nullable
        String uri;

        Json() {
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="expires")
        public void setExpires(long expires) {
            this.expires = expires;
            this.expiresIsSet = true;
        }

        @JsonProperty(value="regions")
        public void setRegions(List<String> regions) {
            this.regions = regions;
        }

        @JsonProperty(value="severity")
        @JsonDeserialize(using=DsAlertSeverityDeserializer.class)
        public void setSeverity(DsAlertSeverity severity) {
            this.severity = severity;
        }

        @JsonProperty(value="time")
        public void setTime(long time) {
            this.time = time;
            this.timeIsSet = true;
        }

        @JsonProperty(value="title")
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="uri")
        public void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long expires() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> regions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DsAlertSeverity severity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long time() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String uri() {
            throw new UnsupportedOperationException();
        }
    }
}

