/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.darksky.model;

import ch.rasc.darksky.model.DsBlock;
import ch.rasc.darksky.model.DsLanguage;
import ch.rasc.darksky.model.DsTimeMachineRequest;
import ch.rasc.darksky.model.DsUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="DsTimeMachineRequest", generator="Immutables")
@Immutable
final class ImmutableDsTimeMachineRequest
implements DsTimeMachineRequest {
    private final String latitude;
    private final String longitude;
    private final long time;
    @Nullable
    private final DsLanguage language;
    @Nullable
    private final DsUnit unit;
    private final Set<DsBlock> excludeBlocks;
    private final Set<DsBlock> includeBlocks;

    private ImmutableDsTimeMachineRequest(String latitude, String longitude, long time, @Nullable DsLanguage language, @Nullable DsUnit unit, Set<DsBlock> excludeBlocks, Set<DsBlock> includeBlocks) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.time = time;
        this.language = language;
        this.unit = unit;
        this.excludeBlocks = excludeBlocks;
        this.includeBlocks = includeBlocks;
    }

    @Override
    public String latitude() {
        return this.latitude;
    }

    @Override
    public String longitude() {
        return this.longitude;
    }

    @Override
    public long time() {
        return this.time;
    }

    @Override
    @Nullable
    public DsLanguage language() {
        return this.language;
    }

    @Override
    @Nullable
    public DsUnit unit() {
        return this.unit;
    }

    @Override
    public Set<DsBlock> excludeBlocks() {
        return this.excludeBlocks;
    }

    @Override
    public Set<DsBlock> includeBlocks() {
        return this.includeBlocks;
    }

    public final ImmutableDsTimeMachineRequest withLatitude(String value) {
        String newValue = Objects.requireNonNull(value, "latitude");
        if (this.latitude.equals(newValue)) {
            return this;
        }
        return new ImmutableDsTimeMachineRequest(newValue, this.longitude, this.time, this.language, this.unit, this.excludeBlocks, this.includeBlocks);
    }

    public final ImmutableDsTimeMachineRequest withLongitude(String value) {
        String newValue = Objects.requireNonNull(value, "longitude");
        if (this.longitude.equals(newValue)) {
            return this;
        }
        return new ImmutableDsTimeMachineRequest(this.latitude, newValue, this.time, this.language, this.unit, this.excludeBlocks, this.includeBlocks);
    }

    public final ImmutableDsTimeMachineRequest withTime(long value) {
        if (this.time == value) {
            return this;
        }
        return new ImmutableDsTimeMachineRequest(this.latitude, this.longitude, value, this.language, this.unit, this.excludeBlocks, this.includeBlocks);
    }

    public final ImmutableDsTimeMachineRequest withLanguage(@Nullable DsLanguage value) {
        if (this.language == value) {
            return this;
        }
        if (Objects.equals((Object)this.language, (Object)value)) {
            return this;
        }
        return new ImmutableDsTimeMachineRequest(this.latitude, this.longitude, this.time, value, this.unit, this.excludeBlocks, this.includeBlocks);
    }

    public final ImmutableDsTimeMachineRequest withUnit(@Nullable DsUnit value) {
        if (this.unit == value) {
            return this;
        }
        if (Objects.equals((Object)this.unit, (Object)value)) {
            return this;
        }
        return new ImmutableDsTimeMachineRequest(this.latitude, this.longitude, this.time, this.language, value, this.excludeBlocks, this.includeBlocks);
    }

    public final ImmutableDsTimeMachineRequest withExcludeBlocks(DsBlock ... elements) {
        Set<DsBlock> newValue = ImmutableDsTimeMachineRequest.createUnmodifiableEnumSet(Arrays.asList(elements));
        return new ImmutableDsTimeMachineRequest(this.latitude, this.longitude, this.time, this.language, this.unit, newValue, this.includeBlocks);
    }

    public final ImmutableDsTimeMachineRequest withExcludeBlocks(Iterable<DsBlock> elements) {
        if (this.excludeBlocks == elements) {
            return this;
        }
        Set<DsBlock> newValue = ImmutableDsTimeMachineRequest.createUnmodifiableEnumSet(elements);
        return new ImmutableDsTimeMachineRequest(this.latitude, this.longitude, this.time, this.language, this.unit, newValue, this.includeBlocks);
    }

    public final ImmutableDsTimeMachineRequest withIncludeBlocks(DsBlock ... elements) {
        Set<DsBlock> newValue = ImmutableDsTimeMachineRequest.createUnmodifiableEnumSet(Arrays.asList(elements));
        return new ImmutableDsTimeMachineRequest(this.latitude, this.longitude, this.time, this.language, this.unit, this.excludeBlocks, newValue);
    }

    public final ImmutableDsTimeMachineRequest withIncludeBlocks(Iterable<DsBlock> elements) {
        if (this.includeBlocks == elements) {
            return this;
        }
        Set<DsBlock> newValue = ImmutableDsTimeMachineRequest.createUnmodifiableEnumSet(elements);
        return new ImmutableDsTimeMachineRequest(this.latitude, this.longitude, this.time, this.language, this.unit, this.excludeBlocks, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDsTimeMachineRequest && this.equalTo((ImmutableDsTimeMachineRequest)another);
    }

    private boolean equalTo(ImmutableDsTimeMachineRequest another) {
        return this.latitude.equals(another.latitude) && this.longitude.equals(another.longitude) && this.time == another.time && Objects.equals((Object)this.language, (Object)another.language) && Objects.equals((Object)this.unit, (Object)another.unit) && this.excludeBlocks.equals(another.excludeBlocks) && this.includeBlocks.equals(another.includeBlocks);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.latitude.hashCode();
        h += (h << 5) + this.longitude.hashCode();
        h += (h << 5) + Long.hashCode(this.time);
        h += (h << 5) + Objects.hashCode((Object)this.language);
        h += (h << 5) + Objects.hashCode((Object)this.unit);
        h += (h << 5) + this.excludeBlocks.hashCode();
        h += (h << 5) + this.includeBlocks.hashCode();
        return h;
    }

    public String toString() {
        return "DsTimeMachineRequest{latitude=" + this.latitude + ", longitude=" + this.longitude + ", time=" + this.time + ", language=" + (Object)((Object)this.language) + ", unit=" + (Object)((Object)this.unit) + ", excludeBlocks=" + this.excludeBlocks + ", includeBlocks=" + this.includeBlocks + "}";
    }

    public static ImmutableDsTimeMachineRequest copyOf(DsTimeMachineRequest instance) {
        if (instance instanceof ImmutableDsTimeMachineRequest) {
            return (ImmutableDsTimeMachineRequest)instance;
        }
        return new DsTimeMachineRequest.Builder().from(instance).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
        if (iterable instanceof EnumSet) {
            return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet)iterable));
        }
        List<T> list = ImmutableDsTimeMachineRequest.createSafeList(iterable, true, false);
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }

    @Generated(from="DsTimeMachineRequest", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_LATITUDE = 1L;
        private static final long INIT_BIT_LONGITUDE = 2L;
        private static final long INIT_BIT_TIME = 4L;
        private long initBits = 7L;
        @Nullable
        private String latitude;
        @Nullable
        private String longitude;
        private long time;
        @Nullable
        private DsLanguage language;
        @Nullable
        private DsUnit unit;
        private EnumSet<DsBlock> excludeBlocks = EnumSet.noneOf(DsBlock.class);
        private EnumSet<DsBlock> includeBlocks = EnumSet.noneOf(DsBlock.class);

        public Builder() {
            if (!(this instanceof DsTimeMachineRequest.Builder)) {
                throw new UnsupportedOperationException("Use: new DsTimeMachineRequest.Builder()");
            }
        }

        public final DsTimeMachineRequest.Builder from(DsTimeMachineRequest instance) {
            DsUnit unitValue;
            Objects.requireNonNull(instance, "instance");
            this.latitude(instance.latitude());
            this.longitude(instance.longitude());
            this.time(instance.time());
            DsLanguage languageValue = instance.language();
            if (languageValue != null) {
                this.language(languageValue);
            }
            if ((unitValue = instance.unit()) != null) {
                this.unit(unitValue);
            }
            this.addAllExcludeBlocks(instance.excludeBlocks());
            this.addAllIncludeBlocks(instance.includeBlocks());
            return (DsTimeMachineRequest.Builder)this;
        }

        public final DsTimeMachineRequest.Builder latitude(String latitude) {
            this.latitude = Objects.requireNonNull(latitude, "latitude");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (DsTimeMachineRequest.Builder)this;
        }

        public final DsTimeMachineRequest.Builder longitude(String longitude) {
            this.longitude = Objects.requireNonNull(longitude, "longitude");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (DsTimeMachineRequest.Builder)this;
        }

        public final DsTimeMachineRequest.Builder time(long time) {
            this.time = time;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (DsTimeMachineRequest.Builder)this;
        }

        public final DsTimeMachineRequest.Builder language(@Nullable DsLanguage language) {
            this.language = language;
            return (DsTimeMachineRequest.Builder)this;
        }

        public final DsTimeMachineRequest.Builder unit(@Nullable DsUnit unit) {
            this.unit = unit;
            return (DsTimeMachineRequest.Builder)this;
        }

        public final DsTimeMachineRequest.Builder excludeBlock(DsBlock element) {
            this.excludeBlocks.add(Objects.requireNonNull(element, "excludeBlocks element"));
            return (DsTimeMachineRequest.Builder)this;
        }

        public final DsTimeMachineRequest.Builder excludeBlocks(DsBlock ... elements) {
            for (DsBlock element : elements) {
                this.excludeBlocks.add(Objects.requireNonNull(element, "excludeBlocks element"));
            }
            return (DsTimeMachineRequest.Builder)this;
        }

        public final DsTimeMachineRequest.Builder excludeBlocks(Iterable<DsBlock> elements) {
            this.excludeBlocks.clear();
            return this.addAllExcludeBlocks(elements);
        }

        public final DsTimeMachineRequest.Builder addAllExcludeBlocks(Iterable<DsBlock> elements) {
            for (DsBlock element : elements) {
                this.excludeBlocks.add(Objects.requireNonNull(element, "excludeBlocks element"));
            }
            return (DsTimeMachineRequest.Builder)this;
        }

        public final DsTimeMachineRequest.Builder includeBlock(DsBlock element) {
            this.includeBlocks.add(Objects.requireNonNull(element, "includeBlocks element"));
            return (DsTimeMachineRequest.Builder)this;
        }

        public final DsTimeMachineRequest.Builder includeBlocks(DsBlock ... elements) {
            for (DsBlock element : elements) {
                this.includeBlocks.add(Objects.requireNonNull(element, "includeBlocks element"));
            }
            return (DsTimeMachineRequest.Builder)this;
        }

        public final DsTimeMachineRequest.Builder includeBlocks(Iterable<DsBlock> elements) {
            this.includeBlocks.clear();
            return this.addAllIncludeBlocks(elements);
        }

        public final DsTimeMachineRequest.Builder addAllIncludeBlocks(Iterable<DsBlock> elements) {
            for (DsBlock element : elements) {
                this.includeBlocks.add(Objects.requireNonNull(element, "includeBlocks element"));
            }
            return (DsTimeMachineRequest.Builder)this;
        }

        public ImmutableDsTimeMachineRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDsTimeMachineRequest(this.latitude, this.longitude, this.time, this.language, this.unit, ImmutableDsTimeMachineRequest.createUnmodifiableEnumSet(this.excludeBlocks), ImmutableDsTimeMachineRequest.createUnmodifiableEnumSet(this.includeBlocks));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("latitude");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("longitude");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("time");
            }
            return "Cannot build DsTimeMachineRequest, some of required attributes are not set " + attributes;
        }
    }
}

