package ch.rasc.forcastio.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link FioResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFioResponse.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "FioResponse"})
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableFioResponse implements FioResponse {
  private final BigDecimal latitude;
  private final BigDecimal longitude;
  private final String timezone;
  private final int offset;
  private final @Nullable FioDataPoint currently;
  private final @Nullable FioDataBlock minutely;
  private final @Nullable FioDataBlock hourly;
  private final @Nullable FioDataBlock daily;
  private final List<FioAlert> alerts;
  private final FioFlag flags;

  private ImmutableFioResponse(
      BigDecimal latitude,
      BigDecimal longitude,
      String timezone,
      int offset,
      @Nullable FioDataPoint currently,
      @Nullable FioDataBlock minutely,
      @Nullable FioDataBlock hourly,
      @Nullable FioDataBlock daily,
      List<FioAlert> alerts,
      FioFlag flags) {
    this.latitude = latitude;
    this.longitude = longitude;
    this.timezone = timezone;
    this.offset = offset;
    this.currently = currently;
    this.minutely = minutely;
    this.hourly = hourly;
    this.daily = daily;
    this.alerts = alerts;
    this.flags = flags;
  }

  /**
   * The requested latitude.
   */
  @JsonProperty("latitude")
  @Override
  public BigDecimal latitude() {
    return latitude;
  }

  /**
   * The requested longitude.
   */
  @JsonProperty("longitude")
  @Override
  public BigDecimal longitude() {
    return longitude;
  }

  /**
   * The IANA timezone name for the requested location (e.g. America/New_York). This is
   * the timezone used for text forecast summaries and for determining the exact start
   * time of daily data points. (Developers are advised to rely on local system settings
   * rather than this value if at all possible: users may deliberately set an unusual
   * timezone, and furthermore are likely to know what they actually want better than
   * our timezone database does.)
   */
  @JsonProperty("timezone")
  @Override
  public String timezone() {
    return timezone;
  }

  /**
   * The current timezone offset in hours from GMT. (This value is deprecated and should
   * not be used.)
   */
  @JsonProperty("offset")
  @Override
  public int offset() {
    return offset;
  }

  /**
   * An instance of {@link FioDataPoint} containing the current weather conditions at
   * the requested location.
   */
  @JsonProperty("currently")
  @Override
  public @Nullable FioDataPoint currently() {
    return currently;
  }

  /**
   * An instance of {@link FioDataPoint} containing the weather conditions
   * minute-by-minute for the next hour.
   */
  @JsonProperty("minutely")
  @Override
  public @Nullable FioDataBlock minutely() {
    return minutely;
  }

  /**
   * An instance of {@link FioDataPoint} containing the weather conditions hour-by-hour
   * for the next two days.
   */
  @JsonProperty("hourly")
  @Override
  public @Nullable FioDataBlock hourly() {
    return hourly;
  }

  /**
   * An instance of {@link FioDataPoint} containing the weather conditions day-by-day
   * for the next week.
   */
  @JsonProperty("daily")
  @Override
  public @Nullable FioDataBlock daily() {
    return daily;
  }

  /**
   * A collection of {@link FioAlert} instances, which, if present, contains any severe
   * weather alerts, issued by a governmental weather authority, pertinent to the
   * requested location.
   */
  @JsonProperty("alerts")
  @Override
  public List<FioAlert> alerts() {
    return alerts;
  }

  /**
   * An instance of {@link FioFlag} containing miscellaneous metadata concerning this
   * request.
   */
  @JsonProperty("flags")
  @Override
  public FioFlag flags() {
    return flags;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioResponse#latitude() latitude} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param latitude A new value for latitude
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioResponse withLatitude(BigDecimal latitude) {
    if (this.latitude == latitude) return this;
    BigDecimal newValue = Objects.requireNonNull(latitude, "latitude");
    return new ImmutableFioResponse(
        newValue,
        this.longitude,
        this.timezone,
        this.offset,
        this.currently,
        this.minutely,
        this.hourly,
        this.daily,
        this.alerts,
        this.flags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioResponse#longitude() longitude} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param longitude A new value for longitude
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioResponse withLongitude(BigDecimal longitude) {
    if (this.longitude == longitude) return this;
    BigDecimal newValue = Objects.requireNonNull(longitude, "longitude");
    return new ImmutableFioResponse(
        this.latitude,
        newValue,
        this.timezone,
        this.offset,
        this.currently,
        this.minutely,
        this.hourly,
        this.daily,
        this.alerts,
        this.flags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioResponse#timezone() timezone} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param timezone A new value for timezone
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioResponse withTimezone(String timezone) {
    if (this.timezone.equals(timezone)) return this;
    String newValue = Objects.requireNonNull(timezone, "timezone");
    return new ImmutableFioResponse(
        this.latitude,
        this.longitude,
        newValue,
        this.offset,
        this.currently,
        this.minutely,
        this.hourly,
        this.daily,
        this.alerts,
        this.flags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioResponse#offset() offset} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param offset A new value for offset
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioResponse withOffset(int offset) {
    if (this.offset == offset) return this;
    return new ImmutableFioResponse(
        this.latitude,
        this.longitude,
        this.timezone,
        offset,
        this.currently,
        this.minutely,
        this.hourly,
        this.daily,
        this.alerts,
        this.flags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioResponse#currently() currently} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param currently A new value for currently (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioResponse withCurrently(@Nullable FioDataPoint currently) {
    if (this.currently == currently) return this;
    return new ImmutableFioResponse(
        this.latitude,
        this.longitude,
        this.timezone,
        this.offset,
        currently,
        this.minutely,
        this.hourly,
        this.daily,
        this.alerts,
        this.flags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioResponse#minutely() minutely} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param minutely A new value for minutely (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioResponse withMinutely(@Nullable FioDataBlock minutely) {
    if (this.minutely == minutely) return this;
    return new ImmutableFioResponse(
        this.latitude,
        this.longitude,
        this.timezone,
        this.offset,
        this.currently,
        minutely,
        this.hourly,
        this.daily,
        this.alerts,
        this.flags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioResponse#hourly() hourly} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param hourly A new value for hourly (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioResponse withHourly(@Nullable FioDataBlock hourly) {
    if (this.hourly == hourly) return this;
    return new ImmutableFioResponse(
        this.latitude,
        this.longitude,
        this.timezone,
        this.offset,
        this.currently,
        this.minutely,
        hourly,
        this.daily,
        this.alerts,
        this.flags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioResponse#daily() daily} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param daily A new value for daily (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioResponse withDaily(@Nullable FioDataBlock daily) {
    if (this.daily == daily) return this;
    return new ImmutableFioResponse(
        this.latitude,
        this.longitude,
        this.timezone,
        this.offset,
        this.currently,
        this.minutely,
        this.hourly,
        daily,
        this.alerts,
        this.flags);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FioResponse#alerts() alerts}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFioResponse withAlerts(FioAlert... elements) {
    List<FioAlert> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableFioResponse(
        this.latitude,
        this.longitude,
        this.timezone,
        this.offset,
        this.currently,
        this.minutely,
        this.hourly,
        this.daily,
        newValue,
        this.flags);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FioResponse#alerts() alerts}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of alerts elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFioResponse withAlerts(Iterable<? extends FioAlert> elements) {
    if (this.alerts == elements) return this;
    List<FioAlert> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableFioResponse(
        this.latitude,
        this.longitude,
        this.timezone,
        this.offset,
        this.currently,
        this.minutely,
        this.hourly,
        this.daily,
        newValue,
        this.flags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioResponse#flags() flags} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param flags A new value for flags
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioResponse withFlags(FioFlag flags) {
    if (this.flags == flags) return this;
    FioFlag newValue = Objects.requireNonNull(flags, "flags");
    return new ImmutableFioResponse(
        this.latitude,
        this.longitude,
        this.timezone,
        this.offset,
        this.currently,
        this.minutely,
        this.hourly,
        this.daily,
        this.alerts,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFioResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFioResponse
        && equalTo((ImmutableFioResponse) another);
  }

  private boolean equalTo(ImmutableFioResponse another) {
    return latitude.equals(another.latitude)
        && longitude.equals(another.longitude)
        && timezone.equals(another.timezone)
        && offset == another.offset
        && Objects.equals(currently, another.currently)
        && Objects.equals(minutely, another.minutely)
        && Objects.equals(hourly, another.hourly)
        && Objects.equals(daily, another.daily)
        && alerts.equals(another.alerts)
        && flags.equals(another.flags);
  }

  /**
   * Computes a hash code from attributes: {@code latitude}, {@code longitude}, {@code timezone}, {@code offset}, {@code currently}, {@code minutely}, {@code hourly}, {@code daily}, {@code alerts}, {@code flags}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + latitude.hashCode();
    h = h * 17 + longitude.hashCode();
    h = h * 17 + timezone.hashCode();
    h = h * 17 + offset;
    h = h * 17 + Objects.hashCode(currently);
    h = h * 17 + Objects.hashCode(minutely);
    h = h * 17 + Objects.hashCode(hourly);
    h = h * 17 + Objects.hashCode(daily);
    h = h * 17 + alerts.hashCode();
    h = h * 17 + flags.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FioResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FioResponse{"
        + "latitude=" + latitude
        + ", longitude=" + longitude
        + ", timezone=" + timezone
        + ", offset=" + offset
        + ", currently=" + currently
        + ", minutely=" + minutely
        + ", hourly=" + hourly
        + ", daily=" + daily
        + ", alerts=" + alerts
        + ", flags=" + flags
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FioResponse {
    BigDecimal latitude;
    BigDecimal longitude;
    String timezone;
    int offset;
    boolean offsetIsSet;
    FioDataPoint currently;
    FioDataBlock minutely;
    FioDataBlock hourly;
    FioDataBlock daily;
    List<FioAlert> alerts = Collections.emptyList();
    FioFlag flags;
    @JsonProperty("latitude")
    public void setLatitude(BigDecimal latitude) {
      this.latitude = latitude;
    }
    @JsonProperty("longitude")
    public void setLongitude(BigDecimal longitude) {
      this.longitude = longitude;
    }
    @JsonProperty("timezone")
    public void setTimezone(String timezone) {
      this.timezone = timezone;
    }
    @JsonProperty("offset")
    public void setOffset(int offset) {
      this.offset = offset;
      this.offsetIsSet = true;
    }
    @JsonProperty("currently")
    public void setCurrently(@Nullable FioDataPoint currently) {
      this.currently = currently;
    }
    @JsonProperty("minutely")
    public void setMinutely(@Nullable FioDataBlock minutely) {
      this.minutely = minutely;
    }
    @JsonProperty("hourly")
    public void setHourly(@Nullable FioDataBlock hourly) {
      this.hourly = hourly;
    }
    @JsonProperty("daily")
    public void setDaily(@Nullable FioDataBlock daily) {
      this.daily = daily;
    }
    @JsonProperty("alerts")
    public void setAlerts(List<FioAlert> alerts) {
      this.alerts = alerts;
    }
    @JsonProperty("flags")
    public void setFlags(FioFlag flags) {
      this.flags = flags;
    }
    @Override
    public BigDecimal latitude() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal longitude() { throw new UnsupportedOperationException(); }
    @Override
    public String timezone() { throw new UnsupportedOperationException(); }
    @Override
    public int offset() { throw new UnsupportedOperationException(); }
    @Override
    public FioDataPoint currently() { throw new UnsupportedOperationException(); }
    @Override
    public FioDataBlock minutely() { throw new UnsupportedOperationException(); }
    @Override
    public FioDataBlock hourly() { throw new UnsupportedOperationException(); }
    @Override
    public FioDataBlock daily() { throw new UnsupportedOperationException(); }
    @Override
    public List<FioAlert> alerts() { throw new UnsupportedOperationException(); }
    @Override
    public FioFlag flags() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableFioResponse fromJson(Json json) {
    ImmutableFioResponse.Builder builder = ImmutableFioResponse.builder();
    if (json.latitude != null) {
      builder.latitude(json.latitude);
    }
    if (json.longitude != null) {
      builder.longitude(json.longitude);
    }
    if (json.timezone != null) {
      builder.timezone(json.timezone);
    }
    if (json.offsetIsSet) {
      builder.offset(json.offset);
    }
    if (json.currently != null) {
      builder.currently(json.currently);
    }
    if (json.minutely != null) {
      builder.minutely(json.minutely);
    }
    if (json.hourly != null) {
      builder.hourly(json.hourly);
    }
    if (json.daily != null) {
      builder.daily(json.daily);
    }
    if (json.alerts != null) {
      builder.addAllAlerts(json.alerts);
    }
    if (json.flags != null) {
      builder.flags(json.flags);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FioResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FioResponse instance
   */
  public static ImmutableFioResponse copyOf(FioResponse instance) {
    if (instance instanceof ImmutableFioResponse) {
      return (ImmutableFioResponse) instance;
    }
    return ImmutableFioResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFioResponse ImmutableFioResponse}.
   * @return A new ImmutableFioResponse builder
   */
  public static ImmutableFioResponse.Builder builder() {
    return new ImmutableFioResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFioResponse ImmutableFioResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_LATITUDE = 0x1L;
    private static final long INIT_BIT_LONGITUDE = 0x2L;
    private static final long INIT_BIT_TIMEZONE = 0x4L;
    private static final long INIT_BIT_OFFSET = 0x8L;
    private static final long INIT_BIT_FLAGS = 0x10L;
    private long initBits = 0x1fL;

    private BigDecimal latitude;
    private BigDecimal longitude;
    private String timezone;
    private int offset;
    private FioDataPoint currently;
    private FioDataBlock minutely;
    private FioDataBlock hourly;
    private FioDataBlock daily;
    private List<FioAlert> alerts = new ArrayList<FioAlert>();
    private FioFlag flags;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FioResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FioResponse instance) {
      Objects.requireNonNull(instance, "instance");
      latitude(instance.latitude());
      longitude(instance.longitude());
      timezone(instance.timezone());
      offset(instance.offset());
      @Nullable FioDataPoint currentlyValue = instance.currently();
      if (currentlyValue != null) {
        currently(currentlyValue);
      }
      @Nullable FioDataBlock minutelyValue = instance.minutely();
      if (minutelyValue != null) {
        minutely(minutelyValue);
      }
      @Nullable FioDataBlock hourlyValue = instance.hourly();
      if (hourlyValue != null) {
        hourly(hourlyValue);
      }
      @Nullable FioDataBlock dailyValue = instance.daily();
      if (dailyValue != null) {
        daily(dailyValue);
      }
      addAllAlerts(instance.alerts());
      flags(instance.flags());
      return this;
    }

    /**
     * Initializes the value for the {@link FioResponse#latitude() latitude} attribute.
     * @param latitude The value for latitude 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder latitude(BigDecimal latitude) {
      this.latitude = Objects.requireNonNull(latitude, "latitude");
      initBits &= ~INIT_BIT_LATITUDE;
      return this;
    }

    /**
     * Initializes the value for the {@link FioResponse#longitude() longitude} attribute.
     * @param longitude The value for longitude 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder longitude(BigDecimal longitude) {
      this.longitude = Objects.requireNonNull(longitude, "longitude");
      initBits &= ~INIT_BIT_LONGITUDE;
      return this;
    }

    /**
     * Initializes the value for the {@link FioResponse#timezone() timezone} attribute.
     * @param timezone The value for timezone 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timezone(String timezone) {
      this.timezone = Objects.requireNonNull(timezone, "timezone");
      initBits &= ~INIT_BIT_TIMEZONE;
      return this;
    }

    /**
     * Initializes the value for the {@link FioResponse#offset() offset} attribute.
     * @param offset The value for offset 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder offset(int offset) {
      this.offset = offset;
      initBits &= ~INIT_BIT_OFFSET;
      return this;
    }

    /**
     * Initializes the value for the {@link FioResponse#currently() currently} attribute.
     * @param currently The value for currently (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder currently(@Nullable FioDataPoint currently) {
      this.currently = currently;
      return this;
    }

    /**
     * Initializes the value for the {@link FioResponse#minutely() minutely} attribute.
     * @param minutely The value for minutely (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder minutely(@Nullable FioDataBlock minutely) {
      this.minutely = minutely;
      return this;
    }

    /**
     * Initializes the value for the {@link FioResponse#hourly() hourly} attribute.
     * @param hourly The value for hourly (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder hourly(@Nullable FioDataBlock hourly) {
      this.hourly = hourly;
      return this;
    }

    /**
     * Initializes the value for the {@link FioResponse#daily() daily} attribute.
     * @param daily The value for daily (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder daily(@Nullable FioDataBlock daily) {
      this.daily = daily;
      return this;
    }

    /**
     * Adds one element to {@link FioResponse#alerts() alerts} list.
     * @param element A alerts element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAlerts(FioAlert element) {
      this.alerts.add(Objects.requireNonNull(element, "alerts element"));
      return this;
    }

    /**
     * Adds elements to {@link FioResponse#alerts() alerts} list.
     * @param elements An array of alerts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAlerts(FioAlert... elements) {
      for (FioAlert element : elements) {
        this.alerts.add(Objects.requireNonNull(element, "alerts element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link FioResponse#alerts() alerts} list.
     * @param elements An iterable of alerts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder alerts(Iterable<? extends FioAlert> elements) {
      this.alerts.clear();
      return addAllAlerts(elements);
    }

    /**
     * Adds elements to {@link FioResponse#alerts() alerts} list.
     * @param elements An iterable of alerts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAlerts(Iterable<? extends FioAlert> elements) {
      for (FioAlert element : elements) {
        this.alerts.add(Objects.requireNonNull(element, "alerts element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link FioResponse#flags() flags} attribute.
     * @param flags The value for flags 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder flags(FioFlag flags) {
      this.flags = Objects.requireNonNull(flags, "flags");
      initBits &= ~INIT_BIT_FLAGS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFioResponse ImmutableFioResponse}.
     * @return An immutable instance of FioResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFioResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFioResponse(
          latitude,
          longitude,
          timezone,
          offset,
          currently,
          minutely,
          hourly,
          daily,
          createUnmodifiableList(true, alerts),
          flags);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_LATITUDE) != 0) attributes.add("latitude");
      if ((initBits & INIT_BIT_LONGITUDE) != 0) attributes.add("longitude");
      if ((initBits & INIT_BIT_TIMEZONE) != 0) attributes.add("timezone");
      if ((initBits & INIT_BIT_OFFSET) != 0) attributes.add("offset");
      if ((initBits & INIT_BIT_FLAGS) != 0) attributes.add("flags");
      return "Cannot build FioResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
