/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.forcastio.model;

import ch.rasc.forcastio.model.FioAlert;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableFioAlert
implements FioAlert {
    private final String title;
    private final long expires;
    private final String uri;
    private final String description;

    private ImmutableFioAlert(String title, long expires, String uri, String description) {
        this.title = title;
        this.expires = expires;
        this.uri = uri;
        this.description = description;
    }

    @Override
    @JsonProperty(value="title")
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="expires")
    public long expires() {
        return this.expires;
    }

    @Override
    @JsonProperty(value="uri")
    public String uri() {
        return this.uri;
    }

    @Override
    @JsonProperty(value="description")
    public String description() {
        return this.description;
    }

    public final ImmutableFioAlert withTitle(String title) {
        if (this.title.equals(title)) {
            return this;
        }
        String newValue = Objects.requireNonNull(title, "title");
        return new ImmutableFioAlert(newValue, this.expires, this.uri, this.description);
    }

    public final ImmutableFioAlert withExpires(long expires) {
        if (this.expires == expires) {
            return this;
        }
        return new ImmutableFioAlert(this.title, expires, this.uri, this.description);
    }

    public final ImmutableFioAlert withUri(String uri) {
        if (this.uri.equals(uri)) {
            return this;
        }
        String newValue = Objects.requireNonNull(uri, "uri");
        return new ImmutableFioAlert(this.title, this.expires, newValue, this.description);
    }

    public final ImmutableFioAlert withDescription(String description) {
        if (this.description.equals(description)) {
            return this;
        }
        String newValue = Objects.requireNonNull(description, "description");
        return new ImmutableFioAlert(this.title, this.expires, this.uri, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFioAlert && this.equalTo((ImmutableFioAlert)another);
    }

    private boolean equalTo(ImmutableFioAlert another) {
        return this.title.equals(another.title) && this.expires == another.expires && this.uri.equals(another.uri) && this.description.equals(another.description);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.title.hashCode();
        h = h * 17 + Long.hashCode(this.expires);
        h = h * 17 + this.uri.hashCode();
        h = h * 17 + this.description.hashCode();
        return h;
    }

    public String toString() {
        return "FioAlert{title=" + this.title + ", expires=" + this.expires + ", uri=" + this.uri + ", description=" + this.description + "}";
    }

    @Deprecated
    @JsonCreator
    static ImmutableFioAlert fromJson(Json json) {
        Builder builder = ImmutableFioAlert.builder();
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.expiresIsSet) {
            builder.expires(json.expires);
        }
        if (json.uri != null) {
            builder.uri(json.uri);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        return builder.build();
    }

    public static ImmutableFioAlert copyOf(FioAlert instance) {
        if (instance instanceof ImmutableFioAlert) {
            return (ImmutableFioAlert)instance;
        }
        return ImmutableFioAlert.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long INIT_BIT_EXPIRES = 2L;
        private static final long INIT_BIT_URI = 4L;
        private static final long INIT_BIT_DESCRIPTION = 8L;
        private long initBits = 15L;
        private String title;
        private long expires;
        private String uri;
        private String description;

        private Builder() {
        }

        public final Builder from(FioAlert instance) {
            Objects.requireNonNull(instance, "instance");
            this.title(instance.title());
            this.expires(instance.expires());
            this.uri(instance.uri());
            this.description(instance.description());
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder expires(long expires) {
            this.expires = expires;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder uri(String uri) {
            this.uri = Objects.requireNonNull(uri, "uri");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableFioAlert build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFioAlert(this.title, this.expires, this.uri, this.description);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("expires");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("uri");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("description");
            }
            return "Cannot build FioAlert, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements FioAlert {
        String title;
        long expires;
        boolean expiresIsSet;
        String uri;
        String description;

        Json() {
        }

        @JsonProperty(value="title")
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="expires")
        public void setExpires(long expires) {
            this.expires = expires;
            this.expiresIsSet = true;
        }

        @JsonProperty(value="uri")
        public void setUri(String uri) {
            this.uri = uri;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        public String title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long expires() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String uri() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }
    }
}

