package ch.rasc.forcastio.model;

import ch.rasc.forcastio.converter.FioUnitDeserializer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link FioFlag}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFioFlag.builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "FioFlag"})
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableFioFlag implements FioFlag {
  private final @Nullable Object darkskyUnavailable;
  private final List<String> darkskyStations;
  private final List<String> datapointStations;
  private final List<String> isdStations;
  private final List<String> lampStations;
  private final List<String> metarStations;
  private final @Nullable String metnoLicense;
  private final List<String> sources;
  private final @Nullable FioUnit units;

  private ImmutableFioFlag(
      @Nullable Object darkskyUnavailable,
      List<String> darkskyStations,
      List<String> datapointStations,
      List<String> isdStations,
      List<String> lampStations,
      List<String> metarStations,
      @Nullable String metnoLicense,
      List<String> sources,
      @Nullable FioUnit units) {
    this.darkskyUnavailable = darkskyUnavailable;
    this.darkskyStations = darkskyStations;
    this.datapointStations = datapointStations;
    this.isdStations = isdStations;
    this.lampStations = lampStations;
    this.metarStations = metarStations;
    this.metnoLicense = metnoLicense;
    this.sources = sources;
    this.units = units;
  }

  /**
   * The presence of this property indicates that the Dark Sky data source supports the
   * given location, but a temporary error (such as a radar station being down for
   * maintenace) has made the data unavailable.
   */
  @JsonProperty("darksky-unavailable")
  @Override
  public @Nullable Object darkskyUnavailable() {
    return darkskyUnavailable;
  }

  /**
   * This property contains an array of IDs for each radar station utilized in servicing
   * this request.
   */
  @JsonProperty("darksky-stations")
  @Override
  public List<String> darkskyStations() {
    return darkskyStations;
  }

  /**
   * This property contains an array of IDs for each DataPoint station utilized in
   * servicing this request.
   */
  @JsonProperty("datapoint-stations")
  @Override
  public List<String> datapointStations() {
    return datapointStations;
  }

  /**
   * This property contains an array of IDs for each ISD station utilized in servicing
   * this request.
   */
  @JsonProperty("isd-stations")
  @Override
  public List<String> isdStations() {
    return isdStations;
  }

  /**
   * This property contains an array of IDs for each LAMP station utilized in servicing
   * this request.
   */
  @JsonProperty("lamp-stations")
  @Override
  public List<String> lampStations() {
    return lampStations;
  }

  /**
   * This property contains an array of IDs for each METAR station utilized in servicing
   * this request.
   */
  @JsonProperty("metar-stations")
  @Override
  public List<String> metarStations() {
    return metarStations;
  }

  /**
   * The presence of this property indicates that data from api.met.no was utilized in
   * order to facilitate this request (as per their license agreement).
   */
  @JsonProperty("metno-license")
  @Override
  public @Nullable String metnoLicense() {
    return metnoLicense;
  }

  /**
   * This property contains an array of IDs for each data source utilized in servicing
   * this request.
   */
  @JsonProperty("sources")
  @Override
  public List<String> sources() {
    return sources;
  }

  /**
   * The presence of this property indicates which units were used for the data in this
   * request.
   */
  @JsonProperty("units")
  @JsonDeserialize(using = FioUnitDeserializer.class)
  @Override
  public @Nullable FioUnit units() {
    return units;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioFlag#darkskyUnavailable() darkskyUnavailable} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for darkskyUnavailable (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioFlag withDarkskyUnavailable(@Nullable Object value) {
    if (this.darkskyUnavailable == value) return this;
    return new ImmutableFioFlag(
        value,
        this.darkskyStations,
        this.datapointStations,
        this.isdStations,
        this.lampStations,
        this.metarStations,
        this.metnoLicense,
        this.sources,
        this.units);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FioFlag#darkskyStations() darkskyStations}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFioFlag withDarkskyStations(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableFioFlag(
        this.darkskyUnavailable,
        newValue,
        this.datapointStations,
        this.isdStations,
        this.lampStations,
        this.metarStations,
        this.metnoLicense,
        this.sources,
        this.units);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FioFlag#darkskyStations() darkskyStations}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of darkskyStations elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFioFlag withDarkskyStations(Iterable<String> elements) {
    if (this.darkskyStations == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableFioFlag(
        this.darkskyUnavailable,
        newValue,
        this.datapointStations,
        this.isdStations,
        this.lampStations,
        this.metarStations,
        this.metnoLicense,
        this.sources,
        this.units);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FioFlag#datapointStations() datapointStations}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFioFlag withDatapointStations(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableFioFlag(
        this.darkskyUnavailable,
        this.darkskyStations,
        newValue,
        this.isdStations,
        this.lampStations,
        this.metarStations,
        this.metnoLicense,
        this.sources,
        this.units);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FioFlag#datapointStations() datapointStations}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of datapointStations elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFioFlag withDatapointStations(Iterable<String> elements) {
    if (this.datapointStations == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableFioFlag(
        this.darkskyUnavailable,
        this.darkskyStations,
        newValue,
        this.isdStations,
        this.lampStations,
        this.metarStations,
        this.metnoLicense,
        this.sources,
        this.units);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FioFlag#isdStations() isdStations}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFioFlag withIsdStations(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableFioFlag(
        this.darkskyUnavailable,
        this.darkskyStations,
        this.datapointStations,
        newValue,
        this.lampStations,
        this.metarStations,
        this.metnoLicense,
        this.sources,
        this.units);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FioFlag#isdStations() isdStations}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of isdStations elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFioFlag withIsdStations(Iterable<String> elements) {
    if (this.isdStations == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableFioFlag(
        this.darkskyUnavailable,
        this.darkskyStations,
        this.datapointStations,
        newValue,
        this.lampStations,
        this.metarStations,
        this.metnoLicense,
        this.sources,
        this.units);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FioFlag#lampStations() lampStations}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFioFlag withLampStations(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableFioFlag(
        this.darkskyUnavailable,
        this.darkskyStations,
        this.datapointStations,
        this.isdStations,
        newValue,
        this.metarStations,
        this.metnoLicense,
        this.sources,
        this.units);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FioFlag#lampStations() lampStations}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of lampStations elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFioFlag withLampStations(Iterable<String> elements) {
    if (this.lampStations == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableFioFlag(
        this.darkskyUnavailable,
        this.darkskyStations,
        this.datapointStations,
        this.isdStations,
        newValue,
        this.metarStations,
        this.metnoLicense,
        this.sources,
        this.units);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FioFlag#metarStations() metarStations}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFioFlag withMetarStations(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableFioFlag(
        this.darkskyUnavailable,
        this.darkskyStations,
        this.datapointStations,
        this.isdStations,
        this.lampStations,
        newValue,
        this.metnoLicense,
        this.sources,
        this.units);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FioFlag#metarStations() metarStations}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of metarStations elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFioFlag withMetarStations(Iterable<String> elements) {
    if (this.metarStations == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableFioFlag(
        this.darkskyUnavailable,
        this.darkskyStations,
        this.datapointStations,
        this.isdStations,
        this.lampStations,
        newValue,
        this.metnoLicense,
        this.sources,
        this.units);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioFlag#metnoLicense() metnoLicense} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for metnoLicense (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioFlag withMetnoLicense(@Nullable String value) {
    if (Objects.equals(this.metnoLicense, value)) return this;
    return new ImmutableFioFlag(
        this.darkskyUnavailable,
        this.darkskyStations,
        this.datapointStations,
        this.isdStations,
        this.lampStations,
        this.metarStations,
        value,
        this.sources,
        this.units);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FioFlag#sources() sources}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFioFlag withSources(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableFioFlag(
        this.darkskyUnavailable,
        this.darkskyStations,
        this.datapointStations,
        this.isdStations,
        this.lampStations,
        this.metarStations,
        this.metnoLicense,
        newValue,
        this.units);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FioFlag#sources() sources}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of sources elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFioFlag withSources(Iterable<String> elements) {
    if (this.sources == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableFioFlag(
        this.darkskyUnavailable,
        this.darkskyStations,
        this.datapointStations,
        this.isdStations,
        this.lampStations,
        this.metarStations,
        this.metnoLicense,
        newValue,
        this.units);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioFlag#units() units} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for units (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioFlag withUnits(@Nullable FioUnit value) {
    if (this.units == value) return this;
    return new ImmutableFioFlag(
        this.darkskyUnavailable,
        this.darkskyStations,
        this.datapointStations,
        this.isdStations,
        this.lampStations,
        this.metarStations,
        this.metnoLicense,
        this.sources,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFioFlag} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFioFlag
        && equalTo((ImmutableFioFlag) another);
  }

  private boolean equalTo(ImmutableFioFlag another) {
    return Objects.equals(darkskyUnavailable, another.darkskyUnavailable)
        && darkskyStations.equals(another.darkskyStations)
        && datapointStations.equals(another.datapointStations)
        && isdStations.equals(another.isdStations)
        && lampStations.equals(another.lampStations)
        && metarStations.equals(another.metarStations)
        && Objects.equals(metnoLicense, another.metnoLicense)
        && sources.equals(another.sources)
        && Objects.equals(units, another.units);
  }

  /**
   * Computes a hash code from attributes: {@code darkskyUnavailable}, {@code darkskyStations}, {@code datapointStations}, {@code isdStations}, {@code lampStations}, {@code metarStations}, {@code metnoLicense}, {@code sources}, {@code units}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(darkskyUnavailable);
    h = h * 17 + darkskyStations.hashCode();
    h = h * 17 + datapointStations.hashCode();
    h = h * 17 + isdStations.hashCode();
    h = h * 17 + lampStations.hashCode();
    h = h * 17 + metarStations.hashCode();
    h = h * 17 + Objects.hashCode(metnoLicense);
    h = h * 17 + sources.hashCode();
    h = h * 17 + Objects.hashCode(units);
    return h;
  }

  /**
   * Prints the immutable value {@code FioFlag} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FioFlag{"
        + "darkskyUnavailable=" + darkskyUnavailable
        + ", darkskyStations=" + darkskyStations
        + ", datapointStations=" + datapointStations
        + ", isdStations=" + isdStations
        + ", lampStations=" + lampStations
        + ", metarStations=" + metarStations
        + ", metnoLicense=" + metnoLicense
        + ", sources=" + sources
        + ", units=" + units
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FioFlag {
    Object darkskyUnavailable;
    List<String> darkskyStations = Collections.emptyList();
    List<String> datapointStations = Collections.emptyList();
    List<String> isdStations = Collections.emptyList();
    List<String> lampStations = Collections.emptyList();
    List<String> metarStations = Collections.emptyList();
    String metnoLicense;
    List<String> sources = Collections.emptyList();
    FioUnit units;
    @JsonProperty("darksky-unavailable")
    public void setDarkskyUnavailable(@Nullable Object darkskyUnavailable) {
      this.darkskyUnavailable = darkskyUnavailable;
    }
    @JsonProperty("darksky-stations")
    public void setDarkskyStations(List<String> darkskyStations) {
      this.darkskyStations = darkskyStations;
    }
    @JsonProperty("datapoint-stations")
    public void setDatapointStations(List<String> datapointStations) {
      this.datapointStations = datapointStations;
    }
    @JsonProperty("isd-stations")
    public void setIsdStations(List<String> isdStations) {
      this.isdStations = isdStations;
    }
    @JsonProperty("lamp-stations")
    public void setLampStations(List<String> lampStations) {
      this.lampStations = lampStations;
    }
    @JsonProperty("metar-stations")
    public void setMetarStations(List<String> metarStations) {
      this.metarStations = metarStations;
    }
    @JsonProperty("metno-license")
    public void setMetnoLicense(@Nullable String metnoLicense) {
      this.metnoLicense = metnoLicense;
    }
    @JsonProperty("sources")
    public void setSources(List<String> sources) {
      this.sources = sources;
    }
    @JsonProperty("units")
    @JsonDeserialize(using = FioUnitDeserializer.class)
    public void setUnits(@Nullable FioUnit units) {
      this.units = units;
    }
    @Override
    public Object darkskyUnavailable() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> darkskyStations() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> datapointStations() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> isdStations() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> lampStations() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> metarStations() { throw new UnsupportedOperationException(); }
    @Override
    public String metnoLicense() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> sources() { throw new UnsupportedOperationException(); }
    @Override
    public FioUnit units() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFioFlag fromJson(Json json) {
    ImmutableFioFlag.Builder builder = ImmutableFioFlag.builder();
    if (json.darkskyUnavailable != null) {
      builder.darkskyUnavailable(json.darkskyUnavailable);
    }
    if (json.darkskyStations != null) {
      builder.addAllDarkskyStations(json.darkskyStations);
    }
    if (json.datapointStations != null) {
      builder.addAllDatapointStations(json.datapointStations);
    }
    if (json.isdStations != null) {
      builder.addAllIsdStations(json.isdStations);
    }
    if (json.lampStations != null) {
      builder.addAllLampStations(json.lampStations);
    }
    if (json.metarStations != null) {
      builder.addAllMetarStations(json.metarStations);
    }
    if (json.metnoLicense != null) {
      builder.metnoLicense(json.metnoLicense);
    }
    if (json.sources != null) {
      builder.addAllSources(json.sources);
    }
    if (json.units != null) {
      builder.units(json.units);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FioFlag} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FioFlag instance
   */
  public static ImmutableFioFlag copyOf(FioFlag instance) {
    if (instance instanceof ImmutableFioFlag) {
      return (ImmutableFioFlag) instance;
    }
    return ImmutableFioFlag.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFioFlag ImmutableFioFlag}.
   * @return A new ImmutableFioFlag builder
   */
  public static ImmutableFioFlag.Builder builder() {
    return new ImmutableFioFlag.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFioFlag ImmutableFioFlag}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Object darkskyUnavailable;
    private List<String> darkskyStations = new ArrayList<String>();
    private List<String> datapointStations = new ArrayList<String>();
    private List<String> isdStations = new ArrayList<String>();
    private List<String> lampStations = new ArrayList<String>();
    private List<String> metarStations = new ArrayList<String>();
    private String metnoLicense;
    private List<String> sources = new ArrayList<String>();
    private FioUnit units;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FioFlag} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FioFlag instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Object darkskyUnavailableValue = instance.darkskyUnavailable();
      if (darkskyUnavailableValue != null) {
        darkskyUnavailable(darkskyUnavailableValue);
      }
      addAllDarkskyStations(instance.darkskyStations());
      addAllDatapointStations(instance.datapointStations());
      addAllIsdStations(instance.isdStations());
      addAllLampStations(instance.lampStations());
      addAllMetarStations(instance.metarStations());
      @Nullable String metnoLicenseValue = instance.metnoLicense();
      if (metnoLicenseValue != null) {
        metnoLicense(metnoLicenseValue);
      }
      addAllSources(instance.sources());
      @Nullable FioUnit unitsValue = instance.units();
      if (unitsValue != null) {
        units(unitsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link FioFlag#darkskyUnavailable() darkskyUnavailable} attribute.
     * @param darkskyUnavailable The value for darkskyUnavailable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder darkskyUnavailable(@Nullable Object darkskyUnavailable) {
      this.darkskyUnavailable = darkskyUnavailable;
      return this;
    }

    /**
     * Adds one element to {@link FioFlag#darkskyStations() darkskyStations} list.
     * @param element A darkskyStations element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDarkskyStations(String element) {
      this.darkskyStations.add(Objects.requireNonNull(element, "darkskyStations element"));
      return this;
    }

    /**
     * Adds elements to {@link FioFlag#darkskyStations() darkskyStations} list.
     * @param elements An array of darkskyStations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDarkskyStations(String... elements) {
      for (String element : elements) {
        this.darkskyStations.add(Objects.requireNonNull(element, "darkskyStations element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link FioFlag#darkskyStations() darkskyStations} list.
     * @param elements An iterable of darkskyStations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder darkskyStations(Iterable<String> elements) {
      this.darkskyStations.clear();
      return addAllDarkskyStations(elements);
    }

    /**
     * Adds elements to {@link FioFlag#darkskyStations() darkskyStations} list.
     * @param elements An iterable of darkskyStations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDarkskyStations(Iterable<String> elements) {
      for (String element : elements) {
        this.darkskyStations.add(Objects.requireNonNull(element, "darkskyStations element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link FioFlag#datapointStations() datapointStations} list.
     * @param element A datapointStations element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDatapointStations(String element) {
      this.datapointStations.add(Objects.requireNonNull(element, "datapointStations element"));
      return this;
    }

    /**
     * Adds elements to {@link FioFlag#datapointStations() datapointStations} list.
     * @param elements An array of datapointStations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDatapointStations(String... elements) {
      for (String element : elements) {
        this.datapointStations.add(Objects.requireNonNull(element, "datapointStations element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link FioFlag#datapointStations() datapointStations} list.
     * @param elements An iterable of datapointStations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder datapointStations(Iterable<String> elements) {
      this.datapointStations.clear();
      return addAllDatapointStations(elements);
    }

    /**
     * Adds elements to {@link FioFlag#datapointStations() datapointStations} list.
     * @param elements An iterable of datapointStations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDatapointStations(Iterable<String> elements) {
      for (String element : elements) {
        this.datapointStations.add(Objects.requireNonNull(element, "datapointStations element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link FioFlag#isdStations() isdStations} list.
     * @param element A isdStations element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addIsdStations(String element) {
      this.isdStations.add(Objects.requireNonNull(element, "isdStations element"));
      return this;
    }

    /**
     * Adds elements to {@link FioFlag#isdStations() isdStations} list.
     * @param elements An array of isdStations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addIsdStations(String... elements) {
      for (String element : elements) {
        this.isdStations.add(Objects.requireNonNull(element, "isdStations element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link FioFlag#isdStations() isdStations} list.
     * @param elements An iterable of isdStations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isdStations(Iterable<String> elements) {
      this.isdStations.clear();
      return addAllIsdStations(elements);
    }

    /**
     * Adds elements to {@link FioFlag#isdStations() isdStations} list.
     * @param elements An iterable of isdStations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllIsdStations(Iterable<String> elements) {
      for (String element : elements) {
        this.isdStations.add(Objects.requireNonNull(element, "isdStations element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link FioFlag#lampStations() lampStations} list.
     * @param element A lampStations element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLampStations(String element) {
      this.lampStations.add(Objects.requireNonNull(element, "lampStations element"));
      return this;
    }

    /**
     * Adds elements to {@link FioFlag#lampStations() lampStations} list.
     * @param elements An array of lampStations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLampStations(String... elements) {
      for (String element : elements) {
        this.lampStations.add(Objects.requireNonNull(element, "lampStations element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link FioFlag#lampStations() lampStations} list.
     * @param elements An iterable of lampStations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lampStations(Iterable<String> elements) {
      this.lampStations.clear();
      return addAllLampStations(elements);
    }

    /**
     * Adds elements to {@link FioFlag#lampStations() lampStations} list.
     * @param elements An iterable of lampStations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllLampStations(Iterable<String> elements) {
      for (String element : elements) {
        this.lampStations.add(Objects.requireNonNull(element, "lampStations element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link FioFlag#metarStations() metarStations} list.
     * @param element A metarStations element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMetarStations(String element) {
      this.metarStations.add(Objects.requireNonNull(element, "metarStations element"));
      return this;
    }

    /**
     * Adds elements to {@link FioFlag#metarStations() metarStations} list.
     * @param elements An array of metarStations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMetarStations(String... elements) {
      for (String element : elements) {
        this.metarStations.add(Objects.requireNonNull(element, "metarStations element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link FioFlag#metarStations() metarStations} list.
     * @param elements An iterable of metarStations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metarStations(Iterable<String> elements) {
      this.metarStations.clear();
      return addAllMetarStations(elements);
    }

    /**
     * Adds elements to {@link FioFlag#metarStations() metarStations} list.
     * @param elements An iterable of metarStations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMetarStations(Iterable<String> elements) {
      for (String element : elements) {
        this.metarStations.add(Objects.requireNonNull(element, "metarStations element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link FioFlag#metnoLicense() metnoLicense} attribute.
     * @param metnoLicense The value for metnoLicense (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metnoLicense(@Nullable String metnoLicense) {
      this.metnoLicense = metnoLicense;
      return this;
    }

    /**
     * Adds one element to {@link FioFlag#sources() sources} list.
     * @param element A sources element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSources(String element) {
      this.sources.add(Objects.requireNonNull(element, "sources element"));
      return this;
    }

    /**
     * Adds elements to {@link FioFlag#sources() sources} list.
     * @param elements An array of sources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSources(String... elements) {
      for (String element : elements) {
        this.sources.add(Objects.requireNonNull(element, "sources element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link FioFlag#sources() sources} list.
     * @param elements An iterable of sources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sources(Iterable<String> elements) {
      this.sources.clear();
      return addAllSources(elements);
    }

    /**
     * Adds elements to {@link FioFlag#sources() sources} list.
     * @param elements An iterable of sources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSources(Iterable<String> elements) {
      for (String element : elements) {
        this.sources.add(Objects.requireNonNull(element, "sources element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link FioFlag#units() units} attribute.
     * @param units The value for units (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder units(@Nullable FioUnit units) {
      this.units = units;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFioFlag ImmutableFioFlag}.
     * @return An immutable instance of FioFlag
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFioFlag build() {
      return new ImmutableFioFlag(
          darkskyUnavailable,
          createUnmodifiableList(true, darkskyStations),
          createUnmodifiableList(true, datapointStations),
          createUnmodifiableList(true, isdStations),
          createUnmodifiableList(true, lampStations),
          createUnmodifiableList(true, metarStations),
          metnoLicense,
          createUnmodifiableList(true, sources),
          units);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
