/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.forcastio.model;

import ch.rasc.forcastio.model.FioAlert;
import ch.rasc.forcastio.model.FioDataBlock;
import ch.rasc.forcastio.model.FioDataPoint;
import ch.rasc.forcastio.model.FioFlag;
import ch.rasc.forcastio.model.FioResponse;
import ch.rasc.forcastio.model.Nullable;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableFioResponse
implements FioResponse {
    private final BigDecimal latitude;
    private final BigDecimal longitude;
    private final String timezone;
    private final int offset;
    @Nullable
    private final FioDataPoint currently;
    @Nullable
    private final FioDataBlock minutely;
    @Nullable
    private final FioDataBlock hourly;
    @Nullable
    private final FioDataBlock daily;
    private final List<FioAlert> alerts;
    private final FioFlag flags;

    private ImmutableFioResponse(BigDecimal latitude, BigDecimal longitude, String timezone, int offset, @Nullable FioDataPoint currently, @Nullable FioDataBlock minutely, @Nullable FioDataBlock hourly, @Nullable FioDataBlock daily, List<FioAlert> alerts, FioFlag flags) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.timezone = timezone;
        this.offset = offset;
        this.currently = currently;
        this.minutely = minutely;
        this.hourly = hourly;
        this.daily = daily;
        this.alerts = alerts;
        this.flags = flags;
    }

    @Override
    @JsonProperty(value="latitude")
    public BigDecimal latitude() {
        return this.latitude;
    }

    @Override
    @JsonProperty(value="longitude")
    public BigDecimal longitude() {
        return this.longitude;
    }

    @Override
    @JsonProperty(value="timezone")
    public String timezone() {
        return this.timezone;
    }

    @Override
    @JsonProperty(value="offset")
    public int offset() {
        return this.offset;
    }

    @Override
    @JsonProperty(value="currently")
    @Nullable
    public FioDataPoint currently() {
        return this.currently;
    }

    @Override
    @JsonProperty(value="minutely")
    @Nullable
    public FioDataBlock minutely() {
        return this.minutely;
    }

    @Override
    @JsonProperty(value="hourly")
    @Nullable
    public FioDataBlock hourly() {
        return this.hourly;
    }

    @Override
    @JsonProperty(value="daily")
    @Nullable
    public FioDataBlock daily() {
        return this.daily;
    }

    @Override
    @JsonProperty(value="alerts")
    public List<FioAlert> alerts() {
        return this.alerts;
    }

    @Override
    @JsonProperty(value="flags")
    public FioFlag flags() {
        return this.flags;
    }

    public final ImmutableFioResponse withLatitude(BigDecimal value) {
        if (this.latitude == value) {
            return this;
        }
        BigDecimal newValue = Objects.requireNonNull(value, "latitude");
        return new ImmutableFioResponse(newValue, this.longitude, this.timezone, this.offset, this.currently, this.minutely, this.hourly, this.daily, this.alerts, this.flags);
    }

    public final ImmutableFioResponse withLongitude(BigDecimal value) {
        if (this.longitude == value) {
            return this;
        }
        BigDecimal newValue = Objects.requireNonNull(value, "longitude");
        return new ImmutableFioResponse(this.latitude, newValue, this.timezone, this.offset, this.currently, this.minutely, this.hourly, this.daily, this.alerts, this.flags);
    }

    public final ImmutableFioResponse withTimezone(String value) {
        if (this.timezone.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "timezone");
        return new ImmutableFioResponse(this.latitude, this.longitude, newValue, this.offset, this.currently, this.minutely, this.hourly, this.daily, this.alerts, this.flags);
    }

    public final ImmutableFioResponse withOffset(int value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableFioResponse(this.latitude, this.longitude, this.timezone, value, this.currently, this.minutely, this.hourly, this.daily, this.alerts, this.flags);
    }

    public final ImmutableFioResponse withCurrently(@Nullable FioDataPoint value) {
        if (this.currently == value) {
            return this;
        }
        return new ImmutableFioResponse(this.latitude, this.longitude, this.timezone, this.offset, value, this.minutely, this.hourly, this.daily, this.alerts, this.flags);
    }

    public final ImmutableFioResponse withMinutely(@Nullable FioDataBlock value) {
        if (this.minutely == value) {
            return this;
        }
        return new ImmutableFioResponse(this.latitude, this.longitude, this.timezone, this.offset, this.currently, value, this.hourly, this.daily, this.alerts, this.flags);
    }

    public final ImmutableFioResponse withHourly(@Nullable FioDataBlock value) {
        if (this.hourly == value) {
            return this;
        }
        return new ImmutableFioResponse(this.latitude, this.longitude, this.timezone, this.offset, this.currently, this.minutely, value, this.daily, this.alerts, this.flags);
    }

    public final ImmutableFioResponse withDaily(@Nullable FioDataBlock value) {
        if (this.daily == value) {
            return this;
        }
        return new ImmutableFioResponse(this.latitude, this.longitude, this.timezone, this.offset, this.currently, this.minutely, this.hourly, value, this.alerts, this.flags);
    }

    public final ImmutableFioResponse withAlerts(FioAlert ... elements) {
        List<FioAlert> newValue = ImmutableFioResponse.createUnmodifiableList(false, ImmutableFioResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableFioResponse(this.latitude, this.longitude, this.timezone, this.offset, this.currently, this.minutely, this.hourly, this.daily, newValue, this.flags);
    }

    public final ImmutableFioResponse withAlerts(Iterable<? extends FioAlert> elements) {
        if (this.alerts == elements) {
            return this;
        }
        List<FioAlert> newValue = ImmutableFioResponse.createUnmodifiableList(false, ImmutableFioResponse.createSafeList(elements, true, false));
        return new ImmutableFioResponse(this.latitude, this.longitude, this.timezone, this.offset, this.currently, this.minutely, this.hourly, this.daily, newValue, this.flags);
    }

    public final ImmutableFioResponse withFlags(FioFlag value) {
        if (this.flags == value) {
            return this;
        }
        FioFlag newValue = Objects.requireNonNull(value, "flags");
        return new ImmutableFioResponse(this.latitude, this.longitude, this.timezone, this.offset, this.currently, this.minutely, this.hourly, this.daily, this.alerts, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFioResponse && this.equalTo((ImmutableFioResponse)another);
    }

    private boolean equalTo(ImmutableFioResponse another) {
        return this.latitude.equals(another.latitude) && this.longitude.equals(another.longitude) && this.timezone.equals(another.timezone) && this.offset == another.offset && Objects.equals(this.currently, another.currently) && Objects.equals(this.minutely, another.minutely) && Objects.equals(this.hourly, another.hourly) && Objects.equals(this.daily, another.daily) && this.alerts.equals(another.alerts) && this.flags.equals(another.flags);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.latitude.hashCode();
        h = h * 17 + this.longitude.hashCode();
        h = h * 17 + this.timezone.hashCode();
        h = h * 17 + this.offset;
        h = h * 17 + Objects.hashCode(this.currently);
        h = h * 17 + Objects.hashCode(this.minutely);
        h = h * 17 + Objects.hashCode(this.hourly);
        h = h * 17 + Objects.hashCode(this.daily);
        h = h * 17 + this.alerts.hashCode();
        h = h * 17 + this.flags.hashCode();
        return h;
    }

    public String toString() {
        return "FioResponse{latitude=" + this.latitude + ", longitude=" + this.longitude + ", timezone=" + this.timezone + ", offset=" + this.offset + ", currently=" + this.currently + ", minutely=" + this.minutely + ", hourly=" + this.hourly + ", daily=" + this.daily + ", alerts=" + this.alerts + ", flags=" + this.flags + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFioResponse fromJson(Json json) {
        Builder builder = ImmutableFioResponse.builder();
        if (json.latitude != null) {
            builder.latitude(json.latitude);
        }
        if (json.longitude != null) {
            builder.longitude(json.longitude);
        }
        if (json.timezone != null) {
            builder.timezone(json.timezone);
        }
        if (json.offsetIsSet) {
            builder.offset(json.offset);
        }
        if (json.currently != null) {
            builder.currently(json.currently);
        }
        if (json.minutely != null) {
            builder.minutely(json.minutely);
        }
        if (json.hourly != null) {
            builder.hourly(json.hourly);
        }
        if (json.daily != null) {
            builder.daily(json.daily);
        }
        if (json.alerts != null) {
            builder.addAllAlerts(json.alerts);
        }
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        return builder.build();
    }

    public static ImmutableFioResponse copyOf(FioResponse instance) {
        if (instance instanceof ImmutableFioResponse) {
            return (ImmutableFioResponse)instance;
        }
        return ImmutableFioResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_LATITUDE = 1L;
        private static final long INIT_BIT_LONGITUDE = 2L;
        private static final long INIT_BIT_TIMEZONE = 4L;
        private static final long INIT_BIT_OFFSET = 8L;
        private static final long INIT_BIT_FLAGS = 16L;
        private long initBits = 31L;
        private BigDecimal latitude;
        private BigDecimal longitude;
        private String timezone;
        private int offset;
        private FioDataPoint currently;
        private FioDataBlock minutely;
        private FioDataBlock hourly;
        private FioDataBlock daily;
        private List<FioAlert> alerts = new ArrayList<FioAlert>();
        private FioFlag flags;

        private Builder() {
        }

        public final Builder from(FioResponse instance) {
            FioDataBlock dailyValue;
            FioDataBlock hourlyValue;
            FioDataBlock minutelyValue;
            Objects.requireNonNull(instance, "instance");
            this.latitude(instance.latitude());
            this.longitude(instance.longitude());
            this.timezone(instance.timezone());
            this.offset(instance.offset());
            FioDataPoint currentlyValue = instance.currently();
            if (currentlyValue != null) {
                this.currently(currentlyValue);
            }
            if ((minutelyValue = instance.minutely()) != null) {
                this.minutely(minutelyValue);
            }
            if ((hourlyValue = instance.hourly()) != null) {
                this.hourly(hourlyValue);
            }
            if ((dailyValue = instance.daily()) != null) {
                this.daily(dailyValue);
            }
            this.addAllAlerts(instance.alerts());
            this.flags(instance.flags());
            return this;
        }

        public final Builder latitude(BigDecimal latitude) {
            this.latitude = Objects.requireNonNull(latitude, "latitude");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder longitude(BigDecimal longitude) {
            this.longitude = Objects.requireNonNull(longitude, "longitude");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder timezone(String timezone) {
            this.timezone = Objects.requireNonNull(timezone, "timezone");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder offset(int offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder currently(@Nullable FioDataPoint currently) {
            this.currently = currently;
            return this;
        }

        public final Builder minutely(@Nullable FioDataBlock minutely) {
            this.minutely = minutely;
            return this;
        }

        public final Builder hourly(@Nullable FioDataBlock hourly) {
            this.hourly = hourly;
            return this;
        }

        public final Builder daily(@Nullable FioDataBlock daily) {
            this.daily = daily;
            return this;
        }

        public final Builder addAlerts(FioAlert element) {
            this.alerts.add(Objects.requireNonNull(element, "alerts element"));
            return this;
        }

        public final Builder addAlerts(FioAlert ... elements) {
            for (FioAlert element : elements) {
                this.alerts.add(Objects.requireNonNull(element, "alerts element"));
            }
            return this;
        }

        public final Builder alerts(Iterable<? extends FioAlert> elements) {
            this.alerts.clear();
            return this.addAllAlerts(elements);
        }

        public final Builder addAllAlerts(Iterable<? extends FioAlert> elements) {
            for (FioAlert fioAlert : elements) {
                this.alerts.add(Objects.requireNonNull(fioAlert, "alerts element"));
            }
            return this;
        }

        public final Builder flags(FioFlag flags) {
            this.flags = Objects.requireNonNull(flags, "flags");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableFioResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFioResponse(this.latitude, this.longitude, this.timezone, this.offset, this.currently, this.minutely, this.hourly, this.daily, ImmutableFioResponse.createUnmodifiableList(true, this.alerts), this.flags);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("latitude");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("longitude");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("timezone");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("offset");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("flags");
            }
            return "Cannot build FioResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements FioResponse {
        BigDecimal latitude;
        BigDecimal longitude;
        String timezone;
        int offset;
        boolean offsetIsSet;
        FioDataPoint currently;
        FioDataBlock minutely;
        FioDataBlock hourly;
        FioDataBlock daily;
        List<FioAlert> alerts = Collections.emptyList();
        FioFlag flags;

        Json() {
        }

        @JsonProperty(value="latitude")
        public void setLatitude(BigDecimal latitude) {
            this.latitude = latitude;
        }

        @JsonProperty(value="longitude")
        public void setLongitude(BigDecimal longitude) {
            this.longitude = longitude;
        }

        @JsonProperty(value="timezone")
        public void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @JsonProperty(value="offset")
        public void setOffset(int offset) {
            this.offset = offset;
            this.offsetIsSet = true;
        }

        @JsonProperty(value="currently")
        public void setCurrently(@Nullable FioDataPoint currently) {
            this.currently = currently;
        }

        @JsonProperty(value="minutely")
        public void setMinutely(@Nullable FioDataBlock minutely) {
            this.minutely = minutely;
        }

        @JsonProperty(value="hourly")
        public void setHourly(@Nullable FioDataBlock hourly) {
            this.hourly = hourly;
        }

        @JsonProperty(value="daily")
        public void setDaily(@Nullable FioDataBlock daily) {
            this.daily = daily;
        }

        @JsonProperty(value="alerts")
        public void setAlerts(List<FioAlert> alerts) {
            this.alerts = alerts;
        }

        @JsonProperty(value="flags")
        public void setFlags(FioFlag flags) {
            this.flags = flags;
        }

        @Override
        public BigDecimal latitude() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal longitude() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String timezone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int offset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FioDataPoint currently() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FioDataBlock minutely() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FioDataBlock hourly() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FioDataBlock daily() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<FioAlert> alerts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FioFlag flags() {
            throw new UnsupportedOperationException();
        }
    }
}

