/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.jcentserverclient;

import ch.rasc.jcentserverclient.ApiError;
import ch.rasc.jcentserverclient.ApiException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Response;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.InputStream;

public class ApiErrorDecoder
implements ErrorDecoder {
    private final ErrorDecoder.Default delegate = new ErrorDecoder.Default();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public Exception decode(String methodKey, Response response) {
        ApiError error;
        String responseBody;
        block23: {
            responseBody = null;
            error = null;
            try (Response.Body body = response.body();
                 InputStream inputStream = body.asInputStream();){
                responseBody = new String(inputStream.readAllBytes());
                if (responseBody.trim().isEmpty()) break block23;
                JsonFactory factory = this.objectMapper.getFactory();
                try (JsonParser parser = factory.createParser(responseBody);){
                    if (parser.nextToken() != JsonToken.START_OBJECT) break block23;
                    while (parser.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = parser.currentName();
                        if ("error".equals(fieldName)) {
                            parser.nextToken();
                            error = (ApiError)this.objectMapper.readValue(parser, ApiError.class);
                            break;
                        }
                        parser.skipChildren();
                    }
                }
            }
            catch (IOException e) {
                return this.delegate.decode(methodKey, response);
            }
        }
        if (error != null) {
            return new ApiException(error, responseBody, response.status());
        }
        return this.delegate.decode(methodKey, response);
    }
}

