/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.jcentserverclient;

import ch.rasc.jcentserverclient.ApiError;

public class ApiException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final ApiError error;
    private final String responseBody;
    private final int statusCode;

    public ApiException(ApiError error, String responseBody, int statusCode) {
        super(ApiException.formatMessage(error));
        this.error = error;
        this.responseBody = responseBody;
        this.statusCode = statusCode;
    }

    private static String formatMessage(ApiError error) {
        if (error != null && error.getMessage() != null) {
            return String.format("Centrifugo API error (code %d): %s", error.getCode(), error.getMessage());
        }
        return "Centrifugo API error";
    }

    public ApiError getError() {
        return this.error;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Integer getErrorCode() {
        return this.error != null ? this.error.getCode() : null;
    }

    public String getErrorMessage() {
        return this.error != null ? this.error.getMessage() : null;
    }
}

