/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.jcentserverclient;

import ch.rasc.jcentserverclient.ApiKeyRequestInterceptor;
import ch.rasc.jcentserverclient.Configuration;
import ch.rasc.jcentserverclient.clients.BatchClient;
import ch.rasc.jcentserverclient.clients.ChannelsClient;
import ch.rasc.jcentserverclient.clients.ConnectionClient;
import ch.rasc.jcentserverclient.clients.HistoryClient;
import ch.rasc.jcentserverclient.clients.PresenceClient;
import ch.rasc.jcentserverclient.clients.PublicationClient;
import ch.rasc.jcentserverclient.clients.StatsClient;
import ch.rasc.jcentserverclient.clients.TokenClient;
import ch.rasc.jcentserverclient.clients.UserBlockClient;
import feign.Feign;
import feign.RequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class CentrifugoServerApiClient {
    private PublicationClient publication;
    private ConnectionClient connection;
    private HistoryClient history;
    private PresenceClient presence;
    private StatsClient stats;
    private ChannelsClient channels;
    private UserBlockClient userBlock;
    public TokenClient token;
    private BatchClient batch;

    public static CentrifugoServerApiClient create(Function<Configuration.Builder, Configuration.Builder> fn) {
        return CentrifugoServerApiClient.create(fn.apply(Configuration.builder()).build());
    }

    public static CentrifugoServerApiClient create(Configuration configuration) {
        CentrifugoServerApiClient client = new CentrifugoServerApiClient();
        JacksonDecoder jsonDecoder = new JacksonDecoder();
        JacksonEncoder jsonEncoder = new JacksonEncoder();
        ArrayList<RequestInterceptor> interceptors = new ArrayList<RequestInterceptor>();
        if (configuration.additionalRequestInterceptor() != null) {
            interceptors.add(configuration.additionalRequestInterceptor());
        }
        if (configuration.apiKey() != null && !configuration.apiKey().isBlank()) {
            interceptors.add(new ApiKeyRequestInterceptor(configuration.apiKey()));
        }
        String baseUrl = configuration.baseUrl();
        client.publication = (PublicationClient)CentrifugoServerApiClient.jsonClientBuilder(configuration, jsonDecoder, jsonEncoder, interceptors).target(PublicationClient.class, baseUrl);
        client.connection = (ConnectionClient)CentrifugoServerApiClient.jsonClientBuilder(configuration, jsonDecoder, jsonEncoder, interceptors).target(ConnectionClient.class, baseUrl);
        client.history = (HistoryClient)CentrifugoServerApiClient.jsonClientBuilder(configuration, jsonDecoder, jsonEncoder, interceptors).target(HistoryClient.class, baseUrl);
        client.presence = (PresenceClient)CentrifugoServerApiClient.jsonClientBuilder(configuration, jsonDecoder, jsonEncoder, interceptors).target(PresenceClient.class, baseUrl);
        client.stats = (StatsClient)CentrifugoServerApiClient.jsonClientBuilder(configuration, jsonDecoder, jsonEncoder, interceptors).target(StatsClient.class, baseUrl);
        client.channels = (ChannelsClient)CentrifugoServerApiClient.jsonClientBuilder(configuration, jsonDecoder, jsonEncoder, interceptors).target(ChannelsClient.class, baseUrl);
        client.userBlock = (UserBlockClient)CentrifugoServerApiClient.jsonClientBuilder(configuration, jsonDecoder, jsonEncoder, interceptors).target(UserBlockClient.class, baseUrl);
        client.token = (TokenClient)CentrifugoServerApiClient.jsonClientBuilder(configuration, jsonDecoder, jsonEncoder, interceptors).target(TokenClient.class, baseUrl);
        client.batch = (BatchClient)CentrifugoServerApiClient.jsonClientBuilder(configuration, jsonDecoder, jsonEncoder, interceptors).target(BatchClient.class, baseUrl);
        return client;
    }

    public PublicationClient publication() {
        return this.publication;
    }

    public ConnectionClient connection() {
        return this.connection;
    }

    public HistoryClient history() {
        return this.history;
    }

    public PresenceClient presence() {
        return this.presence;
    }

    public StatsClient stats() {
        return this.stats;
    }

    public ChannelsClient channels() {
        return this.channels;
    }

    public UserBlockClient userBlock() {
        return this.userBlock;
    }

    public TokenClient token() {
        return this.token;
    }

    public BatchClient batch() {
        return this.batch;
    }

    private static Feign.Builder jsonClientBuilder(Configuration configuration, JacksonDecoder jsonDecoder, JacksonEncoder jsonEncoder, List<RequestInterceptor> interceptors) {
        return Feign.builder().client(configuration.client()).errorDecoder(configuration.errorDecoder()).retryer(configuration.retryer()).options(configuration.feignOptions()).logger(configuration.logger()).logLevel(configuration.logLevel()).decoder((Decoder)jsonDecoder).encoder((Encoder)jsonEncoder).requestInterceptors(interceptors);
    }
}

