/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.jcentserverclient;

import ch.rasc.jcentserverclient.ApiErrorDecoder;
import feign.Client;
import feign.Logger;
import feign.Request;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.codec.ErrorDecoder;
import feign.http2client.Http2Client;
import feign.slf4j.Slf4jLogger;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class Configuration {
    private final String apiKey;
    private final String baseUrl;
    private final Client client;
    private final Retryer retryer;
    private final Request.Options feignOptions;
    private final Logger logger;
    private final ErrorDecoder errorDecoder;
    private final RequestInterceptor additionalRequestInterceptor;
    private final Logger.Level logLevel;

    private Configuration(Builder builder) {
        if (builder.apiKey == null) {
            throw new IllegalArgumentException("apiKey must not be null");
        }
        this.apiKey = builder.apiKey;
        this.baseUrl = Objects.requireNonNullElse(builder.baseUrl, "http://localhost:8000/api");
        this.client = (Client)Objects.requireNonNullElse(builder.client, new Http2Client());
        this.retryer = (Retryer)Objects.requireNonNullElse(builder.retryer, new Retryer.Default(TimeUnit.SECONDS.toMillis(2L), TimeUnit.SECONDS.toMillis(2L), 3));
        this.feignOptions = Objects.requireNonNullElse(builder.feignOptions, new Request.Options(10L, TimeUnit.SECONDS, 60L, TimeUnit.SECONDS, true));
        this.logger = (Logger)Objects.requireNonNullElse(builder.logger, new Slf4jLogger());
        this.errorDecoder = Objects.requireNonNullElse(builder.errorDecoder, new ApiErrorDecoder());
        this.additionalRequestInterceptor = builder.additionalRequestInterceptor;
        this.logLevel = Objects.requireNonNullElse(builder.logLevel, Logger.Level.NONE);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String apiKey() {
        return this.apiKey;
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public Client client() {
        return this.client;
    }

    public Retryer retryer() {
        return this.retryer;
    }

    public Request.Options feignOptions() {
        return this.feignOptions;
    }

    public Logger logger() {
        return this.logger;
    }

    public ErrorDecoder errorDecoder() {
        return this.errorDecoder;
    }

    public RequestInterceptor additionalRequestInterceptor() {
        return this.additionalRequestInterceptor;
    }

    public Logger.Level logLevel() {
        return this.logLevel;
    }

    public static final class Builder {
        private String apiKey;
        private String baseUrl;
        private Client client;
        private Retryer retryer;
        private Request.Options feignOptions;
        private Logger logger;
        private ErrorDecoder errorDecoder;
        private RequestInterceptor additionalRequestInterceptor;
        private Logger.Level logLevel;

        private Builder() {
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder client(Client client) {
            this.client = client;
            return this;
        }

        public Builder retryer(Retryer retryer) {
            this.retryer = retryer;
            return this;
        }

        public Builder feignOptions(Request.Options feignOptions) {
            this.feignOptions = feignOptions;
            return this;
        }

        public Builder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder errorDecoder(ErrorDecoder errorDecoder) {
            this.errorDecoder = errorDecoder;
            return this;
        }

        public Builder additionalRequestInterceptor(RequestInterceptor additionalRequestInterceptor) {
            this.additionalRequestInterceptor = additionalRequestInterceptor;
            return this;
        }

        public Builder logLevel(Logger.Level logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Configuration build() {
            return new Configuration(this);
        }
    }
}

