/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.jcentserverclient.example;

import ch.rasc.jcentserverclient.ApiException;
import ch.rasc.jcentserverclient.CentrifugoServerApiClient;
import ch.rasc.jcentserverclient.Configuration;
import ch.rasc.jcentserverclient.models.BroadcastRequest;
import ch.rasc.jcentserverclient.models.BroadcastResponse;
import ch.rasc.jcentserverclient.models.ChannelsResponse;
import ch.rasc.jcentserverclient.models.DisconnectRequest;
import ch.rasc.jcentserverclient.models.DisconnectResponse;
import ch.rasc.jcentserverclient.models.PublishRequest;
import ch.rasc.jcentserverclient.models.PublishResponse;
import ch.rasc.jcentserverclient.models.SubscribeRequest;
import ch.rasc.jcentserverclient.models.SubscribeResponse;
import ch.rasc.jcentserverclient.models.UnsubscribeRequest;
import ch.rasc.jcentserverclient.models.UnsubscribeResponse;
import java.util.Arrays;
import java.util.HashMap;

public class ClientExample {
    public static void main(String[] args) {
        String apiKey = "1BdKfKI_r6Krx6OaB65d62DrBUBGeILvADkOeWQRCpkawv8gzogkasgzlIuj6_hD99hZxvTbueJdjUU6PD7dkg";
        CentrifugoServerApiClient client = CentrifugoServerApiClient.create(config -> config.apiKey(apiKey).baseUrl("http://localhost:8000/api"));
        Configuration configuration = Configuration.builder().apiKey(apiKey).baseUrl("http://localhost:8000/api").build();
        CentrifugoServerApiClient.create(configuration);
        ClientExample.publishExample(client);
        ClientExample.broadcastExample(client);
        ClientExample.subscribeExample(client);
        ClientExample.listChannelsExample(client);
        ClientExample.unsubscribeExample(client);
        ClientExample.disconnectExample(client);
    }

    private static void publishExample(CentrifugoServerApiClient client) {
        System.out.println("=== Publish Example ===");
        HashMap<String, Object> messageData = new HashMap<String, Object>();
        messageData.put("text", "Hello, Centrifugo!");
        messageData.put("timestamp", System.currentTimeMillis());
        PublishRequest publishRequest = PublishRequest.builder().channel("chat:general").data(messageData).build();
        try {
            PublishResponse response = client.publication().publish(publishRequest);
            if (response.hasError()) {
                System.err.println("Publish error: " + response.error().message());
            } else {
                System.out.println("Message published successfully!");
                System.out.println("Offset: " + response.result().offset());
                System.out.println("Epoch: " + response.result().epoch());
            }
        }
        catch (ApiException e) {
            System.err.println("API Exception: " + e.getMessage());
            System.err.println("Error code: " + e.getErrorCode());
        }
    }

    private static void listChannelsExample(CentrifugoServerApiClient client) {
        System.out.println("=== List Channels Example ===");
        try {
            ChannelsResponse response = client.channels().channels();
            if (response.hasError()) {
                System.err.println("List channels error: " + response.error().message());
            } else {
                System.out.println("Channels:");
                response.result().channels().forEach((name, info) -> System.out.println(" - " + name + " (subscribers: " + info.numClients() + ")"));
            }
        }
        catch (ApiException e) {
            System.err.println("API Exception: " + e.getMessage());
        }
    }

    private static void broadcastExample(CentrifugoServerApiClient client) {
        System.out.println("=== Broadcast Example ===");
        HashMap<String, String> broadcastData = new HashMap<String, String>();
        broadcastData.put("announcement", "Server maintenance in 10 minutes");
        broadcastData.put("priority", "high");
        BroadcastRequest broadcastRequest = BroadcastRequest.builder().channels(Arrays.asList("chat:general", "chat:announcements", "notifications")).data(broadcastData).build();
        try {
            BroadcastResponse response = client.publication().broadcast(broadcastRequest);
            if (response.hasError()) {
                System.err.println("Broadcast error: " + response.error().message());
            } else {
                System.out.println("Broadcast sent successfully!");
                System.out.println("Individual responses: " + response.result().responses().size());
                for (PublishResponse r : response.result().responses()) {
                    System.out.println(r);
                }
            }
        }
        catch (ApiException e) {
            System.err.println("API Exception: " + e.getMessage());
        }
    }

    private static void subscribeExample(CentrifugoServerApiClient client) {
        System.out.println("=== Subscribe Example ===");
        SubscribeRequest subscribeRequest = SubscribeRequest.builder().user("user123").channel("personal:user123").build();
        try {
            SubscribeResponse response = client.connection().subscribe(subscribeRequest);
            if (response.hasError()) {
                System.err.println("Subscribe error: " + response.error().message());
            } else {
                System.out.println("User subscribed successfully!");
            }
        }
        catch (ApiException e) {
            System.err.println("API Exception: " + e.getMessage());
        }
    }

    private static void unsubscribeExample(CentrifugoServerApiClient client) {
        System.out.println("=== Unsubscribe Example ===");
        UnsubscribeRequest unsubscribeRequest = UnsubscribeRequest.builder().user("user123").channel("personal:user123").build();
        try {
            UnsubscribeResponse response = client.connection().unsubscribe(unsubscribeRequest);
            if (response.hasError()) {
                System.err.println("Unsubscribe error: " + response.error().message());
            } else {
                System.out.println("User unsubscribed successfully!");
            }
        }
        catch (ApiException e) {
            System.err.println("API Exception: " + e.getMessage());
        }
    }

    private static void disconnectExample(CentrifugoServerApiClient client) {
        System.out.println("=== Disconnect Example ===");
        DisconnectRequest disconnectRequest = DisconnectRequest.builder().user("user123").build();
        try {
            DisconnectResponse response = client.connection().disconnect(disconnectRequest);
            if (response.hasError()) {
                System.err.println("Disconnect error: " + response.error().message());
            } else {
                System.out.println("User disconnected successfully!");
            }
        }
        catch (ApiException e) {
            System.err.println("API Exception: " + e.getMessage());
        }
    }
}

