/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.jcentserverclient.models;

import ch.rasc.jcentserverclient.models.Command;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public record BatchRequest(@JsonProperty(value="commands") List<Command> commands, @JsonProperty(value="parallel") Boolean parallel) {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<Command> commands;
        private Boolean parallel;

        public Builder commands(Command ... commands) {
            if (commands == null || commands.length == 0) {
                throw new IllegalArgumentException("'commands' is required and cannot be null or empty");
            }
            this.commands = List.of(commands);
            return this;
        }

        public Builder commands(List<Command> commands) {
            if (commands == null || commands.isEmpty()) {
                throw new IllegalArgumentException("'commands' is required and cannot be null or empty");
            }
            this.commands = List.copyOf(commands);
            return this;
        }

        public Builder parallel(Boolean parallel) {
            this.parallel = parallel;
            return this;
        }

        public BatchRequest build() {
            return new BatchRequest(this.commands, this.parallel);
        }
    }
}

