/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.jcentserverclient.models;

import ch.rasc.jcentserverclient.models.Disconnect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public record DisconnectRequest(@JsonProperty(value="user") String user, @JsonProperty(value="client") String client, @JsonProperty(value="session") String session, @JsonProperty(value="whitelist") List<String> whitelist, @JsonProperty(value="disconnect") Disconnect disconnect) {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String user;
        private String client;
        private String session;
        private List<String> whitelist;
        private Disconnect disconnect;

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder client(String client) {
            this.client = client;
            return this;
        }

        public Builder session(String session) {
            this.session = session;
            return this;
        }

        public Builder whitelist(List<String> whitelist) {
            this.whitelist = List.copyOf(whitelist);
            return this;
        }

        public Builder whitelist(String ... whitelist) {
            this.whitelist = List.of(whitelist);
            return this;
        }

        public Builder disconnect(Disconnect disconnect) {
            this.disconnect = disconnect;
            return this;
        }

        public DisconnectRequest build() {
            if (this.user == null || this.user.trim().isEmpty()) {
                throw new IllegalArgumentException("'user' is required and cannot be null or empty");
            }
            return new DisconnectRequest(this.user, this.client, this.session, this.whitelist, this.disconnect);
        }
    }
}

