/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.jcentserverclient.models;

import ch.rasc.jcentserverclient.models.StreamPosition;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public record HistoryRequest(@JsonProperty(value="channel") String channel, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="since") StreamPosition since, @JsonProperty(value="reverse") Boolean reverse) {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String channel;
        private Integer limit;
        private StreamPosition since;
        private Boolean reverse;

        public Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder since(StreamPosition since) {
            this.since = since;
            return this;
        }

        public Builder reverse(Boolean reverse) {
            this.reverse = reverse;
            return this;
        }

        public HistoryRequest build() {
            if (this.channel == null || this.channel.trim().isEmpty()) {
                throw new IllegalArgumentException("'channel' is required and cannot be null or empty");
            }
            return new HistoryRequest(this.channel, this.limit, this.since, this.reverse);
        }
    }
}

