/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.jcentserverclient.models;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public record PublishRequest(@JsonProperty(value="channel") String channel, @JsonProperty(value="data") Object data, @JsonProperty(value="b64data") String b64data, @JsonProperty(value="skip_history") Boolean skipHistory, @JsonProperty(value="tags") Map<String, String> tags, @JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="delta") Boolean delta) {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String channel;
        private Object data;
        private String b64data;
        private Boolean skipHistory;
        private Map<String, String> tags;
        private String idempotencyKey;
        private Boolean delta;

        public Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public Builder data(Object data) {
            this.data = data;
            return this;
        }

        public Builder b64data(String b64data) {
            this.b64data = b64data;
            return this;
        }

        public Builder skipHistory(Boolean skipHistory) {
            this.skipHistory = skipHistory;
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder delta(Boolean delta) {
            this.delta = delta;
            return this;
        }

        public PublishRequest build() {
            if (this.channel == null || this.channel.trim().isEmpty()) {
                throw new IllegalArgumentException("'channel' is required and cannot be null or empty");
            }
            if (this.data == null) {
                throw new IllegalArgumentException("'data' is required and cannot be null");
            }
            return new PublishRequest(this.channel, this.data, this.b64data, this.skipHistory, this.tags, this.idempotencyKey, this.delta);
        }
    }
}

