/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.jcentserverclient.models;

import ch.rasc.jcentserverclient.models.StreamPosition;
import ch.rasc.jcentserverclient.models.SubscribeOptionOverride;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public record SubscribeRequest(@JsonProperty(value="channel") String channel, @JsonProperty(value="user") String user, @JsonProperty(value="expire_at") Long expireAt, @JsonProperty(value="info") Object info, @JsonProperty(value="b64info") String b64info, @JsonProperty(value="client") String client, @JsonProperty(value="data") Object data, @JsonProperty(value="b64data") String b64data, @JsonProperty(value="recover_since") StreamPosition recoverSince, @JsonProperty(value="override") SubscribeOptionOverride override, @JsonProperty(value="session") String session) {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String channel;
        private String user;
        private Long expireAt;
        private Object info;
        private String b64info;
        private String client;
        private Object data;
        private String b64data;
        private StreamPosition recoverSince;
        private SubscribeOptionOverride override;
        private String session;

        public Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder expireAt(Long expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        public Builder info(Object info) {
            this.info = info;
            return this;
        }

        public Builder b64info(String b64info) {
            this.b64info = b64info;
            return this;
        }

        public Builder client(String client) {
            this.client = client;
            return this;
        }

        public Builder data(Object data) {
            this.data = data;
            return this;
        }

        public Builder b64data(String b64data) {
            this.b64data = b64data;
            return this;
        }

        public Builder recoverSince(StreamPosition recoverSince) {
            this.recoverSince = recoverSince;
            return this;
        }

        public Builder override(SubscribeOptionOverride override) {
            this.override = override;
            return this;
        }

        public Builder session(String session) {
            this.session = session;
            return this;
        }

        public SubscribeRequest build() {
            if (this.user == null || this.user.trim().isEmpty()) {
                throw new IllegalArgumentException("'user' is required and cannot be null or empty");
            }
            if (this.channel == null || this.channel.trim().isEmpty()) {
                throw new IllegalArgumentException("'channel' is required and cannot be null or empty");
            }
            return new SubscribeRequest(this.channel, this.user, this.expireAt, this.info, this.b64info, this.client, this.data, this.b64data, this.recoverSince, this.override, this.session);
        }
    }
}

