/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.jcentserverclient.models;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public record UnsubscribeRequest(@JsonProperty(value="user") String user, @JsonProperty(value="channel") String channel, @JsonProperty(value="client") String client, @JsonProperty(value="session") String session) {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String user;
        private String channel;
        private String client;
        private String session;

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public Builder client(String client) {
            this.client = client;
            return this;
        }

        public Builder session(String session) {
            this.session = session;
            return this;
        }

        public UnsubscribeRequest build() {
            if (this.user == null || this.user.trim().isEmpty()) {
                throw new IllegalArgumentException("'user' is required and cannot be null or empty");
            }
            if (this.channel == null || this.channel.trim().isEmpty()) {
                throw new IllegalArgumentException("'channel' is required and cannot be null or empty");
            }
            return new UnsubscribeRequest(this.user, this.channel, this.client, this.session);
        }
    }
}

