/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.piwik.tracking;

import ch.rasc.piwik.tracking.PiwikConfig;
import ch.rasc.piwik.tracking.PiwikRequest;
import java.io.IOException;
import java.util.Random;
import java.util.stream.Collectors;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.LoggerFactory;

public class PiwikTracker {
    private final PiwikConfig config;
    private final OkHttpClient httpClient;
    private final Random random;
    private final String idSite;
    private static final char[] hexCode = "0123456789ABCDEF".toCharArray();

    public PiwikTracker(PiwikConfig config) {
        this(config, new OkHttpClient());
    }

    public PiwikTracker(PiwikConfig config, OkHttpClient httpClient) {
        this.config = config;
        this.httpClient = httpClient;
        this.random = new Random();
        this.idSite = !config.idSite().isEmpty() ? config.idSite().stream().collect(Collectors.joining(",")) : null;
    }

    public void shutdown() {
        this.httpClient.dispatcher().executorService().shutdown();
    }

    public void shutdownNow() {
        this.httpClient.dispatcher().executorService().shutdownNow();
    }

    public void sendAsync(PiwikRequest trackingRequest) {
        this.sendAsync(trackingRequest, null);
    }

    public void sendAsync(PiwikRequest trackingRequest, Callback callback) {
        Request httpRequest = this.createHttpRequest(trackingRequest);
        if (callback != null) {
            this.httpClient.newCall(httpRequest).enqueue(callback);
        } else {
            this.httpClient.newCall(httpRequest).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    LoggerFactory.getLogger(this.getClass()).error("sendAsync", (Throwable)e);
                }

                public void onResponse(Call call, Response response) throws IOException {
                    if (!response.isSuccessful()) {
                        LoggerFactory.getLogger(this.getClass()).error("asnyc request was not successful. http response code: {}", (Object)response.code());
                    }
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean send(PiwikRequest trackingRequest) {
        Request httpRequest = this.createHttpRequest(trackingRequest);
        try (Response response = this.httpClient.newCall(httpRequest).execute();){
            boolean bl = response.isSuccessful();
            return bl;
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("send", (Throwable)e);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Request createHttpRequest(PiwikRequest trackingRequest) {
        byte[] bytes = new byte[10];
        this.random.nextBytes(bytes);
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme(this.config.scheme()).host(this.config.host()).addPathSegment(this.config.path()).addQueryParameter("rec", "1").addQueryParameter("token_auth", this.config.authToken()).addQueryParameter("url", trackingRequest.url()).addQueryParameter("rand", PiwikTracker.printHexBinary(bytes)).addQueryParameter("apiv", "1").addQueryParameter("send_image", "0");
        if (trackingRequest.idSite().isEmpty()) {
            if (this.idSite == null) throw new IllegalArgumentException("idSite is a required parameter");
            urlBuilder.addQueryParameter("idsite", this.idSite);
        } else {
            urlBuilder.addQueryParameter("idsite", trackingRequest.idSite().stream().collect(Collectors.joining(",")));
        }
        if (trackingRequest.parameters().isEmpty()) return new Request.Builder().url(urlBuilder.build()).build();
        trackingRequest.parameters().forEach((k, v) -> urlBuilder.addQueryParameter(k.getValue(), String.valueOf(v)));
        return new Request.Builder().url(urlBuilder.build()).build();
    }

    private static String printHexBinary(byte[] data) {
        StringBuilder r = new StringBuilder(data.length * 2);
        for (byte b : data) {
            r.append(hexCode[b >> 4 & 0xF]);
            r.append(hexCode[b & 0xF]);
        }
        return r.toString();
    }
}

