package ch.rasc.piwik.tracking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PiwikConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new PiwikConfig.Builder()}.
 */
@Generated(from = "PiwikConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
final class ImmutablePiwikConfig implements PiwikConfig {
  private final String scheme;
  private final String host;
  private final String path;
  private final String authToken;
  private final List<String> idSite;

  private ImmutablePiwikConfig(ImmutablePiwikConfig.Builder builder) {
    this.host = builder.host;
    this.authToken = builder.authToken;
    this.idSite = createUnmodifiableList(true, builder.idSite);
    if (builder.scheme != null) {
      initShim.scheme(builder.scheme);
    }
    if (builder.path != null) {
      initShim.path(builder.path);
    }
    this.scheme = initShim.scheme();
    this.path = initShim.path();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "PiwikConfig", generator = "Immutables")
  private final class InitShim {
    private byte schemeBuildStage = STAGE_UNINITIALIZED;
    private String scheme;

    String scheme() {
      if (schemeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (schemeBuildStage == STAGE_UNINITIALIZED) {
        schemeBuildStage = STAGE_INITIALIZING;
        this.scheme = Objects.requireNonNull(schemeInitialize(), "scheme");
        schemeBuildStage = STAGE_INITIALIZED;
      }
      return this.scheme;
    }

    void scheme(String scheme) {
      this.scheme = scheme;
      schemeBuildStage = STAGE_INITIALIZED;
    }

    private byte pathBuildStage = STAGE_UNINITIALIZED;
    private String path;

    String path() {
      if (pathBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (pathBuildStage == STAGE_UNINITIALIZED) {
        pathBuildStage = STAGE_INITIALIZING;
        this.path = Objects.requireNonNull(pathInitialize(), "path");
        pathBuildStage = STAGE_INITIALIZED;
      }
      return this.path;
    }

    void path(String path) {
      this.path = path;
      pathBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (schemeBuildStage == STAGE_INITIALIZING) attributes.add("scheme");
      if (pathBuildStage == STAGE_INITIALIZING) attributes.add("path");
      return "Cannot build PiwikConfig, attribute initializers form cycle " + attributes;
    }
  }

  private String schemeInitialize() {
    return PiwikConfig.super.scheme();
  }

  private String pathInitialize() {
    return PiwikConfig.super.path();
  }

  /**
   * @return The value of the {@code scheme} attribute
   */
  @Override
  public String scheme() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.scheme()
        : this.scheme;
  }

  /**
   * @return The value of the {@code host} attribute
   */
  @Override
  public String host() {
    return host;
  }

  /**
   * @return The value of the {@code path} attribute
   */
  @Override
  public String path() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.path()
        : this.path;
  }

  /**
   * @return The value of the {@code authToken} attribute
   */
  @Override
  public Optional<String> authToken() {
    return Optional.ofNullable(authToken);
  }

  /**
   * @return The value of the {@code idSite} attribute
   */
  @Override
  public List<String> idSite() {
    return idSite;
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePiwikConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePiwikConfig
        && equalTo((ImmutablePiwikConfig) another);
  }

  private boolean equalTo(ImmutablePiwikConfig another) {
    return scheme.equals(another.scheme)
        && host.equals(another.host)
        && path.equals(another.path)
        && Objects.equals(authToken, another.authToken)
        && idSite.equals(another.idSite);
  }

  /**
   * Computes a hash code from attributes: {@code scheme}, {@code host}, {@code path}, {@code authToken}, {@code idSite}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + scheme.hashCode();
    h += (h << 5) + host.hashCode();
    h += (h << 5) + path.hashCode();
    h += (h << 5) + Objects.hashCode(authToken);
    h += (h << 5) + idSite.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PiwikConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("PiwikConfig{");
    builder.append("scheme=").append(scheme);
    builder.append(", ");
    builder.append("host=").append(host);
    builder.append(", ");
    builder.append("path=").append(path);
    if (authToken != null) {
      builder.append(", ");
      builder.append("authToken=").append(authToken);
    }
    builder.append(", ");
    builder.append("idSite=").append(idSite);
    return builder.append("}").toString();
  }

  /**
   * Builds instances of type {@link ImmutablePiwikConfig ImmutablePiwikConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PiwikConfig", generator = "Immutables")
  public static class Builder {
    private static final long INIT_BIT_HOST = 0x1L;
    private long initBits = 0x1L;

    private String scheme;
    private String host;
    private String path;
    private String authToken;
    private List<String> idSite = new ArrayList<String>();

    /**
     * Creates a builder for {@link ImmutablePiwikConfig ImmutablePiwikConfig} instances.
     * <pre>
     * new PiwikConfig.Builder()
     *    .scheme(String) // optional {@link PiwikConfig#scheme() scheme}
     *    .host(String) // required {@link PiwikConfig#host() host}
     *    .path(String) // optional {@link PiwikConfig#path() path}
     *    .authToken(String) // optional {@link PiwikConfig#authToken() authToken}
     *    .addIdSite|addAllIdSite(String) // {@link PiwikConfig#idSite() idSite} elements
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof PiwikConfig.Builder)) {
        throw new UnsupportedOperationException("Use: new PiwikConfig.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code PiwikConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikConfig.Builder from(PiwikConfig instance) {
      Objects.requireNonNull(instance, "instance");
      scheme(instance.scheme());
      host(instance.host());
      path(instance.path());
      Optional<String> authTokenOptional = instance.authToken();
      if (authTokenOptional.isPresent()) {
        authToken(authTokenOptional);
      }
      addAllIdSite(instance.idSite());
      return (PiwikConfig.Builder) this;
    }

    /**
     * Initializes the value for the {@link PiwikConfig#scheme() scheme} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link PiwikConfig#scheme() scheme}.</em>
     * @param scheme The value for scheme 
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikConfig.Builder scheme(String scheme) {
      this.scheme = Objects.requireNonNull(scheme, "scheme");
      return (PiwikConfig.Builder) this;
    }

    /**
     * Initializes the value for the {@link PiwikConfig#host() host} attribute.
     * @param host The value for host 
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikConfig.Builder host(String host) {
      this.host = Objects.requireNonNull(host, "host");
      initBits &= ~INIT_BIT_HOST;
      return (PiwikConfig.Builder) this;
    }

    /**
     * Initializes the value for the {@link PiwikConfig#path() path} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link PiwikConfig#path() path}.</em>
     * @param path The value for path 
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikConfig.Builder path(String path) {
      this.path = Objects.requireNonNull(path, "path");
      return (PiwikConfig.Builder) this;
    }

    /**
     * Initializes the optional value {@link PiwikConfig#authToken() authToken} to authToken.
     * @param authToken The value for authToken
     * @return {@code this} builder for chained invocation
     */
    public final PiwikConfig.Builder authToken(String authToken) {
      this.authToken = Objects.requireNonNull(authToken, "authToken");
      return (PiwikConfig.Builder) this;
    }

    /**
     * Initializes the optional value {@link PiwikConfig#authToken() authToken} to authToken.
     * @param authToken The value for authToken
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikConfig.Builder authToken(Optional<String> authToken) {
      this.authToken = authToken.orElse(null);
      return (PiwikConfig.Builder) this;
    }

    /**
     * Adds one element to {@link PiwikConfig#idSite() idSite} list.
     * @param element A idSite element
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikConfig.Builder addIdSite(String element) {
      this.idSite.add(Objects.requireNonNull(element, "idSite element"));
      return (PiwikConfig.Builder) this;
    }

    /**
     * Adds elements to {@link PiwikConfig#idSite() idSite} list.
     * @param elements An array of idSite elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikConfig.Builder addIdSite(String... elements) {
      for (String element : elements) {
        this.idSite.add(Objects.requireNonNull(element, "idSite element"));
      }
      return (PiwikConfig.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link PiwikConfig#idSite() idSite} list.
     * @param elements An iterable of idSite elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikConfig.Builder idSite(Iterable<String> elements) {
      this.idSite.clear();
      return addAllIdSite(elements);
    }

    /**
     * Adds elements to {@link PiwikConfig#idSite() idSite} list.
     * @param elements An iterable of idSite elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikConfig.Builder addAllIdSite(Iterable<String> elements) {
      for (String element : elements) {
        this.idSite.add(Objects.requireNonNull(element, "idSite element"));
      }
      return (PiwikConfig.Builder) this;
    }

    /**
     * Builds a new {@link ImmutablePiwikConfig ImmutablePiwikConfig}.
     * @return An immutable instance of PiwikConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePiwikConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePiwikConfig(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_HOST) != 0) attributes.add("host");
      return "Cannot build PiwikConfig, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
