/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.sse.eventbus;

import ch.rasc.sse.eventbus.SseEvent;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

final class ImmutableSseEvent
implements SseEvent {
    private final Set<String> clientIds;
    private final Set<String> excludeClientIds;
    private final Class<?> jsonView;
    private final String event;
    private final Object data;
    private final Duration retry;
    private final String id;
    private final String comment;

    private ImmutableSseEvent(Builder builder) {
        this.clientIds = ImmutableSseEvent.createUnmodifiableSet(builder.clientIds);
        this.excludeClientIds = ImmutableSseEvent.createUnmodifiableSet(builder.excludeClientIds);
        this.jsonView = builder.jsonView;
        this.data = builder.data;
        this.retry = builder.retry;
        this.id = builder.id;
        this.comment = builder.comment;
        this.event = builder.event != null ? builder.event : Objects.requireNonNull(SseEvent.super.event(), "event");
    }

    private ImmutableSseEvent(Set<String> clientIds, Set<String> excludeClientIds, Class<?> jsonView, String event, Object data, Duration retry, String id, String comment) {
        this.clientIds = clientIds;
        this.excludeClientIds = excludeClientIds;
        this.jsonView = jsonView;
        this.event = event;
        this.data = data;
        this.retry = retry;
        this.id = id;
        this.comment = comment;
    }

    @Override
    public Set<String> clientIds() {
        return this.clientIds;
    }

    @Override
    public Set<String> excludeClientIds() {
        return this.excludeClientIds;
    }

    @Override
    public Optional<Class<?>> jsonView() {
        return Optional.ofNullable(this.jsonView);
    }

    @Override
    public String event() {
        return this.event;
    }

    @Override
    public Object data() {
        return this.data;
    }

    @Override
    public Optional<Duration> retry() {
        return Optional.ofNullable(this.retry);
    }

    @Override
    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    @Override
    public Optional<String> comment() {
        return Optional.ofNullable(this.comment);
    }

    public final ImmutableSseEvent withClientIds(String ... elements) {
        Set<String> newValue = ImmutableSseEvent.createUnmodifiableSet(ImmutableSseEvent.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSseEvent(newValue, this.excludeClientIds, this.jsonView, this.event, this.data, this.retry, this.id, this.comment);
    }

    public final ImmutableSseEvent withClientIds(Iterable<String> elements) {
        if (this.clientIds == elements) {
            return this;
        }
        Set<String> newValue = ImmutableSseEvent.createUnmodifiableSet(ImmutableSseEvent.createSafeList(elements, true, false));
        return new ImmutableSseEvent(newValue, this.excludeClientIds, this.jsonView, this.event, this.data, this.retry, this.id, this.comment);
    }

    public final ImmutableSseEvent withExcludeClientIds(String ... elements) {
        Set<String> newValue = ImmutableSseEvent.createUnmodifiableSet(ImmutableSseEvent.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSseEvent(this.clientIds, newValue, this.jsonView, this.event, this.data, this.retry, this.id, this.comment);
    }

    public final ImmutableSseEvent withExcludeClientIds(Iterable<String> elements) {
        if (this.excludeClientIds == elements) {
            return this;
        }
        Set<String> newValue = ImmutableSseEvent.createUnmodifiableSet(ImmutableSseEvent.createSafeList(elements, true, false));
        return new ImmutableSseEvent(this.clientIds, newValue, this.jsonView, this.event, this.data, this.retry, this.id, this.comment);
    }

    public final ImmutableSseEvent withJsonView(Class<?> value) {
        Class<?> newValue = Objects.requireNonNull(value, "jsonView");
        if (this.jsonView == newValue) {
            return this;
        }
        return new ImmutableSseEvent(this.clientIds, this.excludeClientIds, newValue, this.event, this.data, this.retry, this.id, this.comment);
    }

    public final ImmutableSseEvent withJsonView(Optional<? extends Class<?>> optional) {
        Class value = optional.orElse(null);
        if (this.jsonView == value) {
            return this;
        }
        return new ImmutableSseEvent(this.clientIds, this.excludeClientIds, value, this.event, this.data, this.retry, this.id, this.comment);
    }

    public final ImmutableSseEvent withEvent(String value) {
        if (this.event.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "event");
        return new ImmutableSseEvent(this.clientIds, this.excludeClientIds, this.jsonView, newValue, this.data, this.retry, this.id, this.comment);
    }

    public final ImmutableSseEvent withData(Object value) {
        if (this.data == value) {
            return this;
        }
        Object newValue = Objects.requireNonNull(value, "data");
        return new ImmutableSseEvent(this.clientIds, this.excludeClientIds, this.jsonView, this.event, newValue, this.retry, this.id, this.comment);
    }

    public final ImmutableSseEvent withRetry(Duration value) {
        Duration newValue = Objects.requireNonNull(value, "retry");
        if (this.retry == newValue) {
            return this;
        }
        return new ImmutableSseEvent(this.clientIds, this.excludeClientIds, this.jsonView, this.event, this.data, newValue, this.id, this.comment);
    }

    public final ImmutableSseEvent withRetry(Optional<? extends Duration> optional) {
        Duration value = optional.orElse(null);
        if (this.retry == value) {
            return this;
        }
        return new ImmutableSseEvent(this.clientIds, this.excludeClientIds, this.jsonView, this.event, this.data, value, this.id, this.comment);
    }

    public final ImmutableSseEvent withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new ImmutableSseEvent(this.clientIds, this.excludeClientIds, this.jsonView, this.event, this.data, this.retry, newValue, this.comment);
    }

    public final ImmutableSseEvent withId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableSseEvent(this.clientIds, this.excludeClientIds, this.jsonView, this.event, this.data, this.retry, value, this.comment);
    }

    public final ImmutableSseEvent withComment(String value) {
        String newValue = Objects.requireNonNull(value, "comment");
        if (Objects.equals(this.comment, newValue)) {
            return this;
        }
        return new ImmutableSseEvent(this.clientIds, this.excludeClientIds, this.jsonView, this.event, this.data, this.retry, this.id, newValue);
    }

    public final ImmutableSseEvent withComment(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.comment, value)) {
            return this;
        }
        return new ImmutableSseEvent(this.clientIds, this.excludeClientIds, this.jsonView, this.event, this.data, this.retry, this.id, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSseEvent && this.equalTo((ImmutableSseEvent)another);
    }

    private boolean equalTo(ImmutableSseEvent another) {
        return this.clientIds.equals(another.clientIds) && this.excludeClientIds.equals(another.excludeClientIds) && Objects.equals(this.jsonView, another.jsonView) && this.event.equals(another.event) && this.data.equals(another.data) && Objects.equals(this.retry, another.retry) && Objects.equals(this.id, another.id) && Objects.equals(this.comment, another.comment);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.clientIds.hashCode();
        h += (h << 5) + this.excludeClientIds.hashCode();
        h += (h << 5) + Objects.hashCode(this.jsonView);
        h += (h << 5) + this.event.hashCode();
        h += (h << 5) + this.data.hashCode();
        h += (h << 5) + Objects.hashCode(this.retry);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.comment);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SseEvent{");
        builder.append("clientIds=").append(this.clientIds);
        builder.append(", ");
        builder.append("excludeClientIds=").append(this.excludeClientIds);
        if (this.jsonView != null) {
            builder.append(", ");
            builder.append("jsonView=").append(this.jsonView);
        }
        builder.append(", ");
        builder.append("event=").append(this.event);
        builder.append(", ");
        builder.append("data=").append(this.data);
        if (this.retry != null) {
            builder.append(", ");
            builder.append("retry=").append(this.retry);
        }
        if (this.id != null) {
            builder.append(", ");
            builder.append("id=").append(this.id);
        }
        if (this.comment != null) {
            builder.append(", ");
            builder.append("comment=").append(this.comment);
        }
        return builder.append("}").toString();
    }

    public static ImmutableSseEvent copyOf(SseEvent instance) {
        if (instance instanceof ImmutableSseEvent) {
            return (ImmutableSseEvent)instance;
        }
        return new SseEvent.Builder().from(instance).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    static class Builder {
        private static final long INIT_BIT_DATA = 1L;
        private long initBits = 1L;
        private List<String> clientIds = new ArrayList<String>();
        private List<String> excludeClientIds = new ArrayList<String>();
        private Class<?> jsonView;
        private String event;
        private Object data;
        private Duration retry;
        private String id;
        private String comment;

        Builder() {
            if (!(this instanceof SseEvent.Builder)) {
                throw new UnsupportedOperationException("Use: new SseEvent.Builder()");
            }
        }

        public final SseEvent.Builder from(SseEvent instance) {
            Optional<String> commentOptional;
            Optional<String> idOptional;
            Objects.requireNonNull(instance, "instance");
            this.addAllClientIds(instance.clientIds());
            this.addAllExcludeClientIds(instance.excludeClientIds());
            Optional<Class<?>> jsonViewOptional = instance.jsonView();
            if (jsonViewOptional.isPresent()) {
                this.jsonView(jsonViewOptional);
            }
            this.event(instance.event());
            this.data(instance.data());
            Optional<Duration> retryOptional = instance.retry();
            if (retryOptional.isPresent()) {
                this.retry(retryOptional);
            }
            if ((idOptional = instance.id()).isPresent()) {
                this.id(idOptional);
            }
            if ((commentOptional = instance.comment()).isPresent()) {
                this.comment(commentOptional);
            }
            return (SseEvent.Builder)this;
        }

        public final SseEvent.Builder addClientId(String element) {
            this.clientIds.add(Objects.requireNonNull(element, "clientIds element"));
            return (SseEvent.Builder)this;
        }

        public final SseEvent.Builder addClientId(String ... elements) {
            for (String element : elements) {
                this.clientIds.add(Objects.requireNonNull(element, "clientIds element"));
            }
            return (SseEvent.Builder)this;
        }

        public final SseEvent.Builder clientIds(Iterable<String> elements) {
            this.clientIds.clear();
            return this.addAllClientIds(elements);
        }

        public final SseEvent.Builder addAllClientIds(Iterable<String> elements) {
            for (String element : elements) {
                this.clientIds.add(Objects.requireNonNull(element, "clientIds element"));
            }
            return (SseEvent.Builder)this;
        }

        public final SseEvent.Builder addExcludeClientId(String element) {
            this.excludeClientIds.add(Objects.requireNonNull(element, "excludeClientIds element"));
            return (SseEvent.Builder)this;
        }

        public final SseEvent.Builder addExcludeClientId(String ... elements) {
            for (String element : elements) {
                this.excludeClientIds.add(Objects.requireNonNull(element, "excludeClientIds element"));
            }
            return (SseEvent.Builder)this;
        }

        public final SseEvent.Builder excludeClientIds(Iterable<String> elements) {
            this.excludeClientIds.clear();
            return this.addAllExcludeClientIds(elements);
        }

        public final SseEvent.Builder addAllExcludeClientIds(Iterable<String> elements) {
            for (String element : elements) {
                this.excludeClientIds.add(Objects.requireNonNull(element, "excludeClientIds element"));
            }
            return (SseEvent.Builder)this;
        }

        public final SseEvent.Builder jsonView(Class<?> jsonView) {
            this.jsonView = Objects.requireNonNull(jsonView, "jsonView");
            return (SseEvent.Builder)this;
        }

        public final SseEvent.Builder jsonView(Optional<? extends Class<?>> jsonView) {
            this.jsonView = jsonView.orElse(null);
            return (SseEvent.Builder)this;
        }

        public final SseEvent.Builder event(String event) {
            this.event = Objects.requireNonNull(event, "event");
            return (SseEvent.Builder)this;
        }

        public final SseEvent.Builder data(Object data) {
            this.data = Objects.requireNonNull(data, "data");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (SseEvent.Builder)this;
        }

        public final SseEvent.Builder retry(Duration retry) {
            this.retry = Objects.requireNonNull(retry, "retry");
            return (SseEvent.Builder)this;
        }

        public final SseEvent.Builder retry(Optional<? extends Duration> retry) {
            this.retry = retry.orElse(null);
            return (SseEvent.Builder)this;
        }

        public final SseEvent.Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return (SseEvent.Builder)this;
        }

        public final SseEvent.Builder id(Optional<String> id) {
            this.id = id.orElse(null);
            return (SseEvent.Builder)this;
        }

        public final SseEvent.Builder comment(String comment) {
            this.comment = Objects.requireNonNull(comment, "comment");
            return (SseEvent.Builder)this;
        }

        public final SseEvent.Builder comment(Optional<String> comment) {
            this.comment = comment.orElse(null);
            return (SseEvent.Builder)this;
        }

        public ImmutableSseEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSseEvent(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("data");
            }
            return "Cannot build SseEvent, some of required attributes are not set " + attributes;
        }
    }
}

