/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.sse.eventbus;

import ch.rasc.sse.eventbus.SubscriptionRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DefaultSubscriptionRegistry
implements SubscriptionRegistry {
    private final ConcurrentMap<String, Set<String>> eventSubscribers = new ConcurrentHashMap<String, Set<String>>();

    protected ConcurrentMap<String, Set<String>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    @Override
    public void subscribe(String clientId, String event) {
        this.eventSubscribers.computeIfAbsent(event, k -> new HashSet()).add(clientId);
    }

    @Override
    public void unsubscribe(String clientId, String event) {
        this.eventSubscribers.computeIfPresent(event, (k, set) -> set.remove(clientId) && set.isEmpty() ? null : set);
    }

    @Override
    public boolean isClientSubscribedToEvent(String clientId, String eventName) {
        Set subscribedClients = (Set)this.eventSubscribers.get(eventName);
        if (subscribedClients != null) {
            return subscribedClients.contains(clientId);
        }
        return false;
    }

    @Override
    public Set<String> getAllEvents() {
        return Collections.unmodifiableSet(this.eventSubscribers.keySet());
    }

    @Override
    public Map<String, Set<String>> getAllSubscriptions() {
        HashMap result = new HashMap();
        this.eventSubscribers.forEach((k, v) -> result.put(k, Collections.unmodifiableSet(v)));
        return Collections.unmodifiableMap(result);
    }

    @Override
    public Set<String> getSubscribers(String event) {
        Set clientIds = (Set)this.eventSubscribers.get(event);
        if (clientIds != null) {
            return Collections.unmodifiableSet(clientIds);
        }
        return Collections.emptySet();
    }

    @Override
    public int countSubscribers(String event) {
        Set clientIds = (Set)this.eventSubscribers.get(event);
        if (clientIds != null) {
            return clientIds.size();
        }
        return 0;
    }

    @Override
    public boolean hasSubscribers(String event) {
        return this.countSubscribers(event) != 0;
    }
}

