/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.sse.eventbus;

import ch.rasc.sse.eventbus.Client;
import ch.rasc.sse.eventbus.SseEvent;
import java.time.Duration;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public class ClientEvent {
    private final Client client;
    private final SseEvent event;
    private final String convertedValue;
    private int errorCounter;

    public ClientEvent(Client client, SseEvent event, String convertedValue) {
        this.client = client;
        this.event = event;
        this.convertedValue = convertedValue;
        this.errorCounter = 0;
    }

    public Client getClient() {
        return this.client;
    }

    public SseEvent getSseEvent() {
        return this.event;
    }

    public SseEmitter.SseEventBuilder createSseEventBuilder() {
        SseEmitter.SseEventBuilder sseBuilder = SseEmitter.event();
        if (!this.event.event().equals("message")) {
            sseBuilder.name(this.event.event());
        }
        this.event.id().ifPresent(arg_0 -> ((SseEmitter.SseEventBuilder)sseBuilder).id(arg_0));
        this.event.retry().map(Duration::toMillis).ifPresent(arg_0 -> ((SseEmitter.SseEventBuilder)sseBuilder).reconnectTime(arg_0));
        this.event.comment().ifPresent(arg_0 -> ((SseEmitter.SseEventBuilder)sseBuilder).comment(arg_0));
        if (this.convertedValue != null) {
            for (String line : this.convertedValue.split("\n")) {
                sseBuilder.data((Object)line);
            }
        } else if (this.event.data() instanceof String) {
            for (String line : ((String)this.event.data()).split("\n")) {
                sseBuilder.data((Object)line);
            }
        } else {
            sseBuilder.data(this.event.data());
        }
        return sseBuilder;
    }

    void incErrorCounter() {
        ++this.errorCounter;
    }

    public int getErrorCounter() {
        return this.errorCounter;
    }
}

