/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.sse.eventbus;

import ch.rasc.sse.eventbus.Client;
import ch.rasc.sse.eventbus.ClientEvent;
import ch.rasc.sse.eventbus.DataObjectConverter;
import ch.rasc.sse.eventbus.SseEvent;
import ch.rasc.sse.eventbus.SseEventBusListener;
import ch.rasc.sse.eventbus.SubscriptionRegistry;
import ch.rasc.sse.eventbus.config.SseEventBusConfigurer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.event.EventListener;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public class SseEventBus {
    private final ConcurrentMap<String, Client> clients;
    private final SubscriptionRegistry subscriptionRegistry;
    private final ScheduledExecutorService taskScheduler;
    private final int noOfSendResponseTries;
    private final Duration clientExpiration;
    private List<DataObjectConverter> dataObjectConverters;
    private final BlockingQueue<ClientEvent> errorQueue;
    private final BlockingQueue<ClientEvent> sendQueue;
    private final SseEventBusListener listener;

    public SseEventBus(SseEventBusConfigurer configurer, SubscriptionRegistry subscriptionRegistry) {
        this.subscriptionRegistry = subscriptionRegistry;
        this.taskScheduler = configurer.taskScheduler();
        this.noOfSendResponseTries = configurer.noOfSendResponseTries();
        this.clientExpiration = configurer.clientExpiration();
        this.clients = new ConcurrentHashMap<String, Client>();
        this.errorQueue = configurer.errorQueue();
        this.sendQueue = configurer.sendQueue();
        this.listener = configurer.listener();
        this.taskScheduler.submit(this::eventLoop);
        this.taskScheduler.scheduleWithFixedDelay(this::reScheduleFailedEvents, 0L, configurer.schedulerDelay().toMillis(), TimeUnit.MILLISECONDS);
        this.taskScheduler.scheduleWithFixedDelay(this::cleanUpClients, 0L, configurer.clientExpirationJobDelay().toMillis(), TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void cleanUp() {
        this.taskScheduler.shutdownNow();
    }

    public SseEmitter createSseEmitter(String clientId) {
        return this.createSseEmitter(clientId, (Long)180000L, new String[0]);
    }

    public SseEmitter createSseEmitter(String clientId, String ... events) {
        return this.createSseEmitter(clientId, (Long)180000L, false, false, events);
    }

    public SseEmitter createSseEmitter(String clientId, boolean unsubscribe, String ... events) {
        return this.createSseEmitter(clientId, (Long)180000L, unsubscribe, false, events);
    }

    public SseEmitter createSseEmitter(String clientId, Long timeout, String ... events) {
        return this.createSseEmitter(clientId, timeout, false, false, events);
    }

    public SseEmitter createSseEmitter(String clientId, Long timeout, boolean unsubscribe, String ... events) {
        return this.createSseEmitter(clientId, timeout, unsubscribe, false, events);
    }

    public SseEmitter createSseEmitter(String clientId, Long timeout, boolean unsubscribe, boolean completeAfterMessage, String ... events) {
        SseEmitter emitter = new SseEmitter(timeout);
        emitter.onTimeout(() -> ((SseEmitter)emitter).complete());
        this.registerClient(clientId, emitter, completeAfterMessage);
        if (events != null && events.length > 0) {
            if (unsubscribe) {
                this.unsubscribeFromAllEvents(clientId, events);
            }
            for (String event : events) {
                this.subscribe(clientId, event);
            }
        }
        return emitter;
    }

    public void registerClient(String clientId, SseEmitter emitter) {
        this.registerClient(clientId, emitter, false);
    }

    public void registerClient(String clientId, SseEmitter emitter, boolean completeAfterMessage) {
        Client client = (Client)this.clients.get(clientId);
        if (client == null) {
            this.clients.put(clientId, new Client(clientId, emitter, completeAfterMessage));
        } else {
            client.updateEmitter(emitter);
        }
    }

    public void unregisterClient(String clientId) {
        this.unsubscribeFromAllEvents(clientId, new String[0]);
        this.clients.remove(clientId);
    }

    public void subscribe(String clientId) {
        this.subscribe(clientId, "message");
    }

    public void subscribe(String clientId, String event) {
        this.subscriptionRegistry.subscribe(clientId, event);
    }

    public void subscribeOnly(String clientId, String event) {
        this.subscriptionRegistry.subscribe(clientId, event);
        this.unsubscribeFromAllEvents(clientId, event);
    }

    public void unsubscribe(String clientId, String event) {
        this.subscriptionRegistry.unsubscribe(clientId, event);
    }

    public void unsubscribeFromAllEvents(String clientId, String ... keepEvents) {
        HashSet<String> keepEventsSet = null;
        if (keepEvents != null && keepEvents.length > 0) {
            keepEventsSet = new HashSet<String>();
            for (String keepEvent : keepEvents) {
                keepEventsSet.add(keepEvent);
            }
        }
        Set<String> events = this.subscriptionRegistry.getAllEvents();
        if (keepEventsSet != null) {
            events = new HashSet<String>(events);
            events.removeAll(keepEventsSet);
        }
        events.forEach(event -> this.unsubscribe(clientId, (String)event));
    }

    @EventListener
    public void handleEvent(SseEvent event) {
        try {
            String convertedValue = null;
            if (!(event.data() instanceof String)) {
                convertedValue = this.convertObject(event);
            }
            if (event.clientIds().isEmpty()) {
                for (Client client : this.clients.values()) {
                    if (event.excludeClientIds().contains(client.getId()) || !this.subscriptionRegistry.isClientSubscribedToEvent(client.getId(), event.event())) continue;
                    ClientEvent clientEvent = new ClientEvent(client, event, convertedValue);
                    this.sendQueue.put(clientEvent);
                    this.listener.afterEventQueued(clientEvent, true);
                }
            } else {
                for (String clientId : event.clientIds()) {
                    if (!this.subscriptionRegistry.isClientSubscribedToEvent(clientId, event.event())) continue;
                    ClientEvent clientEvent = new ClientEvent((Client)this.clients.get(clientId), event, convertedValue);
                    this.sendQueue.put(clientEvent);
                    this.listener.afterEventQueued(clientEvent, true);
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void reScheduleFailedEvents() {
        try {
            ArrayList failedEvents = new ArrayList();
            this.errorQueue.drainTo(failedEvents);
            for (ClientEvent sseClientEvent : failedEvents) {
                if (!this.subscriptionRegistry.isClientSubscribedToEvent(sseClientEvent.getClient().getId(), sseClientEvent.getSseEvent().event())) continue;
                try {
                    this.sendQueue.put(sseClientEvent);
                    try {
                        this.listener.afterEventQueued(sseClientEvent, false);
                    }
                    catch (Exception e) {
                        LogFactory.getLog(SseEventBus.class).error((Object)"calling afterEventQueued hook failed", (Throwable)e);
                    }
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                catch (Exception e) {
                    LogFactory.getLog(SseEventBus.class).error((Object)"re-adding event into send queue failed", (Throwable)e);
                    try {
                        this.errorQueue.put(sseClientEvent);
                    }
                    catch (InterruptedException ie) {
                        throw new RuntimeException(ie);
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            LogFactory.getLog(SseEventBus.class).error((Object)"reScheduleFailedEvents failed", (Throwable)e);
        }
    }

    private void eventLoop() {
        block11: while (true) {
            try {
                while (true) {
                    ClientEvent clientEvent;
                    if ((clientEvent = this.sendQueue.take()).getErrorCounter() < this.noOfSendResponseTries) {
                        Client client = clientEvent.getClient();
                        Exception e = SseEventBus.sendEventToClient(clientEvent);
                        if (e == null) {
                            client.updateLastTransfer();
                            try {
                                this.listener.afterEventSent(clientEvent, null);
                                continue block11;
                            }
                            catch (Exception ex) {
                                LogFactory.getLog(SseEventBus.class).error((Object)"calling afterEventSent hook failed", (Throwable)ex);
                                continue;
                            }
                        }
                        clientEvent.incErrorCounter();
                        try {
                            this.errorQueue.put(clientEvent);
                        }
                        catch (InterruptedException ie) {
                            throw new RuntimeException(ie);
                        }
                        try {
                            this.listener.afterEventSent(clientEvent, e);
                            continue block11;
                        }
                        catch (Exception ex) {
                            LogFactory.getLog(SseEventBus.class).error((Object)"calling afterEventSent hook failed", (Throwable)ex);
                            continue;
                        }
                    }
                    String clientId = clientEvent.getClient().getId();
                    this.unregisterClient(clientId);
                    try {
                        this.listener.afterClientsUnregistered(Collections.singleton(clientId));
                        continue block11;
                    }
                    catch (Exception ex) {
                        LogFactory.getLog(SseEventBus.class).error((Object)"calling afterClientsUnregistered hook failed", (Throwable)ex);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            catch (Exception ex) {
                LogFactory.getLog(SseEventBus.class).error((Object)"eventLoop run failed", (Throwable)ex);
                continue;
            }
            break;
        }
    }

    private static Exception sendEventToClient(ClientEvent clientEvent) {
        Client client = clientEvent.getClient();
        try {
            client.sseEmitter().send(clientEvent.createSseEventBuilder());
            if (client.isCompleteAfterMessage()) {
                client.sseEmitter().complete();
            }
            return null;
        }
        catch (Exception e) {
            return e;
        }
    }

    private String convertObject(SseEvent event) {
        if (this.dataObjectConverters != null) {
            for (DataObjectConverter converter : this.dataObjectConverters) {
                if (!converter.supports(event)) continue;
                return converter.convert(event);
            }
        }
        return null;
    }

    private void cleanUpClients() {
        if (!this.clients.isEmpty()) {
            long expirationTime = System.currentTimeMillis() - this.clientExpiration.toMillis();
            Iterator it = this.clients.entrySet().iterator();
            HashSet<String> staleClients = new HashSet<String>();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (((Client)entry.getValue()).lastTransfer() >= expirationTime) continue;
                staleClients.add((String)entry.getKey());
            }
            staleClients.forEach(this::unregisterClient);
            this.listener.afterClientsUnregistered(staleClients);
        }
    }

    public List<DataObjectConverter> getDataObjectConverters() {
        return this.dataObjectConverters;
    }

    public void setDataObjectConverters(List<DataObjectConverter> dataObjectConverters) {
        this.dataObjectConverters = dataObjectConverters;
    }

    public Set<String> getAllClientIds() {
        return Collections.unmodifiableSet(this.clients.keySet());
    }

    public Set<String> getAllEvents() {
        return this.subscriptionRegistry.getAllEvents();
    }

    public Map<String, Set<String>> getAllSubscriptions() {
        return this.subscriptionRegistry.getAllSubscriptions();
    }

    public Set<String> getSubscribers(String event) {
        return this.subscriptionRegistry.getSubscribers(event);
    }

    public int countSubscribers(String event) {
        return this.subscriptionRegistry.countSubscribers(event);
    }

    public boolean hasSubscribers(String event) {
        return this.countSubscribers(event) != 0;
    }
}

