/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.sse.eventbus.config;

import ch.rasc.sse.eventbus.Client;
import ch.rasc.sse.eventbus.ClientEvent;
import ch.rasc.sse.eventbus.SseEventBusListener;
import java.time.Duration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;

public interface SseEventBusConfigurer {
    default public Duration schedulerDelay() {
        return Duration.ofMillis(500L);
    }

    default public Duration clientExpirationJobDelay() {
        return this.clientExpiration();
    }

    default public Duration clientExpiration() {
        return Duration.ofDays(1L);
    }

    default public int noOfSendResponseTries() {
        return 40;
    }

    default public ScheduledExecutorService taskScheduler() {
        return Executors.newScheduledThreadPool(2);
    }

    default public BlockingQueue<ClientEvent> errorQueue() {
        return new LinkedBlockingQueue<ClientEvent>();
    }

    default public BlockingQueue<ClientEvent> sendQueue() {
        return new LinkedBlockingQueue<ClientEvent>();
    }

    default public ConcurrentMap<String, Client> clients() {
        return new ConcurrentHashMap<String, Client>();
    }

    default public SseEventBusListener listener() {
        return new SseEventBusListener(){};
    }
}

