/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.session.servlet;

import ch.rasc.wamp2spring.message.AbortMessage;
import ch.rasc.wamp2spring.message.ErrorMessage;
import ch.rasc.wamp2spring.message.GoodbyeMessage;
import ch.rasc.wamp2spring.message.HelloMessage;
import ch.rasc.wamp2spring.message.WelcomeMessage;
import java.time.Instant;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

public final class SessionRepositoryMessageInterceptor<S extends Session>
implements ChannelInterceptor,
HandshakeInterceptor {
    private static final String SPRING_SESSION_ID_ATTR_NAME = "SPRING.SESSION.ID";
    private final SessionRepository<S> sessionRepository;

    public SessionRepositoryMessageInterceptor(SessionRepository<S> sessionRepository) {
        this.sessionRepository = sessionRepository;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        Session session;
        String sessionId;
        if (SessionRepositoryMessageInterceptor.messageMatches(message) && (sessionId = (String)message.getHeaders().get((Object)SPRING_SESSION_ID_ATTR_NAME)) != null && (session = this.sessionRepository.findById(sessionId)) != null) {
            session.setLastAccessedTime(Instant.now());
            this.sessionRepository.save(session);
        }
        return message;
    }

    private static boolean messageMatches(Message<?> message) {
        return !(message instanceof AbortMessage) && !(message instanceof ErrorMessage) && !(message instanceof GoodbyeMessage) && !(message instanceof HelloMessage) && !(message instanceof WelcomeMessage);
    }

    public boolean beforeHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Map<String, Object> attributes) throws Exception {
        ServletServerHttpRequest servletRequest;
        HttpSession session;
        if (request instanceof ServletServerHttpRequest && (session = (servletRequest = (ServletServerHttpRequest)request).getServletRequest().getSession(false)) != null) {
            attributes.put(SPRING_SESSION_ID_ATTR_NAME, session.getId());
        }
        return true;
    }

    public void afterHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Exception exception) {
    }
}

