/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.session.servlet;

import ch.rasc.wamp2spring.servlet.WampServletConfigurer;
import ch.rasc.wamp2spring.session.servlet.SessionRepositoryMessageInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.support.AbstractMessageChannel;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.session.web.socket.handler.WebSocketConnectHandlerDecoratorFactory;
import org.springframework.session.web.socket.handler.WebSocketRegistryListener;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistration;
import org.springframework.web.socket.server.HandshakeInterceptor;

public class SessionWampServletConfigurer<S extends Session>
implements WampServletConfigurer {
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    @Bean
    public WebSocketRegistryListener webSocketRegistryListener() {
        return new WebSocketRegistryListener();
    }

    @Bean
    public WebSocketConnectHandlerDecoratorFactory wsConnectHandlerDecoratorFactory() {
        return new WebSocketConnectHandlerDecoratorFactory(this.eventPublisher);
    }

    @Bean
    public SessionRepositoryMessageInterceptor<S> sessionRepositoryInterceptor() {
        return new SessionRepositoryMessageInterceptor(this.sessionRepository);
    }

    public void configureWebSocketHandlerRegistration(WebSocketHandlerRegistration registration) {
        registration.addInterceptors(new HandshakeInterceptor[]{this.sessionRepositoryInterceptor()});
    }

    public void configureClientInboundChannel(AbstractMessageChannel channel) {
        channel.addInterceptor(this.sessionRepositoryInterceptor());
    }

    public WebSocketHandler decorateWebSocketHandler(WebSocketHandler webSocketHandler) {
        return this.wsConnectHandlerDecoratorFactory().decorate(webSocketHandler);
    }
}

