/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.security;

import ch.rasc.wampspring.config.AbstractWampConfigurer;
import ch.rasc.wampspring.message.WampMessageHeader;
import ch.rasc.wampspring.security.WampMessageSecurityMetadataSourceRegistry;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.support.AbstractMessageChannel;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.messaging.access.expression.MessageExpressionVoter;
import org.springframework.security.messaging.access.intercept.ChannelSecurityInterceptor;
import org.springframework.security.messaging.access.intercept.MessageSecurityMetadataSource;
import org.springframework.security.messaging.context.AuthenticationPrincipalArgumentResolver;
import org.springframework.security.messaging.context.SecurityContextChannelInterceptor;

public abstract class AbstractSecurityWampConfigurer
extends AbstractWampConfigurer {
    private final WampMessageSecurityMetadataSourceRegistry inboundRegistry = new WampMessageSecurityMetadataSourceRegistry();

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add((HandlerMethodArgumentResolver)new AuthenticationPrincipalArgumentResolver());
    }

    public void configureClientInboundChannel(AbstractMessageChannel channel) {
        ChannelSecurityInterceptor inboundChannelSecurity = this.inboundChannelSecurity();
        if (this.inboundRegistry.containsMapping()) {
            channel.addInterceptor((ChannelInterceptor)this.securityContextChannelInterceptor());
            channel.addInterceptor((ChannelInterceptor)inboundChannelSecurity);
        }
    }

    @Bean
    public ChannelSecurityInterceptor inboundChannelSecurity() {
        ChannelSecurityInterceptor channelSecurityInterceptor = new ChannelSecurityInterceptor(this.inboundMessageSecurityMetadataSource());
        ArrayList<MessageExpressionVoter> voters = new ArrayList<MessageExpressionVoter>();
        voters.add(new MessageExpressionVoter());
        AffirmativeBased manager = new AffirmativeBased(voters);
        channelSecurityInterceptor.setAccessDecisionManager((AccessDecisionManager)manager);
        return channelSecurityInterceptor;
    }

    @Bean
    public SecurityContextChannelInterceptor securityContextChannelInterceptor() {
        return new SecurityContextChannelInterceptor(WampMessageHeader.PRINCIPAL.name());
    }

    @Bean
    public MessageSecurityMetadataSource inboundMessageSecurityMetadataSource() {
        this.configureInbound(this.inboundRegistry);
        return this.inboundRegistry.createMetadataSource();
    }

    protected void configureInbound(WampMessageSecurityMetadataSourceRegistry messages) {
    }
}

