/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.security;

import ch.rasc.wampspring.message.WampMessageType;
import ch.rasc.wampspring.security.WampDestinationMessageMatcher;
import ch.rasc.wampspring.security.WampMessageTypeMatcher;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.security.messaging.access.expression.ExpressionBasedMessageSecurityMetadataSourceFactory;
import org.springframework.security.messaging.access.intercept.MessageSecurityMetadataSource;
import org.springframework.security.messaging.util.matcher.MessageMatcher;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

public class WampMessageSecurityMetadataSourceRegistry {
    private static final String permitAll = "permitAll";
    private static final String denyAll = "denyAll";
    private static final String anonymous = "anonymous";
    private static final String authenticated = "authenticated";
    private static final String fullyAuthenticated = "fullyAuthenticated";
    private static final String rememberMe = "rememberMe";
    private final LinkedHashMap<MatcherBuilder, String> matcherToExpression = new LinkedHashMap();
    private PathMatcher pathMatcher = new AntPathMatcher();

    public Constraint anyMessage() {
        return this.matchers(MessageMatcher.ANY_MESSAGE);
    }

    public Constraint nullDestMatcher() {
        return this.matchers(WampDestinationMessageMatcher.NULL_DESTINATION_MATCHER);
    }

    public Constraint wampTypeMatchers(WampMessageType ... typesToMatch) {
        MessageMatcher[] typeMatchers = new MessageMatcher[typesToMatch.length];
        for (int i = 0; i < typesToMatch.length; ++i) {
            WampMessageType typeToMatch = typesToMatch[i];
            typeMatchers[i] = new WampMessageTypeMatcher(typeToMatch);
        }
        return this.matchers(typeMatchers);
    }

    public Constraint wampDestMatchers(String ... patterns) {
        return this.wampDestMatchers((WampMessageType)null, patterns);
    }

    public Constraint wampCallDestMatchers(String ... patterns) {
        return this.wampDestMatchers(WampMessageType.CALL, patterns);
    }

    public Constraint wampPublishDestMatchers(String ... patterns) {
        return this.wampDestMatchers(WampMessageType.PUBLISH, patterns);
    }

    public Constraint wampSubscribeDestMatchers(String ... patterns) {
        return this.wampDestMatchers(WampMessageType.SUBSCRIBE, patterns);
    }

    public Constraint wampUnsubscribeDestMatchers(String ... patterns) {
        return this.wampDestMatchers(WampMessageType.UNSUBSCRIBE, patterns);
    }

    private Constraint wampDestMatchers(WampMessageType type, String ... patterns) {
        ArrayList<PathMatcherMessageMatcherBuilder> matchers = new ArrayList<PathMatcherMessageMatcherBuilder>(patterns.length);
        for (String pattern : patterns) {
            matchers.add(new PathMatcherMessageMatcherBuilder(pattern, type));
        }
        return new Constraint(matchers);
    }

    public WampMessageSecurityMetadataSourceRegistry wampDestPathMatcher(PathMatcher matcher) {
        Assert.notNull((Object)matcher, (String)"pathMatcher cannot be null");
        this.pathMatcher = matcher;
        return this;
    }

    public Constraint matchers(MessageMatcher<?> ... matchers) {
        ArrayList<PreBuiltMatcherBuilder> builders = new ArrayList<PreBuiltMatcherBuilder>(matchers.length);
        for (MessageMatcher<?> matcher : matchers) {
            builders.add(new PreBuiltMatcherBuilder(matcher));
        }
        return new Constraint(builders);
    }

    protected MessageSecurityMetadataSource createMetadataSource() {
        LinkedHashMap mte = new LinkedHashMap();
        for (Map.Entry<MatcherBuilder, String> entry : this.matcherToExpression.entrySet()) {
            mte.put(entry.getKey().build(), entry.getValue());
        }
        return ExpressionBasedMessageSecurityMetadataSourceFactory.createExpressionMessageMetadataSource(mte);
    }

    protected boolean containsMapping() {
        return !this.matcherToExpression.isEmpty();
    }

    private static String hasAnyRole(String ... authorities) {
        String anyAuthorities = StringUtils.arrayToDelimitedString((Object[])authorities, (String)"','ROLE_");
        return "hasAnyRole('ROLE_" + anyAuthorities + "')";
    }

    private static String hasRole(String role) {
        Assert.notNull((Object)role, (String)"role cannot be null");
        if (role.startsWith("ROLE_")) {
            throw new IllegalArgumentException("role should not start with 'ROLE_' since it is automatically inserted. Got '" + role + "'");
        }
        return "hasRole('ROLE_" + role + "')";
    }

    private static String hasAuthority(String authority) {
        return "hasAuthority('" + authority + "')";
    }

    private static String hasAnyAuthority(String ... authorities) {
        String anyAuthorities = StringUtils.arrayToDelimitedString((Object[])authorities, (String)"','");
        return "hasAnyAuthority('" + anyAuthorities + "')";
    }

    private static interface MatcherBuilder {
        public MessageMatcher<?> build();
    }

    private class PathMatcherMessageMatcherBuilder
    implements MatcherBuilder {
        private final String pattern;
        private final WampMessageType type;

        private PathMatcherMessageMatcherBuilder(String pattern, WampMessageType type) {
            this.pattern = pattern;
            this.type = type;
        }

        @Override
        public MessageMatcher<?> build() {
            if (this.type == null) {
                return new WampDestinationMessageMatcher(this.pattern, WampMessageSecurityMetadataSourceRegistry.this.pathMatcher);
            }
            if (WampDestinationMessageMatcher.isTypeWithDestination(this.type)) {
                return new WampDestinationMessageMatcher(this.pattern, this.type, WampMessageSecurityMetadataSourceRegistry.this.pathMatcher);
            }
            throw new IllegalStateException(this.type + " is not supported since it does not have a destination");
        }
    }

    private class PreBuiltMatcherBuilder
    implements MatcherBuilder {
        private final MessageMatcher<?> matcher;

        private PreBuiltMatcherBuilder(MessageMatcher<?> matcher) {
            this.matcher = matcher;
        }

        @Override
        public MessageMatcher<?> build() {
            return this.matcher;
        }
    }

    public class Constraint {
        private final List<? extends MatcherBuilder> messageMatchers;

        private Constraint(List<? extends MatcherBuilder> messageMatchers) {
            Assert.notEmpty(messageMatchers, (String)"messageMatchers cannot be null or empty");
            this.messageMatchers = messageMatchers;
        }

        public WampMessageSecurityMetadataSourceRegistry hasRole(String role) {
            return this.access(WampMessageSecurityMetadataSourceRegistry.hasRole(role));
        }

        public WampMessageSecurityMetadataSourceRegistry hasAnyRole(String ... roles) {
            return this.access(WampMessageSecurityMetadataSourceRegistry.hasAnyRole(roles));
        }

        public WampMessageSecurityMetadataSourceRegistry hasAuthority(String authority) {
            return this.access(WampMessageSecurityMetadataSourceRegistry.hasAuthority(authority));
        }

        public WampMessageSecurityMetadataSourceRegistry hasAnyAuthority(String ... authorities) {
            return this.access(WampMessageSecurityMetadataSourceRegistry.hasAnyAuthority(authorities));
        }

        public WampMessageSecurityMetadataSourceRegistry permitAll() {
            return this.access(WampMessageSecurityMetadataSourceRegistry.permitAll);
        }

        public WampMessageSecurityMetadataSourceRegistry anonymous() {
            return this.access(WampMessageSecurityMetadataSourceRegistry.anonymous);
        }

        public WampMessageSecurityMetadataSourceRegistry rememberMe() {
            return this.access(WampMessageSecurityMetadataSourceRegistry.rememberMe);
        }

        public WampMessageSecurityMetadataSourceRegistry denyAll() {
            return this.access(WampMessageSecurityMetadataSourceRegistry.denyAll);
        }

        public WampMessageSecurityMetadataSourceRegistry authenticated() {
            return this.access(WampMessageSecurityMetadataSourceRegistry.authenticated);
        }

        public WampMessageSecurityMetadataSourceRegistry fullyAuthenticated() {
            return this.access(WampMessageSecurityMetadataSourceRegistry.fullyAuthenticated);
        }

        public WampMessageSecurityMetadataSourceRegistry access(String attribute) {
            for (MatcherBuilder matcherBuilder : this.messageMatchers) {
                WampMessageSecurityMetadataSourceRegistry.this.matcherToExpression.put(matcherBuilder, attribute);
            }
            return WampMessageSecurityMetadataSourceRegistry.this;
        }
    }
}

