/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.config;

import ch.rasc.wampspring.EventMessenger;
import ch.rasc.wampspring.config.WampConfigurer;
import ch.rasc.wampspring.config.WampConfigurerAdapter;
import ch.rasc.wampspring.handler.AnnotationMethodHandler;
import ch.rasc.wampspring.handler.PubSubHandler;
import ch.rasc.wampspring.handler.WampMessageSender;
import ch.rasc.wampspring.handler.WampWebsocketHandler;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import java.util.Collection;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistration;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

@Configuration
class DelegatingWampConfiguration
implements WebSocketConfigurer {
    private WampConfigurer configurer;
    private JsonFactory jsonFactory;

    DelegatingWampConfiguration() {
    }

    @Autowired(required=false)
    void setConfigurers(Collection<WampConfigurer> configurers) {
        if (CollectionUtils.isEmpty(configurers)) {
            return;
        }
        if (configurers.size() > 1) {
            throw new IllegalStateException("Only one WampConfigurer may exist");
        }
        if (configurers.size() == 1) {
            this.configurer = configurers.iterator().next();
        }
        this.jsonFactory = new MappingJsonFactory(this.configurer.objectMapper());
    }

    @PostConstruct
    void postConstruct() {
        if (this.configurer == null) {
            this.configurer = new WampConfigurerAdapter();
            this.jsonFactory = new MappingJsonFactory(this.configurer.objectMapper());
        }
    }

    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        String path;
        String wampEndpointPath = this.configurer.wampEndpointPath();
        if (wampEndpointPath != null) {
            if (!wampEndpointPath.startsWith("/")) {
                throw new IllegalArgumentException("wampEndpointPath must start with an /");
            }
            path = wampEndpointPath;
        } else {
            path = "/wamp";
        }
        WebSocketHandlerRegistration reg = registry.addHandler((WebSocketHandler)this.wampWebsocketHandler(), new String[]{path});
        this.configurer.configureWampWebsocketHandler(reg);
    }

    @Bean
    public EventMessenger eventMessenger() {
        return new EventMessenger(this.pubSubHandler());
    }

    @Bean
    public WampMessageSender wampMessageSender() {
        return new WampMessageSender(this.configurer.outboundExecutor(), this.jsonFactory);
    }

    @Bean
    public PubSubHandler pubSubHandler() {
        return new PubSubHandler(this.wampMessageSender());
    }

    @Bean
    public AnnotationMethodHandler annotationMethodHandler() {
        return new AnnotationMethodHandler(this.wampMessageSender(), this.pubSubHandler(), this.configurer.objectMapper(), this.configurer.conversionService());
    }

    @Bean
    public WampWebsocketHandler wampWebsocketHandler() {
        return new WampWebsocketHandler(this.annotationMethodHandler(), this.pubSubHandler(), this.wampMessageSender(), this.jsonFactory);
    }
}

