/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.handler;

import ch.rasc.wampspring.annotation.WampCallListener;
import ch.rasc.wampspring.annotation.WampPublishListener;
import ch.rasc.wampspring.annotation.WampSubscribeListener;
import ch.rasc.wampspring.annotation.WampUnsubscribeListener;
import ch.rasc.wampspring.handler.PubSubHandler;
import ch.rasc.wampspring.handler.WampHandlerMethod;
import ch.rasc.wampspring.handler.WampMessageSender;
import ch.rasc.wampspring.message.CallErrorMessage;
import ch.rasc.wampspring.message.CallMessage;
import ch.rasc.wampspring.message.CallResultMessage;
import ch.rasc.wampspring.message.EventMessage;
import ch.rasc.wampspring.message.PrefixMessage;
import ch.rasc.wampspring.message.PublishMessage;
import ch.rasc.wampspring.message.SubscribeMessage;
import ch.rasc.wampspring.message.UnsubscribeMessage;
import ch.rasc.wampspring.message.WampMessage;
import ch.rasc.wampspring.message.WampMessageHeader;
import ch.rasc.wampspring.support.HandlerMethodArgumentResolver;
import ch.rasc.wampspring.support.HandlerMethodArgumentResolverComposite;
import ch.rasc.wampspring.support.InvocableHandlerMethod;
import ch.rasc.wampspring.support.PrincipalMethodArgumentResolver;
import ch.rasc.wampspring.support.WampMessageMethodArgumentResolver;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.HandlerMethodSelector;

public class AnnotationMethodHandler
implements ApplicationContextAware,
InitializingBean {
    private final Log logger = LogFactory.getLog(this.getClass());
    private ApplicationContext applicationContext;
    private final MultiValueMap<String, WampHandlerMethod> publishMethods = new LinkedMultiValueMap();
    private final MultiValueMap<String, WampHandlerMethod> subscribeMethods = new LinkedMultiValueMap();
    private final MultiValueMap<String, WampHandlerMethod> unsubscribeMethods = new LinkedMultiValueMap();
    private final MultiValueMap<String, WampHandlerMethod> callMethods = new LinkedMultiValueMap();
    private final Map<String, Map<String, String>> sessionIdsPrefixUri = new HashMap<String, Map<String, String>>();
    private List<HandlerMethodArgumentResolver> customArgumentResolvers = new ArrayList<HandlerMethodArgumentResolver>();
    private final HandlerMethodArgumentResolverComposite argumentResolvers = new HandlerMethodArgumentResolverComposite();
    private final WampMessageSender wampMessageSender;
    private final PubSubHandler pubSubHandler;
    private final ObjectMapper objectMapper;
    private final ConversionService conversionService;

    public AnnotationMethodHandler(WampMessageSender wampMessageSender, PubSubHandler pubSubHandler, ObjectMapper objectMapper, ConversionService conversionService) {
        this.wampMessageSender = wampMessageSender;
        this.pubSubHandler = pubSubHandler;
        this.objectMapper = objectMapper;
        this.conversionService = conversionService;
    }

    public void setCustomArgumentResolvers(List<HandlerMethodArgumentResolver> customArgumentResolvers) {
        Assert.notNull(customArgumentResolvers, (String)"The 'customArgumentResolvers' cannot be null.");
        this.customArgumentResolvers = customArgumentResolvers;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        String[] beanNames;
        for (String beanName : beanNames = this.applicationContext.getBeanNamesForType(Object.class)) {
            this.detectHandlerMethods(beanName);
        }
        this.argumentResolvers.addResolver(new WampMessageMethodArgumentResolver());
        this.argumentResolvers.addResolvers(this.customArgumentResolvers);
        this.argumentResolvers.addResolver(new PrincipalMethodArgumentResolver());
    }

    final void detectHandlerMethods(String beanName) {
        Class handlerType = this.applicationContext.getType(beanName);
        handlerType = ClassUtils.getUserClass((Class)handlerType);
        this.initHandlerMethods(beanName, handlerType, WampCallListener.class, this.callMethods);
        this.initHandlerMethods(beanName, handlerType, WampPublishListener.class, this.publishMethods);
        this.initHandlerMethods(beanName, handlerType, WampSubscribeListener.class, this.subscribeMethods);
        this.initHandlerMethods(beanName, handlerType, WampUnsubscribeListener.class, this.unsubscribeMethods);
    }

    private <A extends Annotation> void initHandlerMethods(String beanName, Class<?> handlerType, final Class<A> annotationType, MultiValueMap<String, WampHandlerMethod> handlerMethods) {
        Set methods = HandlerMethodSelector.selectMethods(handlerType, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                return AnnotationUtils.findAnnotation((Method)method, (Class)annotationType) != null;
            }
        });
        for (Method method : methods) {
            Annotation annotation = AnnotationUtils.findAnnotation((Method)method, annotationType);
            String[] destinations = (String[])AnnotationUtils.getValue((Annotation)annotation);
            String[] replyTo = (String[])AnnotationUtils.getValue((Annotation)annotation, (String)"replyTo");
            Boolean excludeSender = (Boolean)AnnotationUtils.getValue((Annotation)annotation, (String)"excludeSender");
            Object bean = this.applicationContext.getBean(beanName);
            WampHandlerMethod newHandlerMethod = new WampHandlerMethod(bean, method, replyTo, excludeSender);
            if (destinations.length > 0) {
                for (String destination : destinations) {
                    handlerMethods.add((Object)destination, (Object)newHandlerMethod);
                    if (!this.logger.isInfoEnabled()) continue;
                    this.logger.info((Object)("Mapped \"@" + annotationType.getSimpleName() + " " + destination + "\" onto " + (Object)((Object)newHandlerMethod)));
                }
                continue;
            }
            String destination = beanName + "." + method.getName();
            handlerMethods.add((Object)destination, (Object)newHandlerMethod);
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info((Object)("Mapped \"@" + annotationType.getSimpleName() + " " + destination + "\" onto " + (Object)((Object)newHandlerMethod)));
        }
    }

    public void handleMessage(WampMessage message) {
        switch (message.getType()) {
            case CALL: {
                this.handleCallMessage((CallMessage)message);
                break;
            }
            case PUBLISH: {
                PublishMessage publishMessage = (PublishMessage)message;
                this.handlePubSubMessage(publishMessage, publishMessage.getEvent(), publishMessage.getTopicURI(), this.publishMethods);
                break;
            }
            case SUBSCRIBE: {
                SubscribeMessage subscribeMessage = (SubscribeMessage)message;
                this.handlePubSubMessage(subscribeMessage, null, subscribeMessage.getTopicURI(), this.subscribeMethods);
                break;
            }
            case UNSUBSCRIBE: {
                UnsubscribeMessage unsubscribeMessage = (UnsubscribeMessage)message;
                this.handlePubSubMessage(unsubscribeMessage, null, unsubscribeMessage.getTopicURI(), this.unsubscribeMethods);
                break;
            }
            case PREFIX: {
                PrefixMessage prefixMessage = (PrefixMessage)message;
                this.handlePrefixMessage(prefixMessage);
                break;
            }
        }
    }

    private void handlePrefixMessage(PrefixMessage prefixMessage) {
        String sessionId = (String)prefixMessage.getHeader(WampMessageHeader.WEBSOCKET_SESSION_ID);
        if (this.sessionIdsPrefixUri.containsKey(sessionId)) {
            Map<String, String> prefixUri = this.sessionIdsPrefixUri.get(sessionId);
            prefixUri.put(prefixMessage.getPrefix(), prefixMessage.getUri());
        } else {
            HashMap<String, String> prefixUri = new HashMap<String, String>();
            prefixUri.put(prefixMessage.getPrefix(), prefixMessage.getUri());
            this.sessionIdsPrefixUri.put(sessionId, prefixUri);
        }
    }

    private void handleCallMessage(CallMessage callMessage) {
        String sessionId = (String)callMessage.getHeader(WampMessageHeader.WEBSOCKET_SESSION_ID);
        List<WampHandlerMethod> matches = this.getHandlerMethod(callMessage.getProcURI(), this.callMethods);
        if (matches == null && (matches = this.searchIfPrefixSet(callMessage, callMessage.getProcURI(), this.callMethods)) == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("No matching method, destination " + callMessage.getProcURI()));
            }
            return;
        }
        for (HandlerMethod handlerMethod : matches) {
            CallErrorMessage callErrorMessage;
            HandlerMethod handlerMethod2 = handlerMethod.createWithResolvedBean();
            InvocableHandlerMethod invocableHandlerMethod = new InvocableHandlerMethod(handlerMethod2, this.objectMapper, this.conversionService);
            invocableHandlerMethod.setMessageMethodArgumentResolvers(this.argumentResolvers);
            try {
                Object[] arguments = null;
                if (callMessage.getArguments() != null) {
                    arguments = callMessage.getArguments().toArray();
                }
                Object returnValue = invocableHandlerMethod.invoke(callMessage, arguments);
                CallResultMessage callResultMessage = new CallResultMessage(callMessage.getCallID(), returnValue);
                this.wampMessageSender.sendMessageToClient(sessionId, (WampMessage)callResultMessage);
            }
            catch (Exception ex) {
                callErrorMessage = new CallErrorMessage(callMessage.getCallID(), "", ex.toString());
                this.wampMessageSender.sendMessageToClient(sessionId, (WampMessage)callErrorMessage);
                this.logger.error((Object)("Error while processing message " + callMessage), (Throwable)ex);
            }
            catch (Throwable ex) {
                callErrorMessage = new CallErrorMessage(callMessage.getCallID(), "", ex.toString());
                this.wampMessageSender.sendMessageToClient(sessionId, (WampMessage)callErrorMessage);
                this.logger.error((Object)("Error while processing message " + callErrorMessage), ex);
            }
        }
    }

    private List<WampHandlerMethod> searchIfPrefixSet(WampMessage message, String destination, MultiValueMap<String, WampHandlerMethod> handlerMethods) {
        String uri;
        String[] curie;
        Map<String, String> prefixUri;
        String prefix;
        String sessionId = (String)message.getHeader(WampMessageHeader.WEBSOCKET_SESSION_ID);
        List<WampHandlerMethod> matches = null;
        if (this.sessionIdsPrefixUri.containsKey(sessionId) && null != (prefix = (prefixUri = this.sessionIdsPrefixUri.get(sessionId)).get((curie = destination.split(":"))[0])) && curie.length > 1 && null != (matches = this.getHandlerMethod(uri = String.format("%s%s", prefix, curie[1]), handlerMethods))) {
            for (WampHandlerMethod match : matches) {
                handlerMethods.add((Object)destination, (Object)match);
            }
        }
        return matches;
    }

    private void handlePubSubMessage(WampMessage message, Object argument, String destination, MultiValueMap<String, WampHandlerMethod> handlerMethods) {
        Assert.notNull((Object)destination, (String)"destination is required");
        List<WampHandlerMethod> matches = this.getHandlerMethod(destination, handlerMethods);
        if (matches == null && (matches = this.searchIfPrefixSet(message, destination, handlerMethods)) == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("No matching method, destination " + destination));
            }
            return;
        }
        for (WampHandlerMethod handlerMethod : matches) {
            InvocableHandlerMethod invocableHandlerMethod = new InvocableHandlerMethod(handlerMethod, this.objectMapper, this.conversionService);
            invocableHandlerMethod.setMessageMethodArgumentResolvers(this.argumentResolvers);
            try {
                Object returnValue = invocableHandlerMethod.invoke(message, argument);
                if (returnValue == null) continue;
                Set<String> mySessionId = Collections.singleton(message.getHeader(WampMessageHeader.WEBSOCKET_SESSION_ID));
                for (String replyToTopicURI : handlerMethod.getReplyTo()) {
                    if (!StringUtils.hasText((String)replyToTopicURI)) continue;
                    if (handlerMethod.isExcludeSender() != null && handlerMethod.isExcludeSender().booleanValue()) {
                        this.pubSubHandler.sendToAllExcept(new EventMessage(replyToTopicURI, returnValue), mySessionId);
                        continue;
                    }
                    this.pubSubHandler.sendToAll(new EventMessage(replyToTopicURI, returnValue));
                }
            }
            catch (Throwable ex) {
                this.logger.error((Object)("Error while processing message " + message), ex);
            }
        }
    }

    List<WampHandlerMethod> getHandlerMethod(String destination, MultiValueMap<String, WampHandlerMethod> handlerMethods) {
        for (String mappingDestination : handlerMethods.keySet()) {
            if (!destination.equals(mappingDestination)) continue;
            return (List)handlerMethods.get((Object)mappingDestination);
        }
        return null;
    }

    public void unregisterSessionFromAllPrefixCurie(String sessionId) {
        if (this.sessionIdsPrefixUri.containsKey(sessionId)) {
            Map<String, String> map = this.sessionIdsPrefixUri.remove(sessionId);
        }
    }
}

